/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.plugin.jdbc.oracle;

import io.edurt.datacap.plugin.jdbc.oracle.OracleAdapter;
import io.edurt.datacap.plugin.jdbc.oracle.OracleConnection;
import io.edurt.datacap.spi.Plugin;
import io.edurt.datacap.spi.PluginType;
import io.edurt.datacap.spi.connection.JdbcConfigure;
import io.edurt.datacap.spi.connection.JdbcConnection;
import io.edurt.datacap.spi.model.Configure;
import io.edurt.datacap.spi.model.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OraclePlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(OraclePlugin.class);
    private JdbcConfigure jdbcConfigure;
    private JdbcConnection connection;
    private Response response;

    public String name() {
        return "Oracle";
    }

    public String description() {
        return "Integrate Oracle data sources";
    }

    public PluginType type() {
        return PluginType.JDBC;
    }

    public void connect(Configure configure) {
        try {
            this.response = new Response();
            this.jdbcConfigure = new JdbcConfigure();
            BeanUtils.copyProperties((Object)this.jdbcConfigure, (Object)configure);
            this.jdbcConfigure.setJdbcDriver("oracle.jdbc.OracleDriver");
            this.jdbcConfigure.setJdbcType("oracle:thin");
            this.connection = new OracleConnection(this.jdbcConfigure, this.response);
        }
        catch (Exception ex) {
            this.response.setIsConnected(Boolean.FALSE);
            this.response.setMessage(ex.getMessage());
        }
    }

    public Response execute(String content) {
        if (ObjectUtils.isNotEmpty((Object)this.connection)) {
            log.info("Execute oracle plugin logic started");
            this.response = this.connection.getResponse();
            OracleAdapter processor = new OracleAdapter(this.connection);
            this.response = processor.handlerExecute(content);
            log.info("Execute oracle plugin logic end");
        }
        return this.response;
    }

    public void destroy() {
        if (ObjectUtils.isNotEmpty((Object)this.connection)) {
            this.connection.destroy();
        }
    }
}

