/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.plugin.jdbc.hive;

import io.edurt.datacap.plugin.jdbc.hive.HiveAdapter;
import io.edurt.datacap.spi.Plugin;
import io.edurt.datacap.spi.PluginType;
import io.edurt.datacap.spi.connection.JdbcConfigure;
import io.edurt.datacap.spi.connection.JdbcConnection;
import io.edurt.datacap.spi.model.Configure;
import io.edurt.datacap.spi.model.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HivePlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(HivePlugin.class);
    private JdbcConfigure jdbcConfigure;
    private JdbcConnection connection;
    private Response response;

    public String name() {
        return "Hive";
    }

    public String description() {
        return "Integrate Hive data sources";
    }

    public PluginType type() {
        return PluginType.JDBC;
    }

    public void connect(Configure configure) {
        try {
            this.response = new Response();
            this.jdbcConfigure = new JdbcConfigure();
            BeanUtils.copyProperties((Object)this.jdbcConfigure, (Object)configure);
            this.jdbcConfigure.setJdbcDriver("org.apache.hive.jdbc.HiveDriver");
            this.jdbcConfigure.setJdbcType("hive2");
            this.connection = new JdbcConnection(this.jdbcConfigure, this.response);
        }
        catch (Exception ex) {
            this.response.setIsConnected(Boolean.FALSE);
            this.response.setMessage(ex.getMessage());
        }
    }

    public Response execute(String content) {
        if (ObjectUtils.isNotEmpty((Object)this.connection)) {
            log.info("Execute hive plugin logic started");
            this.response = this.connection.getResponse();
            HiveAdapter processor = new HiveAdapter(this.connection);
            this.response = processor.handlerExecute(content);
            log.info("Execute hive plugin logic end");
        }
        return this.response;
    }

    public void destroy() {
        if (ObjectUtils.isNotEmpty((Object)this.connection)) {
            this.connection.destroy();
        }
    }
}

