/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileWriterV2;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputControlUtil;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public abstract class Compactor<T extends CellSink> {
    private static final Log LOG = LogFactory.getLog(Compactor.class);
    protected volatile CompactionProgress progress;
    protected final Configuration conf;
    protected final Store store;
    protected final int compactionKVMax;
    protected final Compression.Algorithm compactionCompression;
    protected int keepSeqIdPeriod;
    protected static final String MAJOR_COMPACTION_DROP_CACHE = "hbase.regionserver.majorcompaction.pagecache.drop";
    protected static final String MINOR_COMPACTION_DROP_CACHE = "hbase.regionserver.minorcompaction.pagecache.drop";
    private boolean dropCacheMajor;
    private boolean dropCacheMinor;
    protected final InternalScannerFactory defaultScannerFactory = new InternalScannerFactory(){

        @Override
        public ScanType getScanType(CompactionRequest request) {
            return request.isAllFiles() ? ScanType.COMPACT_DROP_DELETES : ScanType.COMPACT_RETAIN_DELETES;
        }

        @Override
        public InternalScanner createScanner(List<StoreFileScanner> scanners, ScanType scanType, FileDetails fd, long smallestReadPoint) throws IOException {
            return Compactor.this.createScanner(Compactor.this.store, scanners, scanType, smallestReadPoint, fd.earliestPutTs);
        }
    };

    Compactor(Configuration conf, Store store) {
        this.conf = conf;
        this.store = store;
        this.compactionKVMax = this.conf.getInt("hbase.hstore.compaction.kv.max", 10);
        this.compactionCompression = this.store.getFamily() == null ? Compression.Algorithm.NONE : this.store.getFamily().getCompactionCompression();
        this.keepSeqIdPeriod = Math.max(this.conf.getInt("hbase.hstore.compaction.keep.seqId.period", 5), 5);
        this.dropCacheMajor = conf.getBoolean(MAJOR_COMPACTION_DROP_CACHE, true);
        this.dropCacheMinor = conf.getBoolean(MINOR_COMPACTION_DROP_CACHE, true);
    }

    public CompactionProgress getProgress() {
        return this.progress;
    }

    protected FileDetails getFileDetails(Collection<StoreFile> filesToCompact, boolean allFiles) throws IOException {
        FileDetails fd = new FileDetails();
        long oldestHFileTimeStampToKeepMVCC = System.currentTimeMillis() - 86400000L * (long)this.keepSeqIdPeriod;
        for (StoreFile file : filesToCompact) {
            if (allFiles && file.getModificationTimeStamp() < oldestHFileTimeStampToKeepMVCC && fd.minSeqIdToKeep < file.getMaxMemstoreTS()) {
                fd.minSeqIdToKeep = file.getMaxMemstoreTS();
            }
            long seqNum = file.getMaxSequenceId();
            fd.maxSeqId = Math.max(fd.maxSeqId, seqNum);
            StoreFile.Reader r = file.getReader();
            if (r == null) {
                LOG.warn((Object)("Null reader for " + file.getPath()));
                continue;
            }
            long keyCount = r.getEntries();
            fd.maxKeyCount += keyCount;
            Map<byte[], byte[]> fileInfo = r.loadFileInfo();
            byte[] tmp = null;
            if (r.isBulkLoaded()) {
                fd.maxMVCCReadpoint = Math.max(fd.maxMVCCReadpoint, r.getSequenceID());
            } else {
                tmp = fileInfo.get(HFileWriterV2.MAX_MEMSTORE_TS_KEY);
                if (tmp != null) {
                    fd.maxMVCCReadpoint = Math.max(fd.maxMVCCReadpoint, Bytes.toLong((byte[])tmp));
                }
            }
            tmp = fileInfo.get(HFile.FileInfo.MAX_TAGS_LEN);
            if (tmp != null) {
                fd.maxTagsLength = Math.max(fd.maxTagsLength, Bytes.toInt((byte[])tmp));
            }
            long earliestPutTs = 0L;
            if (allFiles) {
                tmp = fileInfo.get(StoreFile.EARLIEST_PUT_TS);
                if (tmp == null) {
                    earliestPutTs = Long.MIN_VALUE;
                    fd.earliestPutTs = Long.MIN_VALUE;
                } else {
                    earliestPutTs = Bytes.toLong((byte[])tmp);
                    fd.earliestPutTs = Math.min(fd.earliestPutTs, earliestPutTs);
                }
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Compacting " + file + ", keycount=" + keyCount + ", bloomtype=" + r.getBloomFilterType().toString() + ", size=" + StringUtils.TraditionalBinaryPrefix.long2String((long)r.length(), (String)"", (int)1) + ", encoding=" + r.getHFileReader().getDataBlockEncoding() + ", compression=" + this.compactionCompression + ", seqNum=" + seqNum + (allFiles ? ", earliestPutTs=" + earliestPutTs : "")));
        }
        return fd;
    }

    protected List<StoreFileScanner> createFileScanners(Collection<StoreFile> filesToCompact, long smallestReadPoint, boolean useDropBehind) throws IOException {
        return StoreFileScanner.getScannersForStoreFiles(filesToCompact, false, false, true, useDropBehind, smallestReadPoint);
    }

    protected long getSmallestReadPoint() {
        return this.store.getSmallestReadPoint();
    }

    protected StoreFile.Writer createTmpWriter(FileDetails fd, boolean shouldDropBehind) throws IOException {
        return this.store.createWriterInTmp(fd.maxKeyCount, this.compactionCompression, true, fd.maxMVCCReadpoint > 0L, fd.maxTagsLength > 0, shouldDropBehind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Path> compact(CompactionRequest request, InternalScannerFactory scannerFactory, CellSinkFactory<T> sinkFactory, ThroughputController throughputController, User user) throws IOException {
        boolean finished;
        InternalScanner scanner;
        List<StoreFile> readersToClose;
        CellSink writer;
        FileDetails fd;
        block23: {
            boolean dropCache;
            long smallestReadPoint;
            block22: {
                List<StoreFileScanner> scanners;
                fd = this.getFileDetails(request.getFiles(), request.isAllFiles());
                this.progress = new CompactionProgress(fd.maxKeyCount);
                smallestReadPoint = this.getSmallestReadPoint();
                writer = null;
                dropCache = request.isMajor() || request.isAllFiles() ? this.dropCacheMajor : this.dropCacheMinor;
                if (this.conf.getBoolean("hbase.regionserver.compaction.private.readers", true)) {
                    readersToClose = new ArrayList(request.getFiles().size());
                    for (StoreFile f : request.getFiles()) {
                        readersToClose.add(f.cloneForReader());
                    }
                    scanners = this.createFileScanners(readersToClose, smallestReadPoint, dropCache);
                } else {
                    readersToClose = Collections.emptyList();
                    scanners = this.createFileScanners(request.getFiles(), smallestReadPoint, dropCache);
                }
                scanner = null;
                finished = false;
                ScanType scanType = scannerFactory.getScanType(request);
                scanner = this.preCreateCoprocScanner(request, scanType, fd.earliestPutTs, scanners, user, smallestReadPoint);
                if (scanner == null) {
                    scanner = scannerFactory.createScanner(scanners, scanType, fd, smallestReadPoint);
                }
                if ((scanner = this.postCreateCoprocScanner(request, scanType, scanner, user)) != null) break block22;
                ArrayList<Path> arrayList = new ArrayList<Path>();
                Closeables.close((Closeable)scanner, (boolean)true);
                for (StoreFile f : readersToClose) {
                    try {
                        f.closeReader(true);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Exception closing " + f), (Throwable)e);
                    }
                }
                if (!finished && writer != null) {
                    this.abortWriter(writer);
                }
                return arrayList;
            }
            try {
                boolean cleanSeqId = false;
                if (fd.minSeqIdToKeep > 0L) {
                    smallestReadPoint = Math.min(fd.minSeqIdToKeep, smallestReadPoint);
                    cleanSeqId = true;
                }
                if (finished = this.performCompaction(scanner, writer = (CellSink)sinkFactory.createWriter(scanner, fd, dropCache), smallestReadPoint, cleanSeqId, throughputController)) break block23;
                throw new InterruptedIOException("Aborting compaction of store " + this.store + " in region " + this.store.getRegionInfo().getRegionNameAsString() + " because it was interrupted.");
            }
            catch (Throwable throwable) {
                Closeables.close(scanner, (boolean)true);
                for (StoreFile f : readersToClose) {
                    try {
                        f.closeReader(true);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Exception closing " + f), (Throwable)e);
                    }
                }
                if (!finished && writer != null) {
                    this.abortWriter(writer);
                }
                throw throwable;
            }
        }
        Closeables.close((Closeable)scanner, (boolean)true);
        for (StoreFile f : readersToClose) {
            try {
                f.closeReader(true);
            }
            catch (IOException e) {
                LOG.warn((Object)("Exception closing " + f), (Throwable)e);
            }
        }
        if (!finished && writer != null) {
            this.abortWriter(writer);
        }
        assert (finished) : "We should have exited the method on all error paths";
        assert (writer != null) : "Writer should be non-null if no error";
        return this.commitWriter(writer, fd, request);
    }

    protected abstract List<Path> commitWriter(T var1, FileDetails var2, CompactionRequest var3) throws IOException;

    protected abstract void abortWriter(T var1) throws IOException;

    protected InternalScanner preCreateCoprocScanner(CompactionRequest request, ScanType scanType, long earliestPutTs, List<StoreFileScanner> scanners, User user, long readPoint) throws IOException {
        if (this.store.getCoprocessorHost() == null) {
            return null;
        }
        return this.store.getCoprocessorHost().preCompactScannerOpen(this.store, scanners, scanType, earliestPutTs, request, readPoint, user);
    }

    protected InternalScanner postCreateCoprocScanner(CompactionRequest request, ScanType scanType, InternalScanner scanner, User user) throws IOException {
        if (this.store.getCoprocessorHost() == null) {
            return scanner;
        }
        return this.store.getCoprocessorHost().preCompact(this.store, scanner, scanType, request, user);
    }

    protected boolean performCompaction(InternalScanner scanner, CellSink writer, long smallestReadPoint, boolean cleanSeqId, ThroughputController throughputController) throws IOException {
        long bytesWritten = 0L;
        long bytesWrittenProgress = 0L;
        ArrayList<Cell> cells = new ArrayList<Cell>();
        long closeCheckInterval = HStore.getCloseCheckInterval();
        long lastMillis = 0L;
        if (LOG.isDebugEnabled()) {
            lastMillis = EnvironmentEdgeManager.currentTime();
        }
        String compactionName = ThroughputControlUtil.getNameForThrottling(this.store, "compaction");
        long now = 0L;
        ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(this.compactionKVMax).build();
        throughputController.start(compactionName);
        try {
            boolean hasMore;
            do {
                hasMore = scanner.next(cells, scannerContext);
                if (LOG.isDebugEnabled()) {
                    now = EnvironmentEdgeManager.currentTime();
                }
                Cell lastCleanCell = null;
                long lastCleanCellSeqId = 0L;
                for (Cell c : cells) {
                    if (cleanSeqId && c.getSequenceId() <= smallestReadPoint) {
                        lastCleanCell = c;
                        lastCleanCellSeqId = c.getSequenceId();
                        CellUtil.setSequenceId((Cell)c, (long)0L);
                    } else {
                        lastCleanCell = null;
                        lastCleanCellSeqId = 0L;
                    }
                    writer.append(c);
                    int len = KeyValueUtil.length((Cell)c);
                    ++this.progress.currentCompactedKVs;
                    this.progress.totalCompactedSize += (long)len;
                    if (LOG.isDebugEnabled()) {
                        bytesWrittenProgress += (long)len;
                    }
                    throughputController.control(compactionName, len);
                    if (closeCheckInterval <= 0L || (bytesWritten += (long)len) <= closeCheckInterval) continue;
                    bytesWritten = 0L;
                    if (this.store.areWritesEnabled()) continue;
                    this.progress.cancel();
                    boolean bl = false;
                    return bl;
                }
                if (lastCleanCell != null) {
                    CellUtil.setSequenceId(lastCleanCell, (long)lastCleanCellSeqId);
                }
                if (LOG.isDebugEnabled() && now - lastMillis >= 60000L) {
                    LOG.debug((Object)("Compaction progress: " + compactionName + " " + this.progress + String.format(", rate=%.2f kB/sec", (double)bytesWrittenProgress / 1024.0 / ((double)(now - lastMillis) / 1000.0)) + ", throughputController is " + throughputController));
                    lastMillis = now;
                    bytesWrittenProgress = 0L;
                }
                cells.clear();
            } while (hasMore);
        }
        catch (InterruptedException e) {
            this.progress.cancel();
            throw new InterruptedIOException("Interrupted while control throughput of compacting " + compactionName);
        }
        finally {
            throughputController.finish(compactionName);
        }
        this.progress.complete();
        return true;
    }

    protected InternalScanner createScanner(Store store, List<StoreFileScanner> scanners, ScanType scanType, long smallestReadPoint, long earliestPutTs) throws IOException {
        Scan scan = new Scan();
        scan.setMaxVersions(store.getFamily().getMaxVersions());
        return new StoreScanner(store, store.getScanInfo(), scan, scanners, scanType, smallestReadPoint, earliestPutTs);
    }

    protected InternalScanner createScanner(Store store, List<StoreFileScanner> scanners, long smallestReadPoint, long earliestPutTs, byte[] dropDeletesFromRow, byte[] dropDeletesToRow) throws IOException {
        Scan scan = new Scan();
        scan.setMaxVersions(store.getFamily().getMaxVersions());
        return new StoreScanner(store, store.getScanInfo(), scan, scanners, smallestReadPoint, earliestPutTs, dropDeletesFromRow, dropDeletesToRow);
    }

    protected static interface InternalScannerFactory {
        public ScanType getScanType(CompactionRequest var1);

        public InternalScanner createScanner(List<StoreFileScanner> var1, ScanType var2, FileDetails var3, long var4) throws IOException;
    }

    protected static class FileDetails {
        public long maxKeyCount = 0L;
        public long earliestPutTs = Long.MAX_VALUE;
        public long maxSeqId = 0L;
        public long maxMVCCReadpoint = 0L;
        public int maxTagsLength = 0;
        public long minSeqIdToKeep = 0L;

        protected FileDetails() {
        }
    }

    protected static interface CellSinkFactory<S> {
        public S createWriter(InternalScanner var1, FileDetails var2, boolean var3) throws IOException;
    }

    public static interface CellSink {
        public void append(Cell var1) throws IOException;
    }
}

