/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.htrace.Span;

@InterfaceAudience.Private
class SyncFuture {
    private static final long NOT_DONE = 0L;
    private long ringBufferSequence;
    private long doneSequence = -1L;
    private Throwable throwable = null;
    private Thread t;
    private Span span;
    private boolean forceSync;

    SyncFuture() {
    }

    synchronized SyncFuture reset(long sequence) {
        return this.reset(sequence, null);
    }

    synchronized SyncFuture reset(long sequence, Span span) {
        if (this.t != null && this.t != Thread.currentThread()) {
            throw new IllegalStateException();
        }
        this.t = Thread.currentThread();
        if (!this.isDone()) {
            throw new IllegalStateException("" + sequence + " " + Thread.currentThread());
        }
        this.doneSequence = 0L;
        this.ringBufferSequence = sequence;
        this.span = span;
        this.throwable = null;
        return this;
    }

    public synchronized String toString() {
        return "done=" + this.isDone() + ", ringBufferSequence=" + this.ringBufferSequence;
    }

    synchronized long getRingBufferSequence() {
        return this.ringBufferSequence;
    }

    synchronized boolean isForceSync() {
        return this.forceSync;
    }

    synchronized SyncFuture setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
        return this;
    }

    synchronized Span getSpan() {
        return this.span;
    }

    synchronized void setSpan(Span span) {
        this.span = span;
    }

    synchronized boolean done(long sequence, Throwable t) {
        if (this.isDone()) {
            return false;
        }
        this.throwable = t;
        if (sequence < this.ringBufferSequence && this.throwable == null) {
            this.throwable = new IllegalStateException("sequence=" + sequence + ", ringBufferSequence=" + this.ringBufferSequence);
        }
        this.doneSequence = sequence;
        this.notify();
        return true;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    public synchronized long get(long timeout) throws InterruptedException, ExecutionException, TimeoutIOException {
        long done = EnvironmentEdgeManager.currentTime() + timeout;
        while (!this.isDone()) {
            this.wait(1000L);
            if (EnvironmentEdgeManager.currentTime() < done) continue;
            throw new TimeoutIOException("Failed to get sync result after " + timeout + " ms for ringBufferSequence=" + this.ringBufferSequence + ", WAL system stuck?");
        }
        if (this.throwable != null) {
            throw new ExecutionException(this.throwable);
        }
        return this.doneSequence;
    }

    public Long get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    public boolean isCancelled() {
        throw new UnsupportedOperationException();
    }

    synchronized boolean isDone() {
        return this.doneSequence != 0L;
    }

    synchronized boolean isThrowable() {
        return this.isDone() && this.getThrowable() != null;
    }

    synchronized Throwable getThrowable() {
        return this.throwable;
    }
}

