/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.compaction;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.Executors;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.util.compaction.ClusterCompactionQueues;
import org.apache.hadoop.hbase.util.compaction.MajorCompactionRequest;
import org.apache.hadoop.hbase.util.compaction.MajorCompactionTTLRequest;
import org.apache.hadoop.hbase.util.compaction.MajorCompactor;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class MajorCompactorTTL
extends MajorCompactor {
    private static final Logger LOG = LoggerFactory.getLogger(MajorCompactorTTL.class);
    private HTableDescriptor htd;

    @VisibleForTesting
    public MajorCompactorTTL(Configuration conf, HTableDescriptor htd, int concurrency, long sleepForMs) throws IOException {
        this.connection = ConnectionFactory.createConnection((Configuration)conf);
        this.htd = htd;
        this.tableName = htd.getTableName();
        this.storesToCompact = Sets.newHashSet();
        this.sleepForMs = sleepForMs;
        this.executor = Executors.newFixedThreadPool(concurrency);
        this.clusterCompactionQueues = new ClusterCompactionQueues(concurrency);
    }

    protected MajorCompactorTTL() {
    }

    @Override
    protected Optional<MajorCompactionRequest> getMajorCompactionRequest(HRegionInfo hri) throws IOException {
        return MajorCompactionTTLRequest.newRequest(this.connection.getConfiguration(), hri, this.htd);
    }

    @Override
    protected Set<String> getStoresRequiringCompaction(MajorCompactionRequest request) throws IOException {
        return ((MajorCompactionTTLRequest)request).getStoresRequiringCompaction(this.htd).keySet();
    }

    public int compactRegionsTTLOnTable(Configuration conf, String table, int concurrency, long sleep, int numServers, int numRegions, boolean dryRun, boolean skipWait) throws Exception {
        Connection conn = ConnectionFactory.createConnection((Configuration)conf);
        TableName tableName = TableName.valueOf((String)table);
        HTableDescriptor htd = conn.getAdmin().getTableDescriptor(tableName);
        if (!this.doesAnyColFamilyHaveTTL(htd)) {
            LOG.info("No TTL present for CF of table: " + tableName + ", skipping compaction");
            return 0;
        }
        LOG.info("Major compacting table " + tableName + " based on TTL");
        MajorCompactorTTL compactor = new MajorCompactorTTL(conf, htd, concurrency, sleep);
        compactor.setNumServers(numServers);
        compactor.setNumRegions(numRegions);
        compactor.setSkipWait(skipWait);
        compactor.initializeWorkQueues();
        if (!dryRun) {
            compactor.compactAllRegions();
        }
        compactor.shutdown();
        return ERRORS.size();
    }

    private boolean doesAnyColFamilyHaveTTL(HTableDescriptor htd) {
        for (HColumnDescriptor descriptor : htd.getColumnFamilies()) {
            if (descriptor.getTimeToLive() == Integer.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    private Options getOptions() {
        Options options = this.getCommonOptions();
        Option tableOption = new Option("table", true, "Table to be compacted");
        tableOption.setRequired(true);
        options.addOption(tableOption);
        return options;
    }

    @Override
    public int run(String[] args) throws Exception {
        CommandLine commandLine;
        Options options = this.getOptions();
        BasicParser cmdLineParser = new BasicParser();
        try {
            commandLine = cmdLineParser.parse(options, args);
        }
        catch (ParseException parseException) {
            System.err.println("ERROR: Unable to parse command-line arguments " + Arrays.toString(args) + " due to: " + (Object)((Object)parseException));
            MajorCompactorTTL.printUsage(options);
            throw parseException;
        }
        String table = commandLine.getOptionValue("table");
        int numServers = Integer.parseInt(commandLine.getOptionValue("numservers", "-1"));
        int numRegions = Integer.parseInt(commandLine.getOptionValue("numregions", "-1"));
        int concurrency = Integer.parseInt(commandLine.getOptionValue("servers", "1"));
        long sleep = Long.parseLong(commandLine.getOptionValue("sleep", "30000"));
        boolean dryRun = commandLine.hasOption("dryRun");
        boolean skipWait = commandLine.hasOption("skipWait");
        return this.compactRegionsTTLOnTable(HBaseConfiguration.create(), table, concurrency, sleep, numServers, numRegions, dryRun, skipWait);
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new MajorCompactorTTL(), (String[])args);
    }
}

