/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TestReduceFetchFromPartialMem;
import org.apache.hadoop.mapreduce.TaskCounter;

public class TestReduceFetch
extends TestReduceFetchFromPartialMem {
    public void testReduceFromDisk() throws Exception {
        int MAP_TASKS = 8;
        JobConf job = mrCluster.createJobConf();
        job.set("mapreduce.reduce.input.buffer.percent", "0.0");
        job.setNumMapTasks(8);
        job.set("mapreduce.reduce.java.opts", "-Xmx128m");
        job.setLong("mapreduce.reduce.memory.totalbytes", 0x8000000L);
        job.set("mapreduce.reduce.shuffle.input.buffer.percent", "0.05");
        job.setInt("mapreduce.task.io.sort.factor", 2);
        job.setInt("mapreduce.reduce.merge.inmem.threshold", 4);
        Counters c = TestReduceFetch.runJob(job);
        long spill = ((Counters.Counter)c.findCounter((Enum)TaskCounter.SPILLED_RECORDS)).getCounter();
        long out = ((Counters.Counter)c.findCounter((Enum)TaskCounter.MAP_OUTPUT_RECORDS)).getCounter();
        TestReduceFetch.assertTrue((String)("Expected all records spilled during reduce (" + spill + ")"), (spill >= 2L * out ? 1 : 0) != 0);
        TestReduceFetch.assertTrue((String)("Expected intermediate merges (" + spill + ")"), (spill >= 2L * out + out / 8L ? 1 : 0) != 0);
    }

    public void testReduceFromMem() throws Exception {
        int MAP_TASKS = 3;
        JobConf job = mrCluster.createJobConf();
        job.set("mapreduce.reduce.input.buffer.percent", "1.0");
        job.set("mapreduce.reduce.shuffle.input.buffer.percent", "1.0");
        job.setLong("mapreduce.reduce.memory.totalbytes", 0x8000000L);
        job.setNumMapTasks(3);
        Counters c = TestReduceFetch.runJob(job);
        long spill = ((Counters.Counter)c.findCounter((Enum)TaskCounter.SPILLED_RECORDS)).getCounter();
        long out = ((Counters.Counter)c.findCounter((Enum)TaskCounter.MAP_OUTPUT_RECORDS)).getCounter();
        TestReduceFetch.assertEquals((String)("Spilled records: " + spill), (long)out, (long)spill);
    }

    static {
        TestReduceFetch.setSuite(TestReduceFetch.class);
    }
}

