/*
 * Decompiled with CFR 0.152.
 */
package com.itmuch.redis.jdbc;

import com.itmuch.redis.jdbc.Hint;
import com.itmuch.redis.jdbc.Logger;
import com.itmuch.redis.jdbc.Op;
import com.itmuch.redis.jdbc.RedisClient;
import com.itmuch.redis.jdbc.Utils;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.util.SafeEncoder;

public abstract class AbstractRedisClient
implements RedisClient {
    public static final Logger LOGGER = new Logger(AbstractRedisClient.class);

    public String[] sendCommand(String sql) throws SQLException {
        try {
            Op op = Utils.parseSql((String)sql);
            Object result = this.sendCommand(op);
            return this.decodeResult(sql, result, op.getHints());
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
    }

    protected abstract Object sendCommand(Op var1);

    protected Protocol.Command convertCommand(String commandString) {
        return Arrays.stream(Protocol.Command.values()).filter(t -> {
            String string = t.toString();
            return string.equalsIgnoreCase(commandString);
        }).findFirst().orElseThrow(() -> new RuntimeException(String.format("command invalided. commandString = %s", commandString)));
    }

    protected String[] decodeResult(String sql, Object originResult, List<Hint> hints) {
        Object[] decodedResult;
        if (originResult == null) {
            decodedResult = new String[]{null};
        } else if (originResult.getClass().isArray()) {
            String decoded = SafeEncoder.encode((byte[])((byte[])originResult));
            decodedResult = (String[])Stream.of(decoded).toArray(String[]::new);
        } else if (originResult instanceof Collection) {
            List list = (List)originResult;
            decodedResult = (String[])list.stream().map(t -> SafeEncoder.encode((byte[])((byte[])t))).toArray(String[]::new);
        } else {
            LOGGER.log("cannot decode result. originResult = %s", new Object[]{originResult});
            decodedResult = (String[])Stream.of(originResult.toString()).toArray(String[]::new);
        }
        LOGGER.log("decode success. sql = %s, originResult = %s, decodedResult = %s", new Object[]{sql, originResult, Utils.toList((Object[])decodedResult)});
        return decodedResult;
    }
}

