/*
 * Decompiled with CFR 0.152.
 */
package com.itmuch.redis.jdbc.cluster;

import com.itmuch.redis.jdbc.AbstractRedisClient;
import com.itmuch.redis.jdbc.Hint;
import com.itmuch.redis.jdbc.HintKey;
import com.itmuch.redis.jdbc.Op;
import java.sql.SQLException;
import java.util.List;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;

public class JedisRedisClusterClient
extends AbstractRedisClient {
    private final JedisCluster jedisCluster;

    @Override
    protected Object sendCommand(Op op) {
        String rawSql = op.getOriginSql();
        String commandString = op.getCommand();
        String[] params = op.getParams();
        List hints = op.getHints();
        try {
            Protocol.Command command = this.convertCommand(commandString);
            String sampleKey = hints.stream().filter(hint -> hint.getKey().equals((Object)HintKey.sample_key)).findFirst().map(Hint::getValue).orElse(null);
            Object result = params == null || params.length == 0 ? this.jedisCluster.sendCommand(sampleKey, (ProtocolCommand)command, new String[0]) : this.jedisCluster.sendCommand(sampleKey, (ProtocolCommand)command, params);
            return result;
        }
        catch (Throwable e) {
            LOGGER.log("command `%s` cannot execute.", new Object[]{rawSql});
            throw new RuntimeException(String.format("command `%s` cannot execute.", rawSql));
        }
    }

    public void select(int dbIndex) throws SQLException {
        throw new SQLException("Redis Cluster does not support this operation");
    }

    public void close() {
        this.jedisCluster.close();
    }

    public JedisRedisClusterClient(JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }
}

