/*
 * Decompiled with CFR 0.152.
 */
package com.itmuch.redis.jdbc.conf;

import java.util.Properties;

public class BaseConnectionInfo {
    protected String username;
    protected String password;
    protected boolean ssl;
    protected int timeout;

    public BaseConnectionInfo(Properties info) {
        String username = info.getProperty("user");
        String password = info.getProperty("password");
        String sslString = info.getProperty("ssl");
        Object timeoutString = info.getOrDefault((Object)"timeout", "1000");
        boolean ssl = "on".equalsIgnoreCase(sslString) || "true".equalsIgnoreCase(sslString);
        this.username = username;
        this.password = password;
        this.timeout = Integer.parseInt(timeoutString.toString());
        this.ssl = ssl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseConnectionInfo)) {
            return false;
        }
        BaseConnectionInfo other = (BaseConnectionInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSsl() != other.isSsl()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseConnectionInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSsl() ? 79 : 97);
        result = result * 59 + this.getTimeout();
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "BaseConnectionInfo(username=" + this.getUsername() + ", password=" + this.getPassword() + ", ssl=" + this.isSsl() + ", timeout=" + this.getTimeout() + ")";
    }

    public BaseConnectionInfo() {
    }
}

