/*
 * Decompiled with CFR 0.152.
 */
package com.itmuch.redis.jdbc.conf;

import com.itmuch.redis.jdbc.Logger;
import com.itmuch.redis.jdbc.Utils;
import com.itmuch.redis.jdbc.conf.BaseConnectionInfo;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import redis.clients.jedis.HostAndPort;

public class RedisClusterConnectionInfo
extends BaseConnectionInfo {
    public static final Logger LOGGER = new Logger(RedisClusterConnectionInfo.class);
    private Set<HostAndPort> nodes;
    private int maxAttempts;

    public RedisClusterConnectionInfo(String rawUrl, Properties info) {
        super(info);
        try {
            URI uri = new URI(rawUrl);
            Object maxAttemptsString = info.getOrDefault((Object)"maxAttempts", (Object)5);
            int maxAttempts = Integer.parseInt(maxAttemptsString.toString());
            String query = uri.getQuery();
            Map paramMap = Utils.parseQueryStringToMap((String)query);
            String host = (String)paramMap.get("host");
            String[] hosts = host.split(";");
            this.nodes = Arrays.stream(hosts).map(h -> {
                String[] split = h.split(":");
                return new HostAndPort(split[0], Integer.parseInt(split[1]));
            }).collect(Collectors.toSet());
            this.maxAttempts = maxAttempts;
        }
        catch (Exception e) {
            LOGGER.log("Cannot parse JDBC URL %s", new Object[]{rawUrl});
            throw new RuntimeException("Cannot parse JDBC URL: " + rawUrl, e);
        }
    }

    public Set<HostAndPort> getNodes() {
        return this.nodes;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setNodes(Set<HostAndPort> nodes) {
        this.nodes = nodes;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    @Override
    public String toString() {
        return "RedisClusterConnectionInfo(nodes=" + this.getNodes() + ", maxAttempts=" + this.getMaxAttempts() + ")";
    }

    public RedisClusterConnectionInfo() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisClusterConnectionInfo)) {
            return false;
        }
        RedisClusterConnectionInfo other = (RedisClusterConnectionInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMaxAttempts() != other.getMaxAttempts()) {
            return false;
        }
        Set<HostAndPort> this$nodes = this.getNodes();
        Set<HostAndPort> other$nodes = other.getNodes();
        return !(this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RedisClusterConnectionInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getMaxAttempts();
        Set<HostAndPort> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        return result;
    }
}

