/*
 * Decompiled with CFR 0.152.
 */
package com.itmuch.redis.jdbc.conf;

import com.itmuch.redis.jdbc.Logger;
import com.itmuch.redis.jdbc.conf.BaseConnectionInfo;
import java.net.URI;
import java.util.Properties;

public class RedisConnectionInfo
extends BaseConnectionInfo {
    private static final Logger LOGGER = new Logger(RedisConnectionInfo.class);
    private String host;
    private int port;
    private int dbIndex;

    public RedisConnectionInfo(String rawUrl, Properties info) {
        super(info);
        try {
            URI uri = new URI(rawUrl);
            String host = uri.getHost() != null ? uri.getHost() : "localhost";
            int port = uri.getPort() > 0 ? uri.getPort() : 6379;
            String path = uri.getPath();
            int dbIndex = 0;
            if (path != null && path.length() > 1) {
                dbIndex = Integer.parseInt(path.replaceAll("/", ""));
            }
            this.host = host;
            this.port = port;
            this.dbIndex = dbIndex;
        }
        catch (Exception e) {
            LOGGER.log("Cannot parse JDBC URL %s", new Object[]{rawUrl});
            throw new RuntimeException("Cannot parse JDBC URL: " + rawUrl, e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getDbIndex() {
        return this.dbIndex;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDbIndex(int dbIndex) {
        this.dbIndex = dbIndex;
    }

    @Override
    public String toString() {
        return "RedisConnectionInfo(host=" + this.getHost() + ", port=" + this.getPort() + ", dbIndex=" + this.getDbIndex() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisConnectionInfo)) {
            return false;
        }
        RedisConnectionInfo other = (RedisConnectionInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getDbIndex() != other.getDbIndex()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RedisConnectionInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPort();
        result = result * 59 + this.getDbIndex();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }
}

