/*
 * Decompiled with CFR 0.152.
 */
package com.itmuch.redis.jdbc.redis;

import com.itmuch.redis.jdbc.AbstractRedisClient;
import com.itmuch.redis.jdbc.Logger;
import com.itmuch.redis.jdbc.Op;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;

public class JedisRedisClient
extends AbstractRedisClient {
    public static final Logger LOGGER = new Logger(JedisRedisClient.class);
    private final Jedis jedis;

    public JedisRedisClient(Jedis jedis) {
        this.jedis = jedis;
    }

    @Override
    protected synchronized Object sendCommand(Op op) {
        String rawSql = op.getOriginSql();
        String commandString = op.getCommand();
        String[] params = op.getParams();
        int db = -1;
        try {
            db = this.jedis.getDB();
            Protocol.Command command = this.convertCommand(commandString);
            Object result = params == null || params.length == 0 ? this.jedis.sendCommand((ProtocolCommand)command) : this.jedis.sendCommand((ProtocolCommand)command, params);
            return result;
        }
        catch (Throwable e) {
            LOGGER.log("command on db %s `%s` cannot execute.", new Object[]{db, rawSql});
            throw new RuntimeException(String.format("command on db %s `%s` cannot execute.", db, rawSql));
        }
    }

    public synchronized void select(int dbIndex) {
        this.jedis.select(dbIndex);
    }

    public synchronized void close() {
        LOGGER.log("close()", new Object[0]);
        this.jedis.close();
    }
}

