/*
 * Decompiled with CFR 0.152.
 */
package com.itmuch.redis.jdbc.redis;

import com.itmuch.redis.jdbc.Logger;
import com.itmuch.redis.jdbc.RedisClient;
import com.itmuch.redis.jdbc.RedisConnection;
import com.itmuch.redis.jdbc.conf.RedisConnectionInfo;
import com.itmuch.redis.jdbc.redis.JedisRedisClient;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import redis.clients.jedis.Jedis;

public class RedisDriver
implements Driver {
    private static final Logger LOGGER = new Logger(RedisDriver.class);
    private static final String REDIS_JDBC_PREFIX = "jdbc:redis:";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            LOGGER.log("wrong url. url is %s", new Object[]{url});
            return null;
        }
        if (info == null) {
            info = new Properties();
        }
        String rawUrl = url.replaceFirst("jdbc:", "");
        RedisConnectionInfo redisConnectionInfo = new RedisConnectionInfo(rawUrl, info);
        String host = redisConnectionInfo.getHost();
        int port = redisConnectionInfo.getPort();
        int dbIndex = redisConnectionInfo.getDbIndex();
        int timeout = redisConnectionInfo.getTimeout();
        boolean ssl = redisConnectionInfo.isSsl();
        String username = redisConnectionInfo.getUsername();
        String password = redisConnectionInfo.getPassword();
        try {
            Jedis jedis = new Jedis(host, port, timeout, timeout, ssl);
            jedis.connect();
            if (username != null) {
                jedis.auth(username, password);
            } else if (password != null) {
                jedis.auth(password);
            }
            if (dbIndex != 0) {
                jedis.select(dbIndex);
            }
            return new RedisConnection((RedisClient)new JedisRedisClient(jedis), dbIndex + "", info);
        }
        catch (Exception e) {
            LOGGER.log("Cannot init RedisConnection %s", new Object[]{e});
            throw new SQLException("Cannot init RedisConnection", e);
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.toLowerCase().startsWith(REDIS_JDBC_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        LOGGER.log("getParentLogger not implemented", new Object[0]);
        throw new SQLFeatureNotSupportedException("getParentLogger not implemented");
    }

    static {
        try {
            DriverManager.registerDriver(new RedisDriver());
        }
        catch (Exception e) {
            LOGGER.log("Can't register driver!", new Object[0]);
            throw new RuntimeException("Can't register driver!", e);
        }
    }
}

