/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.common;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public final class CharArrays {
    private CharArrays() {
    }

    public static char[] utf8BytesToChars(byte[] utf8Bytes) {
        char[] chars;
        ByteBuffer byteBuffer = ByteBuffer.wrap(utf8Bytes);
        CharBuffer charBuffer = StandardCharsets.UTF_8.decode(byteBuffer);
        if (charBuffer.hasArray()) {
            chars = Arrays.copyOfRange(charBuffer.array(), charBuffer.position(), charBuffer.limit());
            Arrays.fill(charBuffer.array(), '\u0000');
        } else {
            int length = charBuffer.limit() - charBuffer.position();
            chars = new char[length];
            charBuffer.get(chars);
            if (!charBuffer.isReadOnly()) {
                charBuffer.clear();
                for (int i = 0; i < charBuffer.limit(); ++i) {
                    charBuffer.put('\u0000');
                }
            }
        }
        return chars;
    }

    public static byte[] toUtf8Bytes(char[] chars) {
        byte[] bytes;
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
        if (byteBuffer.hasArray()) {
            bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
            Arrays.fill(byteBuffer.array(), (byte)0);
        } else {
            int length = byteBuffer.limit() - byteBuffer.position();
            bytes = new byte[length];
            byteBuffer.get(bytes);
            if (!byteBuffer.isReadOnly()) {
                byteBuffer.clear();
                for (int i = 0; i < byteBuffer.limit(); ++i) {
                    byteBuffer.put((byte)0);
                }
            }
        }
        return bytes;
    }

    public static boolean charsBeginsWith(String prefix, char[] chars) {
        if (chars == null || prefix == null) {
            return false;
        }
        if (prefix.length() > chars.length) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (chars[i] == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean constantTimeEquals(char[] a, char[] b) {
        Objects.requireNonNull(a, "char arrays must not be null for constantTimeEquals");
        Objects.requireNonNull(b, "char arrays must not be null for constantTimeEquals");
        if (a.length != b.length) {
            return false;
        }
        int equals = 0;
        for (int i = 0; i < a.length; ++i) {
            equals |= a[i] ^ b[i];
        }
        return equals == 0;
    }

    public static boolean constantTimeEquals(String a, String b) {
        Objects.requireNonNull(a, "strings must not be null for constantTimeEquals");
        Objects.requireNonNull(b, "strings must not be null for constantTimeEquals");
        if (a.length() != b.length()) {
            return false;
        }
        int equals = 0;
        for (int i = 0; i < a.length(); ++i) {
            equals |= a.charAt(i) ^ b.charAt(i);
        }
        return equals == 0;
    }
}

