/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.xpack.sql.client;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public abstract class StringUtils {
    public static final String EMPTY = "";
    public static final String SLASH = "/";
    public static final String PATH_TOP = "..";
    public static final String PATH_CURRENT = ".";
    public static final String DEFAULT_DELIMITER = ",";

    public static String nullAsEmpty(String string) {
        return string == null ? EMPTY : string;
    }

    public static boolean hasText(CharSequence sequence) {
        if (!StringUtils.hasLength(sequence)) {
            return false;
        }
        int length = sequence.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(sequence.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLength(CharSequence sequence) {
        return sequence != null && sequence.length() > 0;
    }

    public static boolean isUpperCase(CharSequence sequence) {
        for (int i = 0; i < sequence.length(); ++i) {
            if (!Character.isLetter(sequence.charAt(i)) || Character.isUpperCase(sequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String[] splitToIndexAndType(String pattern) {
        List<String> tokens = StringUtils.tokenize(pattern, PATH_CURRENT);
        String[] results = new String[2];
        if (tokens.size() == 2) {
            results[0] = tokens.get(0);
            results[1] = tokens.get(1);
        } else {
            results[0] = StringUtils.nullAsEmpty(pattern);
            results[1] = EMPTY;
        }
        return results;
    }

    public static List<String> tokenize(String string) {
        return StringUtils.tokenize(string, DEFAULT_DELIMITER);
    }

    public static List<String> tokenize(String string, String delimiters) {
        return StringUtils.tokenize(string, delimiters, true, true);
    }

    public static List<String> tokenize(String string, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (!StringUtils.hasText(string)) {
            return Collections.emptyList();
        }
        StringTokenizer st = new StringTokenizer(string, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public static String concatenate(Collection<?> list) {
        return StringUtils.concatenate(list, DEFAULT_DELIMITER);
    }

    public static String concatenate(Collection<?> list, String delimiter) {
        if (list == null || list.isEmpty()) {
            return EMPTY;
        }
        if (delimiter == null) {
            delimiter = EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        for (Object object : list) {
            sb.append(object.toString());
            sb.append(delimiter);
        }
        sb.setLength(sb.length() - delimiter.length());
        return sb.toString();
    }

    public static String normalize(String path) {
        int i;
        if (path == null) {
            return null;
        }
        String pathToUse = path.replace("\\", SLASH);
        int prefixIndex = pathToUse.indexOf(":");
        String prefix = EMPTY;
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (prefix.contains(SLASH)) {
                prefix = EMPTY;
            } else {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            }
        }
        if (pathToUse.startsWith(SLASH)) {
            prefix = prefix + SLASH;
            pathToUse = pathToUse.substring(1);
        }
        List<String> pathList = StringUtils.tokenize(pathToUse, SLASH);
        LinkedList<String> pathTokens = new LinkedList<String>();
        int tops = 0;
        for (i = pathList.size() - 1; i >= 0; --i) {
            String element = pathList.get(i);
            if (PATH_CURRENT.equals(element)) continue;
            if (PATH_TOP.equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathTokens.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathTokens.add(0, PATH_TOP);
        }
        return prefix + StringUtils.concatenate(pathTokens, SLASH);
    }

    public static String asUTFString(byte[] content) {
        return StringUtils.asUTFString(content, 0, content.length);
    }

    public static String asUTFString(byte[] content, int offset, int length) {
        return content == null || length == 0 ? EMPTY : new String(content, offset, length, StandardCharsets.UTF_8);
    }

    public static byte[] toUTF(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    private static int levenshteinDistance(CharSequence one, CharSequence another, int threshold) {
        int n = one.length();
        int m = another.length();
        if (n == 0) {
            return m <= threshold ? m : -1;
        }
        if (m == 0) {
            return n <= threshold ? n : -1;
        }
        if (n > m) {
            CharSequence tmp = one;
            one = another;
            another = tmp;
            n = m;
            m = another.length();
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        int boundary = Math.min(n, threshold) + 1;
        for (int i = 0; i < boundary; ++i) {
            p[i] = i;
        }
        Arrays.fill(p, boundary, p.length, Integer.MAX_VALUE);
        Arrays.fill(d, Integer.MAX_VALUE);
        for (int j = 1; j <= m; ++j) {
            int max;
            char t_j = another.charAt(j - 1);
            d[0] = j;
            int min = Math.max(1, j - threshold);
            int n2 = max = j > Integer.MAX_VALUE - threshold ? n : Math.min(n, j + threshold);
            if (min > max) {
                return -1;
            }
            if (min > 1) {
                d[min - 1] = Integer.MAX_VALUE;
            }
            for (int i = min; i <= max; ++i) {
                d[i] = one.charAt(i - 1) == t_j ? p[i - 1] : 1 + Math.min(Math.min(d[i - 1], p[i]), p[i - 1]);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        if (p[n] <= threshold) {
            return p[n];
        }
        return -1;
    }

    public static List<String> findSimilar(CharSequence match, Collection<String> potential) {
        ArrayList<String> list = new ArrayList<String>(3);
        int maxDistance = 5;
        for (String string : potential) {
            int dist = StringUtils.levenshteinDistance(match, string, maxDistance);
            if (dist < 0) continue;
            if (dist < maxDistance) {
                maxDistance = dist;
                list.clear();
                list.add(string);
                continue;
            }
            if (dist != maxDistance) continue;
            list.add(string);
        }
        return list;
    }

    public static boolean parseBoolean(String input) {
        switch (input) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw new IllegalArgumentException("must be [true] or [false]");
    }

    public static String asHexString(byte[] content, int offset, int length) {
        StringBuilder buf = new StringBuilder();
        for (int i = offset; i < length; ++i) {
            String hex = Integer.toHexString(0xFF & content[i]);
            if (hex.length() == 1) {
                buf.append('0');
            }
            buf.append(hex);
        }
        return buf.toString();
    }

    public static String repeatString(String in, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("negative count: " + count);
        }
        StringBuffer sb = new StringBuffer(in.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(in);
        }
        return sb.toString();
    }
}

