/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.xpack.sql.proto;

import java.security.InvalidParameterException;

public class SqlVersion
implements Comparable<SqlVersion> {
    public final int id;
    public final String version;
    public final byte major;
    public final byte minor;
    public final byte revision;
    public static final int REVISION_MULTIPLIER = 100;
    public static final int MINOR_MULTIPLIER = 10000;
    public static final int MAJOR_MULTIPLIER = 1000000;
    public static final SqlVersion V_7_7_0 = new SqlVersion(7, 7, 0);

    public SqlVersion(byte major, byte minor, byte revision) {
        this(SqlVersion.toString(major, minor, revision), major, minor, revision);
    }

    public SqlVersion(Integer major, Integer minor, Integer revision) {
        this(major.byteValue(), minor.byteValue(), revision.byteValue());
        if (major > 127 || minor > 127 || revision > 127) {
            throw new InvalidParameterException("Invalid version initialisers [" + major + ", " + minor + ", " + revision + "]");
        }
    }

    protected SqlVersion(String version, byte ... parts) {
        this.version = version;
        assert (parts.length >= 3) : "Version must be initialized with all Major.Minor.Revision components";
        this.major = parts[0];
        this.minor = parts[1];
        this.revision = parts[2];
        if ((this.major | this.minor | this.revision) < 0 || this.minor >= 100 || this.revision >= 100) {
            throw new InvalidParameterException("Invalid version initialisers [" + this.major + ", " + this.minor + ", " + this.revision + "]");
        }
        this.id = Integer.valueOf(this.major) * 1000000 + Integer.valueOf(this.minor) * 10000 + Integer.valueOf(this.revision) * 100;
    }

    public static SqlVersion fromString(String version) {
        if (version == null || version.isEmpty()) {
            return null;
        }
        return new SqlVersion(version, SqlVersion.from(version));
    }

    protected static byte[] from(String ver) {
        String[] parts = ver.split("[.-]");
        if (parts.length >= 3 && parts.length <= 5) {
            try {
                return new byte[]{Byte.parseByte(parts[0]), Byte.parseByte(parts[1]), Byte.parseByte(parts[2])};
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid version format [" + ver + "]: " + nfe.getMessage());
            }
        }
        throw new IllegalArgumentException("Invalid version format [" + ver + "]");
    }

    private static String toString(byte ... parts) {
        assert (parts.length >= 1) : "Version must contain at least a Major component";
        String ver = String.valueOf(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            ver = ver + "." + parts[i];
        }
        return ver;
    }

    public String toString() {
        return SqlVersion.toString(this.major, this.minor, this.revision);
    }

    public String majorMinorToString() {
        return SqlVersion.toString(this.major, this.minor);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            return ((SqlVersion)o).id == this.id;
        }
        if (o.getClass() == String.class) {
            try {
                SqlVersion v = SqlVersion.fromString((String)o);
                return this.equals(v);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public int compareTo(SqlVersion o) {
        return this.id - o.id;
    }

    public static int majorMinorId(SqlVersion v) {
        return v.major * 1000000 + v.minor * 10000;
    }

    public int compareToMajorMinor(SqlVersion o) {
        return SqlVersion.majorMinorId(this) - SqlVersion.majorMinorId(o);
    }

    public static boolean hasVersionCompatibility(SqlVersion version) {
        return version.compareTo(V_7_7_0) >= 0;
    }

    public static boolean isClientCompatible(SqlVersion version) {
        return V_7_7_0.compareTo(version) <= 0;
    }
}

