/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.plugin.http.cratedb;

import io.edurt.datacap.plugin.http.cratedb.CrateDBResponse;
import io.edurt.datacap.spi.adapter.HttpAdapter;
import io.edurt.datacap.spi.connection.HttpConfigure;
import io.edurt.datacap.spi.connection.HttpConnection;
import io.edurt.datacap.spi.connection.http.HttpClient;
import io.edurt.datacap.spi.connection.http.HttpMethod;
import io.edurt.datacap.spi.json.JSON;
import io.edurt.datacap.spi.model.Response;
import io.edurt.datacap.spi.model.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrateDBAdapter
extends HttpAdapter {
    private static final Logger log = LoggerFactory.getLogger(CrateDBAdapter.class);

    public CrateDBAdapter(HttpConnection httpConnection) {
        super(httpConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handlerExecute(String content) {
        Time processorTime = new Time();
        processorTime.setStart(new Date().getTime());
        Response response = this.httpConnection.getResponse();
        HttpConfigure httpConfigure = new HttpConfigure();
        if (response.getIsConnected().booleanValue()) {
            ArrayList<String> headers = new ArrayList<String>();
            ArrayList<String> types = new ArrayList<String>();
            ArrayList<Object> columns = new ArrayList<Object>();
            try {
                BeanUtils.copyProperties((Object)httpConfigure, (Object)this.httpConnection.getConfigure());
                httpConfigure.setAutoConnected(Boolean.FALSE);
                httpConfigure.setRetry(Integer.valueOf(0));
                httpConfigure.setPath("_sql?types");
                httpConfigure.setMethod(HttpMethod.POST);
                HashMap<String, String> body = new HashMap<String, String>();
                body.put("stmt", content);
                httpConfigure.setJsonBody(JSON.toJSON(body));
                HttpConnection httpConnection = new HttpConnection(httpConfigure, new Response());
                HttpClient httpClient = HttpClient.getInstance((HttpConfigure)httpConfigure, (HttpConnection)httpConnection);
                String responseBody = httpClient.execute();
                CrateDBResponse applyResponse = (CrateDBResponse)JSON.objectmapper.readValue(responseBody, CrateDBResponse.class);
                if (ObjectUtils.isNotEmpty((Object)applyResponse.getError())) {
                    throw new Exception(String.join((CharSequence)":", applyResponse.getError().getCode(), applyResponse.getError().getMessage()));
                }
                headers.addAll(applyResponse.getHeaders());
                types.addAll(applyResponse.getTypes());
                for (Object column : applyResponse.getColumns()) {
                    List _columns = (List)column;
                    columns.add(this.handlerFormatter(httpConfigure.getFormat(), headers, _columns));
                }
                response.setIsSuccessful(Boolean.TRUE);
            }
            catch (Exception ex) {
                log.error("Execute content failed content {} exception ", (Object)content, (Object)ex);
                response.setIsSuccessful(Boolean.FALSE);
                response.setMessage(ex.getMessage());
            }
            finally {
                response.setHeaders(headers);
                response.setTypes(types);
                response.setColumns(columns);
            }
        }
        processorTime.setEnd(new Date().getTime());
        response.setProcessor(processorTime);
        return response;
    }
}

