/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.plugin.http.cratedb;

import io.edurt.datacap.plugin.http.cratedb.CrateDBAdapter;
import io.edurt.datacap.plugin.http.cratedb.CrateDBConnection;
import io.edurt.datacap.spi.Plugin;
import io.edurt.datacap.spi.PluginType;
import io.edurt.datacap.spi.connection.HttpConfigure;
import io.edurt.datacap.spi.connection.HttpConnection;
import io.edurt.datacap.spi.model.Configure;
import io.edurt.datacap.spi.model.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrateDBPlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(CrateDBPlugin.class);
    private HttpConfigure httpConfigure;
    private HttpConnection connection;
    private Response response;

    public String name() {
        return "CrateDB";
    }

    public String description() {
        return "Integrate CrateDB data sources";
    }

    public PluginType type() {
        return PluginType.HTTP;
    }

    public void connect(Configure configure) {
        try {
            this.response = new Response();
            this.httpConfigure = new HttpConfigure();
            BeanUtils.copyProperties((Object)this.httpConfigure, (Object)configure);
            this.connection = new CrateDBConnection(this.httpConfigure, this.response);
        }
        catch (Exception ex) {
            this.response.setIsConnected(Boolean.FALSE);
            this.response.setMessage(ex.getMessage());
        }
    }

    public Response execute(String content) {
        if (ObjectUtils.isNotEmpty((Object)this.connection)) {
            log.info("Execute cratedb plugin logic started");
            this.response = this.connection.getResponse();
            CrateDBAdapter processor = new CrateDBAdapter(this.connection);
            this.response = processor.handlerExecute(content);
            log.info("Execute cratedb plugin logic end");
        }
        return this.response;
    }

    public void destroy() {
        if (ObjectUtils.isNotEmpty((Object)this.connection)) {
            this.connection.destroy();
        }
    }
}

