/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.plugin.jdbc.db2;

import io.edurt.datacap.plugin.jdbc.db2.Db2Adapter;
import io.edurt.datacap.spi.Plugin;
import io.edurt.datacap.spi.PluginType;
import io.edurt.datacap.spi.connection.JdbcConfigure;
import io.edurt.datacap.spi.connection.JdbcConnection;
import io.edurt.datacap.spi.model.Configure;
import io.edurt.datacap.spi.model.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2Plugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(Db2Plugin.class);
    private JdbcConfigure jdbcConfigure;
    private JdbcConnection connection;
    private Response response;

    public String validator() {
        return "SELECT\n  replace(SERVICE_LEVEL, 'DB2 v', '') AS version\nFROM\n  SYSIBMADM.ENV_INST_INFO";
    }

    public String name() {
        return "DB2";
    }

    public String description() {
        return "Integrate DB2 data sources";
    }

    public PluginType type() {
        return PluginType.JDBC;
    }

    public void connect(Configure configure) {
        try {
            this.response = new Response();
            this.jdbcConfigure = new JdbcConfigure();
            BeanUtils.copyProperties((Object)this.jdbcConfigure, (Object)configure);
            this.jdbcConfigure.setJdbcDriver("com.ibm.db2.jcc.DB2Driver");
            this.jdbcConfigure.setJdbcType("db2");
            this.connection = new JdbcConnection(this.jdbcConfigure, this.response);
        }
        catch (Exception ex) {
            this.response.setIsConnected(Boolean.FALSE);
            this.response.setMessage(ex.getMessage());
        }
    }

    public Response execute(String content) {
        if (ObjectUtils.isNotEmpty((Object)this.connection)) {
            log.info("Execute db2 plugin logic started");
            this.response = this.connection.getResponse();
            Db2Adapter processor = new Db2Adapter(this.connection);
            this.response = processor.handlerExecute(content);
            log.info("Execute db2 plugin logic end");
        }
        return this.response;
    }

    public void destroy() {
        if (ObjectUtils.isNotEmpty((Object)this.connection)) {
            this.connection.destroy();
        }
    }
}

