/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.mcl.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.monetdb.mcl.io.LineType;

public final class BufferedMCLReader
extends BufferedReader {
    private LineType lineType = LineType.UNKNOWN;

    public BufferedMCLReader(Reader reader) {
        super(reader);
    }

    public BufferedMCLReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
        super(new InputStreamReader(inputStream, string));
    }

    @Override
    public String readLine() throws IOException {
        String string = super.readLine();
        this.setLineType(string);
        if (this.lineType == LineType.ERROR && string != null && !string.matches("^![0-9A-Z]{5}!.+")) {
            string = "!22000!" + string.substring(1);
        }
        return string;
    }

    public void setLineType(String string) {
        this.lineType = LineType.classify(string);
    }

    public LineType getLineType() {
        return this.lineType;
    }

    public final synchronized String waitForPrompt() throws IOException {
        StringBuilder stringBuilder = new StringBuilder(128);
        while (this.lineType != LineType.PROMPT) {
            String string = this.readLine();
            if (string == null) {
                throw new IOException("Connection to server lost!");
            }
            if (this.lineType != LineType.ERROR) continue;
            stringBuilder.append('\n').append(string.substring(1));
        }
        return stringBuilder.length() == 0 ? null : stringBuilder.toString().trim();
    }
}

