/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.plugin.jdbc.redis;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.edurt.datacap.spi.adapter.JdbcAdapter;
import io.edurt.datacap.spi.column.JdbcColumn;
import io.edurt.datacap.spi.connection.JdbcConfigure;
import io.edurt.datacap.spi.connection.JdbcConnection;
import io.edurt.datacap.spi.model.Response;
import io.edurt.datacap.spi.model.Time;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="I prefer to suppress these FindBugs warnings")
public class RedisAdapter
extends JdbcAdapter {
    private static final Logger log = LoggerFactory.getLogger(RedisAdapter.class);

    public RedisAdapter(JdbcConnection jdbcConnection) {
        super(jdbcConnection);
    }

    public Response handlerExecute(String content) {
        Time processorTime = new Time();
        processorTime.setStart(new Date().getTime());
        Response response = this.jdbcConnection.getResponse();
        Connection connection = (Connection)this.jdbcConnection.getConnection();
        JdbcConfigure configure = (JdbcConfigure)this.jdbcConnection.getConfigure();
        if (response.getIsConnected().booleanValue()) {
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery(content);){
                ArrayList<String> headers = new ArrayList<String>();
                ArrayList<String> types = new ArrayList<String>();
                ArrayList<Object> columns = new ArrayList<Object>();
                boolean isPresent = true;
                JdbcColumn jdbcColumn = new JdbcColumn(resultSet);
                while (resultSet.next()) {
                    ResultSetMetaData metaData = resultSet.getMetaData();
                    int columnCount = metaData.getColumnCount();
                    ArrayList<Object> _columns = new ArrayList<Object>();
                    for (int i = 1; i <= columnCount; ++i) {
                        if (isPresent) {
                            headers.add(metaData.getColumnName(i));
                            types.add(metaData.getColumnTypeName(i));
                        }
                        _columns.add(jdbcColumn.convert(metaData.getColumnTypeName(i), Integer.valueOf(i)));
                    }
                    isPresent = false;
                    columns.add(this.handlerFormatter(configure.getFormat(), headers, _columns));
                }
                response.setHeaders(headers);
                response.setTypes(types);
                response.setColumns(columns);
                response.setIsSuccessful(Boolean.TRUE);
            }
            catch (SQLException ex) {
                log.error("Execute content failed content {} exception ", (Object)content, (Object)ex);
                response.setIsSuccessful(Boolean.FALSE);
                response.setMessage(ex.getMessage());
            }
        }
        processorTime.setEnd(new Date().getTime());
        response.setProcessor(processorTime);
        this.jdbcConnection.destroy();
        return response;
    }
}

