/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.plugin.jdbc.redis;

import io.edurt.datacap.plugin.jdbc.redis.RedisAdapter;
import io.edurt.datacap.spi.Plugin;
import io.edurt.datacap.spi.PluginType;
import io.edurt.datacap.spi.connection.JdbcConfigure;
import io.edurt.datacap.spi.connection.JdbcConnection;
import io.edurt.datacap.spi.model.Configure;
import io.edurt.datacap.spi.model.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisPlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(RedisPlugin.class);
    private JdbcConfigure jdbcConfigure;
    private JdbcConnection jdbcConnection;
    private Response response;

    public String validator() {
        return "set app datacap";
    }

    public String name() {
        return "Redis";
    }

    public String description() {
        return "Integrate Redis data sources";
    }

    public PluginType type() {
        return PluginType.JDBC;
    }

    public void connect(Configure configure) {
        try {
            this.response = new Response();
            this.jdbcConfigure = new JdbcConfigure();
            BeanUtils.copyProperties((Object)this.jdbcConfigure, (Object)configure);
            this.jdbcConfigure.setJdbcDriver("com.itmuch.redis.jdbc.redis.RedisDriver");
            this.jdbcConfigure.setJdbcType("redis");
            this.jdbcConfigure.setUsername(configure.getUsername().map(u -> "".equals(u) ? null : u));
            this.jdbcConfigure.setPassword(configure.getPassword().map(pwd -> "".equals(pwd) ? null : pwd));
            this.jdbcConnection = new JdbcConnection(this.jdbcConfigure, this.response);
        }
        catch (Exception ex) {
            this.response.setIsConnected(Boolean.FALSE);
            this.response.setMessage(ex.getMessage());
        }
    }

    public Response execute(String content) {
        if (ObjectUtils.isNotEmpty((Object)this.jdbcConnection)) {
            log.info("Execute plugin logic started");
            this.response = this.jdbcConnection.getResponse();
            RedisAdapter processor = new RedisAdapter(this.jdbcConnection);
            this.response = processor.handlerExecute(content);
            log.info("Execute plugin logic end");
        }
        return this.response;
    }

    public void destroy() {
        if (ObjectUtils.isNotEmpty((Object)this.jdbcConnection)) {
            this.jdbcConnection.destroy();
        }
    }
}

