/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.distributed;

import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.apache.tephra.InvalidTruncateTimeException;
import org.apache.tephra.TransactionConflictException;
import org.apache.tephra.TransactionManager;
import org.apache.tephra.TransactionNotInProgressException;
import org.apache.tephra.TransactionSizeException;
import org.apache.tephra.distributed.TransactionConverterUtils;
import org.apache.tephra.distributed.thrift.TBoolean;
import org.apache.tephra.distributed.thrift.TGenericException;
import org.apache.tephra.distributed.thrift.TInvalidTruncateTimeException;
import org.apache.tephra.distributed.thrift.TTransaction;
import org.apache.tephra.distributed.thrift.TTransactionConflictException;
import org.apache.tephra.distributed.thrift.TTransactionCouldNotTakeSnapshotException;
import org.apache.tephra.distributed.thrift.TTransactionNotInProgressException;
import org.apache.tephra.distributed.thrift.TTransactionServer;
import org.apache.tephra.rpc.RPCServiceHandler;
import org.apache.tephra.txprune.TransactionPruningService;
import org.apache.thrift.TException;

public class TransactionServiceThriftHandler
implements TTransactionServer.Iface,
RPCServiceHandler {
    private final TransactionManager txManager;
    private final TransactionPruningService pruningService;

    public TransactionServiceThriftHandler(TransactionManager txManager, TransactionPruningService pruningService) {
        this.txManager = txManager;
        this.pruningService = pruningService;
    }

    @Override
    public TTransaction startLong() throws TException {
        return TransactionConverterUtils.wrap(this.txManager.startLong());
    }

    @Override
    public TTransaction startShort() throws TException {
        return TransactionConverterUtils.wrap(this.txManager.startShort());
    }

    @Override
    public TTransaction startLongClientId(String clientId) throws TException {
        try {
            return TransactionConverterUtils.wrap(this.txManager.startLong(clientId));
        }
        catch (IllegalArgumentException ex) {
            throw new TGenericException(ex.getMessage(), ex.getClass().getName());
        }
    }

    @Override
    public TTransaction startShortTimeout(int timeout) throws TException {
        return TransactionConverterUtils.wrap(this.txManager.startShort(timeout));
    }

    @Override
    public TTransaction startShortClientId(String clientId) throws TException {
        try {
            return TransactionConverterUtils.wrap(this.txManager.startShort(clientId));
        }
        catch (IllegalArgumentException ex) {
            throw new TGenericException(ex.getMessage(), ex.getClass().getName());
        }
    }

    @Override
    public TTransaction startShortWithClientIdAndTimeOut(String clientId, int timeout) throws TException {
        try {
            return TransactionConverterUtils.wrap(this.txManager.startShort(clientId, timeout));
        }
        catch (IllegalArgumentException ex) {
            throw new TGenericException(ex.getMessage(), ex.getClass().getName());
        }
    }

    @Override
    public TTransaction startShortWithTimeout(int timeout) throws TException {
        try {
            return TransactionConverterUtils.wrap(this.txManager.startShort(timeout));
        }
        catch (IllegalArgumentException e) {
            throw new TGenericException(e.getMessage(), e.getClass().getName());
        }
    }

    @Override
    public TBoolean canCommitTx(TTransaction tx, Set<ByteBuffer> changes) throws TException {
        try {
            this.canCommitOrThrow(tx.getTransactionId(), changes);
            return new TBoolean(true);
        }
        catch (TGenericException | TTransactionConflictException e) {
            return new TBoolean(false);
        }
    }

    @Override
    public void canCommitOrThrow(long txId, Set<ByteBuffer> changes) throws TException {
        HashSet changeIds = Sets.newHashSet();
        for (ByteBuffer bb : changes) {
            byte[] changeId = new byte[bb.remaining()];
            bb.get(changeId);
            changeIds.add(changeId);
        }
        try {
            this.txManager.canCommit(txId, changeIds);
        }
        catch (TransactionNotInProgressException e) {
            throw new TTransactionNotInProgressException(e.getMessage());
        }
        catch (TransactionSizeException e) {
            throw new TGenericException(e.getMessage(), TransactionSizeException.class.getName());
        }
        catch (TransactionConflictException e) {
            throw new TTransactionConflictException(e.getTransactionId(), e.getConflictingKey(), e.getConflictingClient());
        }
    }

    @Override
    public TBoolean commitTx(TTransaction tx) throws TException {
        try {
            this.commitOrThrow(tx.getTransactionId(), tx.getWritePointer());
            return new TBoolean(true);
        }
        catch (TGenericException | TTransactionConflictException e) {
            return new TBoolean(false);
        }
    }

    @Override
    public void commitOrThrow(long txId, long wp) throws TException {
        try {
            this.txManager.commit(txId, wp);
        }
        catch (TransactionNotInProgressException e) {
            throw new TTransactionNotInProgressException(e.getMessage());
        }
        catch (TransactionConflictException e) {
            throw new TTransactionConflictException(e.getTransactionId(), e.getConflictingKey(), e.getConflictingClient());
        }
    }

    @Override
    public void abortTx(TTransaction tx) throws TException {
        this.txManager.abort(TransactionConverterUtils.unwrap(tx));
    }

    @Override
    public boolean invalidateTx(long tx) throws TException {
        return this.txManager.invalidate(tx);
    }

    @Override
    public ByteBuffer getSnapshot() throws TException {
        try {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                boolean snapshotTaken = this.txManager.takeSnapshot(out);
                if (!snapshotTaken) {
                    throw new TTransactionCouldNotTakeSnapshotException("Transaction manager could not get a snapshot.");
                }
            }
            return ByteBuffer.wrap(out.toByteArray());
        }
        catch (IOException e) {
            throw new TTransactionCouldNotTakeSnapshotException(e.getMessage());
        }
    }

    @Override
    public void resetState() throws TException {
        this.txManager.resetState();
    }

    @Override
    public String status() throws TException {
        return this.txManager.isRunning() ? "OK" : "NOTOK";
    }

    @Override
    public TBoolean truncateInvalidTx(Set<Long> txns) throws TException {
        return new TBoolean(this.txManager.truncateInvalidTx(txns));
    }

    @Override
    public TBoolean truncateInvalidTxBefore(long time) throws TException {
        try {
            return new TBoolean(this.txManager.truncateInvalidTxBefore(time));
        }
        catch (InvalidTruncateTimeException e) {
            throw new TInvalidTruncateTimeException(e.getMessage());
        }
    }

    @Override
    public int invalidTxSize() throws TException {
        return this.txManager.getInvalidSize();
    }

    @Override
    public TTransaction checkpoint(TTransaction originalTx) throws TException {
        try {
            return TransactionConverterUtils.wrap(this.txManager.checkpoint(TransactionConverterUtils.unwrap(originalTx)));
        }
        catch (TransactionNotInProgressException e) {
            throw new TTransactionNotInProgressException(e.getMessage());
        }
    }

    @Override
    public void pruneNow() throws TException {
        this.pruningService.pruneNow();
    }

    @Override
    public void init() throws Exception {
        this.txManager.startAndWait();
    }

    @Override
    public void destroy() throws Exception {
        this.txManager.stopAndWait();
    }
}

