/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.spi;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import io.edurt.datacap.spi.PluginModule;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLoader
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(PluginLoader.class);
    private final Iterable<PluginModule> externalModules;

    public PluginLoader() {
        this.externalModules = ServiceLoader.load(PluginModule.class);
    }

    public PluginLoader(Iterable<PluginModule> externalModules) {
        this.externalModules = externalModules;
    }

    protected void configure() {
        log.info("Loading plugin start ...");
        for (PluginModule plugin : this.externalModules) {
            log.info("Install plugin <{}> type <{}>", (Object)plugin.getName(), (Object)plugin.getType());
            this.install((Module)plugin.get());
        }
        Multibinder binder = Multibinder.newSetBinder((Binder)this.binder(), String.class);
        binder.addBinding().toInstance((Object)((Object)((Object)this)).getClass().getSimpleName());
        log.info("Loading plugin end ...");
    }
}

