/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.spi.column;

import io.edurt.datacap.spi.column.JdbcColumnType;
import java.sql.ResultSet;
import java.sql.SQLException;

public class JdbcColumn {
    private final ResultSet resultSet;

    public JdbcColumn(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public Object convert(String columnType, Integer columnIndex) throws SQLException {
        if (columnType.equalsIgnoreCase(JdbcColumnType.INTEGER.name()) || columnType.equalsIgnoreCase(JdbcColumnType.INT.name())) {
            return this.resultSet.getInt(columnIndex);
        }
        if (columnType.equalsIgnoreCase(JdbcColumnType.TINYINT.name())) {
            return this.resultSet.getByte(columnIndex);
        }
        if (columnType.equalsIgnoreCase(JdbcColumnType.DOUBLE.name())) {
            return this.resultSet.getDouble(columnIndex);
        }
        if (columnType.equalsIgnoreCase(JdbcColumnType.REAL.name())) {
            return Float.valueOf(this.resultSet.getFloat(columnIndex));
        }
        if (columnType.equalsIgnoreCase(JdbcColumnType.BIGINT.name())) {
            return this.resultSet.getLong(columnIndex);
        }
        if (columnType.equalsIgnoreCase(JdbcColumnType.SMALLINT.name())) {
            return this.resultSet.getShort(columnIndex);
        }
        if (columnType.equalsIgnoreCase(JdbcColumnType.DECIMAL.name())) {
            return this.resultSet.getBigDecimal(columnIndex);
        }
        if (columnType.equalsIgnoreCase(JdbcColumnType.BLOB.name())) {
            return this.resultSet.getBytes(columnIndex);
        }
        if (columnType.equalsIgnoreCase(JdbcColumnType.VARCHAR.name()) || String.class.getSimpleName().equals(columnType)) {
            return this.resultSet.getString(columnIndex);
        }
        if (columnType.equalsIgnoreCase(JdbcColumnType.BIT.name())) {
            return this.resultSet.getBoolean(columnIndex);
        }
        if (columnType.equalsIgnoreCase(JdbcColumnType.DATE.name())) {
            return this.resultSet.getDate(columnIndex);
        }
        if (columnType.equalsIgnoreCase(JdbcColumnType.TIME.name())) {
            return this.resultSet.getTime(columnIndex);
        }
        if (columnType.equalsIgnoreCase(JdbcColumnType.TIMESTAMP.name())) {
            return this.resultSet.getTimestamp(columnIndex);
        }
        return this.resultSet.getObject(columnIndex);
    }
}

