/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.spi.connection;

import io.edurt.datacap.spi.connection.Connection;
import io.edurt.datacap.spi.connection.HttpConfigure;
import io.edurt.datacap.spi.model.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnection
extends Connection {
    private static final Logger log = LoggerFactory.getLogger(HttpConnection.class);
    private HttpConfigure httpConfigure;
    private Response response;

    public HttpConnection(HttpConfigure httpConfigure, Response response) {
        super(httpConfigure, response);
    }

    @Override
    public String formatJdbcUrl() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.httpConfigure.getProtocol());
        buffer.append("://");
        buffer.append(this.httpConfigure.getHost());
        buffer.append(":");
        buffer.append(this.httpConfigure.getPort());
        if (StringUtils.isNotEmpty((CharSequence)this.httpConfigure.getPath())) {
            buffer.append("/");
            buffer.append(this.httpConfigure.getPath());
        }
        return buffer.toString();
    }

    @Override
    protected java.sql.Connection openConnection() {
        try {
            this.httpConfigure = (HttpConfigure)this.getConfigure();
            this.response = this.getResponse();
            log.info("Connection protocol {}", (Object)this.httpConfigure.getProtocol());
            log.info("Connection url {}", (Object)this.formatJdbcUrl());
            this.response.setIsConnected(Boolean.TRUE);
        }
        catch (Exception ex) {
            log.error("Connection failed ", (Throwable)ex);
            this.response.setIsConnected(Boolean.FALSE);
            this.response.setMessage(ex.getMessage());
        }
        return null;
    }

    @Override
    public void destroy() {
        log.info("Connection close skip");
    }
}

