/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.spi.connection;

import io.edurt.datacap.spi.connection.Connection;
import io.edurt.datacap.spi.connection.JdbcConfigure;
import io.edurt.datacap.spi.model.Response;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConnection
extends Connection {
    private static final Logger log = LoggerFactory.getLogger(JdbcConnection.class);
    private JdbcConfigure jdbcConfigure;
    private Response response;
    private java.sql.Connection connection;

    public JdbcConnection(JdbcConfigure jdbcConfigure, Response response) {
        super(jdbcConfigure, response);
    }

    @Override
    protected String formatJdbcUrl() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("jdbc:");
        buffer.append(this.jdbcConfigure.getJdbcType());
        buffer.append("://");
        buffer.append(this.jdbcConfigure.getHost());
        buffer.append(":");
        buffer.append(this.jdbcConfigure.getPort());
        if (this.jdbcConfigure.getDatabase().isPresent()) {
            buffer.append("/");
            buffer.append(this.jdbcConfigure.getDatabase().get());
        }
        if (this.jdbcConfigure.getSsl().isPresent() && this.jdbcConfigure.getSsl().get().booleanValue()) {
            buffer.append(String.format("?ssl=%s", this.jdbcConfigure.getSsl().get()));
        }
        if (this.jdbcConfigure.getEnv().isPresent()) {
            Map<String, Object> env = this.jdbcConfigure.getEnv().get();
            List flatEnv = env.entrySet().stream().map(value -> String.format("%s=%s", value.getKey(), value.getValue())).collect(Collectors.toList());
            if (!this.jdbcConfigure.getSsl().isPresent()) {
                buffer.append("?");
            } else {
                buffer.append("&");
            }
            buffer.append(String.join((CharSequence)"&", flatEnv));
        }
        return buffer.toString();
    }

    @Override
    protected java.sql.Connection openConnection() {
        try {
            this.jdbcConfigure = (JdbcConfigure)this.getConfigure();
            this.response = this.getResponse();
            Class.forName(this.jdbcConfigure.getJdbcDriver());
            String url = this.formatJdbcUrl();
            log.info("Connection driver {}", (Object)this.jdbcConfigure.getJdbcDriver());
            log.info("Connection url {}", (Object)url);
            if (this.jdbcConfigure.getUsername().isPresent() || this.jdbcConfigure.getPassword().isPresent()) {
                log.info("Connection username with {} password with {}", (Object)this.jdbcConfigure.getUsername().get(), (Object)"***");
                this.connection = DriverManager.getConnection(url, this.jdbcConfigure.getUsername().get(), this.jdbcConfigure.getPassword().get());
            } else {
                log.info("Connection username and password not present");
                this.connection = DriverManager.getConnection(url);
            }
            this.response.setIsConnected(Boolean.TRUE);
        }
        catch (ClassNotFoundException | SQLException ex) {
            log.error("Connection failed ", (Throwable)ex);
            this.response.setIsConnected(Boolean.FALSE);
            this.response.setMessage(ex.getMessage());
        }
        return this.connection;
    }

    @Override
    public void destroy() {
        if (ObjectUtils.isNotEmpty((Object)this.connection)) {
            try {
                this.connection.close();
            }
            catch (SQLException ex) {
                log.error("Connection close failed ", (Throwable)ex);
            }
        }
    }
}

