/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.spi.connection.http;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.edurt.datacap.spi.connection.HttpConfigure;
import io.edurt.datacap.spi.connection.HttpConnection;
import io.edurt.datacap.spi.connection.http.HttpRetryInterceptor;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.ObjectUtils;

@SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="I prefer to suppress these FindBugs warnings")
public class HttpClient {
    private static final int CONNECTION_TIME_OUT = 200000;
    private static final int SOCKET_TIME_OUT = 20000;
    private static final int MAX_IDLE_CONNECTIONS = 30;
    private static final long KEEP_ALLIVE_TIME = 60000L;
    private static volatile HttpClient httpClient;
    private final OkHttpClient okHttpClient;
    private final HttpConfigure configure;
    private final HttpConnection httpConnection;

    public HttpClient(HttpConfigure configure, HttpConnection httpConnection) {
        this.configure = configure;
        this.httpConnection = httpConnection;
        ConnectionPool connectionPool = new ConnectionPool(30, 60000L, TimeUnit.MILLISECONDS);
        this.okHttpClient = new OkHttpClient().newBuilder().readTimeout(20000L, TimeUnit.MILLISECONDS).writeTimeout(20000L, TimeUnit.MILLISECONDS).connectionPool(connectionPool).retryOnConnectionFailure(configure.getAutoConnected().booleanValue()).connectTimeout(200000L, TimeUnit.MILLISECONDS).addInterceptor((Interceptor)new HttpRetryInterceptor(configure)).addNetworkInterceptor((Interceptor)new HttpRetryInterceptor(configure)).build();
    }

    public static HttpClient getInstance(HttpConfigure configure, HttpConnection httpConnection) {
        httpClient = new HttpClient(configure, httpConnection);
        return httpClient;
    }

    public String execute() {
        switch (this.configure.getMethod()) {
            case GET: {
                return this.get();
            }
            case POST: {
                return this.post();
            }
        }
        return null;
    }

    private String get() {
        HttpUrl.Builder builder = HttpUrl.parse((String)this.httpConnection.formatJdbcUrl()).newBuilder();
        if (ObjectUtils.isNotEmpty(this.configure.getParams())) {
            for (String key : this.configure.getParams().keySet()) {
                builder.addQueryParameter(key, this.configure.getParams().get(key));
            }
        }
        Request request = new Request.Builder().addHeader("Accept-Encoding", "identity").url(builder.build().toString()).build();
        return this.execute(request);
    }

    private String post() {
        RequestBody requestBody = RequestBody.create((MediaType)this.configure.getMediaType(), (String)this.configure.getJsonBody());
        HttpUrl.Builder builder = HttpUrl.parse((String)this.httpConnection.formatJdbcUrl()).newBuilder();
        if (ObjectUtils.isNotEmpty(this.configure.getParams())) {
            for (String key : this.configure.getParams().keySet()) {
                builder.addQueryParameter(key, this.configure.getParams().get(key));
            }
        }
        Request request = new Request.Builder().post(requestBody).addHeader("Accept-Encoding", "identity").url(builder.build().toString()).build();
        return this.execute(request);
    }

    private String execute(Request request) {
        String responseBody = null;
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            responseBody = response.body().string();
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
        }
        return responseBody;
    }
}

