/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.spi.connection.http;

import com.google.common.base.Preconditions;
import io.edurt.datacap.spi.connection.HttpConfigure;
import java.net.ConnectException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HttpRetryInterceptor
implements Interceptor {
    private final HttpConfigure configure;
    private int count = 1;

    public HttpRetryInterceptor(HttpConfigure configure) {
        this.configure = configure;
    }

    public Response intercept(Interceptor.Chain chain) {
        return this.retry(chain);
    }

    public Response retry(Interceptor.Chain chain) {
        Response response = null;
        Request request = chain.request();
        try {
            Thread.sleep(2000L);
            response = chain.proceed(request);
            while (!response.isSuccessful() && this.count < this.configure.getRetry()) {
                ++this.count;
                response = this.retry(chain);
            }
        }
        catch (Exception e) {
            if (e instanceof ConnectException) {
                Preconditions.checkArgument((boolean)false, (Object)e.getMessage());
            }
            while (this.count < this.configure.getRetry()) {
                ++this.count;
                response = this.retry(chain);
            }
        }
        return response;
    }
}

