/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.plugin.jdbc.presto;

import io.edurt.datacap.plugin.jdbc.presto.PrestoAdapter;
import io.edurt.datacap.spi.Plugin;
import io.edurt.datacap.spi.PluginType;
import io.edurt.datacap.spi.connection.JdbcConfigure;
import io.edurt.datacap.spi.connection.JdbcConnection;
import io.edurt.datacap.spi.model.Configure;
import io.edurt.datacap.spi.model.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrestoPlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(PrestoPlugin.class);
    private JdbcConfigure jdbcConfigure;
    private JdbcConnection jdbcConnection;
    private Response response;

    public String validator() {
        return "SELECT node_version AS version\nFROM system.runtime.nodes\nLIMIT 1";
    }

    public String name() {
        return "Presto";
    }

    public String description() {
        return "Integrate Presto data sources";
    }

    public PluginType type() {
        return PluginType.JDBC;
    }

    public void connect(Configure configure) {
        try {
            this.response = new Response();
            this.jdbcConfigure = new JdbcConfigure();
            BeanUtils.copyProperties((Object)this.jdbcConfigure, (Object)configure);
            this.jdbcConfigure.setJdbcDriver("io.prestosql.jdbc.PrestoDriver");
            this.jdbcConfigure.setJdbcType("presto");
            this.jdbcConnection = new JdbcConnection(this.jdbcConfigure, this.response);
        }
        catch (Exception ex) {
            this.response.setIsConnected(Boolean.FALSE);
            this.response.setMessage(ex.getMessage());
        }
    }

    public Response execute(String content) {
        if (ObjectUtils.isNotEmpty((Object)this.jdbcConnection)) {
            log.info("Execute plugin logic started");
            this.response = this.jdbcConnection.getResponse();
            PrestoAdapter processor = new PrestoAdapter(this.jdbcConnection);
            this.response = processor.handlerExecute(content);
            log.info("Execute plugin logic end");
        }
        return this.response;
    }

    public void destroy() {
        if (ObjectUtils.isNotEmpty((Object)this.jdbcConnection)) {
            this.jdbcConnection.destroy();
        }
    }
}

