/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.LimitNode;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.TraverseNoParseNodeVisitor;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;

public class LimitCompiler {
    private static final ParseNodeFactory NODE_FACTORY = new ParseNodeFactory();
    public static final PDatum LIMIT_DATUM = new PDatum(){

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public PDataType getDataType() {
            return PInteger.INSTANCE;
        }

        @Override
        public Integer getMaxLength() {
            return null;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        @Override
        public SortOrder getSortOrder() {
            return SortOrder.getDefault();
        }
    };

    private LimitCompiler() {
    }

    public static Integer compile(StatementContext context, FilterableStatement statement) throws SQLException {
        LimitNode limitNode = statement.getLimit();
        if (limitNode == null) {
            return null;
        }
        LimitParseNodeVisitor visitor = new LimitParseNodeVisitor(context);
        limitNode.getLimitParseNode().accept(visitor);
        return visitor.getLimit();
    }

    private static class LimitParseNodeVisitor
    extends TraverseNoParseNodeVisitor<Void> {
        private final StatementContext context;
        private Integer limit;

        private LimitParseNodeVisitor(StatementContext context) {
            this.context = context;
        }

        public Integer getLimit() {
            return this.limit;
        }

        @Override
        public Void visit(LiteralParseNode node) throws SQLException {
            Integer limit;
            Object limitValue = node.getValue();
            if (limitValue != null && (limit = (Integer)LIMIT_DATUM.getDataType().toObject(limitValue, node.getType())) >= 0) {
                this.limit = limit;
            }
            return null;
        }

        @Override
        public Void visit(BindParseNode node) throws SQLException {
            if (this.context == null) {
                return null;
            }
            Object value = this.context.getBindManager().getBindValue(node);
            this.context.getBindManager().addParamMetaData(node, LIMIT_DATUM);
            this.visit(NODE_FACTORY.literal(value, LIMIT_DATUM.getDataType()));
            return null;
        }
    }
}

