/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.phoenix.compat.hbase.CompatObserverContext;
import org.apache.phoenix.compat.hbase.CompatPhoenixMetaDataControllerEnvironment;
import org.apache.phoenix.coprocessor.MetaDataEndpointObserver;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;

public class PhoenixMetaDataCoprocessorHost
extends CoprocessorHost<PhoenixMetaDataControllerEnvironment> {
    private RegionCoprocessorEnvironment env;
    private UserProvider userProvider;
    public static final String PHOENIX_META_DATA_COPROCESSOR_CONF_KEY = "hbase.coprocessor.phoenix.classes";
    private static final String DEFAULT_PHOENIX_META_DATA_COPROCESSOR_CONF_KEY = "org.apache.phoenix.coprocessor.PhoenixAccessController";

    PhoenixMetaDataCoprocessorHost(RegionCoprocessorEnvironment env) throws IOException {
        super(null);
        this.env = env;
        this.conf = env.getConfiguration();
        this.userProvider = UserProvider.instantiate((Configuration)this.conf);
        boolean accessCheckEnabled = this.conf.getBoolean("phoenix.acls.enabled", false);
        if (this.conf.get(PHOENIX_META_DATA_COPROCESSOR_CONF_KEY) == null && accessCheckEnabled) {
            this.conf.set(PHOENIX_META_DATA_COPROCESSOR_CONF_KEY, DEFAULT_PHOENIX_META_DATA_COPROCESSOR_CONF_KEY);
        }
        this.loadSystemCoprocessors(this.conf, PHOENIX_META_DATA_COPROCESSOR_CONF_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execOperation(CoprocessorOperation<PhoenixMetaDataControllerEnvironment> ctx) throws IOException {
        if (ctx == null) {
            return false;
        }
        boolean bypass = false;
        for (PhoenixMetaDataControllerEnvironment env : this.coprocessors) {
            if (env.getInstance() instanceof MetaDataEndpointObserver) {
                ctx.prepare((CoprocessorEnvironment)env);
                Thread currentThread = Thread.currentThread();
                ClassLoader cl = currentThread.getContextClassLoader();
                try {
                    currentThread.setContextClassLoader(env.getClassLoader());
                    ctx.call((MetaDataEndpointObserver)env.getInstance(), (ObserverContext<PhoenixMetaDataControllerEnvironment>)ctx);
                }
                catch (Throwable e) {
                    this.handleCoprocessorThrowable((CoprocessorEnvironment)env, e);
                }
                finally {
                    currentThread.setContextClassLoader(cl);
                }
                bypass |= ctx.shouldBypass();
                if (ctx.shouldComplete()) break;
            }
            ctx.postEnvCall(env);
        }
        return bypass;
    }

    protected void handleCoprocessorThrowable(CoprocessorEnvironment env, Throwable e) throws IOException {
        if (e instanceof IOException && e.getCause() instanceof DoNotRetryIOException) {
            throw (IOException)e.getCause();
        }
        super.handleCoprocessorThrowable(env, e);
    }

    public PhoenixMetaDataControllerEnvironment createEnvironment(Class<?> implClass, Coprocessor instance, int priority, int sequence, Configuration conf) {
        return new PhoenixMetaDataControllerEnvironment(this.env, instance, priority, sequence, conf);
    }

    void preGetTable(final String tenantId, final String tableName, final TableName physicalTableName) throws IOException {
        this.execOperation(new CoprocessorOperation<PhoenixMetaDataControllerEnvironment>(this.getActiveUser()){

            @Override
            public void call(MetaDataEndpointObserver observer, ObserverContext<PhoenixMetaDataControllerEnvironment> ctx) throws IOException {
                observer.preGetTable(ctx, tenantId, tableName, physicalTableName);
            }
        });
    }

    void preCreateTable(final String tenantId, final String tableName, final TableName physicalTableName, final TableName parentPhysicalTableName, final PTableType tableType, final Set<byte[]> familySet, final Set<TableName> indexes) throws IOException {
        this.execOperation(new CoprocessorOperation<PhoenixMetaDataControllerEnvironment>(this.getActiveUser()){

            @Override
            public void call(MetaDataEndpointObserver observer, ObserverContext<PhoenixMetaDataControllerEnvironment> ctx) throws IOException {
                observer.preCreateTable(ctx, tenantId, tableName, physicalTableName, parentPhysicalTableName, tableType, familySet, indexes);
            }
        });
    }

    void preCreateViewAddChildLink(final String tableName) throws IOException {
        this.execOperation(new CoprocessorOperation<PhoenixMetaDataControllerEnvironment>(this.getActiveUser()){

            @Override
            public void call(MetaDataEndpointObserver observer, ObserverContext<PhoenixMetaDataControllerEnvironment> ctx) throws IOException {
                observer.preCreateViewAddChildLink((ObserverContext<PhoenixMetaDataControllerEnvironment>)this, tableName);
            }
        });
    }

    void preDropTable(final String tenantId, final String tableName, final TableName physicalTableName, final TableName parentPhysicalTableName, final PTableType tableType, final List<PTable> indexes) throws IOException {
        this.execOperation(new CoprocessorOperation<PhoenixMetaDataControllerEnvironment>(this.getActiveUser()){

            @Override
            public void call(MetaDataEndpointObserver observer, ObserverContext<PhoenixMetaDataControllerEnvironment> ctx) throws IOException {
                observer.preDropTable(ctx, tenantId, tableName, physicalTableName, parentPhysicalTableName, tableType, indexes);
            }
        });
    }

    void preAlterTable(final String tenantId, final String tableName, final TableName physicalTableName, final TableName parentPhysicalTableName, final PTableType type) throws IOException {
        this.execOperation(new CoprocessorOperation<PhoenixMetaDataControllerEnvironment>(this.getActiveUser()){

            @Override
            public void call(MetaDataEndpointObserver observer, ObserverContext<PhoenixMetaDataControllerEnvironment> ctx) throws IOException {
                observer.preAlterTable(ctx, tenantId, tableName, physicalTableName, parentPhysicalTableName, type);
            }
        });
    }

    void preGetSchema(final String schemaName) throws IOException {
        this.execOperation(new CoprocessorOperation<PhoenixMetaDataControllerEnvironment>(this.getActiveUser()){

            @Override
            public void call(MetaDataEndpointObserver observer, ObserverContext<PhoenixMetaDataControllerEnvironment> ctx) throws IOException {
                observer.preGetSchema(ctx, schemaName);
            }
        });
    }

    public void preCreateSchema(final String schemaName) throws IOException {
        this.execOperation(new CoprocessorOperation<PhoenixMetaDataControllerEnvironment>(this.getActiveUser()){

            @Override
            public void call(MetaDataEndpointObserver observer, ObserverContext<PhoenixMetaDataControllerEnvironment> ctx) throws IOException {
                observer.preCreateSchema(ctx, schemaName);
            }
        });
    }

    void preDropSchema(final String schemaName) throws IOException {
        this.execOperation(new CoprocessorOperation<PhoenixMetaDataControllerEnvironment>(this.getActiveUser()){

            @Override
            public void call(MetaDataEndpointObserver observer, ObserverContext<PhoenixMetaDataControllerEnvironment> ctx) throws IOException {
                observer.preDropSchema(ctx, schemaName);
            }
        });
    }

    void preIndexUpdate(final String tenantId, final String indexName, final TableName physicalTableName, final TableName parentPhysicalTableName, final PIndexState newState) throws IOException {
        this.execOperation(new CoprocessorOperation<PhoenixMetaDataControllerEnvironment>(this.getActiveUser()){

            @Override
            public void call(MetaDataEndpointObserver observer, ObserverContext<PhoenixMetaDataControllerEnvironment> ctx) throws IOException {
                observer.preIndexUpdate(ctx, tenantId, indexName, physicalTableName, parentPhysicalTableName, newState);
            }
        });
    }

    private User getActiveUser() throws IOException {
        User user = RpcServer.getRequestUser();
        if (user == null) {
            user = this.userProvider.getCurrent();
        }
        return user;
    }

    void preUpsertTaskDetails(final String tableName) throws IOException {
        this.execOperation(new CoprocessorOperation<PhoenixMetaDataControllerEnvironment>(this.getActiveUser()){

            @Override
            public void call(MetaDataEndpointObserver observer, ObserverContext<PhoenixMetaDataControllerEnvironment> ctx) throws IOException {
                observer.preUpsertTaskDetails(ctx, tableName);
            }
        });
    }

    public static class PhoenixMetaDataControllerEnvironment
    extends CompatPhoenixMetaDataControllerEnvironment
    implements RegionCoprocessorEnvironment {
        PhoenixMetaDataControllerEnvironment(RegionCoprocessorEnvironment env, Coprocessor instance, int priority, int sequence, Configuration conf) {
            super(env, instance, priority, sequence, conf);
        }

        public RegionServerServices getRegionServerServices() {
            return this.env.getRegionServerServices();
        }

        public RegionCoprocessorHost getCoprocessorHost() {
            return this.env.getRegion().getCoprocessorHost();
        }

        public Region getRegion() {
            return this.env.getRegion();
        }

        public HRegionInfo getRegionInfo() {
            return this.env.getRegionInfo();
        }

        public ConcurrentMap<String, Object> getSharedData() {
            return this.env.getSharedData();
        }
    }

    private static abstract class CoprocessorOperation<T extends CoprocessorEnvironment>
    extends CompatObserverContext<T> {
        abstract void call(MetaDataEndpointObserver var1, ObserverContext<T> var2) throws IOException;

        public CoprocessorOperation(User user) {
            super(user);
        }

        void postEnvCall(T env) {
        }
    }
}

