/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.exception.DataExceedsCapacityException;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ExpressionUtil;

public abstract class ArrayModifierFunction
extends ScalarFunction {
    private boolean isNullArray;

    public ArrayModifierFunction() {
    }

    public ArrayModifierFunction(List<Expression> children) throws TypeMismatchException {
        super(children);
        Expression arrayExpr = null;
        PDataType baseDataType = null;
        Expression otherExpr = null;
        PDataType otherExpressionType = null;
        if (this.getLHSExpr().getDataType().isArrayType()) {
            arrayExpr = this.getLHSExpr();
            baseDataType = this.getLHSBaseType();
            otherExpr = this.getRHSExpr();
            otherExpressionType = this.getRHSBaseType();
        } else {
            arrayExpr = this.getRHSExpr();
            baseDataType = this.getRHSBaseType();
            otherExpr = this.getLHSExpr();
            otherExpressionType = this.getLHSBaseType();
        }
        if (!(this.getDataType() == null || otherExpr instanceof LiteralExpression && otherExpr.isNullable() || otherExpressionType.isCoercibleTo(baseDataType))) {
            throw TypeMismatchException.newException(baseDataType, otherExpressionType);
        }
        if (this.getDataType() != null && otherExpressionType.getByteSize() == null && otherExpressionType != null && baseDataType.isFixedWidth() && otherExpressionType.isFixedWidth() && arrayExpr.getMaxLength() != null && otherExpr.getMaxLength() != null && otherExpr.getMaxLength() > arrayExpr.getMaxLength()) {
            throw new DataExceedsCapacityException("Values are not size compatible");
        }
        if (this.getDataType() != null && arrayExpr.getScale() != null && otherExpr.getScale() != null && otherExpr.getScale() > arrayExpr.getScale()) {
            throw new DataExceedsCapacityException(baseDataType, arrayExpr.getMaxLength(), arrayExpr.getScale(), null);
        }
        this.init();
    }

    private void init() {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        this.isNullArray = this.getLHSExpr().getDataType().isArrayType() ? ExpressionUtil.isNull(this.getLHSExpr(), ptr) : ExpressionUtil.isNull(this.getRHSExpr(), ptr);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression arrayExpr = null;
        PDataType baseDataType = null;
        Expression otherExpr = null;
        PDataType otherExpressionType = null;
        if (this.getLHSExpr().getDataType().isArrayType()) {
            arrayExpr = this.getLHSExpr();
            baseDataType = this.getLHSBaseType();
            otherExpr = this.getRHSExpr();
            otherExpressionType = this.getRHSBaseType();
        } else {
            arrayExpr = this.getRHSExpr();
            baseDataType = this.getRHSBaseType();
            otherExpr = this.getLHSExpr();
            otherExpressionType = this.getLHSBaseType();
        }
        if (!arrayExpr.evaluate(tuple, ptr)) {
            return false;
        }
        int arrayLength = PArrayDataType.getArrayLength(ptr, baseDataType, arrayExpr.getMaxLength());
        int length = ptr.getLength();
        int offset = ptr.getOffset();
        byte[] arrayBytes = ptr.get();
        otherExpr.evaluate(tuple, ptr);
        this.checkSizeCompatibility(ptr, otherExpr.getSortOrder(), arrayExpr, baseDataType, otherExpr, otherExpressionType);
        this.coerceBytes(ptr, arrayExpr, baseDataType, otherExpr, otherExpressionType);
        return this.modifierFunction(ptr, length, offset, arrayBytes, baseDataType, arrayLength, this.getMaxLength(), arrayExpr);
    }

    protected boolean modifierFunction(ImmutableBytesWritable ptr, int len, int offset, byte[] arrayBytes, PDataType baseDataType, int arrayLength, Integer maxLength, Expression arrayExp) {
        return false;
    }

    protected void checkSizeCompatibility(ImmutableBytesWritable ptr, SortOrder sortOrder, Expression arrayExpr, PDataType baseDataType, Expression otherExpr, PDataType otherExpressionType) {
        if (!baseDataType.isSizeCompatible(ptr, null, otherExpressionType, sortOrder, otherExpr.getMaxLength(), otherExpr.getScale(), arrayExpr.getMaxLength(), arrayExpr.getScale())) {
            throw new DataExceedsCapacityException("Values are not size compatible");
        }
    }

    protected void coerceBytes(ImmutableBytesWritable ptr, Expression arrayExpr, PDataType baseDataType, Expression otherExpr, PDataType otherExpressionType) {
        baseDataType.coerceBytes(ptr, null, otherExpressionType, otherExpr.getMaxLength(), otherExpr.getScale(), otherExpr.getSortOrder(), arrayExpr.getMaxLength(), arrayExpr.getScale(), arrayExpr.getSortOrder());
    }

    public Expression getRHSExpr() {
        return (Expression)this.children.get(1);
    }

    public Expression getLHSExpr() {
        return (Expression)this.children.get(0);
    }

    public PDataType getLHSBaseType() {
        if (this.getLHSExpr().getDataType().isArrayType()) {
            return this.isNullArray ? this.getRHSExpr().getDataType() : PDataType.arrayBaseType(this.getLHSExpr().getDataType());
        }
        return this.getLHSExpr().getDataType();
    }

    public PDataType getRHSBaseType() {
        if (this.getRHSExpr().getDataType().isArrayType()) {
            return this.isNullArray ? this.getLHSExpr().getDataType() : PDataType.arrayBaseType(this.getRHSExpr().getDataType());
        }
        return this.getRHSExpr().getDataType();
    }

    @Override
    public PDataType getDataType() {
        if (this.getLHSExpr().getDataType().isArrayType()) {
            return this.isNullArray ? (this.getRHSExpr().getDataType().isArrayType() ? this.getRHSExpr().getDataType() : PDataType.fromTypeId(this.getRHSExpr().getDataType().getSqlType() + 3000)) : this.getLHSExpr().getDataType();
        }
        return this.isNullArray ? (this.getLHSExpr().getDataType().isArrayType() ? this.getLHSExpr().getDataType() : PDataType.fromTypeId(this.getLHSExpr().getDataType().getSqlType() + 3000)) : this.getRHSExpr().getDataType();
    }

    private Integer getMaxLength(Expression expression) {
        PDataType type = expression.getDataType();
        if (type.isFixedWidth() && type.getByteSize() != null) {
            return type.getByteSize();
        }
        return expression.getMaxLength();
    }

    @Override
    public Integer getMaxLength() {
        if (this.getLHSExpr().getDataType().isArrayType()) {
            return this.getMaxLength(this.isNullArray ? this.getRHSExpr() : this.getLHSExpr());
        }
        return this.getMaxLength(this.isNullArray ? this.getLHSExpr() : this.getRHSExpr());
    }

    @Override
    public SortOrder getSortOrder() {
        if (this.getLHSExpr().getDataType().isArrayType()) {
            return this.isNullArray ? this.getRHSExpr().getSortOrder() : this.getLHSExpr().getSortOrder();
        }
        return this.isNullArray ? this.getLHSExpr().getSortOrder() : this.getRHSExpr().getSortOrder();
    }

    @Override
    public Integer getScale() {
        if (this.getLHSExpr().getDataType().isArrayType()) {
            return this.isNullArray ? this.getRHSExpr().getScale() : this.getLHSExpr().getScale();
        }
        return this.isNullArray ? this.getLHSExpr().getScale() : this.getRHSExpr().getScale();
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.init();
    }
}

