/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.metrics;

import org.apache.hadoop.hbase.metrics.BaseSource;

public interface MetricsIndexerSource
extends BaseSource {
    public static final String METRICS_NAME = "PhoenixIndexer";
    public static final String METRICS_CONTEXT = "phoenix";
    public static final String METRICS_DESCRIPTION = "Metrics about the Phoenix Indexer";
    public static final String METRICS_JMX_CONTEXT = "RegionServer,sub=PhoenixIndexer";
    public static final String INDEX_PREPARE_TIME = "indexPrepareTime";
    public static final String INDEX_PREPARE_TIME_DESC = "Histogram for the time in milliseconds for preparing an index write";
    public static final String SLOW_INDEX_PREPARE = "slowIndexPrepareCalls";
    public static final String SLOW_INDEX_PREPARE_DESC = "The number of index preparations slower than the configured threshold";
    public static final String INDEX_WRITE_TIME = "indexWriteTime";
    public static final String INDEX_WRITE_TIME_DESC = "Histogram for the time in milliseconds for writing an index update";
    public static final String SLOW_INDEX_WRITE = "slowIndexWriteCalls";
    public static final String SLOW_INDEX_WRITE_DESC = "The number of index writes slower than the configured threshold";
    public static final String DUPLICATE_KEY_TIME = "duplicateKeyCheckTime";
    public static final String DUPLICATE_KEY_TIME_DESC = "Histogram for the time in milliseconds to handle ON DUPLICATE keywords";
    public static final String SLOW_DUPLICATE_KEY = "slowDuplicateKeyCheckCalls";
    public static final String SLOW_DUPLICATE_KEY_DESC = "The number of on duplicate key checks slower than the configured threshold";
    public static final String PRE_WAL_RESTORE_TIME = "preWALRestoreTime";
    public static final String PRE_WAL_RESTORE_TIME_DESC = "Histogram for the time in milliseconds for Indexer's preWALRestore";
    public static final String SLOW_PRE_WAL_RESTORE = "slowPreWALRestoreCalls";
    public static final String SLOW_PRE_WAL_RESTORE_DESC = "The number of preWALRestore calls slower than the configured threshold";
    public static final String POST_PUT_TIME = "postPutTime";
    public static final String POST_PUT_TIME_DESC = "Histogram for the time in milliseconds for Indexer's postPut";
    public static final String SLOW_POST_PUT = "slowPostPutCalls";
    public static final String SLOW_POST_PUT_DESC = "The number of postPut calls slower than the configured threshold";
    public static final String POST_DELETE_TIME = "postDeleteTime";
    public static final String POST_DELETE_TIME_DESC = "Histogram for the time in milliseconds for Indexer's postDelete";
    public static final String SLOW_POST_DELETE = "slowPostDeleteCalls";
    public static final String SLOW_POST_DELETE_DESC = "The number of postDelete calls slower than the configured threshold";
    public static final String POST_OPEN_TIME = "postOpenTime";
    public static final String POST_OPEN_TIME_DESC = "Histogram for the time in milliseconds for Indexer's postOpen";
    public static final String SLOW_POST_OPEN = "slowPostOpenCalls";
    public static final String SLOW_POST_OPEN_DESC = "The number of postOpen calls slower than the configured threshold";
    public static final String PRE_INDEX_UPDATE_TIME = "preIndexUpdateTime";
    public static final String PRE_INDEX_UPDATE_TIME_DESC = "Histogram for the time in milliseconds for index updates pre data updates";
    public static final String POST_INDEX_UPDATE_TIME = "postIndexUpdateTime";
    public static final String POST_INDEX_UPDATE_TIME_DESC = "Histogram for the time in milliseconds for index updates post data updates";
    public static final String PRE_INDEX_UPDATE_FAILURE_TIME = "preIndexUpdateFailureTime";
    public static final String PRE_INDEX_UPDATE_FAILURE_TIME_DESC = "Histogram for the time in milliseconds on failures of index updates pre data updates";
    public static final String POST_INDEX_UPDATE_FAILURE_TIME = "postIndexUpdateFailureTime";
    public static final String POST_INDEX_UPDATE_FAILURE_TIME_DESC = "Histogram for the time in milliseconds on failures of index updates post data updates";
    public static final String PRE_INDEX_UPDATE_FAILURE = "preIndexUpdateFailure";
    public static final String PRE_INDEX_UPDATE_FAILURE_DESC = "The number of failures of index updates pre data updates";
    public static final String POST_INDEX_UPDATE_FAILURE = "postIndexUpdateFailure";
    public static final String POST_INDEX_UPDATE_FAILURE_DESC = "The number of failures of index updates post data updates";

    public void updateIndexPrepareTime(String var1, long var2);

    public void incrementNumSlowIndexPrepareCalls(String var1);

    public void updateIndexWriteTime(String var1, long var2);

    public void incrementNumSlowIndexWriteCalls(String var1);

    public void updatePreWALRestoreTime(String var1, long var2);

    public void incrementNumSlowPreWALRestoreCalls(String var1);

    public void updatePostPutTime(String var1, long var2);

    public void incrementNumSlowPostPutCalls(String var1);

    public void updatePostDeleteTime(String var1, long var2);

    public void incrementNumSlowPostDeleteCalls(String var1);

    public void updatePostOpenTime(String var1, long var2);

    public void incrementNumSlowPostOpenCalls(String var1);

    public void updateDuplicateKeyCheckTime(String var1, long var2);

    public void incrementSlowDuplicateKeyCheckCalls(String var1);

    public void updatePreIndexUpdateTime(String var1, long var2);

    public void updatePostIndexUpdateTime(String var1, long var2);

    public void updatePreIndexUpdateFailureTime(String var1, long var2);

    public void updatePostIndexUpdateFailureTime(String var1, long var2);

    public void incrementPreIndexUpdateFailures(String var1);

    public void incrementPostIndexUpdateFailures(String var1);
}

