/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compat.hbase.CompatUtil;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.filter.PagedFilter;
import org.apache.phoenix.hbase.index.IndexRegionObserver;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.metrics.GlobalIndexCheckerSource;
import org.apache.phoenix.hbase.index.metrics.MetricsIndexerSourceFactory;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalIndexChecker
extends BaseScannerRegionObserver {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalIndexChecker.class);
    private HTableFactory hTableFactory;
    private GlobalIndexCheckerSource metricsSource;

    @Override
    protected boolean isRegionObserverFor(Scan scan) {
        return scan.getAttribute("_CheckVerifyColumn") != null;
    }

    @Override
    protected RegionScanner doPostScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException, SQLException {
        return new GlobalIndexScanner((RegionCoprocessorEnvironment)c.getEnvironment(), scan, s, this.metricsSource);
    }

    @Override
    public void start(CoprocessorEnvironment e) throws IOException {
        this.hTableFactory = ServerUtil.getDelegateHTableFactory(e, ServerUtil.ConnectionType.INDEX_WRITER_CONNECTION);
        this.metricsSource = MetricsIndexerSourceFactory.getInstance().getGlobalIndexCheckerSource();
    }

    public void stop(CoprocessorEnvironment e) throws IOException {
        this.hTableFactory.shutdown();
    }

    private class GlobalIndexScanner
    extends BaseRegionScanner {
        private RegionScanner scanner;
        private long ageThreshold;
        private Scan scan;
        private Scan indexScan;
        private Scan singleRowIndexScan;
        private Scan buildIndexScan;
        private Table dataHTable;
        private byte[] emptyCF;
        private byte[] emptyCQ;
        private IndexMaintainer indexMaintainer;
        private byte[][] viewConstants;
        private RegionCoprocessorEnvironment env;
        private Region region;
        private long minTimestamp;
        private long maxTimestamp;
        private GlobalIndexCheckerSource metricsSource;
        private long rowCount;
        private long pageSize;
        private boolean restartScanDueToPageFilterRemoval;
        private boolean hasMore;
        private String indexName;
        private long pageSizeMs;

        public GlobalIndexScanner(RegionCoprocessorEnvironment env, Scan scan, RegionScanner scanner, GlobalIndexCheckerSource metricsSource) throws IOException {
            super(scanner);
            this.buildIndexScan = null;
            this.dataHTable = null;
            this.indexMaintainer = null;
            this.viewConstants = null;
            this.rowCount = 0L;
            this.pageSize = Long.MAX_VALUE;
            this.restartScanDueToPageFilterRemoval = false;
            this.env = env;
            this.scan = scan;
            this.scanner = scanner;
            this.metricsSource = metricsSource;
            this.region = env.getRegion();
            this.emptyCF = scan.getAttribute("_EmptyCFName");
            this.emptyCQ = scan.getAttribute("_EmptyCQName");
            this.ageThreshold = env.getConfiguration().getLong("phoenix.global.index.row.age.threshold.to.delete.ms", 604800000L);
            this.minTimestamp = scan.getTimeRange().getMin();
            this.maxTimestamp = scan.getTimeRange().getMax();
            byte[] indexTableNameBytes = this.region.getRegionInfo().getTable().getName();
            this.indexName = Bytes.toString((byte[])indexTableNameBytes);
            byte[] md = scan.getAttribute("IdxProtoMD");
            List<IndexMaintainer> maintainers = IndexMaintainer.deserialize(md, true);
            this.indexMaintainer = IndexMaintainer.getIndexMaintainer(maintainers, indexTableNameBytes);
            if (this.indexMaintainer == null) {
                throw new DoNotRetryIOException("repairIndexRows: IndexMaintainer is not included in scan attributes for " + this.region.getRegionInfo().getTable().getNameAsString());
            }
            this.pageSizeMs = ScanUtil.getPageSizeMsForRegionScanner(scan);
        }

        @Override
        public int getBatch() {
            return this.scanner.getBatch();
        }

        @Override
        public long getMaxResultSize() {
            return this.scanner.getMaxResultSize();
        }

        public boolean next(List<Cell> result, boolean raw) throws IOException {
            try {
                long startTime = EnvironmentEdgeManager.currentTimeMillis();
                do {
                    this.hasMore = raw ? this.scanner.nextRaw(result) : this.scanner.next(result);
                    if (result.isEmpty()) break;
                    if (ScanUtil.isDummy(result)) {
                        return true;
                    }
                    Cell cell = result.get(0);
                    if (this.verifyRowAndRepairIfNecessary(result)) break;
                    if (!this.hasMore || EnvironmentEdgeManager.currentTimeMillis() - startTime < this.pageSizeMs) continue;
                    byte[] rowKey = CellUtil.cloneRow((Cell)cell);
                    result.clear();
                    ScanUtil.getDummyResult(rowKey, result);
                    return true;
                } while (this.hasMore);
                ++this.rowCount;
                if (this.rowCount == this.pageSize) {
                    return false;
                }
                return this.hasMore;
            }
            catch (Throwable t) {
                ServerUtil.throwIOException(this.region.getRegionInfo().getRegionNameAsString(), t);
                return false;
            }
        }

        @Override
        public boolean next(List<Cell> result) throws IOException {
            return this.next(result, false);
        }

        @Override
        public boolean nextRaw(List<Cell> result) throws IOException {
            return this.next(result, true);
        }

        @Override
        public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
            throw new IOException("next with scannerContext should not be called in Phoenix environment");
        }

        @Override
        public boolean nextRaw(List<Cell> result, ScannerContext scannerContext) throws IOException {
            throw new IOException("NextRaw with scannerContext should not be called in Phoenix environment");
        }

        @Override
        public void close() throws IOException {
            this.scanner.close();
            if (this.dataHTable != null) {
                this.dataHTable.close();
            }
        }

        @Override
        public HRegionInfo getRegionInfo() {
            return this.scanner.getRegionInfo();
        }

        @Override
        public boolean reseek(byte[] row) throws IOException {
            return this.scanner.reseek(row);
        }

        @Override
        public long getMvccReadPoint() {
            return this.scanner.getMvccReadPoint();
        }

        private void deleteRowIfAgedEnough(byte[] indexRowKey, long ts, boolean specific) throws IOException {
            if (EnvironmentEdgeManager.currentTimeMillis() - ts > this.ageThreshold) {
                Delete del = specific ? this.indexMaintainer.buildRowDeleteMutation(indexRowKey, IndexMaintainer.DeleteType.SINGLE_VERSION, ts) : this.indexMaintainer.buildRowDeleteMutation(indexRowKey, IndexMaintainer.DeleteType.ALL_VERSIONS, ts);
                Mutation[] mutations = new Mutation[]{del};
                this.region.batchMutate(mutations, 0L, 0L);
            }
        }

        private PageFilter removePageFilterFromFilterList(FilterList filterList) {
            Iterator filterIterator = filterList.getFilters().iterator();
            while (filterIterator.hasNext()) {
                PageFilter pageFilter;
                Filter filter = (Filter)filterIterator.next();
                if (filter instanceof PageFilter) {
                    filterIterator.remove();
                    return (PageFilter)filter;
                }
                if (!(filter instanceof FilterList) || (pageFilter = this.removePageFilterFromFilterList((FilterList)filter)) == null) continue;
                return pageFilter;
            }
            return null;
        }

        private PageFilter removePageFilter(Scan scan) {
            Filter filter = scan.getFilter();
            if (filter != null) {
                if (filter instanceof PagedFilter && (filter = ((PagedFilter)filter).getDelegateFilter()) == null) {
                    return null;
                }
                if (filter instanceof PageFilter) {
                    scan.setFilter(null);
                    return (PageFilter)filter;
                }
                if (filter instanceof FilterList) {
                    return this.removePageFilterFromFilterList((FilterList)filter);
                }
            }
            return null;
        }

        private void repairIndexRows(byte[] indexRowKey, long ts, List<Cell> row) throws IOException {
            if (this.buildIndexScan == null) {
                PageFilter pageFilter = this.removePageFilter(this.scan);
                if (pageFilter != null) {
                    this.pageSize = pageFilter.getPageSize();
                    this.restartScanDueToPageFilterRemoval = true;
                }
                this.buildIndexScan = new Scan();
                this.indexScan = new Scan(this.scan);
                this.singleRowIndexScan = new Scan(this.scan);
                byte[] dataTableName = this.scan.getAttribute("_PhysicalDataTableName");
                this.dataHTable = GlobalIndexChecker.this.hTableFactory.getTable(new ImmutableBytesPtr(dataTableName));
                this.viewConstants = IndexUtil.deserializeViewConstantsFromScan(this.scan);
                this.buildIndexScan.setAttribute("_UngroupedAgg", PDataType.TRUE_BYTES);
                this.buildIndexScan.setAttribute("IdxProtoMD", this.scan.getAttribute("IdxProtoMD"));
                this.buildIndexScan.setAttribute("_RebuildIndexes", PDataType.TRUE_BYTES);
                this.buildIndexScan.setAttribute("_SKIP_REGION_BOUNDARY_CHECK", Bytes.toBytes((boolean)true));
                for (ColumnReference columnReference : this.indexMaintainer.getAllColumnsForDataTable()) {
                    this.buildIndexScan.addColumn(columnReference.getFamily(), columnReference.getQualifier());
                }
                this.buildIndexScan.addColumn(this.indexMaintainer.getDataEmptyKeyValueCF(), this.indexMaintainer.getEmptyKeyValueQualifierForDataTable());
            }
            byte[] dataRowKey = this.indexMaintainer.buildDataRowKey(new ImmutableBytesWritable(indexRowKey), this.viewConstants);
            CompatUtil.setSingleRow((Scan)this.buildIndexScan, (byte[])dataRowKey);
            this.buildIndexScan.setTimeRange(0L, this.maxTimestamp);
            this.buildIndexScan.setAttribute("_IndexRowKey", indexRowKey);
            Result result = null;
            try {
                Throwable throwable = null;
                try (ResultScanner resultScanner = this.dataHTable.getScanner(this.buildIndexScan);){
                    result = resultScanner.next();
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable t) {
                ServerUtil.throwIOException(this.dataHTable.getName().toString(), t);
            }
            byte[] value = result.value();
            long l = PLong.INSTANCE.getCodec().decodeLong(new ImmutableBytesWritable(value), SortOrder.getDefault());
            if (l == (long)RebuildReturnCode.NO_DATA_ROW.getValue()) {
                this.deleteRowIfAgedEnough(indexRowKey, ts, false);
                row.clear();
                if (this.restartScanDueToPageFilterRemoval) {
                    this.scanner.close();
                    CompatUtil.setStartRow((Scan)this.indexScan, (byte[])indexRowKey, (boolean)false);
                    this.scanner = ((BaseRegionScanner)this.delegate).getNewRegionScanner(this.indexScan);
                    this.hasMore = true;
                    this.restartScanDueToPageFilterRemoval = false;
                }
                return;
            }
            this.scanner.close();
            this.restartScanDueToPageFilterRemoval = false;
            if (l == (long)RebuildReturnCode.NO_INDEX_ROW.getValue()) {
                this.deleteRowIfAgedEnough(indexRowKey, ts, false);
                CompatUtil.setStartRow((Scan)this.indexScan, (byte[])indexRowKey, (boolean)false);
                this.scanner = ((BaseRegionScanner)this.delegate).getNewRegionScanner(this.indexScan);
                this.hasMore = true;
                row.clear();
                return;
            }
            CompatUtil.setStartRow((Scan)this.indexScan, (byte[])indexRowKey, (boolean)true);
            this.scanner = ((BaseRegionScanner)this.delegate).getNewRegionScanner(this.indexScan);
            this.hasMore = this.scanner.next(row);
            if (row.isEmpty()) {
                return;
            }
            if (ScanUtil.isDummy(row)) {
                return;
            }
            if (Bytes.compareTo((byte[])row.get(0).getRowArray(), (int)row.get(0).getRowOffset(), (int)row.get(0).getRowLength(), (byte[])indexRowKey, (int)0, (int)indexRowKey.length) != 0) {
                if (this.verifyRowAndRemoveEmptyColumn(row)) {
                    return;
                }
                this.scanner.close();
                this.scanner = ((BaseRegionScanner)this.delegate).getNewRegionScanner(this.indexScan);
                this.hasMore = true;
                row.clear();
                return;
            }
            if (this.verifyRowAndRemoveEmptyColumn(row)) {
                return;
            }
            do {
                this.deleteRowIfAgedEnough(indexRowKey, ts, true);
                CompatUtil.setSingleRow((Scan)this.singleRowIndexScan, (byte[])indexRowKey);
                this.singleRowIndexScan.setTimeRange(this.minTimestamp, ts);
                RegionScanner singleRowScanner = ((BaseRegionScanner)this.delegate).getNewRegionScanner(this.singleRowIndexScan);
                row.clear();
                singleRowScanner.next(row);
                singleRowScanner.close();
                if (row.isEmpty()) {
                    LOG.error("Could not find the newly rebuilt index row with row key " + Bytes.toStringBinary((byte[])indexRowKey) + " for table " + this.region.getRegionInfo().getTable().getNameAsString());
                    return;
                }
                if (ScanUtil.isDummy(row)) {
                    return;
                }
                if (this.verifyRowAndRemoveEmptyColumn(row)) {
                    return;
                }
                ts = this.getMaxTimestamp(row);
            } while (Bytes.compareTo((byte[])row.get(0).getRowArray(), (int)row.get(0).getRowOffset(), (int)row.get(0).getRowLength(), (byte[])indexRowKey, (int)0, (int)indexRowKey.length) == 0);
            Cell cell = row.get(0);
            byte[] rowKey = CellUtil.cloneRow((Cell)cell);
            throw new DoNotRetryIOException("The scan returned a row with row key (" + Bytes.toStringBinary((byte[])rowKey) + ") different than indexRowKey (" + Bytes.toStringBinary((byte[])indexRowKey) + ") for table " + this.region.getRegionInfo().getTable().getNameAsString());
        }

        private boolean isEmptyColumn(Cell cell) {
            return Bytes.compareTo((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength(), (byte[])this.emptyCF, (int)0, (int)this.emptyCF.length) == 0 && Bytes.compareTo((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])this.emptyCQ, (int)0, (int)this.emptyCQ.length) == 0;
        }

        private void removeOlderCells(List<Cell> cellList) {
            Iterator<Cell> cellIterator = cellList.iterator();
            if (!cellIterator.hasNext()) {
                return;
            }
            Cell cell = cellIterator.next();
            long maxTs = cell.getTimestamp();
            boolean allTheSame = true;
            while (cellIterator.hasNext()) {
                cell = cellIterator.next();
                long ts = cell.getTimestamp();
                if (ts == maxTs) continue;
                if (ts > maxTs) {
                    maxTs = ts;
                }
                allTheSame = false;
            }
            if (allTheSame) {
                return;
            }
            cellIterator = cellList.iterator();
            while (cellIterator.hasNext()) {
                cell = cellIterator.next();
                if (cell.getTimestamp() == maxTs) continue;
                cellIterator.remove();
            }
        }

        private boolean verifyRowAndRemoveEmptyColumn(List<Cell> cellList) throws IOException {
            if (!this.indexMaintainer.isImmutableRows()) {
                this.removeOlderCells(cellList);
            }
            long cellListSize = cellList.size();
            Cell cell = null;
            if (cellListSize == 0L) {
                return true;
            }
            Iterator<Cell> cellIterator = cellList.iterator();
            while (cellIterator.hasNext()) {
                cell = cellIterator.next();
                if (!this.isEmptyColumn(cell)) continue;
                if (Bytes.compareTo((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength(), (byte[])IndexRegionObserver.VERIFIED_BYTES, (int)0, (int)IndexRegionObserver.VERIFIED_BYTES.length) != 0) {
                    return false;
                }
                if (cellListSize > 1L) {
                    cellIterator.remove();
                }
                return true;
            }
            return false;
        }

        private long getMaxTimestamp(List<Cell> cellList) {
            long maxTs = 0L;
            long ts = 0L;
            for (Cell cell : cellList) {
                ts = cell.getTimestamp();
                if (ts <= maxTs) continue;
                maxTs = ts;
            }
            return maxTs;
        }

        private boolean verifyRowAndRepairIfNecessary(List<Cell> cellList) throws IOException {
            this.metricsSource.incrementIndexInspections(this.indexName);
            Cell cell = cellList.get(0);
            if (this.verifyRowAndRemoveEmptyColumn(cellList)) {
                return true;
            }
            long repairStart = EnvironmentEdgeManager.currentTimeMillis();
            byte[] rowKey = CellUtil.cloneRow((Cell)cell);
            long ts = cellList.get(0).getTimestamp();
            cellList.clear();
            try {
                this.repairIndexRows(rowKey, ts, cellList);
                this.metricsSource.incrementIndexRepairs(this.indexName);
                this.metricsSource.updateUnverifiedIndexRowAge(this.indexName, EnvironmentEdgeManager.currentTimeMillis() - ts);
                this.metricsSource.updateIndexRepairTime(this.indexName, EnvironmentEdgeManager.currentTimeMillis() - repairStart);
            }
            catch (IOException e) {
                this.metricsSource.incrementIndexRepairFailures(this.indexName);
                this.metricsSource.updateIndexRepairFailureTime(this.indexName, EnvironmentEdgeManager.currentTimeMillis() - repairStart);
                throw e;
            }
            return !cellList.isEmpty();
        }
    }

    public static enum RebuildReturnCode {
        NO_DATA_ROW(0),
        NO_INDEX_ROW(1),
        INDEX_ROW_EXISTS(2);

        private int value;

        private RebuildReturnCode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

