/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.builder.BaseIndexCodec;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.hbase.index.covered.IndexUpdate;
import org.apache.phoenix.hbase.index.covered.TableState;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.PhoenixIndexMetaData;

public class PhoenixIndexCodec
extends BaseIndexCodec {
    public static final String INDEX_MD = "IdxMD";
    public static final String INDEX_PROTO_MD = "IdxProtoMD";
    public static final String INDEX_UUID = "IdxUUID";
    public static final String INDEX_MAINTAINERS = "IndexMaintainers";
    public static KeyValueBuilder KV_BUILDER = GenericKeyValueBuilder.INSTANCE;
    private byte[] tableName;

    public PhoenixIndexCodec() {
    }

    public PhoenixIndexCodec(Configuration conf, byte[] tableName) {
        this.initialize(conf, tableName);
    }

    @Override
    public void initialize(Configuration conf, byte[] tableName) {
        this.tableName = tableName;
    }

    boolean hasIndexMaintainers(Map<String, byte[]> attributes) {
        if (attributes == null) {
            return false;
        }
        byte[] uuid = attributes.get(INDEX_UUID);
        return uuid != null;
    }

    @Override
    public Iterable<IndexUpdate> getIndexUpserts(TableState state2, IndexMetaData context, byte[] regionStartKey, byte[] regionEndKey) throws IOException {
        PhoenixIndexMetaData metaData = (PhoenixIndexMetaData)context;
        List<IndexMaintainer> indexMaintainers = metaData.getIndexMaintainers();
        if (indexMaintainers.get(0).isRowDeleted(state2.getPendingUpdate())) {
            return Collections.emptyList();
        }
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ptr.set(state2.getCurrentRowKey());
        ArrayList indexUpdates = Lists.newArrayList();
        for (IndexMaintainer maintainer : indexMaintainers) {
            Pair<ValueGetter, IndexUpdate> statePair = state2.getIndexUpdateState(maintainer.getAllColumns(), metaData.getReplayWrite() != null, false, context);
            ValueGetter valueGetter = (ValueGetter)statePair.getFirst();
            IndexUpdate indexUpdate = (IndexUpdate)statePair.getSecond();
            indexUpdate.setTable(maintainer.isLocalIndex() ? this.tableName : maintainer.getIndexTableName());
            Put put = maintainer.buildUpdateMutation(KV_BUILDER, valueGetter, ptr, state2.getCurrentTimestamp(), regionStartKey, regionEndKey);
            indexUpdate.setUpdate((Mutation)put);
            indexUpdates.add(indexUpdate);
        }
        return indexUpdates;
    }

    @Override
    public Iterable<IndexUpdate> getIndexDeletes(TableState state2, IndexMetaData context, byte[] regionStartKey, byte[] regionEndKey) throws IOException {
        PhoenixIndexMetaData metaData = (PhoenixIndexMetaData)context;
        List<IndexMaintainer> indexMaintainers = metaData.getIndexMaintainers();
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ptr.set(state2.getCurrentRowKey());
        ArrayList indexUpdates = Lists.newArrayList();
        for (IndexMaintainer maintainer : indexMaintainers) {
            HashSet cols = Sets.newHashSet(maintainer.getAllColumns());
            cols.add(new ColumnReference(indexMaintainers.get(0).getDataEmptyKeyValueCF(), indexMaintainers.get(0).getEmptyKeyValueQualifier()));
            Pair<ValueGetter, IndexUpdate> statePair = state2.getIndexUpdateState(cols, metaData.getReplayWrite() != null, true, context);
            ValueGetter valueGetter = (ValueGetter)statePair.getFirst();
            if (valueGetter == null) continue;
            IndexUpdate indexUpdate = (IndexUpdate)statePair.getSecond();
            indexUpdate.setTable(maintainer.isLocalIndex() ? this.tableName : maintainer.getIndexTableName());
            Delete delete = maintainer.buildDeleteMutation(KV_BUILDER, valueGetter, ptr, state2.getPendingUpdate(), state2.getCurrentTimestamp(), regionStartKey, regionEndKey);
            indexUpdate.setUpdate((Mutation)delete);
            indexUpdates.add(indexUpdate);
        }
        return indexUpdates;
    }

    @Override
    public boolean isEnabled(Mutation m) {
        return this.hasIndexMaintainers(m.getAttributesMap());
    }
}

