/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.phoenix.jdbc.DelegatePreparedStatement;
import org.apache.phoenix.jdbc.LoggingPhoenixConnection;
import org.apache.phoenix.jdbc.LoggingPhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixMetricsLog;

public class LoggingPhoenixPreparedStatement
extends DelegatePreparedStatement {
    private PhoenixMetricsLog phoenixMetricsLog;
    private String sql;
    private Connection conn;

    public LoggingPhoenixPreparedStatement(PreparedStatement stmt, PhoenixMetricsLog phoenixMetricsLog, String sql, Connection conn) {
        super(stmt);
        this.phoenixMetricsLog = phoenixMetricsLog;
        this.sql = sql;
        this.conn = conn;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        LoggingPhoenixResultSet rs = new LoggingPhoenixResultSet(super.executeQuery(), this.phoenixMetricsLog, this.sql);
        this.loggingAutoCommitHelper();
        return rs;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ResultSet resultSet = super.getResultSet();
        return resultSet == null ? null : new LoggingPhoenixResultSet(resultSet, this.phoenixMetricsLog, this.sql);
    }

    @Override
    public int executeUpdate() throws SQLException {
        int res = super.executeUpdate();
        this.loggingAutoCommitHelper();
        return res;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return new LoggingPhoenixResultSet(super.getGeneratedKeys(), this.phoenixMetricsLog, this.sql);
    }

    private void loggingAutoCommitHelper() throws SQLException {
        if (this.conn.getAutoCommit() && this.conn instanceof LoggingPhoenixConnection) {
            ((LoggingPhoenixConnection)this.conn).loggingMetricsHelper();
        }
    }
}

