/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.phoenix.monitoring.CombinableMetric;
import org.apache.phoenix.monitoring.CombinableMetricImpl;
import org.apache.phoenix.monitoring.MetricType;

public class MutationMetricQueue {
    private Map<String, MutationMetric> tableMutationMetric = new HashMap<String, MutationMetric>();

    public void addMetricsForTable(String tableName, MutationMetric metric) {
        MutationMetric tableMetric = this.tableMutationMetric.get(tableName);
        if (tableMetric == null) {
            this.tableMutationMetric.put(tableName, metric);
        } else {
            tableMetric.combineMetric(metric);
        }
    }

    public void combineMetricQueues(MutationMetricQueue other) {
        Map<String, MutationMetric> tableMetricMap = other.tableMutationMetric;
        for (Map.Entry<String, MutationMetric> entry : tableMetricMap.entrySet()) {
            this.addMetricsForTable(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, Map<MetricType, Long>> aggregate() {
        HashMap<String, Map<MetricType, Long>> publishedMetrics = new HashMap<String, Map<MetricType, Long>>();
        for (Map.Entry<String, MutationMetric> entry : this.tableMutationMetric.entrySet()) {
            String tableName = entry.getKey();
            MutationMetric metric = entry.getValue();
            HashMap<MetricType, Long> publishedMetricsForTable = (HashMap<MetricType, Long>)publishedMetrics.get(tableName);
            if (publishedMetricsForTable == null) {
                publishedMetricsForTable = new HashMap<MetricType, Long>();
                publishedMetrics.put(tableName, publishedMetricsForTable);
            }
            publishedMetricsForTable.put(metric.getNumMutations().getMetricType(), metric.getNumMutations().getValue());
            publishedMetricsForTable.put(metric.getMutationsSizeBytes().getMetricType(), metric.getMutationsSizeBytes().getValue());
            publishedMetricsForTable.put(metric.getCommitTimeForMutations().getMetricType(), metric.getCommitTimeForMutations().getValue());
            publishedMetricsForTable.put(metric.getNumFailedMutations().getMetricType(), metric.getNumFailedMutations().getValue());
            publishedMetricsForTable.put(metric.getNumOfIndexCommitFailedMutations().getMetricType(), metric.getNumOfIndexCommitFailedMutations().getValue());
        }
        return publishedMetrics;
    }

    public void clearMetrics() {
        this.tableMutationMetric.clear();
    }

    public static class NoOpMutationMetricsQueue
    extends MutationMetricQueue {
        public static final NoOpMutationMetricsQueue NO_OP_MUTATION_METRICS_QUEUE = new NoOpMutationMetricsQueue();

        private NoOpMutationMetricsQueue() {
        }

        @Override
        public void addMetricsForTable(String tableName, MutationMetric metric) {
        }

        @Override
        public Map<String, Map<MetricType, Long>> aggregate() {
            return Collections.emptyMap();
        }
    }

    public static class MutationMetric {
        private final CombinableMetric numMutations = new CombinableMetricImpl(MetricType.MUTATION_BATCH_SIZE);
        private final CombinableMetric mutationsSizeBytes = new CombinableMetricImpl(MetricType.MUTATION_BYTES);
        private final CombinableMetric totalCommitTimeForMutations = new CombinableMetricImpl(MetricType.MUTATION_COMMIT_TIME);
        private final CombinableMetric numFailedMutations = new CombinableMetricImpl(MetricType.MUTATION_BATCH_FAILED_SIZE);
        private final CombinableMetric numOfIndexCommitFailMutations = new CombinableMetricImpl(MetricType.INDEX_COMMIT_FAILURE_SIZE);

        public MutationMetric(long numMutations, long mutationsSizeBytes, long commitTimeForMutations, long numFailedMutations, long numOfPhase3Failed) {
            this.numMutations.change(numMutations);
            this.mutationsSizeBytes.change(mutationsSizeBytes);
            this.totalCommitTimeForMutations.change(commitTimeForMutations);
            this.numFailedMutations.change(numFailedMutations);
            this.numOfIndexCommitFailMutations.change(numOfPhase3Failed);
        }

        public CombinableMetric getCommitTimeForMutations() {
            return this.totalCommitTimeForMutations;
        }

        public CombinableMetric getNumMutations() {
            return this.numMutations;
        }

        public CombinableMetric getMutationsSizeBytes() {
            return this.mutationsSizeBytes;
        }

        public CombinableMetric getNumFailedMutations() {
            return this.numFailedMutations;
        }

        public CombinableMetric getNumOfIndexCommitFailedMutations() {
            return this.numOfIndexCommitFailMutations;
        }

        public void combineMetric(MutationMetric other) {
            this.numMutations.combine(other.numMutations);
            this.mutationsSizeBytes.combine(other.mutationsSizeBytes);
            this.totalCommitTimeForMutations.combine(other.totalCommitTimeForMutations);
            this.numFailedMutations.combine(other.numFailedMutations);
            this.numOfIndexCommitFailMutations.combine(other.numOfIndexCommitFailMutations);
        }
    }
}

