/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.SingleTableStatement;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTableType;

public class AlterIndexStatement
extends SingleTableStatement {
    private final String dataTableName;
    private final boolean ifExists;
    private final PIndexState indexState;
    private boolean async;
    private boolean isRebuildAll;
    private ListMultimap<String, Pair<String, Object>> props;
    private static final PTableType tableType = PTableType.INDEX;

    public AlterIndexStatement(NamedTableNode indexTableNode, String dataTableName, boolean ifExists, PIndexState indexState, boolean isRebuildAll, boolean async) {
        this(indexTableNode, dataTableName, ifExists, indexState, isRebuildAll, async, null);
    }

    public AlterIndexStatement(NamedTableNode indexTableNode, String dataTableName, boolean ifExists, PIndexState indexState, boolean isRebuildAll, boolean async, ListMultimap<String, Pair<String, Object>> props) {
        super(indexTableNode, 0);
        this.dataTableName = dataTableName;
        this.ifExists = ifExists;
        this.indexState = indexState;
        this.async = async;
        this.isRebuildAll = isRebuildAll;
        this.props = props == null ? ImmutableListMultimap.of() : props;
    }

    public String getTableName() {
        return this.dataTableName;
    }

    @Override
    public int getBindCount() {
        return 0;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public PIndexState getIndexState() {
        return this.indexState;
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean isRebuildAll() {
        return this.isRebuildAll;
    }

    public ListMultimap<String, Pair<String, Object>> getProps() {
        return this.props;
    }

    public PTableType getTableType() {
        return tableType;
    }
}

