/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.parse.TableNodeVisitor;
import org.apache.phoenix.util.SchemaUtil;

public class DerivedTableNode
extends TableNode {
    private final SelectStatement select;

    DerivedTableNode(String alias, SelectStatement select) {
        super(SchemaUtil.normalizeIdentifier(alias));
        this.select = select;
    }

    public SelectStatement getSelect() {
        return this.select;
    }

    @Override
    public <T> T accept(TableNodeVisitor<T> visitor) throws SQLException {
        return visitor.visit(this);
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        buf.append('(');
        this.select.toSQL(resolver, buf);
        buf.append(')');
        buf.append(" " + (this.getAlias() == null ? "" : this.getAlias()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.select == null ? 0 : this.select.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DerivedTableNode other = (DerivedTableNode)obj;
        return !(this.select == null ? other.select != null : !this.select.equals(other.select));
    }
}

