/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.BinaryParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;

public class InParseNode
extends BinaryParseNode {
    private final boolean negate;
    private final boolean isSubqueryDistinct;

    InParseNode(ParseNode l, ParseNode r, boolean negate, boolean isSubqueryDistinct) {
        super(l, r);
        this.negate = negate;
        this.isSubqueryDistinct = isSubqueryDistinct;
    }

    public boolean isNegate() {
        return this.negate;
    }

    public boolean isSubqueryDistinct() {
        return this.isSubqueryDistinct;
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        List l = Collections.emptyList();
        if (visitor.visitEnter(this)) {
            l = this.acceptChildren(visitor);
        }
        return visitor.visitLeave(this, l);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isSubqueryDistinct ? 1231 : 1237);
        result = 31 * result + (this.negate ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InParseNode other = (InParseNode)obj;
        if (this.isSubqueryDistinct != other.isSubqueryDistinct) {
            return false;
        }
        return this.negate == other.negate;
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        this.getChildren().get(0).toSQL(resolver, buf);
        if (this.negate) {
            buf.append(" NOT");
        }
        buf.append(" IN (");
        this.getChildren().get(1).toSQL(resolver, buf);
        buf.append(')');
    }
}

