/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import org.apache.phoenix.coprocessor.generated.PSchemaProtos;
import org.apache.phoenix.schema.PMetaDataEntity;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.util.SchemaUtil;

public class PSchema
implements PMetaDataEntity {
    private final PName schemaName;
    private PTableKey schemaKey;
    private long timeStamp;
    private int estimatedSize;

    public PSchema(long timeStamp) {
        this.timeStamp = timeStamp;
        this.schemaName = null;
    }

    public PSchema(String schemaName) {
        this(schemaName, Long.MAX_VALUE);
    }

    public PSchema(String schemaName, long timeStamp) {
        this.schemaName = PNameFactory.newName(SchemaUtil.normalizeIdentifier(schemaName));
        this.schemaKey = new PTableKey(null, this.schemaName.getString());
        this.timeStamp = timeStamp;
        this.estimatedSize = 12 + PNameFactory.getEstimatedSize(this.schemaName);
    }

    public PSchema(PSchema schema) {
        this(schema.getSchemaName().toString(), schema.getTimeStamp());
    }

    public String getSchemaName() {
        return this.schemaName == null ? null : this.schemaName.getString();
    }

    public PTableKey getSchemaKey() {
        return this.schemaKey;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public static PSchemaProtos.PSchema toProto(PSchema schema) {
        PSchemaProtos.PSchema.Builder builder = PSchemaProtos.PSchema.newBuilder();
        builder.setSchemaName(schema.getSchemaName());
        builder.setTimeStamp(schema.getTimeStamp());
        return builder.build();
    }

    public static PSchema createFromProto(PSchemaProtos.PSchema schema) {
        long timeStamp = schema.getTimeStamp();
        String schemaName = schema.getSchemaName();
        return new PSchema(schemaName, timeStamp);
    }

    @Override
    public int getEstimatedSize() {
        return this.estimatedSize;
    }
}

