/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.PhoenixRpcSchedulerFactory;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.IndexHalfStoreFileReaderGenerator;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.coprocessor.ChildLinkMetaDataEndpoint;
import org.apache.phoenix.coprocessor.GroupedAggregateRegionObserver;
import org.apache.phoenix.coprocessor.MetaDataEndpointImpl;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.coprocessor.MetaDataRegionObserver;
import org.apache.phoenix.coprocessor.PhoenixTTLRegionObserver;
import org.apache.phoenix.coprocessor.ScanRegionObserver;
import org.apache.phoenix.coprocessor.SequenceRegionObserver;
import org.apache.phoenix.coprocessor.ServerCachingEndpointImpl;
import org.apache.phoenix.coprocessor.SystemCatalogRegionObserver;
import org.apache.phoenix.coprocessor.TaskMetaDataEndpoint;
import org.apache.phoenix.coprocessor.TaskRegionObserver;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.coprocessor.generated.ChildLinkMetaDataProtos;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.exception.InvalidRegionSplitPolicyException;
import org.apache.phoenix.exception.PhoenixIOException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.exception.UpgradeInProgressException;
import org.apache.phoenix.exception.UpgradeNotRequiredException;
import org.apache.phoenix.exception.UpgradeRequiredException;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.IndexRegionObserver;
import org.apache.phoenix.hbase.index.IndexRegionSplitPolicy;
import org.apache.phoenix.hbase.index.Indexer;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.index.GlobalIndexChecker;
import org.apache.phoenix.index.PhoenixIndexBuilder;
import org.apache.phoenix.index.PhoenixIndexCodec;
import org.apache.phoenix.index.PhoenixTransactionalIndexer;
import org.apache.phoenix.iterate.TableResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.log.QueryLoggerDisruptor;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.query.ChildLinkMetaDataServiceCallBack;
import org.apache.phoenix.query.ChildQueryServices;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.DelegateQueryServices;
import org.apache.phoenix.query.GuidePostsCacheProvider;
import org.apache.phoenix.query.GuidePostsCacheWrapper;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.schema.ColumnAlreadyExistsException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ConnectionProperty;
import org.apache.phoenix.schema.EmptySequenceCacheException;
import org.apache.phoenix.schema.FunctionNotFoundException;
import org.apache.phoenix.schema.NewerSchemaAlreadyExistsException;
import org.apache.phoenix.schema.NewerTableAlreadyExistsException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PMetaDataImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PSynchronizedMetaData;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ReadOnlyTableException;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.Sequence;
import org.apache.phoenix.schema.SequenceAllocation;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.SystemFunctionSplitPolicy;
import org.apache.phoenix.schema.SystemStatsSplitPolicy;
import org.apache.phoenix.schema.SystemTaskSplitPolicy;
import org.apache.phoenix.schema.TableAlreadyExistsException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableProperty;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.GuidePostsKey;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.transaction.PhoenixTransactionClient;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.Closeables;
import org.apache.phoenix.util.ConfigUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.JDBCUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixContextExecutor;
import org.apache.phoenix.util.PhoenixStopWatch;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.StringUtil;
import org.apache.phoenix.util.TimeKeeper;
import org.apache.phoenix.util.UpgradeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionQueryServicesImpl
extends DelegateQueryServices
implements ConnectionQueryServices {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionQueryServicesImpl.class);
    private static final int INITIAL_CHILD_SERVICES_CAPACITY = 100;
    private static final int DEFAULT_OUT_OF_ORDER_MUTATIONS_WAIT_TIME_MS = 1000;
    private static final String ALTER_TABLE_SET_PROPS = "ALTER TABLE %s SET %s=%s";
    private final GuidePostsCacheProvider GUIDE_POSTS_CACHE_PROVIDER = new GuidePostsCacheProvider();
    protected final Configuration config;
    protected final PhoenixEmbeddedDriver.ConnectionInfo connectionInfo;
    private final ReadOnlyProps props;
    private final String userName;
    private final User user;
    private final ConcurrentHashMap<ImmutableBytesWritable, ConnectionQueryServices> childServices;
    private final GuidePostsCacheWrapper tableStatsCache;
    private volatile PMetaData latestMetaData;
    private final Object latestMetaDataLock = new Object();
    private int lowestClusterHBaseVersion = Integer.MAX_VALUE;
    private boolean hasIndexWALCodec = true;
    @GuardedBy(value="connectionCountLock")
    private int connectionCount = 0;
    @GuardedBy(value="connectionCountLock")
    private int internalConnectionCount = 0;
    private final Object connectionCountLock = new Object();
    private final boolean returnSequenceValues;
    private HConnection connection;
    private volatile boolean initialized;
    private volatile int nSequenceSaltBuckets;
    private volatile boolean closed;
    private volatile SQLException initializationException;
    private volatile ConcurrentMap<SequenceKey, Sequence> sequenceMap = Maps.newConcurrentMap();
    private KeyValueBuilder kvBuilder;
    private final int renewLeaseTaskFrequency;
    private final int renewLeasePoolSize;
    private final int renewLeaseThreshold;
    private final List<LinkedBlockingQueue<WeakReference<PhoenixConnection>>> connectionQueues;
    private ScheduledExecutorService renewLeaseExecutor;
    private PhoenixTransactionClient[] txClients = new PhoenixTransactionClient[TransactionFactory.Provider.values().length];
    private static final ThreadFactory renewLeaseThreadFactory = new RenewLeaseThreadFactory();
    private final boolean renewLeaseEnabled;
    private final boolean isAutoUpgradeEnabled;
    private final AtomicBoolean upgradeRequired = new AtomicBoolean(false);
    private final int maxConnectionsAllowed;
    private final int maxInternalConnectionsAllowed;
    private final boolean shouldThrottleNumConnections;
    public static final byte[] MUTEX_LOCKED = "MUTEX_LOCKED".getBytes();
    private final Map<ConnectionQueryServices.Feature, FeatureSupported> featureMap = ImmutableMap.of((Object)((Object)ConnectionQueryServices.Feature.LOCAL_INDEX), (Object)new FeatureSupported(){

        @Override
        public boolean isSupported(ConnectionQueryServices services) {
            int hbaseVersion = services.getLowestClusterHBaseVersion();
            return hbaseVersion < MetaDataProtocol.MIN_LOCAL_SI_VERSION_DISALLOW || hbaseVersion > MetaDataProtocol.MAX_LOCAL_SI_VERSION_DISALLOW;
        }
    }, (Object)((Object)ConnectionQueryServices.Feature.RENEW_LEASE), (Object)new FeatureSupported(){

        @Override
        public boolean isSupported(ConnectionQueryServices services) {
            int hbaseVersion = services.getLowestClusterHBaseVersion();
            return hbaseVersion >= MetaDataProtocol.MIN_RENEW_LEASE_VERSION;
        }
    });
    private QueryLoggerDisruptor queryDisruptor;
    private static final String TRUE_BYTES_AS_STRING = Bytes.toString((byte[])PDataType.TRUE_BYTES);

    private PMetaData newEmptyMetaData() {
        return new PSynchronizedMetaData(new PMetaDataImpl(100, this.getProps()));
    }

    public ConnectionQueryServicesImpl(QueryServices services, PhoenixEmbeddedDriver.ConnectionInfo connectionInfo, Properties info) {
        super(services);
        Configuration config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        for (Map.Entry entry : services.getProps()) {
            config.set(entry.getKey(), entry.getValue());
        }
        if (info != null) {
            for (Object key : info.keySet()) {
                config.set((String)key, info.getProperty((String)key));
            }
        }
        for (Map.Entry entry : connectionInfo.asProps()) {
            config.set((String)entry.getKey(), (String)entry.getValue());
        }
        this.connectionInfo = connectionInfo;
        this.config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration(config);
        ConfigUtil.setReplicationConfigIfAbsent(this.config);
        this.props = new ReadOnlyProps(this.config.iterator());
        this.userName = connectionInfo.getPrincipal();
        this.user = connectionInfo.getUser();
        this.latestMetaData = this.newEmptyMetaData();
        this.childServices = new ConcurrentHashMap(100);
        String hbaseVersion = VersionInfo.getVersion();
        this.kvBuilder = KeyValueBuilder.get(hbaseVersion);
        this.returnSequenceValues = this.props.getBoolean("phoenix.sequence.returnValues", false);
        this.renewLeaseEnabled = config.getBoolean("phoenix.scanner.lease.renew.enabled", true);
        this.renewLeasePoolSize = config.getInt("phoenix.scanner.lease.pool.size", 10);
        this.renewLeaseThreshold = config.getInt("phoenix.scanner.lease.threshold", 45000);
        this.renewLeaseTaskFrequency = config.getInt("phoenix.scanner.lease.renew.interval", 30000);
        ArrayList list = Lists.newArrayListWithCapacity((int)this.renewLeasePoolSize);
        for (int i = 0; i < this.renewLeasePoolSize; ++i) {
            LinkedBlockingQueue queue = new LinkedBlockingQueue();
            list.add(queue);
        }
        this.connectionQueues = ImmutableList.copyOf((Collection)list);
        this.tableStatsCache = this.GUIDE_POSTS_CACHE_PROVIDER.getGuidePostsCache(this.props.get("phoenix.guide.posts.cache.factory.class", "org.apache.phoenix.query.DefaultGuidePostsCacheFactory"), this, config);
        this.isAutoUpgradeEnabled = config.getBoolean("phoenix.autoupgrade.enabled", true);
        this.maxConnectionsAllowed = config.getInt("phoenix.client.connection.max.allowed.connections", 0);
        this.maxInternalConnectionsAllowed = config.getInt("phoenix.internal.connection.max.allowed.connections", 0);
        boolean bl = this.shouldThrottleNumConnections = this.maxConnectionsAllowed > 0 || this.maxInternalConnectionsAllowed > 0;
        if (!QueryUtil.isServerConnection(this.props)) {
            try {
                this.queryDisruptor = new QueryLoggerDisruptor(this.config);
            }
            catch (SQLException e) {
                LOGGER.warn("Unable to initiate query logging service !!");
                e.printStackTrace();
            }
        }
    }

    private void openConnection() throws SQLException {
        try {
            this.connection = HBaseFactoryProvider.getHConnectionFactory().createConnection(this.config);
            GlobalClientMetrics.GLOBAL_HCONNECTIONS_COUNTER.increment();
            LOGGER.info("HConnection established. Stacktrace for informational purposes: " + this.connection + " " + LogUtil.getCallerStackTrace());
        }
        catch (IOException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION).setRootCause(e).build().buildException();
        }
        if (this.connection.isClosed()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION).build().buildException();
        }
    }

    private void closeConnection() throws IOException {
        if (this.connection != null) {
            this.connection.close();
            LOGGER.info("{} HConnection closed. Stacktrace for informational purposes: {}", (Object)this.connection, (Object)LogUtil.getCallerStackTrace());
        }
        GlobalClientMetrics.GLOBAL_HCONNECTIONS_COUNTER.decrement();
    }

    @Override
    public HTableInterface getTable(byte[] tableName) throws SQLException {
        try {
            return HBaseFactoryProvider.getHTableFactory().getTable(tableName, this.connection, null);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Table getTableIfExists(byte[] tableName) throws SQLException {
        try (HBaseAdmin admin = this.getAdmin();){
            if (!admin.tableExists(TableName.valueOf((byte[])tableName))) {
                throw new TableNotFoundException(SchemaUtil.getSchemaNameFromFullName(tableName), SchemaUtil.getTableNameFromFullName(tableName));
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return this.getTable(tableName);
    }

    @Override
    public HTableDescriptor getTableDescriptor(byte[] tableName) throws SQLException {
        HTableInterface htable = this.getTable(tableName);
        try {
            HTableDescriptor hTableDescriptor = htable.getTableDescriptor();
            return hTableDescriptor;
        }
        catch (IOException e) {
            if (e instanceof org.apache.hadoop.hbase.TableNotFoundException || e.getCause() instanceof org.apache.hadoop.hbase.TableNotFoundException) {
                byte[][] schemaAndTableName = new byte[2][];
                SchemaUtil.getVarChars(tableName, schemaAndTableName);
                throw new TableNotFoundException(Bytes.toString((byte[])schemaAndTableName[0]), Bytes.toString((byte[])schemaAndTableName[1]));
            }
            throw new RuntimeException(e);
        }
        finally {
            Closeables.closeQuietly((Closeable)htable);
        }
    }

    @Override
    public ReadOnlyProps getProps() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        ConnectionQueryServicesImpl connectionQueryServicesImpl = this;
        synchronized (connectionQueryServicesImpl) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            GlobalClientMetrics.GLOBAL_QUERY_SERVICES_COUNTER.decrement();
            try {
                if (this.queryDisruptor != null) {
                    this.queryDisruptor.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            SQLException sqlE = null;
            try {
                if (this.connection == null) return;
                this.returnAllSequences(this.sequenceMap);
            }
            catch (SQLException e) {
                sqlE = e;
            }
            finally {
                try {
                    this.childServices.clear();
                    PhoenixTransactionClient[] e = this.latestMetaDataLock;
                    synchronized (this.latestMetaDataLock) {
                        block83: {
                            this.latestMetaData = null;
                            this.latestMetaDataLock.notifyAll();
                            // ** MonitorExit[e] (shouldn't be in output)
                            try {
                                this.closeConnection();
                                if (this.renewLeaseExecutor == null) break block83;
                            }
                            catch (Throwable throwable) {
                                if (this.renewLeaseExecutor != null) {
                                    this.renewLeaseExecutor.shutdownNow();
                                }
                                PhoenixTransactionClient[] phoenixTransactionClientArray = this.txClients;
                                int n = phoenixTransactionClientArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    PhoenixTransactionClient client = phoenixTransactionClientArray[n2];
                                    if (client != null) {
                                        client.close();
                                    }
                                    ++n2;
                                }
                                throw throwable;
                            }
                            this.renewLeaseExecutor.shutdownNow();
                        }
                        e = this.txClients;
                        int n = e.length;
                        int n3 = 0;
                        while (true) {
                            if (n3 >= n) {
                            }
                            PhoenixTransactionClient client = e[n3];
                            if (client != null) {
                                client.close();
                            }
                            ++n3;
                        }
                    }
                }
                catch (IOException e) {
                    if (sqlE == null) {
                        sqlE = ServerUtil.parseServerException(e);
                    }
                    sqlE.setNextException(ServerUtil.parseServerException(e));
                }
                finally {
                    try {
                        this.tableStatsCache.invalidateAll();
                        super.close();
                    }
                    catch (SQLException e) {
                        if (sqlE == null) {
                            sqlE = e;
                        }
                        sqlE.setNextException(e);
                    }
                    finally {
                        if (sqlE == null) return;
                        throw sqlE;
                    }
                }
            }
            return;
        }
    }

    protected ConnectionQueryServices newChildQueryService() {
        return new ChildQueryServices(this);
    }

    @Override
    public ConnectionQueryServices getChildQueryServices(ImmutableBytesWritable tenantId) {
        ConnectionQueryServices childQueryService = this.childServices.get(tenantId);
        if (childQueryService == null) {
            childQueryService = this.newChildQueryService();
            ConnectionQueryServices prevQueryService = this.childServices.putIfAbsent(tenantId, childQueryService);
            return prevQueryService == null ? childQueryService : prevQueryService;
        }
        return childQueryService;
    }

    @Override
    public void clearTableRegionCache(byte[] tableName) throws SQLException {
        this.connection.clearRegionCache(TableName.valueOf((byte[])tableName));
    }

    @Override
    public List<HRegionLocation> getAllTableRegions(byte[] tableName) throws SQLException {
        int retryCount = 0;
        int maxRetryCount = 1;
        boolean reload = false;
        while (true) {
            try {
                HRegionLocation regionLocation;
                ArrayList locations = Lists.newArrayList();
                byte[] currentKey = HConstants.EMPTY_START_ROW;
                do {
                    regionLocation = this.connection.getRegionLocation(TableName.valueOf((byte[])tableName), currentKey, reload);
                    locations.add(regionLocation);
                } while (!Bytes.equals((byte[])(currentKey = regionLocation.getRegionInfo().getEndKey()), (byte[])HConstants.EMPTY_END_ROW));
                return locations;
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException e) {
                String fullName = Bytes.toString((byte[])tableName);
                throw new TableNotFoundException(fullName);
            }
            catch (IOException e) {
                if (retryCount++ < maxRetryCount) {
                    reload = true;
                    continue;
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.GET_TABLE_REGIONS_FAIL).setRootCause(e).build().buildException();
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTable(PTable table, long resolvedTime) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            try {
                this.throwConnectionClosedIfNullMetaData();
                PTableRef existingTableRef = this.latestMetaData.getTableRef(new PTableKey(table.getTenantId(), table.getName().getString()));
                PTable existingTable = existingTableRef.getTable();
                if (existingTable.getTimeStamp() > table.getTimeStamp()) {
                    existingTableRef.setLastAccessTime(TimeKeeper.SYSTEM.getCurrentTime());
                    return;
                }
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            this.latestMetaData.addTable(table, resolvedTime);
            this.latestMetaDataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateResolvedTimestamp(PTable table, long resolvedTime) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.throwConnectionClosedIfNullMetaData();
            this.latestMetaData.updateResolvedTimestamp(table, resolvedTime);
            this.latestMetaDataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PMetaData metaDataMutated(PName tenantId, String tableName, long tableSeqNum, Mutator mutator) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.throwConnectionClosedIfNullMetaData();
            PMetaData metaData = this.latestMetaData;
            long endTime = EnvironmentEdgeManager.currentTimeMillis() + 1000L;
            try {
                while (true) {
                    long waitTime;
                    block11: {
                        try {
                            PTable table = metaData.getTableRef(new PTableKey(tenantId, tableName)).getTable();
                            if (table.getSequenceNumber() + 1L == tableSeqNum) {
                                mutator.mutate(metaData);
                                break;
                            }
                            if (table.getSequenceNumber() < tableSeqNum) break block11;
                            LOGGER.warn("Attempt to cache older version of " + tableName + ": current= " + table.getSequenceNumber() + ", new=" + tableSeqNum);
                            break;
                        }
                        catch (TableNotFoundException tableNotFoundException) {
                            // empty catch block
                        }
                    }
                    if ((waitTime = endTime - EnvironmentEdgeManager.currentTimeMillis()) <= 0L) {
                        LOGGER.warn("Unable to update meta data repo within 1 seconds for " + tableName);
                        metaData.removeTable(tenantId, tableName, null, Long.MAX_VALUE);
                        break;
                    }
                    this.latestMetaDataLock.wait(waitTime);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
            }
            this.latestMetaData = metaData;
            this.latestMetaDataLock.notifyAll();
            return metaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTable(PName tenantId, String tableName, String parentTableName, long tableTimeStamp) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.throwConnectionClosedIfNullMetaData();
            this.latestMetaData.removeTable(tenantId, tableName, parentTableName, tableTimeStamp);
            this.latestMetaDataLock.notifyAll();
        }
    }

    @Override
    public void removeColumn(final PName tenantId, final String tableName, final List<PColumn> columnsToRemove, final long tableTimeStamp, final long tableSeqNum, final long resolvedTime) throws SQLException {
        this.metaDataMutated(tenantId, tableName, tableSeqNum, new Mutator(){

            @Override
            public void mutate(PMetaData metaData) throws SQLException {
                try {
                    metaData.removeColumn(tenantId, tableName, columnsToRemove, tableTimeStamp, tableSeqNum, resolvedTime);
                }
                catch (TableNotFoundException tableNotFoundException) {
                    // empty catch block
                }
            }
        });
    }

    private void validateConnectionProperties(Properties info) {
        if (info.get("phoenix.default.update.cache.frequency") != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Connection's phoenix.default.update.cache.frequency set to " + info.get("phoenix.default.update.cache.frequency"));
            }
            ConnectionProperty.UPDATE_CACHE_FREQUENCY.getValue(info.getProperty("phoenix.default.update.cache.frequency"));
        }
    }

    @Override
    public PhoenixConnection connect(String url, Properties info) throws SQLException {
        this.checkClosed();
        PMetaData metadata = this.latestMetaData;
        this.throwConnectionClosedIfNullMetaData();
        this.validateConnectionProperties(info);
        metadata = metadata.clone();
        return new PhoenixConnection(this, url, info, metadata);
    }

    private HColumnDescriptor generateColumnFamilyDescriptor(Pair<byte[], Map<String, Object>> family, PTableType tableType) throws SQLException {
        HColumnDescriptor columnDesc = new HColumnDescriptor((byte[])family.getFirst());
        if (tableType != PTableType.VIEW) {
            columnDesc.setDataBlockEncoding(SchemaUtil.DEFAULT_DATA_BLOCK_ENCODING);
            columnDesc.setBloomFilterType(BloomType.NONE);
            for (Map.Entry entry : ((Map)family.getSecond()).entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                ConnectionQueryServicesImpl.setHColumnDescriptorValue(columnDesc, key, value);
            }
        }
        return columnDesc;
    }

    private static void setHColumnDescriptorValue(HColumnDescriptor columnDesc, String key, Object value) {
        if ("VERSIONS".equals(key)) {
            columnDesc.setMaxVersions(ConnectionQueryServicesImpl.getMaxVersion(value));
        } else {
            columnDesc.setValue(key, value == null ? null : value.toString());
        }
    }

    private static int getMaxVersion(Object value) {
        if (value == null) {
            return -1;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        String stringValue = value.toString();
        if (stringValue.isEmpty()) {
            return -1;
        }
        return Integer.parseInt(stringValue);
    }

    private void modifyColumnFamilyDescriptor(HColumnDescriptor hcd, Map<String, Object> props) throws SQLException {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String propName = entry.getKey();
            Object value = entry.getValue();
            ConnectionQueryServicesImpl.setHColumnDescriptorValue(hcd, propName, value);
        }
    }

    private HTableDescriptor generateTableDescriptor(byte[] physicalTableName, HTableDescriptor existingDesc, PTableType tableType, Map<String, Object> tableProps, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits, boolean isNamespaceMapped) throws SQLException {
        Object defaultFamilyBytes;
        String defaultFamilyName = (String)tableProps.remove("DEFAULT_COLUMN_FAMILY");
        HTableDescriptor newTableDescriptor = existingDesc != null ? new HTableDescriptor(existingDesc) : new HTableDescriptor(TableName.valueOf((byte[])physicalTableName));
        HColumnDescriptor dataTableColDescForIndexTablePropSyncing = null;
        if (tableType == PTableType.INDEX || MetaDataUtil.isViewIndex(Bytes.toString((byte[])physicalTableName))) {
            defaultFamilyBytes = defaultFamilyName == null ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES : Bytes.toBytes((String)defaultFamilyName);
            Object object = defaultFamilyBytes;
            HTableDescriptor baseTableDesc = MetaDataUtil.isViewIndex(Bytes.toString((byte[])physicalTableName)) ? this.getTableDescriptor(Bytes.toBytes((String)MetaDataUtil.getViewIndexUserTableName(Bytes.toString((byte[])physicalTableName)))) : (existingDesc == null ? this.getTableDescriptor(SchemaUtil.getPhysicalTableName(Bytes.toBytes((String)((String)tableProps.get("DATA_TABLE_NAME"))), isNamespaceMapped).getName()) : existingDesc);
            dataTableColDescForIndexTablePropSyncing = baseTableDesc.getFamily(defaultFamilyBytes);
            if (dataTableColDescForIndexTablePropSyncing == null) {
                dataTableColDescForIndexTablePropSyncing = baseTableDesc.getColumnFamilies()[0];
            }
        }
        defaultFamilyBytes = tableProps.entrySet().iterator();
        while (defaultFamilyBytes.hasNext()) {
            Map.Entry entry = (Map.Entry)defaultFamilyBytes.next();
            String key = (String)entry.getKey();
            if (TableProperty.isPhoenixTableProperty(key)) continue;
            Object value = entry.getValue();
            newTableDescriptor.setValue(key, value == null ? null : value.toString());
        }
        Map<String, Object> syncedProps = MetaDataUtil.getSyncedProps(dataTableColDescForIndexTablePropSyncing);
        for (Pair<byte[], Map<String, Object>> family : families) {
            HColumnDescriptor columnDescriptor;
            byte[] familyByte = (byte[])family.getFirst();
            if (newTableDescriptor.getFamily(familyByte) == null) {
                if (tableType == PTableType.VIEW) {
                    String fullTableName = Bytes.toString((byte[])physicalTableName);
                    throw new ReadOnlyTableException("The HBase column families for a read-only table must already exist", SchemaUtil.getSchemaNameFromFullName(fullTableName), SchemaUtil.getTableNameFromFullName(fullTableName), Bytes.toString((byte[])familyByte));
                }
                columnDescriptor = this.generateColumnFamilyDescriptor(family, tableType);
                if ((tableType == PTableType.INDEX || MetaDataUtil.isViewIndex(Bytes.toString((byte[])physicalTableName))) && syncedProps != null && !syncedProps.isEmpty()) {
                    HColumnDescriptor newColFamDesc = new HColumnDescriptor(columnDescriptor);
                    this.modifyColumnFamilyDescriptor(newColFamDesc, syncedProps);
                    columnDescriptor = new HColumnDescriptor(newColFamDesc);
                }
                newTableDescriptor.addFamily(columnDescriptor);
                continue;
            }
            if (tableType == PTableType.VIEW) continue;
            columnDescriptor = newTableDescriptor.getFamily(familyByte);
            if (columnDescriptor == null) {
                throw new IllegalArgumentException("Unable to find column descriptor with family name " + Bytes.toString((byte[])((byte[])family.getFirst())));
            }
            this.modifyColumnFamilyDescriptor(columnDescriptor, (Map)family.getSecond());
            newTableDescriptor.modifyFamily(columnDescriptor);
        }
        this.addCoprocessors(physicalTableName, newTableDescriptor, tableType, tableProps, existingDesc);
        if (tableType == PTableType.SYSTEM) {
            newTableDescriptor.setValue("PRIORITY", String.valueOf(PhoenixRpcSchedulerFactory.getMetadataPriority(this.config)));
        } else if (tableType == PTableType.INDEX && !this.isLocalIndexTable(newTableDescriptor.getFamiliesKeys()) && !Boolean.TRUE.equals(tableProps.get("IMMUTABLE_ROWS"))) {
            newTableDescriptor.setValue("PRIORITY", String.valueOf(PhoenixRpcSchedulerFactory.getIndexPriority(this.config)));
        }
        return newTableDescriptor;
    }

    private boolean isLocalIndexTable(Collection<byte[]> families) {
        for (byte[] family : families) {
            if (!Bytes.toString((byte[])family).startsWith("L#")) continue;
            return true;
        }
        return false;
    }

    private void addCoprocessors(byte[] tableName, HTableDescriptor descriptor, PTableType tableType, Map<String, Object> tableProps, HTableDescriptor existingDesc) throws SQLException {
        int priority = this.props.getInt("phoenix.coprocessor.priority", 0x2FFFFFFE);
        try {
            TransactionFactory.Provider provider = this.getTransactionProvider(tableProps);
            boolean isTransactional = provider != null;
            boolean isViewIndex = TRUE_BYTES_AS_STRING.equals(tableProps.get("IS_VIEW_INDEX_TABLE"));
            boolean indexRegionObserverEnabled = this.config.getBoolean("phoenix.index.region.observer.enabled", true);
            boolean isViewBaseTransactional = false;
            if (!isTransactional && isViewIndex && tableProps.containsKey("TRANSACTIONAL") && Boolean.TRUE.equals(tableProps.get("TRANSACTIONAL"))) {
                isViewBaseTransactional = true;
            }
            if (!(isTransactional || isViewBaseTransactional || tableType != PTableType.INDEX && !isViewIndex)) {
                if (!indexRegionObserverEnabled && descriptor.hasCoprocessor(GlobalIndexChecker.class.getName())) {
                    descriptor.removeCoprocessor(GlobalIndexChecker.class.getName());
                } else if (indexRegionObserverEnabled && !descriptor.hasCoprocessor(GlobalIndexChecker.class.getName()) && !this.isLocalIndexTable(descriptor.getFamiliesKeys())) {
                    if (descriptor.hasCoprocessor(IndexRegionObserver.class.getName())) {
                        descriptor.removeCoprocessor(IndexRegionObserver.class.getName());
                    }
                    descriptor.addCoprocessor(GlobalIndexChecker.class.getName(), null, priority - 1, null);
                }
            }
            if (!descriptor.hasCoprocessor(ScanRegionObserver.class.getName())) {
                descriptor.addCoprocessor(ScanRegionObserver.class.getName(), null, priority, null);
            }
            if (!descriptor.hasCoprocessor(UngroupedAggregateRegionObserver.class.getName())) {
                descriptor.addCoprocessor(UngroupedAggregateRegionObserver.class.getName(), null, priority, null);
            }
            if (!descriptor.hasCoprocessor(GroupedAggregateRegionObserver.class.getName())) {
                descriptor.addCoprocessor(GroupedAggregateRegionObserver.class.getName(), null, priority, null);
            }
            if (!descriptor.hasCoprocessor(ServerCachingEndpointImpl.class.getName())) {
                descriptor.addCoprocessor(ServerCachingEndpointImpl.class.getName(), null, priority, null);
            }
            if (!(tableType == PTableType.INDEX || tableType == PTableType.VIEW || isViewIndex || SchemaUtil.isMetaTable(tableName) || SchemaUtil.isStatsTable(tableName))) {
                if (isTransactional) {
                    if (!descriptor.hasCoprocessor(PhoenixTransactionalIndexer.class.getName())) {
                        descriptor.addCoprocessor(PhoenixTransactionalIndexer.class.getName(), null, priority, null);
                    }
                    if (descriptor.hasCoprocessor(Indexer.class.getName())) {
                        descriptor.removeCoprocessor(Indexer.class.getName());
                    }
                    if (descriptor.hasCoprocessor(IndexRegionObserver.class.getName())) {
                        descriptor.removeCoprocessor(IndexRegionObserver.class.getName());
                    }
                } else {
                    if (descriptor.hasCoprocessor(PhoenixTransactionalIndexer.class.getName())) {
                        descriptor.removeCoprocessor(PhoenixTransactionalIndexer.class.getName());
                    }
                    if (!this.doesPhoenixTableAlreadyExist(existingDesc)) {
                        HashMap opts;
                        if (indexRegionObserverEnabled) {
                            if (descriptor.hasCoprocessor(Indexer.class.getName())) {
                                descriptor.removeCoprocessor(Indexer.class.getName());
                            }
                            if (!descriptor.hasCoprocessor(IndexRegionObserver.class.getName())) {
                                opts = Maps.newHashMapWithExpectedSize((int)1);
                                opts.put("org.apache.hadoop.hbase.index.codec.class", PhoenixIndexCodec.class.getName());
                                IndexRegionObserver.enableIndexing(descriptor, PhoenixIndexBuilder.class, opts, priority);
                            }
                        } else {
                            if (descriptor.hasCoprocessor(IndexRegionObserver.class.getName())) {
                                descriptor.removeCoprocessor(IndexRegionObserver.class.getName());
                            }
                            if (!descriptor.hasCoprocessor(Indexer.class.getName())) {
                                opts = Maps.newHashMapWithExpectedSize((int)1);
                                opts.put("org.apache.hadoop.hbase.index.codec.class", PhoenixIndexCodec.class.getName());
                                Indexer.enableIndexing(descriptor, PhoenixIndexBuilder.class, opts, priority);
                            }
                        }
                    }
                }
            }
            if ((SchemaUtil.isStatsTable(tableName) || SchemaUtil.isMetaTable(tableName)) && !descriptor.hasCoprocessor(MultiRowMutationEndpoint.class.getName())) {
                descriptor.addCoprocessor(MultiRowMutationEndpoint.class.getName(), null, priority, null);
            }
            Set familiesKeys = descriptor.getFamiliesKeys();
            for (byte[] family : familiesKeys) {
                if (!Bytes.toString((byte[])family).startsWith("L#") || descriptor.hasCoprocessor(IndexHalfStoreFileReaderGenerator.class.getName())) continue;
                descriptor.addCoprocessor(IndexHalfStoreFileReaderGenerator.class.getName(), null, priority, null);
                break;
            }
            if (SchemaUtil.isMetaTable(tableName) || SchemaUtil.isFunctionTable(tableName)) {
                if (!descriptor.hasCoprocessor(MetaDataEndpointImpl.class.getName())) {
                    descriptor.addCoprocessor(MetaDataEndpointImpl.class.getName(), null, priority, null);
                }
                if (SchemaUtil.isMetaTable(tableName) && !descriptor.hasCoprocessor(MetaDataRegionObserver.class.getName())) {
                    descriptor.addCoprocessor(MetaDataRegionObserver.class.getName(), null, priority + 1, null);
                }
            } else if (SchemaUtil.isSequenceTable(tableName)) {
                if (!descriptor.hasCoprocessor(SequenceRegionObserver.class.getName())) {
                    descriptor.addCoprocessor(SequenceRegionObserver.class.getName(), null, priority, null);
                }
            } else if (SchemaUtil.isTaskTable(tableName)) {
                if (!descriptor.hasCoprocessor(TaskRegionObserver.class.getName())) {
                    descriptor.addCoprocessor(TaskRegionObserver.class.getName(), null, priority, null);
                }
                if (!descriptor.hasCoprocessor(TaskMetaDataEndpoint.class.getName())) {
                    descriptor.addCoprocessor(TaskMetaDataEndpoint.class.getName(), null, priority, null);
                }
            } else if (SchemaUtil.isChildLinkTable(tableName) && !descriptor.hasCoprocessor(ChildLinkMetaDataEndpoint.class.getName())) {
                descriptor.addCoprocessor(ChildLinkMetaDataEndpoint.class.getName(), null, priority, null);
            }
            if (isTransactional) {
                Class<? extends RegionObserver> coprocessorGCClass;
                Class<? extends RegionObserver> coprocessorClass = provider.getTransactionProvider().getCoprocessor();
                if (!descriptor.hasCoprocessor(coprocessorClass.getName())) {
                    descriptor.addCoprocessor(coprocessorClass.getName(), null, priority - 10, null);
                }
                if ((coprocessorGCClass = provider.getTransactionProvider().getGCCoprocessor()) != null && !descriptor.hasCoprocessor(coprocessorGCClass.getName())) {
                    descriptor.addCoprocessor(coprocessorGCClass.getName(), null, priority - 10, null);
                }
            } else {
                for (TransactionFactory.Provider aprovider : TransactionFactory.Provider.values()) {
                    Class<? extends RegionObserver> coprocessorClass = aprovider.getTransactionProvider().getCoprocessor();
                    Class<? extends RegionObserver> coprocessorGCClass = aprovider.getTransactionProvider().getGCCoprocessor();
                    if (coprocessorClass != null && descriptor.hasCoprocessor(coprocessorClass.getName())) {
                        descriptor.removeCoprocessor(coprocessorClass.getName());
                    }
                    if (coprocessorGCClass == null || !descriptor.hasCoprocessor(coprocessorGCClass.getName())) continue;
                    descriptor.removeCoprocessor(coprocessorGCClass.getName());
                }
            }
            if (!SchemaUtil.isSystemTable(tableName) && !descriptor.hasCoprocessor(PhoenixTTLRegionObserver.class.getName())) {
                descriptor.addCoprocessor(PhoenixTTLRegionObserver.class.getName(), null, priority - 2, null);
            }
            if (Arrays.equals(tableName, SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.props).getName()) && !descriptor.hasCoprocessor(SystemCatalogRegionObserver.class.getName())) {
                descriptor.addCoprocessor(SystemCatalogRegionObserver.class.getName(), null, priority, null);
            }
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    private TransactionFactory.Provider getTransactionProvider(Map<String, Object> tableProps) {
        TransactionFactory.Provider provider = (TransactionFactory.Provider)((Object)TableProperty.TRANSACTION_PROVIDER.getValue(tableProps));
        return provider;
    }

    private boolean doesPhoenixTableAlreadyExist(HTableDescriptor existingDesc) {
        if (existingDesc == null) {
            return false;
        }
        boolean hasScanObserver = existingDesc.hasCoprocessor(ScanRegionObserver.class.getName());
        boolean hasUnAggObserver = existingDesc.hasCoprocessor(UngroupedAggregateRegionObserver.class.getName());
        boolean hasGroupedObserver = existingDesc.hasCoprocessor(GroupedAggregateRegionObserver.class.getName());
        boolean hasIndexObserver = existingDesc.hasCoprocessor(Indexer.class.getName()) || existingDesc.hasCoprocessor(IndexRegionObserver.class.getName()) || existingDesc.hasCoprocessor(GlobalIndexChecker.class.getName());
        return hasScanObserver && hasUnAggObserver && hasGroupedObserver && hasIndexObserver;
    }

    private void pollForUpdatedTableDescriptor(final HBaseAdmin admin, final HTableDescriptor newTableDescriptor, final byte[] tableName) throws InterruptedException, TimeoutException {
        this.checkAndRetry(new RetriableOperation(){

            @Override
            public String getOperationName() {
                return "UpdateOrNewTableDescriptor";
            }

            @Override
            public boolean checkForCompletion() throws TimeoutException, IOException {
                HTableDescriptor tableDesc = admin.getTableDescriptor(tableName);
                return newTableDescriptor.equals((Object)tableDesc);
            }
        });
    }

    private void checkAndRetry(RetriableOperation op) throws InterruptedException, TimeoutException {
        int maxRetries = this.props.getInt("phoenix.schema.change.retries", 10);
        long sleepInterval = this.props.getLong("phoenix.schema.change.delay", 5000L);
        boolean success = false;
        int numTries = 1;
        PhoenixStopWatch watch = new PhoenixStopWatch();
        watch.start();
        do {
            block5: {
                try {
                    success = op.checkForCompletion();
                }
                catch (Exception ex) {
                    if (numTries != 1 && numTries != maxRetries) break block5;
                    watch.stop();
                    TimeoutException toThrow = new TimeoutException("Operation " + op.getOperationName() + " didn't complete because of exception. Time elapsed: " + watch.elapsedMillis());
                    toThrow.initCause(ex);
                    throw toThrow;
                }
            }
            Thread.sleep(sleepInterval);
        } while (++numTries < maxRetries && !success);
        watch.stop();
        if (!success) {
            throw new TimeoutException("Operation  " + op.getOperationName() + " didn't complete within " + watch.elapsedMillis() + " ms " + (numTries > 1 ? "after trying " + numTries + (numTries > 1 ? "times." : "time.") : ""));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Operation " + op.getOperationName() + " completed within " + watch.elapsedMillis() + "ms " + (numTries > 1 ? "after trying " + numTries + (numTries > 1 ? "times." : "time.") : ""));
        }
    }

    private boolean allowOnlineTableSchemaUpdate() {
        return this.props.getBoolean("hbase.online.schema.update.enable", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ensureNamespaceCreated(String schemaName) throws SQLException {
        boolean createdNamespace;
        block20: {
            SQLException sqlE = null;
            createdNamespace = false;
            try (HBaseAdmin admin = this.getAdmin();){
                NamespaceDescriptor namespaceDescriptor = null;
                try {
                    namespaceDescriptor = admin.getNamespaceDescriptor(schemaName);
                }
                catch (NamespaceNotFoundException namespaceNotFoundException) {
                    // empty catch block
                }
                if (namespaceDescriptor == null) {
                    namespaceDescriptor = NamespaceDescriptor.create((String)schemaName).build();
                    admin.createNamespace(namespaceDescriptor);
                    createdNamespace = true;
                }
            }
            catch (IOException e) {
                sqlE = ServerUtil.parseServerException(e);
                return (boolean)sqlE;
            }
            finally {
                if (sqlE == null) break block20;
                throw sqlE;
            }
        }
        return createdNamespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private HTableDescriptor ensureTableCreated(byte[] physicalTableName, PTableType tableType, Map<String, Object> props, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits, boolean modifyExistingMetaData, boolean isNamespaceMapped, boolean isDoNotUpgradePropSet) throws SQLException {
        block99: {
            SQLException sqlE = null;
            HTableDescriptor existingDesc = null;
            boolean isMetaTable = SchemaUtil.isMetaTable(physicalTableName);
            boolean tableExist = true;
            try {
                HTableDescriptor hTableDescriptor;
                Throwable throwable;
                HBaseAdmin admin;
                block97: {
                    block98: {
                        HTableDescriptor newDesc;
                        block94: {
                            HTableDescriptor hTableDescriptor2;
                            block95: {
                                block96: {
                                    boolean willBeTx;
                                    block91: {
                                        HTableDescriptor possibleCompatException22222222;
                                        block92: {
                                            block93: {
                                                block88: {
                                                    HTableDescriptor possibleCompatException22222222;
                                                    block89: {
                                                        block90: {
                                                            boolean createdNamespace;
                                                            block87: {
                                                                block84: {
                                                                    HTableDescriptor possibleCompatException32222;
                                                                    block85: {
                                                                        block86: {
                                                                            admin = this.getAdmin();
                                                                            throwable = null;
                                                                            String quorum = ZKConfig.getZKQuorumServersString((Configuration)this.config);
                                                                            String znode = this.getProps().get("zookeeper.znode.parent");
                                                                            createdNamespace = false;
                                                                            LOGGER.debug("Found quorum: " + quorum + ":" + znode);
                                                                            if (!isMetaTable) break block84;
                                                                            if (SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, this.getProps())) {
                                                                                try {
                                                                                    createdNamespace = this.ensureNamespaceCreated("SYSTEM");
                                                                                }
                                                                                catch (PhoenixIOException phoenixIOException) {
                                                                                    // empty catch block
                                                                                }
                                                                                if (admin.tableExists(SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, false))) {
                                                                                    try {
                                                                                        this.checkClientServerCompatibility(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
                                                                                    }
                                                                                    catch (SQLException possibleCompatException4) {
                                                                                        if (createdNamespace && possibleCompatException4.getErrorCode() == SQLExceptionCode.INCONSISTENT_NAMESPACE_MAPPING_PROPERTIES.getErrorCode()) {
                                                                                            this.ensureNamespaceDropped("SYSTEM");
                                                                                        }
                                                                                        throw possibleCompatException4;
                                                                                    }
                                                                                    throw new UpgradeRequiredException(33L);
                                                                                }
                                                                            } else if (admin.tableExists(SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, true))) {
                                                                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INCONSISTENT_NAMESPACE_MAPPING_PROPERTIES).setMessage("Cannot initiate connection as " + SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, true) + " is found but client does not have " + "phoenix.schema.isNamespaceMappingEnabled" + " enabled").build().buildException();
                                                                            }
                                                                            if (!isDoNotUpgradePropSet) break block84;
                                                                            try {
                                                                                this.checkClientServerCompatibility(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getName());
                                                                            }
                                                                            catch (SQLException possibleCompatException32222) {
                                                                                if (possibleCompatException32222.getCause() instanceof org.apache.hadoop.hbase.TableNotFoundException) {
                                                                                    throw new UpgradeRequiredException(33L);
                                                                                }
                                                                                throw possibleCompatException32222;
                                                                            }
                                                                            possibleCompatException32222 = null;
                                                                            if (admin == null) break block85;
                                                                            if (throwable == null) break block86;
                                                                            try {
                                                                                admin.close();
                                                                            }
                                                                            catch (Throwable throwable2) {
                                                                                throwable.addSuppressed(throwable2);
                                                                            }
                                                                            break block85;
                                                                        }
                                                                        admin.close();
                                                                    }
                                                                    return possibleCompatException32222;
                                                                }
                                                                try {
                                                                    existingDesc = admin.getTableDescriptor(physicalTableName);
                                                                }
                                                                catch (org.apache.hadoop.hbase.TableNotFoundException e) {
                                                                    tableExist = false;
                                                                    if (tableType != PTableType.VIEW) break block87;
                                                                    String fullTableName = Bytes.toString((byte[])physicalTableName);
                                                                    throw new ReadOnlyTableException("An HBase table for a VIEW must already exist", SchemaUtil.getSchemaNameFromFullName(fullTableName), SchemaUtil.getTableNameFromFullName(fullTableName));
                                                                }
                                                            }
                                                            newDesc = this.generateTableDescriptor(physicalTableName, existingDesc, tableType, props, families, splits, isNamespaceMapped);
                                                            if (tableExist) break block88;
                                                            if (SchemaUtil.isSystemTable(physicalTableName) && !this.isUpgradeRequired() && (!this.isAutoUpgradeEnabled || isDoNotUpgradePropSet)) {
                                                                throw new UpgradeRequiredException();
                                                            }
                                                            if (newDesc.getValue(MetaDataUtil.IS_LOCAL_INDEX_TABLE_PROP_BYTES) != null && Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(newDesc.getValue(MetaDataUtil.IS_LOCAL_INDEX_TABLE_PROP_BYTES)))) {
                                                                newDesc.setValue("SPLIT_POLICY", IndexRegionSplitPolicy.class.getName());
                                                            }
                                                            try {
                                                                if (splits == null) {
                                                                    admin.createTable(newDesc);
                                                                } else {
                                                                    admin.createTable(newDesc, splits);
                                                                }
                                                            }
                                                            catch (TableExistsException e) {
                                                                if (isMetaTable && !this.isUpgradeRequired()) {
                                                                    this.checkClientServerCompatibility(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getName());
                                                                }
                                                                HTableDescriptor hTableDescriptor3 = null;
                                                                if (admin != null) {
                                                                    if (throwable != null) {
                                                                        try {
                                                                            admin.close();
                                                                        }
                                                                        catch (Throwable throwable3) {
                                                                            throwable.addSuppressed(throwable3);
                                                                        }
                                                                    } else {
                                                                        admin.close();
                                                                    }
                                                                }
                                                                if (sqlE != null) {
                                                                    throw sqlE;
                                                                }
                                                                return hTableDescriptor3;
                                                            }
                                                            if (isMetaTable && !this.isUpgradeRequired()) {
                                                                try {
                                                                    this.checkClientServerCompatibility(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getName());
                                                                }
                                                                catch (SQLException possibleCompatException22222222) {
                                                                    if (possibleCompatException22222222.getErrorCode() == SQLExceptionCode.INCONSISTENT_NAMESPACE_MAPPING_PROPERTIES.getErrorCode()) {
                                                                        try {
                                                                            admin.disableTable(physicalTableName);
                                                                            admin.deleteTable(physicalTableName);
                                                                        }
                                                                        catch (org.apache.hadoop.hbase.TableNotFoundException tableNotFoundException) {
                                                                            // empty catch block
                                                                        }
                                                                        if (createdNamespace && SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, this.getProps())) {
                                                                            this.ensureNamespaceDropped("SYSTEM");
                                                                        }
                                                                    }
                                                                    throw possibleCompatException22222222;
                                                                }
                                                            }
                                                            possibleCompatException22222222 = null;
                                                            if (admin == null) break block89;
                                                            if (throwable == null) break block90;
                                                            try {
                                                                admin.close();
                                                            }
                                                            catch (Throwable throwable4) {
                                                                throwable.addSuppressed(throwable4);
                                                            }
                                                            break block89;
                                                        }
                                                        admin.close();
                                                    }
                                                    return possibleCompatException22222222;
                                                }
                                                if (isMetaTable && !this.isUpgradeRequired()) {
                                                    this.checkClientServerCompatibility(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getName());
                                                } else {
                                                    for (Pair<byte[], Map<String, Object>> family : families) {
                                                        if (newDesc.getValue("SPLIT_POLICY") != null && newDesc.getValue("SPLIT_POLICY").equals(IndexRegionSplitPolicy.class.getName()) || !Bytes.toString((byte[])((byte[])family.getFirst())).startsWith("L#")) continue;
                                                        newDesc.setValue("SPLIT_POLICY", IndexRegionSplitPolicy.class.getName());
                                                        break;
                                                    }
                                                }
                                                if (modifyExistingMetaData) break block91;
                                                possibleCompatException22222222 = existingDesc;
                                                if (admin == null) break block92;
                                                if (throwable == null) break block93;
                                                try {
                                                    admin.close();
                                                }
                                                catch (Throwable family) {
                                                    throwable.addSuppressed(family);
                                                }
                                                break block92;
                                            }
                                            admin.close();
                                        }
                                        return possibleCompatException22222222;
                                    }
                                    TransactionFactory.Provider provider = this.getTransactionProvider(props);
                                    boolean bl = willBeTx = provider != null;
                                    if (willBeTx) {
                                        if (!ConnectionQueryServicesImpl.equalTxCoprocessor(provider, existingDesc, newDesc)) {
                                            if (ConnectionQueryServicesImpl.hasTxCoprocessor(existingDesc)) {
                                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SWITCH_TXN_PROVIDERS).setSchemaName(SchemaUtil.getSchemaNameFromFullName(physicalTableName)).setTableName(SchemaUtil.getTableNameFromFullName(physicalTableName)).build().buildException();
                                            }
                                            if (provider.getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.ALTER_NONTX_TO_TX)) {
                                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ALTER_TABLE_FROM_NON_TXN_TO_TXNL).setMessage(provider.name()).setSchemaName(SchemaUtil.getSchemaNameFromFullName(physicalTableName)).setTableName(SchemaUtil.getTableNameFromFullName(physicalTableName)).build().buildException();
                                            }
                                            newDesc.setValue("data.tx.read.pre.existing", Boolean.TRUE.toString());
                                        }
                                    } else {
                                        if (ConnectionQueryServicesImpl.hasTxCoprocessor(existingDesc)) {
                                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TX_MAY_NOT_SWITCH_TO_NON_TX).setSchemaName(SchemaUtil.getSchemaNameFromFullName(physicalTableName)).setTableName(SchemaUtil.getTableNameFromFullName(physicalTableName)).build().buildException();
                                        }
                                        newDesc.remove("data.tx.read.pre.existing");
                                    }
                                    if (!existingDesc.equals((Object)newDesc)) break block94;
                                    hTableDescriptor2 = null;
                                    if (admin == null) break block95;
                                    if (throwable == null) break block96;
                                    try {
                                        admin.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                    break block95;
                                }
                                admin.close();
                            }
                            return hTableDescriptor2;
                        }
                        if (tableType != PTableType.SYSTEM) {
                            this.modifyTable(physicalTableName, newDesc, true);
                        }
                        hTableDescriptor = newDesc;
                        if (admin == null) break block97;
                        if (throwable == null) break block98;
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        break block97;
                    }
                    admin.close();
                }
                return hTableDescriptor;
                catch (Throwable throwable7) {
                    try {
                        try {
                            throwable = throwable7;
                            throw throwable7;
                        }
                        catch (Throwable throwable8) {
                            if (admin != null) {
                                if (throwable != null) {
                                    try {
                                        admin.close();
                                    }
                                    catch (Throwable throwable9) {
                                        throwable.addSuppressed(throwable9);
                                    }
                                } else {
                                    admin.close();
                                }
                            }
                            throw throwable8;
                        }
                    }
                    catch (IOException e) {
                        sqlE = ServerUtil.parseServerException(e);
                        if (sqlE != null) {
                            throw sqlE;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
                        return sqlE;
                    }
                    catch (TimeoutException e) {
                        sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.OPERATION_TIMED_OUT).setRootCause(e.getCause() != null ? e.getCause() : e).build().buildException();
                        return sqlE;
                    }
                }
            }
            finally {
                if (sqlE == null) break block99;
                throw sqlE;
            }
        }
        return null;
    }

    @VisibleForTesting
    public boolean updateAndConfirmSplitPolicyForTask(HTableDescriptor htd) throws SQLException {
        boolean isTaskTable = false;
        TableName sysTaskTable = SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_TASK_NAME, this.props);
        if (htd.getTableName().equals((Object)sysTaskTable)) {
            isTaskTable = true;
        }
        if (isTaskTable) {
            String actualSplitPolicy = htd.getRegionSplitPolicyClassName();
            String targetSplitPolicy = SystemTaskSplitPolicy.class.getName();
            if (!targetSplitPolicy.equals(actualSplitPolicy)) {
                if (StringUtils.isNotEmpty((String)actualSplitPolicy)) {
                    throw new InvalidRegionSplitPolicyException("SYSTEM", "TASK", (List<String>)ImmutableList.of((Object)"null", (Object)targetSplitPolicy), actualSplitPolicy);
                }
                htd.setRegionSplitPolicyClassName(targetSplitPolicy);
                return true;
            }
        }
        return false;
    }

    private static boolean hasTxCoprocessor(HTableDescriptor descriptor) {
        for (TransactionFactory.Provider provider : TransactionFactory.Provider.values()) {
            Class<? extends RegionObserver> coprocessorClass = provider.getTransactionProvider().getCoprocessor();
            if (coprocessorClass == null || !descriptor.hasCoprocessor(coprocessorClass.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean equalTxCoprocessor(TransactionFactory.Provider provider, HTableDescriptor existingDesc, HTableDescriptor newDesc) {
        Class<? extends RegionObserver> coprocessorClass = provider.getTransactionProvider().getCoprocessor();
        return coprocessorClass != null && existingDesc.hasCoprocessor(coprocessorClass.getName()) && newDesc.hasCoprocessor(coprocessorClass.getName());
    }

    private void modifyTable(byte[] tableName, HTableDescriptor newDesc, boolean shouldPoll) throws IOException, InterruptedException, TimeoutException, SQLException {
        try (HBaseAdmin admin = this.getAdmin();){
            if (!this.allowOnlineTableSchemaUpdate()) {
                admin.disableTable(tableName);
                admin.modifyTable(tableName, newDesc);
                admin.enableTable(tableName);
            } else {
                admin.modifyTable(tableName, newDesc);
                if (shouldPoll) {
                    this.pollForUpdatedTableDescriptor(admin, newDesc, tableName);
                }
            }
        }
    }

    private static boolean hasIndexWALCodec(Long serverVersion) {
        if (serverVersion == null) {
            return true;
        }
        return MetaDataUtil.decodeHasIndexWALCodec(serverVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkClientServerCompatibility(byte[] metaTable) throws SQLException, AccessDeniedException {
        StringBuilder errorMessage = new StringBuilder();
        int minHBaseVersion = Integer.MAX_VALUE;
        boolean isTableNamespaceMappingEnabled = false;
        long systemCatalogTimestamp = Long.MAX_VALUE;
        HTableInterface ht = null;
        try {
            Map results;
            ht = this.getTable(metaTable);
            byte[] tablekey = PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES;
            try {
                results = ht.coprocessorService(MetaDataProtos.MetaDataService.class, tablekey, tablekey, (Batch.Call)new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.GetVersionResponse>(){

                    public MetaDataProtos.GetVersionResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                        ServerRpcController controller = new ServerRpcController();
                        BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                        MetaDataProtos.GetVersionRequest.Builder builder = MetaDataProtos.GetVersionRequest.newBuilder();
                        builder.setClientVersion(VersionUtil.encodeVersion(4, 16, 0));
                        instance.getVersion((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.GetVersionResponse>)rpcCallback);
                        if (controller.getFailedOn() != null) {
                            throw controller.getFailedOn();
                        }
                        return (MetaDataProtos.GetVersionResponse)rpcCallback.get();
                    }
                });
            }
            catch (Throwable t) {
                throw ServerUtil.parseServerException(t);
            }
            for (Map.Entry result : results.entrySet()) {
                MetaDataProtos.GetVersionResponse versionResponse = (MetaDataProtos.GetVersionResponse)result.getValue();
                long serverJarVersion = versionResponse.getVersion();
                isTableNamespaceMappingEnabled |= MetaDataUtil.decodeTableNamespaceMappingEnabled(serverJarVersion);
                MetaDataUtil.ClientServerCompatibility compatibility = MetaDataUtil.areClientAndServerCompatible(serverJarVersion);
                if (!compatibility.getIsCompatible()) {
                    if (compatibility.getErrorCode() == SQLExceptionCode.OUTDATED_JARS.getErrorCode()) {
                        errorMessage.append("Newer Phoenix clients can't communicate with older Phoenix servers. Client version: 4.16.0; Server version: " + this.getServerVersion(serverJarVersion) + " The following servers require an updated " + "phoenix-[version]-server.jar" + " to be put in the classpath of HBase.");
                    } else if (compatibility.getErrorCode() == SQLExceptionCode.INCOMPATIBLE_CLIENT_SERVER_JAR.getErrorCode()) {
                        errorMessage.append("Major version of client is less than that of the server. Client version: 4.16.0; Server version: " + this.getServerVersion(serverJarVersion));
                    }
                }
                this.hasIndexWALCodec &= ConnectionQueryServicesImpl.hasIndexWALCodec(serverJarVersion);
                if (minHBaseVersion > MetaDataUtil.decodeHBaseVersion(serverJarVersion)) {
                    minHBaseVersion = MetaDataUtil.decodeHBaseVersion(serverJarVersion);
                }
                if (versionResponse.hasSystemCatalogTimestamp()) {
                    long l = systemCatalogTimestamp = systemCatalogTimestamp < versionResponse.getSystemCatalogTimestamp() ? systemCatalogTimestamp : versionResponse.getSystemCatalogTimestamp();
                }
                if (compatibility.getErrorCode() == 0) continue;
                if (compatibility.getErrorCode() == SQLExceptionCode.OUTDATED_JARS.getErrorCode()) {
                    errorMessage.setLength(errorMessage.length() - 1);
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.OUTDATED_JARS).setMessage(errorMessage.toString()).build().buildException();
                }
                if (compatibility.getErrorCode() != SQLExceptionCode.INCOMPATIBLE_CLIENT_SERVER_JAR.getErrorCode()) continue;
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INCOMPATIBLE_CLIENT_SERVER_JAR).setMessage(errorMessage.toString()).build().buildException();
            }
            if (isTableNamespaceMappingEnabled != SchemaUtil.isNamespaceMappingEnabled(PTableType.TABLE, this.getProps())) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INCONSISTENT_NAMESPACE_MAPPING_PROPERTIES).setMessage("Ensure that config phoenix.schema.isNamespaceMappingEnabled is consistent on client and server.").build().buildException();
            }
            this.lowestClusterHBaseVersion = minHBaseVersion;
        }
        finally {
            if (ht != null) {
                try {
                    ht.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Could not close HTable", (Throwable)e);
                }
            }
        }
        if (systemCatalogTimestamp < 33L) {
            throw new UpgradeRequiredException(systemCatalogTimestamp);
        }
    }

    private String getServerVersion(long serverJarVersion) {
        return VersionUtil.decodeMajorVersion(MetaDataUtil.decodePhoenixVersion(serverJarVersion)) + "." + VersionUtil.decodeMinorVersion(MetaDataUtil.decodePhoenixVersion(serverJarVersion)) + "." + VersionUtil.decodePatchVersion(MetaDataUtil.decodePhoenixVersion(serverJarVersion));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MetaDataProtocol.MetaDataMutationResult childLinkMetaDataCoprocessorExec(byte[] parentTableKey, Batch.Call<ChildLinkMetaDataProtos.ChildLinkMetaDataService, MetaDataProtos.MetaDataResponse> callable) throws SQLException {
        try (HTableInterface htable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES, this.getProps()).getName());){
            Map results = htable.coprocessorService(ChildLinkMetaDataProtos.ChildLinkMetaDataService.class, parentTableKey, parentTableKey, callable);
            assert (results.size() == 1);
            MetaDataProtos.MetaDataResponse result = (MetaDataProtos.MetaDataResponse)results.values().iterator().next();
            MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = MetaDataProtocol.MetaDataMutationResult.constructFromProto(result);
            return metaDataMutationResult;
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
        catch (Throwable t) {
            throw new SQLException(t);
        }
    }

    private MetaDataProtocol.MetaDataMutationResult metaDataCoprocessorExec(byte[] tableKey, Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse> callable) throws SQLException {
        return this.metaDataCoprocessorExec(tableKey, callable, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MetaDataProtocol.MetaDataMutationResult metaDataCoprocessorExec(byte[] tableKey, Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse> callable, byte[] tableName) throws SQLException {
        try {
            boolean retried = false;
            while (true) {
                if (retried) {
                    this.connection.relocateRegion(SchemaUtil.getPhysicalName(tableName, this.getProps()), tableKey);
                }
                HTableInterface ht = this.getTable(SchemaUtil.getPhysicalName(tableName, this.getProps()).getName());
                try {
                    Map results = ht.coprocessorService(MetaDataProtos.MetaDataService.class, tableKey, tableKey, callable);
                    assert (results.size() == 1);
                    MetaDataProtos.MetaDataResponse result = (MetaDataProtos.MetaDataResponse)results.values().iterator().next();
                    if (result.getReturnCode() == MetaDataProtos.MutationCode.TABLE_NOT_IN_REGION || result.getReturnCode() == MetaDataProtos.MutationCode.FUNCTION_NOT_IN_REGION) {
                        if (retried) {
                            MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = MetaDataProtocol.MetaDataMutationResult.constructFromProto(result);
                            return metaDataMutationResult;
                        }
                        retried = true;
                        continue;
                    }
                    MetaDataProtocol.MetaDataMutationResult metaDataMutationResult = MetaDataProtocol.MetaDataMutationResult.constructFromProto(result);
                    return metaDataMutationResult;
                }
                finally {
                    Closeables.closeQuietly((Closeable)ht);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
        catch (Throwable t) {
            throw new SQLException(t);
        }
    }

    private void ensureViewIndexTableCreated(byte[] physicalTableName, Map<String, Object> tableProps, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits, long timestamp, boolean isNamespaceMapped) throws SQLException {
        byte[] physicalIndexName = MetaDataUtil.getViewIndexPhysicalName(physicalTableName);
        tableProps.put("IS_VIEW_INDEX_TABLE", TRUE_BYTES_AS_STRING);
        HTableDescriptor desc = this.ensureTableCreated(physicalIndexName, PTableType.TABLE, tableProps, families, splits, true, isNamespaceMapped, false);
        if (desc != null && !Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(desc.getValue(MetaDataUtil.IS_VIEW_INDEX_TABLE_PROP_BYTES)))) {
            String fullTableName = Bytes.toString((byte[])physicalIndexName);
            throw new TableAlreadyExistsException(SchemaUtil.getSchemaNameFromFullName(fullTableName), SchemaUtil.getTableNameFromFullName(fullTableName), "Unable to create shared physical table for indexes on views.");
        }
    }

    private boolean ensureViewIndexTableDropped(byte[] physicalTableName, long timestamp) throws SQLException {
        boolean wasDeleted;
        block17: {
            byte[] physicalIndexName = MetaDataUtil.getViewIndexPhysicalName(physicalTableName);
            wasDeleted = false;
            try (HBaseAdmin admin = this.getAdmin();){
                try {
                    HTableDescriptor desc = admin.getTableDescriptor(physicalIndexName);
                    if (!Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(desc.getValue(MetaDataUtil.IS_VIEW_INDEX_TABLE_PROP_BYTES)))) break block17;
                    ReadOnlyProps props = this.getProps();
                    boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                    if (dropMetadata) {
                        admin.disableTable(physicalIndexName);
                        admin.deleteTable(physicalIndexName);
                        this.clearTableRegionCache(physicalIndexName);
                        wasDeleted = true;
                        break block17;
                    }
                    this.tableStatsCache.invalidateAll(desc);
                }
                catch (org.apache.hadoop.hbase.TableNotFoundException tableNotFoundException) {
                    // empty catch block
                }
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
        }
        return wasDeleted;
    }

    private boolean ensureLocalIndexTableDropped(byte[] physicalTableName, long timestamp) throws SQLException {
        HTableDescriptor desc = null;
        boolean wasDeleted = false;
        try (HBaseAdmin admin = this.getAdmin();){
            try {
                desc = admin.getTableDescriptor(physicalTableName);
                for (byte[] fam : desc.getFamiliesKeys()) {
                    this.tableStatsCache.invalidate(new GuidePostsKey(physicalTableName, fam));
                }
                ReadOnlyProps props = this.getProps();
                boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                if (dropMetadata) {
                    ArrayList<String> columnFamiles = new ArrayList<String>();
                    for (HColumnDescriptor cf : desc.getColumnFamilies()) {
                        if (!cf.getNameAsString().startsWith("L#")) continue;
                        columnFamiles.add(cf.getNameAsString());
                    }
                    for (String cf : columnFamiles) {
                        admin.deleteColumn(physicalTableName, cf);
                    }
                    this.clearTableRegionCache(physicalTableName);
                    wasDeleted = true;
                }
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
        return wasDeleted;
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult createTable(final List<Mutation> tableMetaData, byte[] physicalTableName, PTableType tableType, Map<String, Object> tableProps, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits, boolean isNamespaceMapped, final boolean allocateIndexId, boolean isDoNotUpgradePropSet, final PTable parentTable) throws SQLException {
        List<Mutation> childLinkMutations = MetaDataUtil.removeChildLinkMutations(tableMetaData);
        byte[][] rowKeyMetadata = new byte[3][];
        Put m = MetaDataUtil.getPutOnlyTableHeaderRow(tableMetaData);
        byte[] key = m.getRow();
        SchemaUtil.getVarChars(key, rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] schemaBytes = rowKeyMetadata[1];
        byte[] tableBytes = rowKeyMetadata[2];
        byte[] physicalTableNameBytes = physicalTableName != null ? physicalTableName : SchemaUtil.getPhysicalHBaseTableName(schemaBytes, tableBytes, isNamespaceMapped).getBytes();
        boolean localIndexTable = false;
        for (Pair<byte[], Map<String, Object>> family : families) {
            if (!Bytes.toString((byte[])((byte[])family.getFirst())).startsWith("L#")) continue;
            localIndexTable = true;
            break;
        }
        if (tableType == PTableType.VIEW && physicalTableName != null || tableType != PTableType.VIEW && (physicalTableName == null || localIndexTable)) {
            this.ensureTableCreated(physicalTableNameBytes, tableType, tableProps, families, splits, true, isNamespaceMapped, isDoNotUpgradePropSet);
        }
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        if (tableType == PTableType.INDEX) {
            if (physicalTableName != null && !localIndexTable && !MetaDataUtil.isMultiTenant((Mutation)m, this.kvBuilder, ptr)) {
                this.ensureViewIndexTableCreated(tenantIdBytes.length == 0 ? null : PNameFactory.newName(tenantIdBytes), physicalTableName, MetaDataUtil.getClientTimeStamp((Mutation)m), isNamespaceMapped);
            }
        } else if (tableType == PTableType.TABLE && MetaDataUtil.isMultiTenant((Mutation)m, this.kvBuilder, ptr)) {
            ptr.set(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
            MetaDataUtil.getMutationValue((Mutation)m, PhoenixDatabaseMetaData.DEFAULT_COLUMN_FAMILY_NAME_BYTES, this.kvBuilder, ptr);
            List<Object> familiesPlusDefault = null;
            for (Pair<byte[], Map<String, Object>> family : families) {
                byte[] cf = (byte[])family.getFirst();
                if (Bytes.compareTo((byte[])cf, (int)0, (int)cf.length, (byte[])ptr.get(), (int)ptr.getOffset(), (int)ptr.getLength()) != 0) continue;
                familiesPlusDefault = families;
                break;
            }
            if (familiesPlusDefault == null) {
                byte[] defaultCF = ByteUtil.copyKeyBytesIfNecessary(ptr);
                familiesPlusDefault = Lists.newArrayList(families);
                familiesPlusDefault.add(new Pair((Object)defaultCF, Collections.emptyMap()));
            }
            this.ensureViewIndexTableCreated(physicalTableNameBytes, tableProps, familiesPlusDefault, MetaDataUtil.isSalted((Mutation)m, this.kvBuilder, ptr) ? splits : (byte[][])null, MetaDataUtil.getClientTimeStamp((Mutation)m), isNamespaceMapped);
        }
        if (!childLinkMutations.isEmpty()) {
            byte[] rowKey = childLinkMutations.get(0).getRow();
            MetaDataProtocol.MetaDataMutationResult result = this.childLinkMetaDataCoprocessorExec(rowKey, new ChildLinkMetaDataServiceCallBack(childLinkMutations));
            switch (result.getMutationCode()) {
                case UNABLE_TO_CREATE_CHILD_LINK: {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNABLE_TO_CREATE_CHILD_LINK).setSchemaName(Bytes.toString((byte[])schemaBytes)).setTableName(Bytes.toString((byte[])physicalTableNameBytes)).build().buildException();
                }
            }
        }
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
        return this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.CreateTableRequest.Builder builder = MetaDataProtos.CreateTableRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setClientVersion(VersionUtil.encodeVersion(4, 16, 0));
                if (allocateIndexId) {
                    builder.setAllocateIndexId(allocateIndexId);
                }
                if (parentTable != null) {
                    builder.setParentTable(PTableImpl.toProto(parentTable));
                }
                MetaDataProtos.CreateTableRequest build = builder.build();
                instance.createTable((RpcController)controller, build, (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult getTable(PName tenantId, final byte[] schemaBytes, final byte[] tableBytes, final long tableTimestamp, final long clientTimestamp) throws SQLException {
        final byte[] tenantIdBytes = tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId.getBytes();
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
        return this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.GetTableRequest.Builder builder = MetaDataProtos.GetTableRequest.newBuilder();
                builder.setTenantId(ByteStringer.wrap((byte[])tenantIdBytes));
                builder.setSchemaName(ByteStringer.wrap((byte[])schemaBytes));
                builder.setTableName(ByteStringer.wrap((byte[])tableBytes));
                builder.setTableTimestamp(tableTimestamp);
                builder.setClientTimestamp(clientTimestamp);
                builder.setClientVersion(VersionUtil.encodeVersion(4, 16, 0));
                instance.getTable((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropTable(final List<Mutation> tableMetaData, final PTableType tableType, final boolean cascade) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        SchemaUtil.getVarChars(tableMetaData.get(0).getRow(), rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] schemaBytes = rowKeyMetadata[1];
        byte[] tableBytes = rowKeyMetadata[2];
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantIdBytes, schemaBytes, tableBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.DropTableRequest.Builder builder = MetaDataProtos.DropTableRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setTableType(tableType.getSerializedValue());
                builder.setCascade(cascade);
                builder.setClientVersion(VersionUtil.encodeVersion(4, 16, 0));
                instance.dropTable((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
        MetaDataProtocol.MutationCode code = result.getMutationCode();
        switch (code) {
            case TABLE_ALREADY_EXISTS: {
                ReadOnlyProps props = this.getProps();
                boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                PTable table = result.getTable();
                if (dropMetadata) {
                    this.flushParentPhysicalTable(table);
                    this.dropTables(result.getTableNamesToDelete());
                } else {
                    this.invalidateTableStats(result.getTableNamesToDelete());
                }
                long timestamp = MetaDataUtil.getClientTimeStamp(tableMetaData);
                if (tableType != PTableType.TABLE) break;
                byte[] physicalName = table.getPhysicalName().getBytes();
                this.ensureViewIndexTableDropped(physicalName, timestamp);
                this.ensureLocalIndexTableDropped(physicalName, timestamp);
                this.tableStatsCache.invalidateAll(table);
                break;
            }
        }
        return result;
    }

    private void flushParentPhysicalTable(PTable table) throws SQLException {
        byte[] parentPhysicalTableName = null;
        if (PTableType.VIEW == table.getType()) {
            if (!table.getIndexes().isEmpty()) {
                parentPhysicalTableName = table.getPhysicalName().getBytes();
            }
        } else if (PTableType.INDEX == table.getType()) {
            PTable parentTable = this.getTable(table.getTenantId(), table.getParentName().getString(), Long.MAX_VALUE);
            parentPhysicalTableName = parentTable.getPhysicalName().getBytes();
        }
        if (parentPhysicalTableName != null) {
            try {
                this.flushTable(parentPhysicalTableName);
            }
            catch (PhoenixIOException ex) {
                if (ex.getCause() instanceof org.apache.hadoop.hbase.TableNotFoundException) {
                    LOGGER.info("Flushing physical parent table " + Bytes.toString((byte[])parentPhysicalTableName) + " of " + table.getName().getString() + " failed with : " + ex + " with cause: " + ex.getCause() + " since the table has already been dropped");
                }
                throw ex;
            }
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropFunction(final List<Mutation> functionData, final boolean ifExists) throws SQLException {
        byte[][] rowKeyMetadata = new byte[2][];
        byte[] key = functionData.get(0).getRow();
        SchemaUtil.getVarChars(key, rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] functionBytes = rowKeyMetadata[1];
        byte[] functionKey = SchemaUtil.getFunctionKey(tenantIdBytes, functionBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(functionKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.DropFunctionRequest.Builder builder = MetaDataProtos.DropFunctionRequest.newBuilder();
                for (Mutation m : functionData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setIfExists(ifExists);
                builder.setClientVersion(VersionUtil.encodeVersion(4, 16, 0));
                instance.dropFunction((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        }, PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME_BYTES);
        return result;
    }

    private void invalidateTableStats(List<byte[]> tableNamesToDelete) throws SQLException {
        if (tableNamesToDelete != null) {
            for (byte[] tableName : tableNamesToDelete) {
                TableName tn = TableName.valueOf((byte[])tableName);
                HTableDescriptor htableDesc = this.getTableDescriptor(tableName);
                this.tableStatsCache.invalidateAll(htableDesc);
            }
        }
    }

    private void dropTable(byte[] tableNameToDelete) throws SQLException {
        this.dropTables(Collections.singletonList(tableNameToDelete));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTables(List<byte[]> tableNamesToDelete) throws SQLException {
        block21: {
            SQLException sqlE = null;
            try (HBaseAdmin admin = this.getAdmin();){
                if (tableNamesToDelete != null) {
                    for (byte[] tableName : tableNamesToDelete) {
                        try {
                            HTableDescriptor htableDesc = this.getTableDescriptor(tableName);
                            admin.disableTable(tableName);
                            admin.deleteTable(tableName);
                            this.tableStatsCache.invalidateAll(htableDesc);
                            this.clearTableRegionCache(tableName);
                        }
                        catch (TableNotFoundException tableNotFoundException) {}
                    }
                }
            }
            catch (IOException e) {
                sqlE = ServerUtil.parseServerException(e);
            }
            finally {
                if (sqlE == null) break block21;
                throw sqlE;
            }
        }
    }

    private static Map<String, Object> createPropertiesMap(Map<ImmutableBytesWritable, ImmutableBytesWritable> htableProps) {
        HashMap props = Maps.newHashMapWithExpectedSize((int)htableProps.size());
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : htableProps.entrySet()) {
            ImmutableBytesWritable key = entry.getKey();
            ImmutableBytesWritable value = entry.getValue();
            props.put(Bytes.toString((byte[])key.get(), (int)key.getOffset(), (int)key.getLength()), Bytes.toString((byte[])value.get(), (int)value.getOffset(), (int)value.getLength()));
        }
        return props;
    }

    private void ensureViewIndexTableCreated(PName tenantId, byte[] physicalIndexTableName, long timestamp, boolean isNamespaceMapped) throws SQLException {
        String name = Bytes.toString((byte[])SchemaUtil.getParentTableNameFromIndexTable(physicalIndexTableName, "_IDX_")).replace(":", ".");
        PTable table = this.getTable(tenantId, name, timestamp);
        this.ensureViewIndexTableCreated(table, timestamp, isNamespaceMapped);
    }

    private PTable getTable(PName tenantId, String fullTableName, long timestamp) throws SQLException {
        PTable table;
        block3: {
            try {
                PMetaData metadata = this.latestMetaData;
                this.throwConnectionClosedIfNullMetaData();
                table = metadata.getTableRef(new PTableKey(tenantId, fullTableName)).getTable();
                if (table.getTimeStamp() >= timestamp) {
                    throw new TableNotFoundException(table.getSchemaName().getString(), table.getTableName().getString());
                }
            }
            catch (TableNotFoundException e) {
                byte[] schemaName = Bytes.toBytes((String)SchemaUtil.getSchemaNameFromFullName(fullTableName));
                byte[] tableName = Bytes.toBytes((String)SchemaUtil.getTableNameFromFullName(fullTableName));
                MetaDataProtocol.MetaDataMutationResult result = this.getTable(tenantId, schemaName, tableName, Long.MAX_VALUE, timestamp);
                table = result.getTable();
                if (table != null) break block3;
                throw e;
            }
        }
        return table;
    }

    private void ensureViewIndexTableCreated(PTable table, long timestamp, boolean isNamespaceMapped) throws SQLException {
        byte[] physicalTableName = table.getPhysicalName().getBytes();
        HTableDescriptor htableDesc = this.getTableDescriptor(physicalTableName);
        ArrayList families = Lists.newArrayListWithExpectedSize((int)Math.max(1, table.getColumnFamilies().size() + 1));
        for (PColumnFamily family : table.getColumnFamilies()) {
            byte[] familyName = family.getName().getBytes();
            Map<String, Object> familyProps = ConnectionQueryServicesImpl.createPropertiesMap(htableDesc.getFamily(familyName).getValues());
            families.add(new Pair((Object)familyName, familyProps));
        }
        byte[] defaultFamilyName = table.getDefaultFamilyName() == null ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES : table.getDefaultFamilyName().getBytes();
        families.add(new Pair((Object)defaultFamilyName, Collections.emptyMap()));
        byte[][] splits = null;
        if (table.getBucketNum() != null) {
            splits = SaltingUtil.getSalteByteSplitPoints(table.getBucketNum());
        }
        Map<String, Object> tableProps = ConnectionQueryServicesImpl.createPropertiesMap(htableDesc.getValues());
        tableProps.put("TRANSACTIONAL", table.isTransactional());
        tableProps.put("IMMUTABLE_ROWS", table.isImmutableRows());
        this.ensureViewIndexTableCreated(physicalTableName, tableProps, families, splits, timestamp, isNamespaceMapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetaDataProtocol.MetaDataMutationResult addColumn(final List<Mutation> tableMetaData, PTable table, final PTable parentTable, Map<String, List<Pair<String, Object>>> stmtProperties, Set<String> colFamiliesForPColumnsToBeAdded, List<PColumn> columns) throws SQLException {
        ArrayList families = new ArrayList(stmtProperties.size());
        HashMap<String, Object> tableProps = new HashMap<String, Object>();
        HashSet<HTableDescriptor> tableDescriptors = Collections.emptySet();
        boolean nonTxToTx = false;
        Map<HTableDescriptor, HTableDescriptor> oldToNewTableDescriptors = this.separateAndValidateProperties(table, stmtProperties, colFamiliesForPColumnsToBeAdded, tableProps);
        HashSet<HTableDescriptor> origTableDescriptors = new HashSet<HTableDescriptor>(oldToNewTableDescriptors.keySet());
        HTableDescriptor baseTableOrigDesc = this.getTableDescriptor(table.getPhysicalName().getBytes());
        HTableDescriptor tableDescriptor = oldToNewTableDescriptors.get(baseTableOrigDesc);
        if (tableDescriptor != null) {
            tableDescriptors = Sets.newHashSetWithExpectedSize((int)(3 + table.getIndexes().size()));
            nonTxToTx = Boolean.TRUE.equals(tableProps.get("data.tx.read.pre.existing"));
            if (nonTxToTx) {
                this.updateDescriptorForTx(table, tableProps, tableDescriptor, Boolean.TRUE.toString(), tableDescriptors, origTableDescriptors, oldToNewTableDescriptors);
                tableDescriptors.add(tableDescriptor);
            } else {
                tableDescriptors = new HashSet<HTableDescriptor>(oldToNewTableDescriptors.values());
            }
        }
        boolean success = false;
        boolean metaDataUpdated = !tableDescriptors.isEmpty();
        boolean pollingNeeded = tableProps.isEmpty() || !families.isEmpty() || !colFamiliesForPColumnsToBeAdded.isEmpty();
        MetaDataProtocol.MetaDataMutationResult result = null;
        try {
            boolean modifyHTable = true;
            if (table.getType() == PTableType.VIEW) {
                boolean canViewsAddNewCF = this.props.getBoolean("phoenix.view.allowNewColumnFamily", true);
                boolean bl = modifyHTable = canViewsAddNewCF && !this.existingColumnFamiliesForBaseTable(table.getPhysicalName()).containsAll(colFamiliesForPColumnsToBeAdded);
            }
            if (tableMetaData.isEmpty() || tableMetaData.size() == 1 && tableMetaData.get(0).isEmpty()) {
                if (modifyHTable) {
                    this.sendHBaseMetaData(tableDescriptors, pollingNeeded);
                }
                MetaDataProtocol.MetaDataMutationResult canViewsAddNewCF = new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.NO_OP, EnvironmentEdgeManager.currentTimeMillis(), table);
                return canViewsAddNewCF;
            }
            byte[][] rowKeyMetaData = new byte[3][];
            PTableType tableType = table.getType();
            Mutation m = tableMetaData.get(0);
            byte[] rowKey = m.getRow();
            SchemaUtil.getVarChars(rowKey, rowKeyMetaData);
            byte[] tenantIdBytes = rowKeyMetaData[0];
            byte[] schemaBytes = rowKeyMetaData[1];
            byte[] tableBytes = rowKeyMetaData[2];
            byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            final boolean addingColumns = columns != null && columns.size() > 0;
            result = this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

                public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                    ServerRpcController controller = new ServerRpcController();
                    BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                    MetaDataProtos.AddColumnRequest.Builder builder = MetaDataProtos.AddColumnRequest.newBuilder();
                    for (Mutation m : tableMetaData) {
                        ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                        builder.addTableMetadataMutations(mp.toByteString());
                    }
                    builder.setClientVersion(VersionUtil.encodeVersion(4, 16, 0));
                    if (parentTable != null) {
                        builder.setParentTable(PTableImpl.toProto(parentTable));
                    }
                    builder.setAddingColumns(addingColumns);
                    instance.addColumn((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                    if (controller.getFailedOn() != null) {
                        throw controller.getFailedOn();
                    }
                    return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
                }
            });
            if (result.getMutationCode() == MetaDataProtocol.MutationCode.COLUMN_NOT_FOUND || result.getMutationCode() == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                success = true;
                if (MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.DISABLE_WAL_BYTES, this.kvBuilder, ptr) && Boolean.FALSE.equals(PBoolean.INSTANCE.toObject(ptr))) {
                    this.flushTable(table.getPhysicalName().getBytes());
                }
                if (tableType == PTableType.TABLE && MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.MULTI_TENANT_BYTES, this.kvBuilder, ptr)) {
                    long timestamp = MetaDataUtil.getClientTimeStamp(m);
                    if (Boolean.TRUE.equals(PBoolean.INSTANCE.toObject(ptr.get(), ptr.getOffset(), ptr.getLength()))) {
                        this.ensureViewIndexTableCreated(table, timestamp, table.isNamespaceMapped());
                    } else {
                        this.ensureViewIndexTableDropped(table.getPhysicalName().getBytes(), timestamp);
                    }
                }
            }
            if (modifyHTable && result.getMutationCode() != MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION) {
                this.sendHBaseMetaData(tableDescriptors, pollingNeeded);
            }
        }
        finally {
            if (!success && metaDataUpdated && nonTxToTx) {
                this.sendHBaseMetaData(origTableDescriptors, pollingNeeded);
            }
        }
        return result;
    }

    private void updateDescriptorForTx(PTable table, Map<String, Object> tableProps, HTableDescriptor tableDescriptor, String txValue, Set<HTableDescriptor> descriptorsToUpdate, Set<HTableDescriptor> origDescriptors, Map<HTableDescriptor, HTableDescriptor> oldToNewTableDescriptors) throws SQLException {
        byte[] physicalTableName = table.getPhysicalName().getBytes();
        try (HBaseAdmin admin = this.getAdmin();){
            HTableDescriptor newIndexDescriptor;
            HTableDescriptor intermedIndexDesc;
            HashMap indexTableProps;
            this.setTransactional(tableDescriptor, table.getType(), txValue, tableProps);
            if (txValue == null) {
                indexTableProps = Collections.emptyMap();
            } else {
                indexTableProps = Maps.newHashMapWithExpectedSize((int)1);
                indexTableProps.put("data.tx.read.pre.existing", Boolean.valueOf(txValue));
                indexTableProps.put("TRANSACTION_PROVIDER", tableProps.get("TRANSACTION_PROVIDER"));
            }
            for (PTable index : table.getIndexes()) {
                HTableDescriptor origIndexDesc;
                HTableDescriptor intermedIndexDesc2 = origIndexDesc = admin.getTableDescriptor(TableName.valueOf((byte[])index.getPhysicalName().getBytes()));
                if (origDescriptors.contains(origIndexDesc)) {
                    intermedIndexDesc2 = oldToNewTableDescriptors.get(origIndexDesc);
                    descriptorsToUpdate.remove(intermedIndexDesc2);
                } else {
                    origDescriptors.add(origIndexDesc);
                }
                HTableDescriptor newIndexDescriptor2 = new HTableDescriptor(intermedIndexDesc2);
                if (index.getColumnFamilies().isEmpty()) {
                    byte[] dataFamilyName = SchemaUtil.getEmptyColumnFamily(table);
                    byte[] indexFamilyName = SchemaUtil.getEmptyColumnFamily(index);
                    HColumnDescriptor indexColDescriptor = newIndexDescriptor2.getFamily(indexFamilyName);
                    HColumnDescriptor tableColDescriptor = tableDescriptor.getFamily(dataFamilyName);
                    indexColDescriptor.setMaxVersions(tableColDescriptor.getMaxVersions());
                    indexColDescriptor.setValue("dataset.table.ttl", tableColDescriptor.getValue("dataset.table.ttl"));
                    newIndexDescriptor2.removeFamily(indexFamilyName);
                    newIndexDescriptor2.addFamily(indexColDescriptor);
                } else {
                    for (PColumnFamily family : index.getColumnFamilies()) {
                        byte[] familyName = family.getName().getBytes();
                        HColumnDescriptor indexColDescriptor = newIndexDescriptor2.getFamily(familyName);
                        HColumnDescriptor tableColDescriptor = tableDescriptor.getFamily(familyName);
                        indexColDescriptor.setMaxVersions(tableColDescriptor.getMaxVersions());
                        indexColDescriptor.setValue(Bytes.toBytes((String)"dataset.table.ttl"), tableColDescriptor.getValue(Bytes.toBytes((String)"dataset.table.ttl")));
                        newIndexDescriptor2.removeFamily(familyName);
                        newIndexDescriptor2.addFamily(indexColDescriptor);
                    }
                }
                this.setTransactional(newIndexDescriptor2, index.getType(), txValue, indexTableProps);
                descriptorsToUpdate.add(newIndexDescriptor2);
            }
            try {
                HTableDescriptor origIndexDesc;
                intermedIndexDesc = origIndexDesc = admin.getTableDescriptor(TableName.valueOf((byte[])MetaDataUtil.getViewIndexPhysicalName(physicalTableName)));
                if (origDescriptors.contains(origIndexDesc)) {
                    intermedIndexDesc = oldToNewTableDescriptors.get(origIndexDesc);
                    descriptorsToUpdate.remove(intermedIndexDesc);
                } else {
                    origDescriptors.add(origIndexDesc);
                }
                newIndexDescriptor = new HTableDescriptor(intermedIndexDesc);
                this.setSharedIndexMaxVersion(table, tableDescriptor, newIndexDescriptor);
                this.setTransactional(newIndexDescriptor, PTableType.INDEX, txValue, indexTableProps);
                descriptorsToUpdate.add(newIndexDescriptor);
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException origIndexDesc) {
                // empty catch block
            }
            try {
                intermedIndexDesc = origIndexDesc = admin.getTableDescriptor(TableName.valueOf((byte[])MetaDataUtil.getLocalIndexPhysicalName(physicalTableName)));
                if (origDescriptors.contains(origIndexDesc)) {
                    intermedIndexDesc = oldToNewTableDescriptors.get(origIndexDesc);
                    descriptorsToUpdate.remove(intermedIndexDesc);
                } else {
                    origDescriptors.add(origIndexDesc);
                }
                newIndexDescriptor = new HTableDescriptor(intermedIndexDesc);
                this.setSharedIndexMaxVersion(table, tableDescriptor, newIndexDescriptor);
                this.setTransactional(newIndexDescriptor, PTableType.INDEX, txValue, indexTableProps);
                descriptorsToUpdate.add(newIndexDescriptor);
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    private void setSharedIndexMaxVersion(PTable table, HTableDescriptor tableDescriptor, HTableDescriptor indexDescriptor) {
        if (table.getColumnFamilies().isEmpty()) {
            byte[] familyName = SchemaUtil.getEmptyColumnFamily(table);
            HColumnDescriptor indexColDescriptor = indexDescriptor.getFamily(familyName);
            HColumnDescriptor tableColDescriptor = tableDescriptor.getFamily(familyName);
            indexColDescriptor.setMaxVersions(tableColDescriptor.getMaxVersions());
            indexColDescriptor.setValue("dataset.table.ttl", tableColDescriptor.getValue("dataset.table.ttl"));
        } else {
            for (PColumnFamily family : table.getColumnFamilies()) {
                byte[] familyName = family.getName().getBytes();
                HColumnDescriptor indexColDescriptor = indexDescriptor.getFamily(familyName);
                if (indexColDescriptor == null) continue;
                HColumnDescriptor tableColDescriptor = tableDescriptor.getFamily(familyName);
                indexColDescriptor.setMaxVersions(tableColDescriptor.getMaxVersions());
                indexColDescriptor.setValue("dataset.table.ttl", tableColDescriptor.getValue("dataset.table.ttl"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHBaseMetaData(Set<HTableDescriptor> tableDescriptors, boolean pollingNeeded) throws SQLException {
        SQLException sqlE = null;
        for (HTableDescriptor descriptor : tableDescriptors) {
            try {
                this.modifyTable(descriptor.getName(), descriptor, pollingNeeded);
            }
            catch (IOException e) {
                sqlE = ServerUtil.parseServerException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
            }
            catch (TimeoutException e) {
                sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.OPERATION_TIMED_OUT).setRootCause(e.getCause() != null ? e.getCause() : e).build().buildException();
            }
            finally {
                if (sqlE == null) continue;
                throw sqlE;
            }
        }
    }

    private void setTransactional(HTableDescriptor tableDescriptor, PTableType tableType, String txValue, Map<String, Object> tableProps) throws SQLException {
        if (txValue == null) {
            tableDescriptor.remove("data.tx.read.pre.existing");
        } else {
            tableDescriptor.setValue("data.tx.read.pre.existing", txValue);
        }
        this.addCoprocessors(tableDescriptor.getName(), tableDescriptor, tableType, tableProps, tableDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    private Map<HTableDescriptor, HTableDescriptor> separateAndValidateProperties(PTable table, Map<String, List<Pair<String, Object>>> properties, Set<String> colFamiliesForPColumnsToBeAdded, Map<String, Object> tableProps) throws SQLException {
        void var18_27;
        boolean isAddingPkColOnly;
        HashMap stmtFamiliesPropsMap = new HashMap(properties.size());
        Map<String, Iterator<PColumnFamily>> commonFamilyProps = new HashMap();
        boolean addingColumns = colFamiliesForPColumnsToBeAdded != null && !colFamiliesForPColumnsToBeAdded.isEmpty();
        HashSet<String> existingColumnFamilies = this.existingColumnFamilies(table);
        HashMap<String, Map<String, Object>> allFamiliesProps = new HashMap<String, Map<String, Object>>(existingColumnFamilies.size());
        boolean isTransactional = table.isTransactional();
        boolean willBeTransactional = false;
        boolean isOrWillBeTransactional = isTransactional;
        Integer newTTL = null;
        Integer newReplicationScope = null;
        KeepDeletedCells newKeepDeletedCells = null;
        TransactionFactory.Provider txProvider = null;
        for (String string : properties.keySet()) {
            List<Pair<String, Object>> propsList = properties.get(string);
            if (propsList == null || propsList.size() <= 0) continue;
            HashMap<String, Iterator<PColumnFamily>> colFamilyPropsMap = new HashMap<String, Iterator<PColumnFamily>>(propsList.size());
            for (Pair<String, Object> pair : propsList) {
                String string2 = (String)pair.getFirst();
                Iterator<PColumnFamily> propValue = pair.getSecond();
                if ((MetaDataUtil.isHTableProperty(string2) || TableProperty.isPhoenixTableProperty(string2)) && addingColumns) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_TABLE_PROPERTY_ADD_COLUMN).setMessage("Property: " + string2).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).build().buildException();
                }
                if (MetaDataUtil.isHTableProperty(string2)) {
                    if (!string.equals("")) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_TABLE_PROPERTY).setMessage("Column Family: " + string + ", Property: " + string2).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).build().buildException();
                    }
                    tableProps.put(string2, propValue);
                    continue;
                }
                if (TableProperty.isPhoenixTableProperty(string2)) {
                    TableProperty tableProperty = TableProperty.valueOf(string2);
                    tableProperty.validate(true, !string.equals(""), table.getType());
                    if (string2.equals("TTL")) {
                        if (table.getType() == PTableType.INDEX) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_OR_ALTER_PROPERTY_FOR_INDEX).setMessage("Property: " + string2).build().buildException();
                        }
                        newTTL = ((Number)((Object)propValue)).intValue();
                        commonFamilyProps.put(string2, propValue);
                        continue;
                    }
                    if (string2.equals("TRANSACTIONAL") && Boolean.TRUE.equals(propValue)) {
                        isOrWillBeTransactional = true;
                        willBeTransactional = true;
                        tableProps.put("data.tx.read.pre.existing", propValue);
                        continue;
                    }
                    if (!string2.equals("TRANSACTION_PROVIDER") || propValue == null) continue;
                    isOrWillBeTransactional = true;
                    willBeTransactional = true;
                    tableProps.put("data.tx.read.pre.existing", Boolean.TRUE);
                    txProvider = (TransactionFactory.Provider)((Object)TableProperty.TRANSACTION_PROVIDER.getValue(propValue));
                    tableProps.put("TRANSACTION_PROVIDER", (Object)txProvider);
                    continue;
                }
                if (MetaDataUtil.isHColumnProperty(string2)) {
                    if (table.getType() == PTableType.INDEX && MetaDataUtil.propertyNotAllowedToBeOutOfSync(string2)) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_OR_ALTER_PROPERTY_FOR_INDEX).setMessage("Property: " + string2).build().buildException();
                    }
                    if (string.equals("")) {
                        if (string2.equals("KEEP_DELETED_CELLS")) {
                            KeepDeletedCells keepDeletedCells = newKeepDeletedCells = Boolean.valueOf(propValue.toString()) != false ? KeepDeletedCells.TRUE : KeepDeletedCells.FALSE;
                        }
                        if (string2.equals("REPLICATION_SCOPE")) {
                            newReplicationScope = ((Number)((Object)propValue)).intValue();
                        }
                        commonFamilyProps.put(string2, propValue);
                        continue;
                    }
                    if (MetaDataUtil.propertyNotAllowedToBeOutOfSync(string2)) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.COLUMN_FAMILY_NOT_ALLOWED_FOR_PROPERTY).setMessage("Property: " + string2).build().buildException();
                    }
                    colFamilyPropsMap.put(string2, propValue);
                    continue;
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ALTER_PROPERTY).setMessage("Column Family: " + string + ", Property: " + string2).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).build().buildException();
            }
            if (isOrWillBeTransactional && newTTL != null) {
                TransactionFactory.Provider isOrWillBeTransactionProvider;
                TransactionFactory.Provider provider = isOrWillBeTransactionProvider = txProvider == null ? table.getTransactionProvider() : txProvider;
                if (isOrWillBeTransactionProvider.getTransactionProvider().isUnsupported(PhoenixTransactionProvider.Feature.SET_TTL)) {
                    throw new SQLExceptionInfo.Builder(PhoenixTransactionProvider.Feature.SET_TTL.getCode()).setMessage(isOrWillBeTransactionProvider.name()).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).build().buildException();
                }
            }
            if (colFamilyPropsMap.isEmpty()) continue;
            stmtFamiliesPropsMap.put(string, colFamilyPropsMap);
        }
        commonFamilyProps = Collections.unmodifiableMap(commonFamilyProps);
        boolean bl = isAddingPkColOnly = colFamiliesForPColumnsToBeAdded.size() == 1 && colFamiliesForPColumnsToBeAdded.contains(null);
        if (!commonFamilyProps.isEmpty()) {
            HashMap<String, Iterator<PColumnFamily>> m;
            if (!addingColumns) {
                for (String existingColFamily : existingColumnFamilies) {
                    m = new HashMap<String, Iterator<PColumnFamily>>(commonFamilyProps.size());
                    m.putAll(commonFamilyProps);
                    allFamiliesProps.put(existingColFamily, m);
                }
            } else {
                for (String colFamily : colFamiliesForPColumnsToBeAdded) {
                    if (colFamily != null) {
                        m = new HashMap(commonFamilyProps.size());
                        m.putAll(commonFamilyProps);
                        allFamiliesProps.put(colFamily, m);
                        continue;
                    }
                    if (!isAddingPkColOnly) continue;
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.SET_UNSUPPORTED_PROP_ON_ALTER_TABLE).build().buildException();
                }
            }
        }
        for (String f : stmtFamiliesPropsMap.keySet()) {
            if (!addingColumns && !existingColumnFamilies.contains(f)) {
                String schemaNameStr = table.getSchemaName() == null ? null : table.getSchemaName().getString();
                String tableNameStr = table.getTableName() == null ? null : table.getTableName().getString();
                throw new ColumnFamilyNotFoundException(schemaNameStr, tableNameStr, f);
            }
            if (addingColumns && !colFamiliesForPColumnsToBeAdded.contains(f)) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_SET_PROPERTY_FOR_COLUMN_NOT_ADDED).build().buildException();
            }
            Map commonProps = (Map)allFamiliesProps.get(f);
            Map stmtProps = (Map)stmtFamiliesPropsMap.get(f);
            if (commonProps != null) {
                if (stmtProps == null) continue;
                commonProps.putAll(stmtProps);
                continue;
            }
            if (stmtProps == null) continue;
            allFamiliesProps.put(f, stmtProps);
        }
        for (String cf : colFamiliesForPColumnsToBeAdded) {
            if (cf == null || allFamiliesProps.get(cf) != null) continue;
            allFamiliesProps.put(cf, new HashMap());
        }
        if (table.getColumnFamilies().isEmpty() && !addingColumns && !commonFamilyProps.isEmpty()) {
            allFamiliesProps.put(Bytes.toString((byte[])(table.getDefaultFamilyName() == null ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES : table.getDefaultFamilyName().getBytes())), commonFamilyProps);
        }
        if (!(table.getType() != PTableType.VIEW || stmtFamiliesPropsMap.isEmpty() && commonFamilyProps.isEmpty() && tableProps.isEmpty())) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.VIEW_WITH_PROPERTIES).build().buildException();
        }
        Object var18_25 = null;
        HTableDescriptor origTableDescriptor = null;
        HashMap tableAndIndexDescriptorMappings = Collections.emptyMap();
        if (!allFamiliesProps.isEmpty() || !tableProps.isEmpty()) {
            void var22_39;
            tableAndIndexDescriptorMappings = Maps.newHashMapWithExpectedSize((int)(3 + table.getIndexes().size()));
            HTableDescriptor existingTableDescriptor = origTableDescriptor = this.getTableDescriptor(table.getPhysicalName().getBytes());
            HTableDescriptor hTableDescriptor = new HTableDescriptor(existingTableDescriptor);
            if (!tableProps.isEmpty()) {
                for (Map.Entry<String, Object> entry : tableProps.entrySet()) {
                    hTableDescriptor.setValue(entry.getKey(), entry.getValue() != null ? entry.getValue().toString() : null);
                }
            }
            if (addingColumns) {
                this.setSyncedPropsForNewColumnFamilies(allFamiliesProps, table, hTableDescriptor, newTTL, newKeepDeletedCells, newReplicationScope);
            }
            if (newTTL != null || newKeepDeletedCells != null || newReplicationScope != null) {
                this.setSyncedPropsForUnreferencedColumnFamilies(this.getTableDescriptor(table.getPhysicalName().getBytes()), allFamiliesProps, newTTL, newKeepDeletedCells, newReplicationScope);
            }
            Object var22_34 = null;
            if (isOrWillBeTransactional) {
                int ttl;
                void var22_36;
                Map map = (Map)allFamiliesProps.get(SchemaUtil.getEmptyColumnFamilyAsString(table));
                if (map != null) {
                    Integer n = (Integer)map.get("VERSIONS");
                }
                if (var22_36 == null) {
                    if (isTransactional) {
                        Integer n = hTableDescriptor.getFamily(SchemaUtil.getEmptyColumnFamily(table)).getMaxVersions();
                    } else {
                        Integer n = this.getProps().getInt("phoenix.transactions.maxVersions", Integer.MAX_VALUE);
                    }
                }
                if (willBeTransactional) {
                    for (PColumnFamily pColumnFamily : table.getColumnFamilies()) {
                        if (allFamiliesProps.containsKey(pColumnFamily.getName().getString())) continue;
                        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)1);
                        hashMap.put("VERSIONS", var22_39);
                        allFamiliesProps.put(pColumnFamily.getName().getString(), hashMap);
                    }
                }
                if ((ttl = ConnectionQueryServicesImpl.getTTL(table, hTableDescriptor, newTTL)) != Integer.MAX_VALUE) {
                    for (Map.Entry entry : allFamiliesProps.entrySet()) {
                        Map props = (HashMap<String, Integer>)entry.getValue();
                        if (props == null) {
                            allFamiliesProps.put((String)entry.getKey(), new HashMap());
                            props = (Map)allFamiliesProps.get(entry.getKey());
                        } else {
                            props = new HashMap<String, Integer>(props);
                        }
                        props.put("dataset.table.ttl", ttl);
                        if (!willBeTransactional && !Boolean.valueOf(hTableDescriptor.getValue("data.tx.read.pre.existing")).booleanValue()) {
                            props.remove("TTL");
                        }
                        entry.setValue(props);
                    }
                }
            }
            for (Map.Entry entry : allFamiliesProps.entrySet()) {
                byte[] byArray;
                HColumnDescriptor colDescriptor;
                Map map = (Map)entry.getValue();
                if (isOrWillBeTransactional && !map.containsKey("VERSIONS")) {
                    map.put("VERSIONS", var22_39);
                }
                if ((colDescriptor = hTableDescriptor.getFamily(byArray = Bytes.toBytes((String)((String)entry.getKey())))) == null) {
                    colDescriptor = this.generateColumnFamilyDescriptor((Pair<byte[], Map<String, Object>>)new Pair((Object)byArray, (Object)map), table.getType());
                    hTableDescriptor.addFamily(colDescriptor);
                } else {
                    this.modifyColumnFamilyDescriptor(colDescriptor, map);
                    hTableDescriptor.removeFamily(byArray);
                    hTableDescriptor.addFamily(colDescriptor);
                }
                if (!isOrWillBeTransactional) continue;
                this.checkTransactionalVersionsValue(colDescriptor);
            }
        }
        if (origTableDescriptor != null && var18_27 != null) {
            tableAndIndexDescriptorMappings.put(origTableDescriptor, var18_27);
        }
        Map<String, Object> applyPropsToAllIndexColFams = this.getNewSyncedPropsMap(newTTL, newKeepDeletedCells, newReplicationScope);
        this.setSyncedPropertiesForTableIndexes(table, tableAndIndexDescriptorMappings, applyPropsToAllIndexColFams);
        return tableAndIndexDescriptorMappings;
    }

    private void checkTransactionalVersionsValue(HColumnDescriptor colDescriptor) throws SQLException {
        int maxVersions = colDescriptor.getMaxVersions();
        if (maxVersions <= 1) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TX_MAX_VERSIONS_MUST_BE_GREATER_THAN_ONE).setFamilyName(colDescriptor.getNameAsString()).build().buildException();
        }
    }

    private HashSet<String> existingColumnFamiliesForBaseTable(PName baseTableName) throws TableNotFoundException {
        this.throwConnectionClosedIfNullMetaData();
        PTable table = this.latestMetaData.getTableRef(new PTableKey(null, baseTableName.getString())).getTable();
        return this.existingColumnFamilies(table);
    }

    public HashSet<String> existingColumnFamilies(PTable table) {
        List<PColumnFamily> cfs = table.getColumnFamilies();
        HashSet<String> cfNames = new HashSet<String>(cfs.size());
        for (PColumnFamily cf : table.getColumnFamilies()) {
            cfNames.add(cf.getName().getString());
        }
        return cfNames;
    }

    public static int getTTL(PTable table, HTableDescriptor tableDesc, Integer newTTL) throws SQLException {
        int ttl = newTTL != null ? newTTL.intValue() : tableDesc.getFamily(SchemaUtil.getEmptyColumnFamily(table)).getTimeToLive();
        return ttl;
    }

    public static KeepDeletedCells getKeepDeletedCells(PTable table, HTableDescriptor tableDesc, KeepDeletedCells newKeepDeletedCells) throws SQLException {
        return newKeepDeletedCells != null ? newKeepDeletedCells : tableDesc.getFamily(SchemaUtil.getEmptyColumnFamily(table)).getKeepDeletedCells();
    }

    public static int getReplicationScope(PTable table, HTableDescriptor tableDesc, Integer newReplicationScope) throws SQLException {
        return newReplicationScope != null ? newReplicationScope.intValue() : tableDesc.getFamily(SchemaUtil.getEmptyColumnFamily(table)).getScope();
    }

    private void setSyncedPropsForNewColumnFamilies(Map<String, Map<String, Object>> allFamiliesProps, PTable table, HTableDescriptor tableDesc, Integer newTTL, KeepDeletedCells newKeepDeletedCells, Integer newReplicationScope) throws SQLException {
        if (!allFamiliesProps.isEmpty()) {
            int ttl = ConnectionQueryServicesImpl.getTTL(table, tableDesc, newTTL);
            int replicationScope = ConnectionQueryServicesImpl.getReplicationScope(table, tableDesc, newReplicationScope);
            KeepDeletedCells keepDeletedCells = ConnectionQueryServicesImpl.getKeepDeletedCells(table, tableDesc, newKeepDeletedCells);
            for (Map.Entry<String, Map<String, Object>> entry : allFamiliesProps.entrySet()) {
                Map<String, Object> props = entry.getValue();
                if (props == null) {
                    allFamiliesProps.put(entry.getKey(), new HashMap());
                    props = allFamiliesProps.get(entry.getKey());
                }
                props.put("TTL", ttl);
                props.put("KEEP_DELETED_CELLS", keepDeletedCells);
                props.put("REPLICATION_SCOPE", replicationScope);
            }
        }
    }

    private void setPropIfNotNull(Map<String, Object> propMap, String propName, Object propVal) {
        if (propName != null && propVal != null) {
            propMap.put(propName, propVal);
        }
    }

    private Map<String, Object> getNewSyncedPropsMap(Integer newTTL, KeepDeletedCells newKeepDeletedCells, Integer newReplicationScope) {
        HashMap newSyncedProps = Maps.newHashMapWithExpectedSize((int)3);
        this.setPropIfNotNull(newSyncedProps, "TTL", newTTL);
        this.setPropIfNotNull(newSyncedProps, "KEEP_DELETED_CELLS", newKeepDeletedCells);
        this.setPropIfNotNull(newSyncedProps, "REPLICATION_SCOPE", newReplicationScope);
        return newSyncedProps;
    }

    private void setSyncedPropsForUnreferencedColumnFamilies(HTableDescriptor tableDesc, Map<String, Map<String, Object>> allFamiliesProps, Integer newTTL, KeepDeletedCells newKeepDeletedCells, Integer newReplicationScope) {
        for (HColumnDescriptor family : tableDesc.getColumnFamilies()) {
            if (allFamiliesProps.containsKey(family.getNameAsString())) continue;
            allFamiliesProps.put(family.getNameAsString(), this.getNewSyncedPropsMap(newTTL, newKeepDeletedCells, newReplicationScope));
        }
    }

    private void setSyncedPropertiesForTableIndexes(PTable table, Map<HTableDescriptor, HTableDescriptor> tableAndIndexDescriptorMappings, Map<String, Object> applyPropsToAllIndexesDefaultCF) throws SQLException {
        if (applyPropsToAllIndexesDefaultCF == null || applyPropsToAllIndexesDefaultCF.isEmpty()) {
            return;
        }
        for (PTable indexTable : table.getIndexes()) {
            if (indexTable.getIndexType() == PTable.IndexType.LOCAL) continue;
            HTableDescriptor origIndexDescriptor = this.getTableDescriptor(indexTable.getPhysicalName().getBytes());
            HTableDescriptor newIndexDescriptor = new HTableDescriptor(origIndexDescriptor);
            byte[] defaultIndexColFam = SchemaUtil.getEmptyColumnFamily(indexTable);
            HColumnDescriptor indexDefaultColDescriptor = new HColumnDescriptor(origIndexDescriptor.getFamily(defaultIndexColFam));
            this.modifyColumnFamilyDescriptor(indexDefaultColDescriptor, applyPropsToAllIndexesDefaultCF);
            newIndexDescriptor.removeFamily(defaultIndexColFam);
            newIndexDescriptor.addFamily(indexDefaultColDescriptor);
            tableAndIndexDescriptorMappings.put(origIndexDescriptor, newIndexDescriptor);
        }
        String viewIndexName = MetaDataUtil.getViewIndexPhysicalName(table.getPhysicalName().getString());
        if (!Strings.isNullOrEmpty((String)viewIndexName)) {
            try {
                HTableDescriptor origViewIndexTableDescriptor = this.getTableDescriptor(Bytes.toBytes((String)viewIndexName));
                HTableDescriptor newViewIndexDescriptor = new HTableDescriptor(origViewIndexTableDescriptor);
                for (HColumnDescriptor cfd : origViewIndexTableDescriptor.getColumnFamilies()) {
                    HColumnDescriptor newCfd = new HColumnDescriptor(cfd);
                    this.modifyColumnFamilyDescriptor(newCfd, applyPropsToAllIndexesDefaultCF);
                    newViewIndexDescriptor.removeFamily(cfd.getName());
                    newViewIndexDescriptor.addFamily(newCfd);
                }
                tableAndIndexDescriptorMappings.put(origViewIndexTableDescriptor, newViewIndexDescriptor);
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropColumn(final List<Mutation> tableMetaData, PTableType tableType, final PTable parentTable) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        SchemaUtil.getVarChars(tableMetaData.get(0).getRow(), rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] schemaBytes = rowKeyMetadata[1];
        byte[] tableBytes = rowKeyMetadata[2];
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.DropColumnRequest.Builder builder = MetaDataProtos.DropColumnRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setClientVersion(VersionUtil.encodeVersion(4, 16, 0));
                if (parentTable != null) {
                    builder.setParentTable(PTableImpl.toProto(parentTable));
                }
                instance.dropColumn((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
        MetaDataProtocol.MutationCode code = result.getMutationCode();
        switch (code) {
            case TABLE_ALREADY_EXISTS: {
                ReadOnlyProps props = this.getProps();
                boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                if (dropMetadata) {
                    this.dropTables(result.getTableNamesToDelete());
                    break;
                }
                this.invalidateTableStats(result.getTableNamesToDelete());
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhoenixConnection removeNotNullConstraint(PhoenixConnection oldMetaConnection, String schemaName, String tableName, long timestamp, String columnName) throws SQLException {
        PhoenixConnection metaConnection;
        block16: {
            Properties props = PropertiesUtil.deepCopy(oldMetaConnection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(timestamp));
            metaConnection = new PhoenixConnection(oldMetaConnection, this, props);
            SQLException sqlE = null;
            try {
                String dml = "UPSERT INTO " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " (" + "TENANT_ID" + "," + "TABLE_SCHEM" + "," + "TABLE_NAME" + "," + "COLUMN_NAME" + "," + "NULLABLE" + ") VALUES (null, ?, ?, ?, ?)";
                PreparedStatement stmt = metaConnection.prepareStatement(dml);
                stmt.setString(1, schemaName);
                stmt.setString(2, tableName);
                stmt.setString(3, columnName);
                stmt.setInt(4, 1);
                stmt.executeUpdate();
                metaConnection.commit();
            }
            catch (NewerTableAlreadyExistsException e) {
                LOGGER.warn("Table already modified at this timestamp, so assuming column already nullable: " + columnName);
            }
            catch (SQLException e) {
                LOGGER.warn("Add column failed due to:" + e);
                sqlE = e;
                return sqlE;
            }
            finally {
                try {
                    oldMetaConnection.close();
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    }
                    sqlE = e;
                }
                if (sqlE == null) break block16;
                throw sqlE;
            }
        }
        return metaConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhoenixConnection addColumn(PhoenixConnection oldMetaConnection, String tableName, long timestamp, String columns, boolean addIfNotExists) throws SQLException {
        PhoenixConnection metaConnection;
        block16: {
            Properties props = PropertiesUtil.deepCopy(oldMetaConnection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(timestamp));
            metaConnection = new PhoenixConnection(oldMetaConnection, this, props);
            SQLException sqlE = null;
            try {
                metaConnection.createStatement().executeUpdate("ALTER TABLE " + tableName + " ADD " + (addIfNotExists ? " IF NOT EXISTS " : "") + columns);
            }
            catch (NewerTableAlreadyExistsException e) {
                LOGGER.warn("Table already modified at this timestamp, so assuming add of these columns already done: " + columns);
            }
            catch (SQLException e) {
                LOGGER.warn("Add column failed due to:" + e);
                sqlE = e;
                return sqlE;
            }
            finally {
                try {
                    oldMetaConnection.close();
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    }
                    sqlE = e;
                }
                if (sqlE == null) break block16;
                throw sqlE;
            }
        }
        return metaConnection;
    }

    private PhoenixConnection addColumnsIfNotExists(PhoenixConnection oldMetaConnection, String tableName, long timestamp, String columns) throws SQLException {
        return this.addColumn(oldMetaConnection, tableName, timestamp, columns, true);
    }

    protected long getSystemTableVersion() {
        return 33L;
    }

    protected void setUpgradeRequired() {
        this.upgradeRequired.set(true);
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean isInitialized) {
        this.initialized = isInitialized;
    }

    protected String getSystemCatalogTableDDL() {
        return this.setSystemDDLProperties(QueryConstants.CREATE_TABLE_METADATA);
    }

    protected String getSystemSequenceTableDDL(int nSaltBuckets) {
        String schema = String.format(this.setSystemDDLProperties(QueryConstants.CREATE_SEQUENCE_METADATA), new Object[0]);
        return Sequence.getCreateTableStatement(schema, nSaltBuckets);
    }

    protected String getFunctionTableDDL() {
        return this.setSystemDDLProperties(QueryConstants.CREATE_FUNCTION_METADATA);
    }

    protected String getLogTableDDL() {
        return this.setSystemLogDDLProperties(QueryConstants.CREATE_LOG_METADATA);
    }

    private String setSystemLogDDLProperties(String ddl) {
        return String.format(ddl, this.props.getInt("phoenix.log.saltBuckets", 32));
    }

    protected String getChildLinkDDL() {
        return this.setSystemDDLProperties(QueryConstants.CREATE_CHILD_LINK_METADATA);
    }

    protected String getMutexDDL() {
        return this.setSystemDDLProperties(QueryConstants.CREATE_MUTEX_METADATA);
    }

    protected String getTaskDDL() {
        return this.setSystemDDLProperties(QueryConstants.CREATE_TASK_METADATA);
    }

    private String setSystemDDLProperties(String ddl) {
        return String.format(ddl, this.props.getInt("phoenix.system.default.max.versions", 1), this.props.getBoolean("phoenix.system.default.keep.deleted.cells", false));
    }

    @Override
    public void init(final String url, final Properties props) throws SQLException {
        try {
            PhoenixContextExecutor.call(new Callable<Void>(){

                /*
                 * Exception decompiling
                 */
                @Override
                public Void call() throws Exception {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, SQLException.class);
            Throwables.propagate((Throwable)e);
        }
    }

    void createSysMutexTableIfNotExists(HBaseAdmin admin) throws IOException {
        try {
            if (this.checkIfSysMutexExistsAndModifyTTLIfRequired(admin)) {
                return;
            }
            TableName mutexTableName = SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_MUTEX_NAME, this.getProps());
            HTableDescriptor tableDesc = new HTableDescriptor(mutexTableName);
            HColumnDescriptor columnDesc = new HColumnDescriptor(PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES);
            columnDesc.setTimeToLive(900);
            tableDesc.addFamily(columnDesc);
            admin.createTable(tableDesc);
        }
        catch (IOException e) {
            if (this.inspectIfAnyExceptionInChain(e, Arrays.asList(AccessDeniedException.class, TableExistsException.class))) {
                LOGGER.debug("Ignoring exception while creating mutex table during connection initialization: " + Throwables.getStackTraceAsString((Throwable)e));
            }
            throw e;
        }
    }

    @VisibleForTesting
    boolean checkIfSysMutexExistsAndModifyTTLIfRequired(HBaseAdmin admin) throws IOException {
        HTableDescriptor htd;
        try {
            htd = admin.getTableDescriptor(Bytes.toBytes((String)PhoenixDatabaseMetaData.SYSTEM_MUTEX_NAME));
        }
        catch (org.apache.hadoop.hbase.TableNotFoundException ignored) {
            try {
                htd = admin.getTableDescriptor(TableName.valueOf((String)"SYSTEM", (String)"MUTEX"));
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException ignored2) {
                return false;
            }
        }
        if (htd.getFamily(PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES).getTimeToLive() != 900) {
            LOGGER.debug("SYSTEM MUTEX already appears to exist, but has the wrong TTL. Will modify the TTL");
            HColumnDescriptor hColFamDesc = htd.removeFamily(PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES);
            hColFamDesc.setTimeToLive(900);
            htd.addFamily(hColFamDesc);
            admin.modifyTable(htd.getTableName(), htd);
        } else {
            LOGGER.debug("SYSTEM MUTEX already appears to exist with the correct TTL, not creating it");
        }
        return true;
    }

    private boolean inspectIfAnyExceptionInChain(Throwable io, List<Class<? extends Exception>> ioList) {
        boolean exceptionToIgnore = false;
        for (Throwable t : Throwables.getCausalChain((Throwable)io)) {
            for (Class<? extends Exception> exception : ioList) {
                exceptionToIgnore |= this.isExceptionInstanceOf(t, exception);
            }
            if (!exceptionToIgnore) continue;
            break;
        }
        return exceptionToIgnore;
    }

    private boolean isExceptionInstanceOf(Throwable io, Class<? extends Exception> exception) {
        return exception.isInstance(io) || io instanceof RemoteException && ((RemoteException)io).getClassName().equals(exception.getName());
    }

    List<TableName> getSystemTableNamesInDefaultNamespace(HBaseAdmin admin) throws IOException {
        return Lists.newArrayList((Object[])admin.listTableNames("SYSTEM\\..*"));
    }

    private void createOtherSystemTables(PhoenixConnection metaConnection) throws SQLException, IOException {
        try {
            this.nSequenceSaltBuckets = this.props.getInt("phoenix.sequence.saltBuckets", 0);
            metaConnection.createStatement().execute(this.getSystemSequenceTableDDL(this.nSequenceSaltBuckets));
        }
        catch (TableAlreadyExistsException e) {
            this.nSequenceSaltBuckets = ConnectionQueryServicesImpl.getSaltBuckets(e);
        }
        try {
            metaConnection.createStatement().execute(QueryConstants.CREATE_STATS_TABLE_METADATA);
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        try {
            metaConnection.createStatement().execute(this.getFunctionTableDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        try {
            metaConnection.createStatement().execute(this.getLogTableDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        try {
            metaConnection.createStatement().executeUpdate(this.getChildLinkDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        try {
            metaConnection.createStatement().executeUpdate(this.getMutexDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        try {
            metaConnection.createStatement().executeUpdate(this.getTaskDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
    }

    private void createSchemaIfNotExistsSystemNSMappingEnabled(PhoenixConnection metaConnection) throws SQLException {
        block4: {
            if (SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, this.getProps())) {
                try {
                    metaConnection.createStatement().execute("CREATE SCHEMA IF NOT EXISTS SYSTEM");
                }
                catch (NewerSchemaAlreadyExistsException newerSchemaAlreadyExistsException) {
                }
                catch (PhoenixIOException e) {
                    if (!Iterables.isEmpty((Iterable)Iterables.filter((Iterable)Throwables.getCausalChain((Throwable)e), AccessDeniedException.class))) break block4;
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PhoenixConnection upgradeSystemCatalogIfRequired(PhoenixConnection metaConnection, long currentServerSideTableTimeStamp) throws SQLException, IOException, TimeoutException, InterruptedException {
        String columnsToAdd = "";
        if (currentServerSideTableTimeStamp < 7L) {
            columnsToAdd = this.addColumn(columnsToAdd, "STORE_NULLS " + PBoolean.INSTANCE.getSqlTypeName());
            try (HBaseAdmin admin = this.getAdmin();){
                HTableDescriptor[] localIndexTables;
                for (HTableDescriptor table : localIndexTables = admin.listTables("_LOCAL_IDX_.*")) {
                    if (table.getValue("PARENT_TABLE") != null || table.getValue("IS_LOCAL_INDEX_TABLE") == null) continue;
                    table.setValue("PARENT_TABLE", MetaDataUtil.getLocalIndexUserTableName(table.getNameAsString()));
                    admin.disableTable(table.getTableName());
                    admin.modifyTable(table.getTableName(), table);
                    admin.enableTable(table.getTableName());
                }
            }
        }
        if (currentServerSideTableTimeStamp < 3L) {
            columnsToAdd = this.addColumn(columnsToAdd, "INDEX_TYPE " + PUnsignedTinyint.INSTANCE.getSqlTypeName() + ", " + "INDEX_DISABLE_TIMESTAMP" + " " + PLong.INSTANCE.getSqlTypeName());
        }
        if (!columnsToAdd.isEmpty()) {
            PhoenixConnection newMetaConnection;
            metaConnection = newMetaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 7L, columnsToAdd);
        }
        if (currentServerSideTableTimeStamp < 8L) {
            columnsToAdd = "BASE_COLUMN_COUNT " + PInteger.INSTANCE.getSqlTypeName();
            try {
                metaConnection = this.addColumn(metaConnection, "SYSTEM.\"CATALOG\"", 8L, columnsToAdd, false);
                UpgradeUtil.upgradeTo4_5_0(metaConnection);
            }
            catch (ColumnAlreadyExistsException ignored) {
                LOGGER.debug("No need to run 4.5 upgrade");
            }
            Properties p = PropertiesUtil.deepCopy(metaConnection.getClientInfo());
            p.remove("CurrentSCN");
            p.remove("TenantId");
            try (PhoenixConnection conn = new PhoenixConnection(this, metaConnection.getURL(), p, metaConnection.getMetaDataCache());){
                List<String> unsupportedTables;
                List<String> tablesNeedingUpgrade = UpgradeUtil.getPhysicalTablesWithDescRowKey(conn);
                if (!tablesNeedingUpgrade.isEmpty()) {
                    LOGGER.warn("The following tables require upgrade due to a bug causing the row key to be incorrect for descending columns and ascending BINARY columns (PHOENIX-2067 and PHOENIX-2120):\n" + Joiner.on((char)' ').join(tablesNeedingUpgrade) + "\nTo upgrade issue the \"bin/psql.py -u\" command.");
                }
                if (!(unsupportedTables = UpgradeUtil.getPhysicalTablesWithDescVarbinaryRowKey(conn)).isEmpty()) {
                    LOGGER.warn("The following tables use an unsupported VARBINARY DESC construct and need to be changed:\n" + Joiner.on((char)' ').join(unsupportedTables));
                }
            }
        }
        if (currentServerSideTableTimeStamp < 9L) {
            columnsToAdd = "IS_ROW_TIMESTAMP " + PBoolean.INSTANCE.getSqlTypeName();
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 9L, columnsToAdd);
        }
        if (currentServerSideTableTimeStamp < 15L) {
            metaConnection = this.dropStatsTable(metaConnection, 11L);
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 12L, "TRANSACTIONAL " + PBoolean.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 13L, "UPDATE_CACHE_FREQUENCY " + PLong.INSTANCE.getSqlTypeName());
            metaConnection = this.setImmutableTableIndexesImmutable(metaConnection, 14L);
            metaConnection = this.updateSystemCatalogTimestamp(metaConnection, 15L);
            this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, 15L);
            this.clearCache();
        }
        if (currentServerSideTableTimeStamp < 18L) {
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 16L, "IS_NAMESPACE_MAPPED " + PBoolean.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 17L, "AUTO_PARTITION_SEQ " + PVarchar.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 18L, "APPEND_ONLY_SCHEMA " + PBoolean.INSTANCE.getSqlTypeName());
            metaConnection = UpgradeUtil.disableViewIndexes(metaConnection);
            if (this.getProps().getBoolean("phoenix.client.localIndexUpgrade", true)) {
                metaConnection = UpgradeUtil.upgradeLocalIndexes(metaConnection);
            }
            this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, 18L);
            this.clearCache();
        }
        if (currentServerSideTableTimeStamp < 20L) {
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 20L, "GUIDE_POSTS_WIDTH " + PLong.INSTANCE.getSqlTypeName());
            this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, 20L);
            this.clearCache();
        }
        if (currentServerSideTableTimeStamp < 25L) {
            metaConnection = this.addColumnQualifierColumn(metaConnection, 22L);
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 23L, "IMMUTABLE_STORAGE_SCHEME " + PTinyint.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 24L, "ENCODING_SCHEME " + PTinyint.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 25L, "QUALIFIER_COUNTER " + PInteger.INSTANCE.getSqlTypeName());
            this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, 25L);
            this.clearCache();
        }
        if (currentServerSideTableTimeStamp < 27L) {
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 27L, "USE_STATS_FOR_PARALLELIZATION " + PBoolean.INSTANCE.getSqlTypeName());
            UpgradeUtil.addParentToChildLinks(metaConnection);
        }
        if (currentServerSideTableTimeStamp < 28L) {
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 28L, "TRANSACTION_PROVIDER " + PTinyint.INSTANCE.getSqlTypeName());
            metaConnection.createStatement().executeUpdate("ALTER TABLE SYSTEM.\"CATALOG\" SET VERSIONS= " + this.props.getInt("phoenix.system.default.max.versions", 1) + ",\n" + "KEEP_DELETED_CELLS" + "=" + this.props.getBoolean("phoenix.system.default.keep.deleted.cells", false));
            metaConnection.createStatement().executeUpdate("ALTER TABLE SYSTEM.\"FUNCTION\" SET SPLIT_POLICY='" + SystemFunctionSplitPolicy.class.getName() + "',\n" + "VERSIONS" + "= " + this.props.getInt("phoenix.system.default.max.versions", 1) + ",\n" + "KEEP_DELETED_CELLS" + "=" + this.props.getBoolean("phoenix.system.default.keep.deleted.cells", false));
            metaConnection.createStatement().executeUpdate("ALTER TABLE " + PhoenixDatabaseMetaData.SYSTEM_STATS_NAME + " SET " + "SPLIT_POLICY" + "='" + SystemStatsSplitPolicy.class.getName() + "'");
        }
        if (currentServerSideTableTimeStamp < 29L) {
            UpgradeUtil.addViewIndexToParentLinks(metaConnection);
        }
        if (currentServerSideTableTimeStamp < 29L) {
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 29L, "VIEW_INDEX_ID_DATA_TYPE " + PInteger.INSTANCE.getSqlTypeName());
        }
        if (currentServerSideTableTimeStamp < 33L) {
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 30L, "PHOENIX_TTL " + PInteger.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 31L, "PHOENIX_TTL_HWM " + PInteger.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 32L, "LAST_DDL_TIMESTAMP " + PLong.INSTANCE.getSqlTypeName());
            metaConnection = this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 33L, "CHANGE_DETECTION_ENABLED " + PBoolean.INSTANCE.getSqlTypeName());
            UpgradeUtil.bootstrapLastDDLTimestamp(metaConnection);
            boolean isNamespaceMapping = SchemaUtil.isNamespaceMappingEnabled(null, this.getConfiguration());
            String tableName = PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME;
            if (isNamespaceMapping) {
                tableName = tableName.replace(".", ":");
            }
            byte[] tableBytes = StringUtil.toBytes(tableName);
            byte[] rowKey = SchemaUtil.getColumnKey(null, "SYSTEM", "CATALOG", "VIEW_INDEX_ID", "0");
            if (UpgradeUtil.isUpdateViewIndexIdColumnDataTypeFromShortToLongNeeded(metaConnection, rowKey, tableBytes)) {
                LOGGER.info("Updating VIEW_INDEX_ID data type to BIGINT.");
                UpgradeUtil.updateViewIndexIdColumnDataTypeFromShortToLong(metaConnection, rowKey, tableBytes);
            } else {
                LOGGER.info("Updating VIEW_INDEX_ID data type is not needed.");
            }
            try (HBaseAdmin admin = metaConnection.getQueryServices().getAdmin();){
                TableName syscatPhysicalTableName = SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, this.props);
                HTableDescriptor htd = admin.getTableDescriptor(syscatPhysicalTableName);
                if (!htd.hasCoprocessor(SystemCatalogRegionObserver.class.getName())) {
                    int priority = this.props.getInt("phoenix.coprocessor.priority", 0x2FFFFFFE);
                    htd.addCoprocessor(SystemCatalogRegionObserver.class.getName(), null, priority, null);
                    admin.modifyTable(syscatPhysicalTableName, htd);
                    this.pollForUpdatedTableDescriptor(admin, htd, syscatPhysicalTableName.getName());
                }
            }
        }
        return metaConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void upgradeSystemTables(String url, Properties props) throws SQLException {
        PhoenixConnection metaConnection = null;
        boolean success = false;
        HashMap<String, String> systemTableToSnapshotMap = new HashMap<String, String>();
        String sysCatalogTableName = null;
        SQLException toThrow = null;
        boolean acquiredMutexLock = false;
        boolean moveChildLinks = false;
        boolean syncAllTableAndIndexProps = false;
        try {
            block82: {
                if (!this.isUpgradeRequired()) {
                    throw new UpgradeNotRequiredException();
                }
                Properties scnProps = PropertiesUtil.deepCopy(props);
                scnProps.setProperty("CurrentSCN", Long.toString(33L));
                scnProps.remove("TenantId");
                String globalUrl = JDBCUtil.removeProperty(url, "TenantId");
                metaConnection = new PhoenixConnection(this, globalUrl, scnProps, this.newEmptyMetaData());
                metaConnection.setRunningUpgrade(true);
                try (HBaseAdmin admin2 = this.getAdmin();){
                    this.createSysMutexTableIfNotExists(admin2);
                }
                try {
                    metaConnection.createStatement().executeUpdate(this.getSystemCatalogTableDDL());
                }
                catch (NewerTableAlreadyExistsException admin2) {
                }
                catch (UpgradeRequiredException e) {
                    long currentServerSideTableTimeStamp = e.getSystemCatalogTimeStamp();
                    if (currentServerSideTableTimeStamp < 29L) {
                        moveChildLinks = true;
                    }
                    sysCatalogTableName = SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getNameAsString();
                    if (SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, this.getProps())) {
                        String snapshotName = null;
                        acquiredMutexLock = this.acquireUpgradeMutex(0L);
                        if (acquiredMutexLock) {
                            LOGGER.debug("Acquired lock in SYSMUTEX table for migrating SYSTEM tables to SYSTEM namespace and/or upgrading " + sysCatalogTableName);
                            snapshotName = UpgradeUtil.getSysTableSnapshotName(currentServerSideTableTimeStamp, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME);
                            this.createSnapshot(snapshotName, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME);
                            systemTableToSnapshotMap.put(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, snapshotName);
                            LOGGER.info("Created snapshot {} for {}", (Object)snapshotName, (Object)PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME);
                        }
                        this.ensureSystemTablesMigratedToSystemNamespace();
                        LOGGER.debug("Migrated SYSTEM tables to SYSTEM namespace");
                        if (snapshotName != null) {
                            this.deleteSnapshot(snapshotName);
                        } else {
                            snapshotName = UpgradeUtil.getSysTableSnapshotName(currentServerSideTableTimeStamp, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME);
                        }
                        systemTableToSnapshotMap.remove(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME);
                        this.createSnapshot(snapshotName, sysCatalogTableName);
                        systemTableToSnapshotMap.put(sysCatalogTableName, snapshotName);
                        LOGGER.info("Created snapshot {} for {}", (Object)snapshotName, (Object)sysCatalogTableName);
                        metaConnection = this.upgradeSystemCatalogIfRequired(metaConnection, currentServerSideTableTimeStamp);
                    }
                }
                catch (TableAlreadyExistsException e) {
                    long currentServerSideTableTimeStamp = e.getTable().getTimeStamp();
                    sysCatalogTableName = e.getTable().getPhysicalName().getString();
                    if (currentServerSideTableTimeStamp < 33L && (acquiredMutexLock = this.acquireUpgradeMutex(currentServerSideTableTimeStamp))) {
                        LOGGER.debug("Acquired lock in SYSMUTEX table for upgrading " + sysCatalogTableName);
                        this.takeSnapshotOfSysTable(systemTableToSnapshotMap, e);
                    }
                    metaConnection = this.upgradeSystemCatalogIfRequired(metaConnection, currentServerSideTableTimeStamp);
                    if (currentServerSideTableTimeStamp < 29L) {
                        moveChildLinks = true;
                        syncAllTableAndIndexProps = true;
                    }
                    if (currentServerSideTableTimeStamp >= 33L) break block82;
                    try (PhoenixConnection conn = new PhoenixConnection(this, globalUrl, props, this.newEmptyMetaData());){
                        UpgradeUtil.mergeViewIndexIdSequences(metaConnection);
                    }
                    catch (Exception mergeViewIndeIdException) {
                        LOGGER.warn("Merge view index id sequence failed! If possible, please run MergeViewIndexIdSequencesTool to avoid view indexid collision. Error: " + mergeViewIndeIdException.getMessage());
                    }
                }
            }
            metaConnection = this.upgradeOtherSystemTablesIfRequired(metaConnection, moveChildLinks, systemTableToSnapshotMap);
            if (syncAllTableAndIndexProps) {
                UpgradeUtil.syncTableAndIndexProperties(metaConnection);
            }
            this.createSchemaIfNotExistsSystemNSMappingEnabled(metaConnection);
            this.clearUpgradeRequired();
            success = true;
            return;
        }
        catch (UpgradeInProgressException | UpgradeNotRequiredException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                toThrow = (SQLException)e;
            }
            toThrow = new SQLException(e);
        }
        finally {
            try {
                if (metaConnection != null) {
                    metaConnection.close();
                }
            }
            catch (SQLException e) {
                if (toThrow != null) {
                    toThrow.setNextException(e);
                }
                toThrow = e;
            }
            finally {
                if (!success) {
                    LOGGER.warn("Failed upgrading System tables. Snapshots for system tables created so far: " + systemTableToSnapshotMap);
                }
                if (acquiredMutexLock) {
                    try {
                        this.releaseUpgradeMutex();
                    }
                    catch (IOException e) {
                        LOGGER.warn("Release of upgrade mutex failed ", (Throwable)e);
                    }
                }
                if (toThrow == null) return;
                throw toThrow;
            }
        }
    }

    private PhoenixConnection upgradeOtherSystemTablesIfRequired(PhoenixConnection metaConnection, boolean moveChildLinks, Map<String, String> systemTableToSnapshotMap) throws SQLException, IOException {
        metaConnection = this.upgradeSystemChildLink(metaConnection, moveChildLinks, systemTableToSnapshotMap);
        metaConnection = this.upgradeSystemSequence(metaConnection, systemTableToSnapshotMap);
        metaConnection = this.upgradeSystemStats(metaConnection, systemTableToSnapshotMap);
        metaConnection = this.upgradeSystemTask(metaConnection, systemTableToSnapshotMap);
        metaConnection = this.upgradeSystemFunction(metaConnection);
        metaConnection = this.upgradeSystemLog(metaConnection);
        return this.upgradeSystemMutex(metaConnection);
    }

    private PhoenixConnection upgradeSystemChildLink(PhoenixConnection metaConnection, boolean moveChildLinks, Map<String, String> systemTableToSnapshotMap) throws SQLException {
        try (Statement statement = metaConnection.createStatement();){
            statement.executeUpdate(this.getChildLinkDDL());
        }
        catch (TableAlreadyExistsException e) {
            this.takeSnapshotOfSysTable(systemTableToSnapshotMap, e);
        }
        if (moveChildLinks) {
            UpgradeUtil.moveChildLinks(metaConnection);
        }
        return metaConnection;
    }

    private PhoenixConnection upgradeSystemSequence(PhoenixConnection metaConnection, Map<String, String> systemTableToSnapshotMap) throws SQLException {
        int nSaltBuckets = this.props.getInt("phoenix.sequence.saltBuckets", 0);
        try (Statement statement = metaConnection.createStatement();){
            String createSequenceTable = this.getSystemSequenceTableDDL(nSaltBuckets);
            statement.executeUpdate(createSequenceTable);
            this.nSequenceSaltBuckets = nSaltBuckets;
        }
        catch (NewerTableAlreadyExistsException e) {
            this.nSequenceSaltBuckets = ConnectionQueryServicesImpl.getSaltBuckets(e);
        }
        catch (TableAlreadyExistsException e) {
            this.takeSnapshotOfSysTable(systemTableToSnapshotMap, e);
            long currentServerSideTableTimeStamp = e.getTable().getTimeStamp();
            if (currentServerSideTableTimeStamp < 3L) {
                String columnsToAdd = "MIN_VALUE " + PLong.INSTANCE.getSqlTypeName() + ", " + "MAX_VALUE" + " " + PLong.INSTANCE.getSqlTypeName() + ", " + "CYCLE_FLAG" + " " + PBoolean.INSTANCE.getSqlTypeName() + ", " + "LIMIT_REACHED_FLAG" + " " + PBoolean.INSTANCE.getSqlTypeName();
                this.addColumnsIfNotExists(metaConnection, "SYSTEM.\"CATALOG\"", 33L, columnsToAdd);
            }
            if (currentServerSideTableTimeStamp < 5L) {
                if (UpgradeUtil.upgradeSequenceTable(metaConnection, nSaltBuckets, e.getTable())) {
                    metaConnection.removeTable(null, "SYSTEM", "SEQUENCE", 33L);
                    this.clearTableFromCache(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_SCHEMA_BYTES, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_TABLE_BYTES, 33L);
                    this.clearTableRegionCache(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES);
                }
                this.nSequenceSaltBuckets = nSaltBuckets;
            }
            this.nSequenceSaltBuckets = ConnectionQueryServicesImpl.getSaltBuckets(e);
        }
        return metaConnection;
    }

    private void takeSnapshotOfSysTable(Map<String, String> systemTableToSnapshotMap, TableAlreadyExistsException e) throws SQLException {
        String tableName;
        long currentServerSideTableTimeStamp = e.getTable().getTimeStamp();
        String snapshotName = UpgradeUtil.getSysTableSnapshotName(currentServerSideTableTimeStamp, tableName = e.getTable().getPhysicalName().getString());
        if (snapshotName.contains(":")) {
            snapshotName = snapshotName.replace(":", ".");
        }
        this.createSnapshot(snapshotName, tableName);
        systemTableToSnapshotMap.put(tableName, snapshotName);
        LOGGER.info("Snapshot {} created for table {}", (Object)snapshotName, (Object)tableName);
    }

    private PhoenixConnection upgradeSystemStats(PhoenixConnection metaConnection, Map<String, String> systemTableToSnapshotMap) throws SQLException {
        block16: {
            try (Statement statement2 = metaConnection.createStatement();){
                statement2.executeUpdate(QueryConstants.CREATE_STATS_TABLE_METADATA);
            }
            catch (NewerTableAlreadyExistsException statement2) {
            }
            catch (TableAlreadyExistsException e) {
                this.takeSnapshotOfSysTable(systemTableToSnapshotMap, e);
                long currentServerSideTableTimeStamp = e.getTable().getTimeStamp();
                if (currentServerSideTableTimeStamp < 7L) {
                    metaConnection = this.addColumnsIfNotExists(metaConnection, PhoenixDatabaseMetaData.SYSTEM_STATS_NAME, 33L, "GUIDE_POSTS_ROW_COUNT " + PLong.INSTANCE.getSqlTypeName());
                }
                if (currentServerSideTableTimeStamp >= 20L) break block16;
                metaConnection = this.removeNotNullConstraint(metaConnection, "SYSTEM", "STATS", 20L, "COLUMN_FAMILY");
                this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_STATS_NAME, null, 20L);
                this.clearCache();
            }
        }
        return metaConnection;
    }

    private PhoenixConnection upgradeSystemTask(PhoenixConnection metaConnection, Map<String, String> systemTableToSnapshotMap) throws SQLException, IOException {
        try (Statement statement2 = metaConnection.createStatement();){
            statement2.executeUpdate(this.getTaskDDL());
        }
        catch (NewerTableAlreadyExistsException statement2) {
        }
        catch (TableAlreadyExistsException e) {
            this.takeSnapshotOfSysTable(systemTableToSnapshotMap, e);
            long currentServerSideTableTimeStamp = e.getTable().getTimeStamp();
            if (currentServerSideTableTimeStamp <= 29L) {
                String columnsToAdd = "TASK_STATUS " + PVarchar.INSTANCE.getSqlTypeName() + ", " + "TASK_END_TS" + " " + PTimestamp.INSTANCE.getSqlTypeName() + ", " + "TASK_PRIORITY" + " " + PUnsignedTinyint.INSTANCE.getSqlTypeName() + ", " + "TASK_DATA" + " " + PVarchar.INSTANCE.getSqlTypeName();
                String taskTableFullName = SchemaUtil.getTableName("SYSTEM", "TASK");
                metaConnection = this.addColumnsIfNotExists(metaConnection, taskTableFullName, 33L, columnsToAdd);
                try (Statement statement3 = metaConnection.createStatement();){
                    String setTtlQuery = String.format(ALTER_TABLE_SET_PROPS, taskTableFullName, "TTL", "864000");
                    statement3.executeUpdate(setTtlQuery);
                }
                this.clearCache();
            }
            try (HBaseAdmin admin = metaConnection.getQueryServices().getAdmin();){
                TableName tableName = SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_TASK_NAME, this.props);
                HTableDescriptor td = admin.getTableDescriptor(tableName);
                boolean isTableDescUpdated = false;
                if (this.updateAndConfirmSplitPolicyForTask(td)) {
                    isTableDescUpdated = true;
                }
                if (!td.hasCoprocessor(TaskMetaDataEndpoint.class.getName())) {
                    int priority = this.props.getInt("phoenix.coprocessor.priority", 0x2FFFFFFE);
                    td.addCoprocessor(TaskMetaDataEndpoint.class.getName(), null, priority, null);
                    isTableDescUpdated = true;
                }
                if (isTableDescUpdated) {
                    admin.modifyTable(tableName, td);
                    this.pollForUpdatedTableDescriptor(admin, td, tableName.getName());
                }
            }
            catch (InterruptedException | TimeoutException ite) {
                throw new SQLException(PhoenixDatabaseMetaData.SYSTEM_TASK_NAME + " Upgrade is not confirmed");
            }
        }
        return metaConnection;
    }

    private PhoenixConnection upgradeSystemFunction(PhoenixConnection metaConnection) throws SQLException {
        try {
            metaConnection.createStatement().executeUpdate(this.getFunctionTableDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        return metaConnection;
    }

    private PhoenixConnection upgradeSystemLog(PhoenixConnection metaConnection) throws SQLException {
        try {
            metaConnection.createStatement().executeUpdate(this.getLogTableDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        return metaConnection;
    }

    private PhoenixConnection upgradeSystemMutex(PhoenixConnection metaConnection) throws SQLException {
        try {
            metaConnection.createStatement().executeUpdate(this.getMutexDDL());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
        return metaConnection;
    }

    private PhoenixConnection addColumnQualifierColumn(PhoenixConnection oldMetaConnection, Long timestamp) throws SQLException {
        Properties props = PropertiesUtil.deepCopy(oldMetaConnection.getClientInfo());
        props.setProperty("CurrentSCN", Long.toString(timestamp));
        PhoenixConnection metaConnection = new PhoenixConnection(oldMetaConnection, this, props);
        metaConnection.setAutoCommit(false);
        PTable sysCatalogPTable = metaConnection.getTable(new PTableKey(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME));
        int numColumns = sysCatalogPTable.getColumns().size();
        try (PreparedStatement mutateTable = metaConnection.prepareStatement("UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,TABLE_TYPE,TABLE_SEQ_NUM,COLUMN_COUNT) VALUES (?, ?, ?, ?, ?, ?)");){
            mutateTable.setString(1, null);
            mutateTable.setString(2, "SYSTEM");
            mutateTable.setString(3, "CATALOG");
            mutateTable.setString(4, PTableType.SYSTEM.getSerializedValue());
            mutateTable.setLong(5, sysCatalogPTable.getSequenceNumber() + 1L);
            mutateTable.setInt(6, numColumns + 1);
            mutateTable.execute();
        }
        ArrayList<Mutation> tableMetadata = new ArrayList<Mutation>((Collection)metaConnection.getMutationState().toMutations(metaConnection.getSCN()).next().getSecond());
        metaConnection.rollback();
        PColumnImpl column = new PColumnImpl(PNameFactory.newName("COLUMN_QUALIFIER"), PNameFactory.newName("DEFAULT_COLUMN_FAMILY"), PVarbinary.INSTANCE, null, null, true, numColumns, SortOrder.ASC, null, null, false, null, false, false, Bytes.toBytes((String)"COLUMN_QUALIFIER"), timestamp);
        String upsertColumnMetadata = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,NULLABLE,COLUMN_SIZE,DECIMAL_DIGITS,ORDINAL_POSITION,SORT_ORDER,DATA_TABLE_NAME,ARRAY_SIZE,VIEW_CONSTANT,IS_VIEW_REFERENCED,PK_NAME,KEY_SEQ,COLUMN_DEF,IS_ROW_TIMESTAMP) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement colUpsert = metaConnection.prepareStatement(upsertColumnMetadata);){
            colUpsert.setString(1, null);
            colUpsert.setString(2, "SYSTEM");
            colUpsert.setString(3, "CATALOG");
            colUpsert.setString(4, "COLUMN_QUALIFIER");
            colUpsert.setString(5, "0");
            colUpsert.setInt(6, column.getDataType().getSqlType());
            colUpsert.setInt(7, 1);
            colUpsert.setNull(8, 4);
            colUpsert.setNull(9, 4);
            colUpsert.setInt(10, sysCatalogPTable.getBucketNum() != null ? numColumns : numColumns + 1);
            colUpsert.setInt(11, SortOrder.ASC.getSystemValue());
            colUpsert.setString(12, null);
            colUpsert.setNull(13, 4);
            colUpsert.setBytes(14, null);
            colUpsert.setBoolean(15, false);
            colUpsert.setString(16, sysCatalogPTable.getPKName() == null ? null : sysCatalogPTable.getPKName().getString());
            colUpsert.setNull(17, 5);
            colUpsert.setNull(18, 12);
            colUpsert.setBoolean(19, false);
            colUpsert.execute();
        }
        tableMetadata.addAll((Collection)metaConnection.getMutationState().toMutations(metaConnection.getSCN()).next().getSecond());
        metaConnection.rollback();
        metaConnection.getQueryServices().addColumn(tableMetadata, sysCatalogPTable, null, Collections.emptyMap(), Collections.emptySet(), Lists.newArrayList((Object[])new PColumn[]{column}));
        metaConnection.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, timestamp);
        this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, timestamp);
        this.clearCache();
        return metaConnection;
    }

    private void deleteSnapshot(String snapshotName) throws SQLException, IOException {
        try (HBaseAdmin admin = this.getAdmin();){
            admin.deleteSnapshot(snapshotName);
            LOGGER.info("Snapshot {} is deleted", (Object)snapshotName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSnapshot(String snapshotName, String tableName) throws SQLException {
        HBaseAdmin admin = null;
        SQLException sqlE = null;
        try {
            admin = this.getAdmin();
            admin.snapshot(snapshotName, tableName);
            LOGGER.info("Successfully created snapshot " + snapshotName + " for " + tableName);
            return;
        }
        catch (Exception e) {
            sqlE = new SQLException(e);
        }
        finally {
            try {
                if (admin != null) {
                    admin.close();
                }
            }
            catch (Exception e) {
                SQLException adminCloseEx = new SQLException(e);
                if (sqlE == null) {
                    sqlE = adminCloseEx;
                }
                sqlE.setNextException(adminCloseEx);
            }
            finally {
                if (sqlE == null) return;
                throw sqlE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureSystemTablesMigratedToSystemNamespace() throws SQLException, IOException, IllegalArgumentException, InterruptedException {
        if (!SchemaUtil.isNamespaceMappingEnabled(PTableType.SYSTEM, this.getProps())) {
            return;
        }
        try (HTableInterface metatable = null;
             HBaseAdmin admin = this.getAdmin();){
            List<TableName> tableNames = this.getSystemTableNamesInDefaultNamespace(admin);
            if (tableNames.size() == 0) {
                return;
            }
            if (tableNames.size() > 8) {
                LOGGER.warn("Expected 8 system tables but found " + tableNames.size() + ":" + tableNames);
            }
            byte[] mappedSystemTable = SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getName();
            metatable = this.getTable(mappedSystemTable);
            if (tableNames.contains(PhoenixDatabaseMetaData.SYSTEM_CATALOG_HBASE_TABLE_NAME)) {
                if (!admin.tableExists(mappedSystemTable)) {
                    LOGGER.info("Migrating SYSTEM.CATALOG table to SYSTEM namespace.");
                    UpgradeUtil.mapTableToNamespace(admin, (Table)metatable, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, this.getProps(), null, PTableType.SYSTEM, null);
                    this.removeTable(null, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME, null, 3L);
                }
                tableNames.remove(PhoenixDatabaseMetaData.SYSTEM_CATALOG_HBASE_TABLE_NAME);
            }
            for (TableName table : tableNames) {
                LOGGER.info(String.format("Migrating %s table to SYSTEM namespace.", table.getNameAsString()));
                UpgradeUtil.mapTableToNamespace(admin, (Table)metatable, table.getNameAsString(), this.getProps(), null, PTableType.SYSTEM, null);
                this.removeTable(null, table.getNameAsString(), null, 3L);
            }
            this.clearCache();
        }
    }

    @VisibleForTesting
    public boolean acquireUpgradeMutex(long currentServerSideTableTimestamp) throws SQLException {
        Preconditions.checkArgument((currentServerSideTableTimestamp < 33L ? 1 : 0) != 0);
        if (!this.writeMutexCell(null, "SYSTEM", "CATALOG", null, null)) {
            throw new UpgradeInProgressException(MetaDataProtocol.getVersion(currentServerSideTableTimestamp), MetaDataProtocol.getVersion(33L));
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean writeMutexCell(String tenantId, String schemaName, String tableName, String columnName, String familyName) throws SQLException {
        try {
            byte[] rowKey = columnName != null ? SchemaUtil.getColumnKey(tenantId, schemaName, tableName, columnName, familyName) : SchemaUtil.getTableKey(tenantId, schemaName, tableName);
            try (Table sysMutexTable = this.getSysMutexTable();){
                byte[] family = PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES;
                byte[] qualifier = PhoenixDatabaseMetaData.SYSTEM_MUTEX_COLUMN_NAME_BYTES;
                byte[] value = MUTEX_LOCKED;
                Put put = new Put(rowKey);
                put.addColumn(family, qualifier, value);
                boolean checkAndPut = sysMutexTable.checkAndPut(rowKey, family, qualifier, null, put);
                String processName = ManagementFactory.getRuntimeMXBean().getName();
                String msg = " tenantId : " + tenantId + " schemaName : " + schemaName + " tableName : " + tableName + " columnName : " + columnName + " familyName : " + familyName;
                if (!checkAndPut) {
                    LOGGER.error(processName + " failed to acquire mutex for " + msg);
                } else {
                    LOGGER.debug(processName + " acquired mutex for " + msg);
                }
                boolean bl = checkAndPut;
                return bl;
            }
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    @VisibleForTesting
    public void releaseUpgradeMutex() throws IOException, SQLException {
        this.deleteMutexCell(null, "SYSTEM", "CATALOG", null, null);
    }

    @Override
    public void deleteMutexCell(String tenantId, String schemaName, String tableName, String columnName, String familyName) throws SQLException {
        try {
            byte[] rowKey = columnName != null ? SchemaUtil.getColumnKey(tenantId, schemaName, tableName, columnName, familyName) : SchemaUtil.getTableKey(tenantId, schemaName, tableName);
            try (Table sysMutexTable = this.getSysMutexTable();){
                byte[] family = PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES;
                byte[] qualifier = PhoenixDatabaseMetaData.SYSTEM_MUTEX_COLUMN_NAME_BYTES;
                Delete delete = new Delete(rowKey);
                delete.addColumn(family, qualifier);
                sysMutexTable.delete(delete);
                String processName = ManagementFactory.getRuntimeMXBean().getName();
                String msg = " tenantId : " + tenantId + " schemaName : " + schemaName + " tableName : " + tableName + " columnName : " + columnName + " familyName : " + familyName;
                LOGGER.debug(processName + " released mutex for " + msg);
            }
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    @VisibleForTesting
    public Table getSysMutexTable() throws SQLException {
        Table table;
        String tableNameAsString = PhoenixDatabaseMetaData.SYSTEM_MUTEX_NAME;
        try {
            table = this.getTableIfExists(Bytes.toBytes((String)tableNameAsString));
        }
        catch (TableNotFoundException e) {
            tableNameAsString = tableNameAsString.replace(".", ":");
            table = this.getTable(Bytes.toBytes((String)tableNameAsString));
        }
        return table;
    }

    private String addColumn(String columnsToAddSoFar, String columns) {
        if (columnsToAddSoFar == null || columnsToAddSoFar.isEmpty()) {
            return columns;
        }
        return columnsToAddSoFar + ", " + columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhoenixConnection setImmutableTableIndexesImmutable(PhoenixConnection oldMetaConnection, long timestamp) throws SQLException {
        PhoenixConnection metaConnection;
        block12: {
            SQLException sqlE = null;
            Properties props = PropertiesUtil.deepCopy(oldMetaConnection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(timestamp));
            metaConnection = new PhoenixConnection(oldMetaConnection, this, props);
            boolean autoCommit = metaConnection.getAutoCommit();
            try {
                metaConnection.setAutoCommit(true);
                metaConnection.createStatement().execute("UPSERT INTO SYSTEM.CATALOG(TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY, IMMUTABLE_ROWS)\nSELECT A.TENANT_ID, A.TABLE_SCHEM,B.COLUMN_FAMILY,null,null,true\nFROM SYSTEM.CATALOG A JOIN SYSTEM.CATALOG B ON (\n A.TENANT_ID = B.TENANT_ID AND \n A.TABLE_SCHEM = B.TABLE_SCHEM AND\n A.TABLE_NAME = B.TABLE_NAME AND\n A.COLUMN_NAME = B.COLUMN_NAME AND\n B.LINK_TYPE = 1\n)\nWHERE A.COLUMN_FAMILY IS NULL AND\n B.COLUMN_FAMILY IS NOT NULL AND\n A.IMMUTABLE_ROWS = TRUE");
            }
            catch (SQLException e) {
                LOGGER.warn("exception during upgrading stats table:" + e);
                sqlE = e;
                return sqlE;
            }
            finally {
                try {
                    metaConnection.setAutoCommit(autoCommit);
                    oldMetaConnection.close();
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    }
                    sqlE = e;
                }
                if (sqlE == null) break block12;
                throw sqlE;
            }
        }
        return metaConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhoenixConnection updateSystemCatalogTimestamp(PhoenixConnection oldMetaConnection, long timestamp) throws SQLException {
        PhoenixConnection metaConnection;
        block12: {
            SQLException sqlE = null;
            Properties props = PropertiesUtil.deepCopy(oldMetaConnection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(timestamp));
            metaConnection = new PhoenixConnection(oldMetaConnection, this, props);
            boolean autoCommit = metaConnection.getAutoCommit();
            try {
                metaConnection.setAutoCommit(true);
                metaConnection.createStatement().execute("UPSERT INTO SYSTEM.CATALOG(TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY, DISABLE_WAL)\nVALUES (NULL, 'SYSTEM','CATALOG', NULL, NULL, FALSE)");
            }
            catch (SQLException e) {
                LOGGER.warn("exception during upgrading stats table:" + e);
                sqlE = e;
                return sqlE;
            }
            finally {
                try {
                    metaConnection.setAutoCommit(autoCommit);
                    oldMetaConnection.close();
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    }
                    sqlE = e;
                }
                if (sqlE == null) break block12;
                throw sqlE;
            }
        }
        return metaConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhoenixConnection dropStatsTable(PhoenixConnection oldMetaConnection, long timestamp) throws SQLException, IOException {
        PhoenixConnection metaConnection;
        block12: {
            Properties props = PropertiesUtil.deepCopy(oldMetaConnection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(timestamp));
            metaConnection = new PhoenixConnection(oldMetaConnection, this, props);
            SQLException sqlE = null;
            boolean wasCommit = metaConnection.getAutoCommit();
            try {
                metaConnection.setAutoCommit(true);
                metaConnection.createStatement().executeUpdate("DELETE FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE " + "TABLE_NAME" + "='" + "STATS" + "' AND " + "TABLE_SCHEM" + "='" + "SYSTEM" + "'");
            }
            catch (SQLException e) {
                LOGGER.warn("exception during upgrading stats table:" + e);
                sqlE = e;
                return sqlE;
            }
            finally {
                try {
                    metaConnection.setAutoCommit(wasCommit);
                    oldMetaConnection.close();
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    }
                    sqlE = e;
                }
                if (sqlE == null) break block12;
                throw sqlE;
            }
        }
        return metaConnection;
    }

    private void scheduleRenewLeaseTasks() {
        if (this.isRenewingLeasesEnabled()) {
            this.renewLeaseExecutor = Executors.newScheduledThreadPool(this.renewLeasePoolSize, renewLeaseThreadFactory);
            for (LinkedBlockingQueue<WeakReference<PhoenixConnection>> q : this.connectionQueues) {
                this.renewLeaseExecutor.scheduleAtFixedRate(new RenewLeaseTask(q), 0L, this.renewLeaseTaskFrequency, TimeUnit.MILLISECONDS);
            }
        }
    }

    private static int getSaltBuckets(TableAlreadyExistsException e) {
        PTable table = e.getTable();
        Integer sequenceSaltBuckets = table == null ? null : table.getBucketNum();
        return sequenceSaltBuckets == null ? 0 : sequenceSaltBuckets;
    }

    @Override
    public MutationState updateData(MutationPlan plan) throws SQLException {
        MutationState state2 = plan.execute();
        plan.getContext().getConnection().commit();
        return state2;
    }

    @Override
    public int getLowestClusterHBaseVersion() {
        return this.lowestClusterHBaseVersion;
    }

    @Override
    public boolean hasIndexWALCodec() {
        return this.hasIndexWALCodec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long clearCache() throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.latestMetaData = this.newEmptyMetaData();
        }
        this.tableStatsCache.invalidateAll();
        try (HTableInterface htable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getName());){
            Map results = htable.coprocessorService(MetaDataProtos.MetaDataService.class, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, (Batch.Call)new Batch.Call<MetaDataProtos.MetaDataService, Long>(){

                public Long call(MetaDataProtos.MetaDataService instance) throws IOException {
                    ServerRpcController controller = new ServerRpcController();
                    BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                    MetaDataProtos.ClearCacheRequest.Builder builder = MetaDataProtos.ClearCacheRequest.newBuilder();
                    builder.setClientVersion(VersionUtil.encodeVersion(4, 16, 0));
                    instance.clearCache((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.ClearCacheResponse>)rpcCallback);
                    if (controller.getFailedOn() != null) {
                        throw controller.getFailedOn();
                    }
                    return ((MetaDataProtos.ClearCacheResponse)rpcCallback.get()).getUnfreedBytes();
                }
            });
            long unfreedBytes = 0L;
            for (Map.Entry result : results.entrySet()) {
                if (result.getValue() == null) continue;
                unfreedBytes += ((Long)result.getValue()).longValue();
            }
            long l = unfreedBytes;
            return l;
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
    }

    private void flushTable(byte[] tableName) throws SQLException {
        HBaseAdmin admin = this.getAdmin();
        try {
            admin.flush(tableName);
        }
        catch (IOException e) {
            throw new PhoenixIOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
        }
        finally {
            Closeables.closeQuietly((Closeable)admin);
        }
    }

    @Override
    public HBaseAdmin getAdmin() throws SQLException {
        try {
            return new HBaseAdmin((Connection)this.connection);
        }
        catch (IOException e) {
            throw new PhoenixIOException(e);
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult updateIndexState(final List<Mutation> tableMetaData, String parentTableName) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        SchemaUtil.getVarChars(tableMetaData.get(0).getRow(), rowKeyMetadata);
        byte[] tableKey = SchemaUtil.getTableKey(rowKeyMetadata[0], rowKeyMetadata[1], rowKeyMetadata[2]);
        return this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.UpdateIndexStateRequest.Builder builder = MetaDataProtos.UpdateIndexStateRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setClientVersion(VersionUtil.encodeVersion(4, 16, 0));
                instance.updateIndexState((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult updateIndexState(List<Mutation> tableMetaData, String parentTableName, Map<String, List<Pair<String, Object>>> stmtProperties, PTable table) throws SQLException {
        if (stmtProperties == null) {
            return this.updateIndexState(tableMetaData, parentTableName);
        }
        Map<HTableDescriptor, HTableDescriptor> oldToNewTableDescriptors = this.separateAndValidateProperties(table, stmtProperties, new HashSet<String>(), new HashMap<String, Object>());
        HTableDescriptor origTableDescriptor = this.getTableDescriptor(table.getPhysicalName().getBytes());
        HTableDescriptor newTableDescriptor = oldToNewTableDescriptors.remove(origTableDescriptor);
        HashSet modifiedTableDescriptors = Collections.emptySet();
        if (newTableDescriptor != null) {
            modifiedTableDescriptors = Sets.newHashSetWithExpectedSize((int)(3 + table.getIndexes().size()));
            modifiedTableDescriptors.add(newTableDescriptor);
        }
        this.sendHBaseMetaData(modifiedTableDescriptors, true);
        return this.updateIndexState(tableMetaData, parentTableName);
    }

    /*
     * Loose catch block
     */
    @Override
    public long createSequence(String tenantId, String schemaName, String sequenceName, long startWith, long incrementBy, long cacheSize, long minValue, long maxValue, boolean cycle, long timestamp) throws SQLException {
        SequenceKey sequenceKey = new SequenceKey(tenantId, schemaName, sequenceName, this.nSequenceSaltBuckets);
        Sequence newSequences = new Sequence(sequenceKey);
        Sequence sequence = this.sequenceMap.putIfAbsent(sequenceKey, newSequences);
        if (sequence == null) {
            sequence = newSequences;
        }
        try {
            sequence.getLock().lock();
            Append append = sequence.createSequence(startWith, incrementBy, cacheSize, timestamp, minValue, maxValue, cycle);
            HTableInterface htable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, this.getProps()).getName());
            htable.setAutoFlush(true);
            try {
                Result result = htable.append(append);
                long l = sequence.createSequence(result, minValue, maxValue, cycle);
                return l;
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
            finally {
                Closeables.closeQuietly((Closeable)htable);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            sequence.getLock().unlock();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public long dropSequence(String tenantId, String schemaName, String sequenceName, long timestamp) throws SQLException {
        SequenceKey sequenceKey = new SequenceKey(tenantId, schemaName, sequenceName, this.nSequenceSaltBuckets);
        Sequence newSequences = new Sequence(sequenceKey);
        Sequence sequence = this.sequenceMap.putIfAbsent(sequenceKey, newSequences);
        if (sequence == null) {
            sequence = newSequences;
        }
        try {
            sequence.getLock().lock();
            Append append = sequence.dropSequence(timestamp);
            HTableInterface htable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, this.getProps()).getName());
            try {
                Result result = htable.append(append);
                long l = sequence.dropSequence(result);
                return l;
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
            finally {
                Closeables.closeQuietly((Closeable)htable);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            sequence.getLock().unlock();
        }
    }

    @Override
    public long currentSequenceValue(SequenceKey sequenceKey, long timestamp) throws SQLException {
        Sequence sequence = (Sequence)this.sequenceMap.get(sequenceKey);
        if (sequence == null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CALL_CURRENT_BEFORE_NEXT_VALUE).setSchemaName(sequenceKey.getSchemaName()).setTableName(sequenceKey.getSequenceName()).build().buildException();
        }
        sequence.getLock().lock();
        try {
            long l = sequence.currentValue(timestamp);
            return l;
        }
        catch (EmptySequenceCacheException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CALL_CURRENT_BEFORE_NEXT_VALUE).setSchemaName(sequenceKey.getSchemaName()).setTableName(sequenceKey.getSequenceName()).build().buildException();
        }
        finally {
            sequence.getLock().unlock();
        }
    }

    @Override
    public void validateSequences(List<SequenceAllocation> sequenceAllocations, long timestamp, long[] values, SQLException[] exceptions, Sequence.ValueOp action) throws SQLException {
        this.incrementSequenceValues(sequenceAllocations, timestamp, values, exceptions, action);
    }

    @Override
    public void incrementSequences(List<SequenceAllocation> sequenceAllocations, long timestamp, long[] values, SQLException[] exceptions) throws SQLException {
        this.incrementSequenceValues(sequenceAllocations, timestamp, values, exceptions, Sequence.ValueOp.INCREMENT_SEQUENCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementSequenceValues(List<SequenceAllocation> sequenceAllocations, long timestamp, long[] values, SQLException[] exceptions, Sequence.ValueOp op) throws SQLException {
        Sequence sequence4;
        ArrayList sequences = Lists.newArrayListWithExpectedSize((int)sequenceAllocations.size());
        for (SequenceAllocation sequenceAllocation : sequenceAllocations) {
            Sequence newSequences;
            SequenceKey key = sequenceAllocation.getSequenceKey();
            sequence4 = this.sequenceMap.putIfAbsent(key, newSequences = new Sequence(key));
            if (sequence4 == null) {
                sequence4 = newSequences;
            }
            sequences.add(sequence4);
        }
        try {
            Object[] resultObjects;
            ArrayList toIncrementList;
            ArrayList incrementBatch;
            block32: {
                for (Sequence sequence2 : sequences) {
                    sequence2.getLock().lock();
                }
                incrementBatch = Lists.newArrayListWithExpectedSize((int)sequences.size());
                toIncrementList = Lists.newArrayListWithExpectedSize((int)sequences.size());
                int[] indexes = new int[sequences.size()];
                for (int i = 0; i < sequences.size(); ++i) {
                    sequence4 = (Sequence)sequences.get(i);
                    try {
                        values[i] = sequence4.incrementValue(timestamp, op, sequenceAllocations.get(i).getNumAllocations());
                        continue;
                    }
                    catch (EmptySequenceCacheException e) {
                        indexes[toIncrementList.size()] = i;
                        toIncrementList.add(sequence4);
                        Increment inc = sequence4.newIncrement(timestamp, op, sequenceAllocations.get(i).getNumAllocations());
                        incrementBatch.add(inc);
                        continue;
                    }
                    catch (SQLException e) {
                        exceptions[i] = e;
                    }
                }
                if (toIncrementList.isEmpty()) {
                    return;
                }
                HTableInterface hTable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, this.getProps()).getName());
                resultObjects = null;
                SQLException sqlE = null;
                try {
                    resultObjects = hTable.batch((List)incrementBatch);
                }
                catch (IOException e) {
                    sqlE = ServerUtil.parseServerException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
                }
                finally {
                    try {
                        hTable.close();
                    }
                    catch (IOException e) {
                        if (sqlE == null) {
                            sqlE = ServerUtil.parseServerException(e);
                        }
                        sqlE.setNextException(ServerUtil.parseServerException(e));
                    }
                    if (sqlE == null) break block32;
                    throw sqlE;
                }
            }
            for (int i = 0; i < resultObjects.length; ++i) {
                Sequence sequence3 = (Sequence)toIncrementList.get(i);
                Result result = (Result)resultObjects[i];
                try {
                    long numToAllocate = Bytes.toLong((byte[])((Increment)incrementBatch.get(i)).getAttribute("NUM_TO_ALLOCATE"));
                    values[indexes[i]] = sequence3.incrementValue(result, op, numToAllocate);
                    continue;
                }
                catch (SQLException e) {
                    exceptions[indexes[i]] = e;
                }
            }
        }
        finally {
            for (Sequence sequence4 : sequences) {
                sequence4.getLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clearTableFromCache(final byte[] tenantId, final byte[] schemaName, final byte[] tableName, final long clientTS) throws SQLException {
        try {
            SQLException sqlE = null;
            HTableInterface htable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, this.getProps()).getName());
            try {
                htable.coprocessorService(MetaDataProtos.MetaDataService.class, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, (Batch.Call)new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.ClearTableFromCacheResponse>(){

                    public MetaDataProtos.ClearTableFromCacheResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                        ServerRpcController controller = new ServerRpcController();
                        BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                        MetaDataProtos.ClearTableFromCacheRequest.Builder builder = MetaDataProtos.ClearTableFromCacheRequest.newBuilder();
                        builder.setTenantId(ByteStringer.wrap((byte[])tenantId));
                        builder.setTableName(ByteStringer.wrap((byte[])tableName));
                        builder.setSchemaName(ByteStringer.wrap((byte[])schemaName));
                        builder.setClientTimestamp(clientTS);
                        builder.setClientVersion(VersionUtil.encodeVersion(4, 16, 0));
                        instance.clearTableFromCache((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.ClearTableFromCacheResponse>)rpcCallback);
                        if (controller.getFailedOn() != null) {
                            throw controller.getFailedOn();
                        }
                        return (MetaDataProtos.ClearTableFromCacheResponse)rpcCallback.get();
                    }
                });
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
            catch (Throwable e) {
                sqlE = new SQLException(e);
            }
            finally {
                try {
                    htable.close();
                }
                catch (IOException e) {
                    if (sqlE == null) {
                        sqlE = ServerUtil.parseServerException(e);
                    }
                    sqlE.setNextException(ServerUtil.parseServerException(e));
                }
                finally {
                    if (sqlE == null) return;
                    throw sqlE;
                }
            }
        }
        catch (Exception e) {
            throw new SQLException(ServerUtil.parseServerException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnSequences(List<SequenceKey> keys, long timestamp, SQLException[] exceptions) throws SQLException {
        ArrayList sequences = Lists.newArrayListWithExpectedSize((int)keys.size());
        for (SequenceKey key : keys) {
            Sequence newSequences;
            Sequence sequence = this.sequenceMap.putIfAbsent(key, newSequences = new Sequence(key));
            if (sequence == null) {
                sequence = newSequences;
            }
            sequences.add(sequence);
        }
        try {
            Object[] resultObjects;
            ArrayList toReturnList;
            block31: {
                for (Sequence sequence : sequences) {
                    sequence.getLock().lock();
                }
                ArrayList mutations = Lists.newArrayListWithExpectedSize((int)sequences.size());
                toReturnList = Lists.newArrayListWithExpectedSize((int)sequences.size());
                int[] indexes = new int[sequences.size()];
                for (int i = 0; i < sequences.size(); ++i) {
                    Sequence sequence = (Sequence)sequences.get(i);
                    try {
                        Append append = sequence.newReturn(timestamp);
                        toReturnList.add(sequence);
                        mutations.add(append);
                        continue;
                    }
                    catch (EmptySequenceCacheException append) {
                        // empty catch block
                    }
                }
                if (toReturnList.isEmpty()) {
                    return;
                }
                HTableInterface hTable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, this.getProps()).getName());
                resultObjects = null;
                SQLException sqlE = null;
                try {
                    resultObjects = hTable.batch((List)mutations);
                }
                catch (IOException e) {
                    sqlE = ServerUtil.parseServerException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
                }
                finally {
                    try {
                        hTable.close();
                    }
                    catch (IOException e) {
                        if (sqlE == null) {
                            sqlE = ServerUtil.parseServerException(e);
                        }
                        sqlE.setNextException(ServerUtil.parseServerException(e));
                    }
                    if (sqlE == null) break block31;
                    throw sqlE;
                }
            }
            for (int i = 0; i < resultObjects.length; ++i) {
                Sequence sequence = (Sequence)toReturnList.get(i);
                Result result = (Result)resultObjects[i];
                try {
                    sequence.returnValue(result);
                    continue;
                }
                catch (SQLException e) {
                    exceptions[indexes[i]] = e;
                }
            }
        }
        finally {
            for (Sequence sequence : sequences) {
                sequence.getLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnAllSequences(ConcurrentMap<SequenceKey, Sequence> sequenceMap) throws SQLException {
        block18: {
            ArrayList mutations = Lists.newArrayListWithExpectedSize((int)sequenceMap.size());
            for (Sequence sequence : sequenceMap.values()) {
                mutations.addAll(sequence.newReturns());
            }
            if (mutations.isEmpty()) {
                return;
            }
            HTableInterface hTable = this.getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, this.getProps()).getName());
            SQLException sqlE = null;
            try {
                hTable.batch((List)mutations);
            }
            catch (IOException e) {
                sqlE = ServerUtil.parseServerException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
            }
            finally {
                try {
                    hTable.close();
                }
                catch (IOException e) {
                    if (sqlE == null) {
                        sqlE = ServerUtil.parseServerException(e);
                    }
                    sqlE.setNextException(ServerUtil.parseServerException(e));
                }
                if (sqlE == null) break block18;
                throw sqlE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnection(PhoenixConnection connection) throws SQLException {
        if (this.returnSequenceValues || this.shouldThrottleNumConnections) {
            Object object = this.connectionCountLock;
            synchronized (object) {
                if (this.shouldThrottleNumConnections) {
                    int allowedConnections;
                    int futureConnections = 1 + (connection.isInternalConnection() ? this.internalConnectionCount : this.connectionCount);
                    int n = allowedConnections = connection.isInternalConnection() ? this.maxInternalConnectionsAllowed : this.maxConnectionsAllowed;
                    if (allowedConnections != 0 && futureConnections > allowedConnections) {
                        GlobalClientMetrics.GLOBAL_PHOENIX_CONNECTIONS_THROTTLED_COUNTER.increment();
                        if (connection.isInternalConnection()) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.NEW_INTERNAL_CONNECTION_THROTTLED).build().buildException();
                        }
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.NEW_CONNECTION_THROTTLED).build().buildException();
                    }
                }
                if (!connection.isInternalConnection()) {
                    ++this.connectionCount;
                } else {
                    ++this.internalConnectionCount;
                }
            }
        }
        if (this.isRenewingLeasesEnabled()) {
            this.connectionQueues.get(this.getQueueIndex(connection)).add(new WeakReference<PhoenixConnection>(connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnection(PhoenixConnection connection) throws SQLException {
        if (this.returnSequenceValues) {
            ConcurrentMap<SequenceKey, Sequence> formerSequenceMap = null;
            Object object = this.connectionCountLock;
            synchronized (object) {
                if (!connection.isInternalConnection() && this.connectionCount + this.internalConnectionCount - 1 <= 0 && !this.sequenceMap.isEmpty()) {
                    formerSequenceMap = this.sequenceMap;
                    this.sequenceMap = Maps.newConcurrentMap();
                }
            }
            if (formerSequenceMap != null) {
                this.returnAllSequences(formerSequenceMap);
            }
        }
        if (this.returnSequenceValues || this.shouldThrottleNumConnections) {
            Object object = this.connectionCountLock;
            synchronized (object) {
                if (connection.isInternalConnection() && this.internalConnectionCount > 0) {
                    --this.internalConnectionCount;
                } else if (this.connectionCount > 0) {
                    --this.connectionCount;
                }
            }
        }
    }

    private int getQueueIndex(PhoenixConnection conn) {
        return ThreadLocalRandom.current().nextInt(this.renewLeasePoolSize);
    }

    @Override
    public KeyValueBuilder getKeyValueBuilder() {
        return this.kvBuilder;
    }

    @Override
    public boolean supportsFeature(ConnectionQueryServices.Feature feature) {
        FeatureSupported supported = this.featureMap.get((Object)feature);
        if (supported == null) {
            return false;
        }
        return supported.isSupported(this);
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    private void checkClosed() {
        if (this.closed) {
            this.throwConnectionClosedException();
        }
    }

    private void throwConnectionClosedIfNullMetaData() {
        if (this.latestMetaData == null) {
            this.throwConnectionClosedException();
        }
    }

    private void throwConnectionClosedException() {
        throw new IllegalStateException("Connection to the cluster is closed");
    }

    @Override
    public GuidePostsInfo getTableStats(GuidePostsKey key) throws SQLException {
        try {
            return this.tableStatsCache.get(key);
        }
        catch (ExecutionException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    @Override
    public int getSequenceSaltBuckets() {
        return this.nSequenceSaltBuckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFunction(PFunction function) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            try {
                this.throwConnectionClosedIfNullMetaData();
                PFunction existingFunction = this.latestMetaData.getFunction(new PTableKey(function.getTenantId(), function.getFunctionName()));
                if (existingFunction.getTimeStamp() >= function.getTimeStamp()) {
                    return;
                }
            }
            catch (FunctionNotFoundException functionNotFoundException) {
                // empty catch block
            }
            this.latestMetaData.addFunction(function);
            this.latestMetaDataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFunction(PName tenantId, String function, long functionTimeStamp) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.throwConnectionClosedIfNullMetaData();
            this.latestMetaData.removeFunction(tenantId, function, functionTimeStamp);
            this.latestMetaDataLock.notifyAll();
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult getFunctions(PName tenantId, final List<Pair<byte[], Long>> functions, final long clientTimestamp) throws SQLException {
        final byte[] tenantIdBytes = tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId.getBytes();
        return this.metaDataCoprocessorExec(tenantIdBytes, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.GetFunctionsRequest.Builder builder = MetaDataProtos.GetFunctionsRequest.newBuilder();
                builder.setTenantId(ByteStringer.wrap((byte[])tenantIdBytes));
                for (Pair function : functions) {
                    builder.addFunctionNames(ByteStringer.wrap((byte[])((byte[])function.getFirst())));
                    builder.addFunctionTimestamps((Long)function.getSecond());
                }
                builder.setClientTimestamp(clientTimestamp);
                builder.setClientVersion(VersionUtil.encodeVersion(4, 16, 0));
                instance.getFunctions((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        }, PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME_BYTES);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult getSchema(final String schemaName, final long clientTimestamp) throws SQLException {
        return this.metaDataCoprocessorExec(SchemaUtil.getSchemaKey(schemaName), new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.GetSchemaRequest.Builder builder = MetaDataProtos.GetSchemaRequest.newBuilder();
                builder.setSchemaName(schemaName);
                builder.setClientTimestamp(clientTimestamp);
                builder.setClientVersion(VersionUtil.encodeVersion(4, 16, 0));
                instance.getSchema((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult createFunction(final List<Mutation> functionData, final PFunction function, final boolean temporary) throws SQLException {
        byte[][] rowKeyMetadata = new byte[2][];
        Put m = MetaDataUtil.getPutOnlyTableHeaderRow(functionData);
        byte[] key = m.getRow();
        SchemaUtil.getVarChars(key, rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] functionBytes = rowKeyMetadata[1];
        byte[] functionKey = SchemaUtil.getFunctionKey(tenantIdBytes, functionBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(functionKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.CreateFunctionRequest.Builder builder = MetaDataProtos.CreateFunctionRequest.newBuilder();
                for (Mutation m : functionData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setTemporary(temporary);
                builder.setReplace(function.isReplace());
                builder.setClientVersion(VersionUtil.encodeVersion(4, 16, 0));
                instance.createFunction((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        }, PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME_BYTES);
        return result;
    }

    @Override
    public long getRenewLeaseThresholdMilliSeconds() {
        return this.renewLeaseThreshold;
    }

    @Override
    public boolean isRenewingLeasesEnabled() {
        return this.supportsFeature(ConnectionQueryServices.Feature.RENEW_LEASE) && this.renewLeaseEnabled;
    }

    @Override
    public HRegionLocation getTableRegionLocation(byte[] tableName, byte[] row) throws SQLException {
        int retryCount = 0;
        int maxRetryCount = 1;
        boolean reload = false;
        while (true) {
            try {
                return this.connection.getRegionLocation(TableName.valueOf((byte[])tableName), row, reload);
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException e) {
                String fullName = Bytes.toString((byte[])tableName);
                throw new TableNotFoundException(SchemaUtil.getSchemaNameFromFullName(fullName), SchemaUtil.getTableNameFromFullName(fullName));
            }
            catch (IOException e) {
                if (retryCount++ < maxRetryCount) {
                    reload = true;
                    continue;
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.GET_TABLE_REGIONS_FAIL).setRootCause(e).build().buildException();
            }
            break;
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult createSchema(final List<Mutation> schemaMutations, final String schemaName) throws SQLException {
        this.ensureNamespaceCreated(schemaName);
        Put m = MetaDataUtil.getPutOnlyTableHeaderRow(schemaMutations);
        byte[] key = m.getRow();
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(key, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.CreateSchemaRequest.Builder builder = MetaDataProtos.CreateSchemaRequest.newBuilder();
                for (Mutation m : schemaMutations) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setSchemaName(schemaName);
                builder.setClientVersion(VersionUtil.encodeVersion(4, 16, 0));
                instance.createSchema((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
        return result;
    }

    @Override
    public void addSchema(PSchema schema) throws SQLException {
        this.latestMetaData.addSchema(schema);
    }

    @Override
    public void removeSchema(PSchema schema, long schemaTimeStamp) {
        this.latestMetaData.removeSchema(schema, schemaTimeStamp);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropSchema(final List<Mutation> schemaMetaData, final String schemaName) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(SchemaUtil.getSchemaKey(schemaName), new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                MetaDataProtos.DropSchemaRequest.Builder builder = MetaDataProtos.DropSchemaRequest.newBuilder();
                for (Mutation m : schemaMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addSchemaMetadataMutations(mp.toByteString());
                }
                builder.setSchemaName(schemaName);
                builder.setClientVersion(VersionUtil.encodeVersion(4, 16, 0));
                instance.dropSchema((RpcController)controller, builder.build(), (RpcCallback<MetaDataProtos.MetaDataResponse>)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        });
        MetaDataProtocol.MutationCode code = result.getMutationCode();
        switch (code) {
            case SCHEMA_ALREADY_EXISTS: {
                ReadOnlyProps props = this.getProps();
                boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                if (!dropMetadata) break;
                this.ensureNamespaceDropped(schemaName);
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureNamespaceDropped(String schemaName) throws SQLException {
        block20: {
            SQLException sqlE = null;
            try (HBaseAdmin admin = this.getAdmin();){
                String quorum = ZKConfig.getZKQuorumServersString((Configuration)this.config);
                String znode = this.props.get("zookeeper.znode.parent");
                LOGGER.debug("Found quorum: " + quorum + ":" + znode);
                boolean nameSpaceExists = true;
                try {
                    admin.getNamespaceDescriptor(schemaName);
                }
                catch (NamespaceNotFoundException e) {
                    nameSpaceExists = false;
                }
                if (nameSpaceExists) {
                    admin.deleteNamespace(schemaName);
                }
            }
            catch (IOException e) {
                sqlE = ServerUtil.parseServerException(e);
            }
            finally {
                if (sqlE == null) break block20;
                throw sqlE;
            }
        }
    }

    public void addTableStats(GuidePostsKey key, GuidePostsInfo info) {
        this.tableStatsCache.put(Objects.requireNonNull(key), Objects.requireNonNull(info));
    }

    @Override
    public void invalidateStats(GuidePostsKey key) {
        this.tableStatsCache.invalidate(Objects.requireNonNull(key));
    }

    @Override
    public boolean isUpgradeRequired() {
        return this.upgradeRequired.get();
    }

    @Override
    public void clearUpgradeRequired() {
        this.upgradeRequired.set(false);
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public QueryLoggerDisruptor getQueryDisruptor() {
        return this.queryDisruptor;
    }

    @Override
    public synchronized PhoenixTransactionClient initTransactionClient(TransactionFactory.Provider provider) throws SQLException {
        PhoenixTransactionClient client = this.txClients[provider.ordinal()];
        if (client == null) {
            PhoenixTransactionClient phoenixTransactionClient = provider.getTransactionProvider().getTransactionClient(this.config, this.connectionInfo);
            this.txClients[provider.ordinal()] = phoenixTransactionClient;
            client = phoenixTransactionClient;
        }
        return client;
    }

    @VisibleForTesting
    public List<LinkedBlockingQueue<WeakReference<PhoenixConnection>>> getCachedConnections() {
        return this.connectionQueues;
    }

    static /* synthetic */ SQLException access$100(ConnectionQueryServicesImpl x0) {
        return x0.initializationException;
    }

    static /* synthetic */ void access$200(ConnectionQueryServicesImpl x0) {
        x0.checkClosed();
    }

    static /* synthetic */ void access$400(ConnectionQueryServicesImpl x0) throws SQLException {
        x0.openConnection();
    }

    static /* synthetic */ PMetaData access$500(ConnectionQueryServicesImpl x0) {
        return x0.newEmptyMetaData();
    }

    static /* synthetic */ boolean access$600(ConnectionQueryServicesImpl x0, Throwable x1, List x2) {
        return x0.inspectIfAnyExceptionInChain(x1, x2);
    }

    static /* synthetic */ void access$700(ConnectionQueryServicesImpl x0, byte[] x1) throws SQLException, AccessDeniedException {
        x0.checkClientServerCompatibility(x1);
    }

    static /* synthetic */ SQLException access$102(ConnectionQueryServicesImpl x0, SQLException x1) {
        x0.initializationException = x1;
        return x0.initializationException;
    }

    static /* synthetic */ AtomicBoolean access$800(ConnectionQueryServicesImpl x0) {
        return x0.upgradeRequired;
    }

    static /* synthetic */ void access$900(ConnectionQueryServicesImpl x0, PhoenixConnection x1) throws SQLException, IOException {
        x0.createOtherSystemTables(x1);
    }

    static /* synthetic */ void access$1000(ConnectionQueryServicesImpl x0, PhoenixConnection x1) throws SQLException {
        x0.createSchemaIfNotExistsSystemNSMappingEnabled(x1);
    }

    static /* synthetic */ boolean access$1100(ConnectionQueryServicesImpl x0) {
        return x0.isAutoUpgradeEnabled;
    }

    static /* synthetic */ void access$1200(ConnectionQueryServicesImpl x0) {
        x0.scheduleRenewLeaseTasks();
    }

    static /* synthetic */ void access$1300(ConnectionQueryServicesImpl x0) throws IOException {
        x0.closeConnection();
    }

    @VisibleForTesting
    static class RenewLeaseTask
    implements Runnable {
        private final LinkedBlockingQueue<WeakReference<PhoenixConnection>> connectionsQueue;
        private final Random random = new Random();
        private static final int MAX_WAIT_TIME = 1000;

        RenewLeaseTask(LinkedBlockingQueue<WeakReference<PhoenixConnection>> queue) {
            this.connectionsQueue = queue;
        }

        private void waitForRandomDuration() throws InterruptedException {
            new CountDownLatch(1).await(this.random.nextInt(1000), TimeUnit.MILLISECONDS);
        }

        @Override
        public void run() {
            try {
                boolean wait = true;
                for (int numConnections = this.connectionsQueue.size(); numConnections > 0; --numConnections) {
                    WeakReference<PhoenixConnection> connRef;
                    if (wait) {
                        this.waitForRandomDuration();
                        wait = false;
                    }
                    if ((connRef = this.connectionsQueue.poll(1L, TimeUnit.MILLISECONDS)) == null) {
                        throw new InternalRenewLeaseTaskException("Connection ref found to be null. This is a bug. Some other thread removed items from the connection queue.");
                    }
                    PhoenixConnection conn = (PhoenixConnection)connRef.get();
                    if (conn == null || conn.isClosed()) continue;
                    LinkedBlockingQueue<WeakReference<TableResultIterator>> scannerQueue = conn.getScanners();
                    int renewed = 0;
                    long start = EnvironmentEdgeManager.currentTimeMillis();
                    block10: for (int numScanners = scannerQueue.size(); numScanners > 0; --numScanners) {
                        WeakReference<TableResultIterator> ref = scannerQueue.poll(1L, TimeUnit.MILLISECONDS);
                        if (ref == null) {
                            throw new InternalRenewLeaseTaskException("TableResulIterator ref found to be null. This is a bug. Some other thread removed items from the scanner queue.");
                        }
                        TableResultIterator scanningItr = (TableResultIterator)ref.get();
                        if (scanningItr == null) continue;
                        TableResultIterator.RenewLeaseStatus status = scanningItr.renewLease();
                        switch (status) {
                            case RENEWED: {
                                ++renewed;
                                scannerQueue.offer(new WeakReference<TableResultIterator>(scanningItr));
                                LOGGER.info("Lease renewed for scanner: " + scanningItr);
                                continue block10;
                            }
                            case UNINITIALIZED: 
                            case THRESHOLD_NOT_REACHED: 
                            case LOCK_NOT_ACQUIRED: {
                                scannerQueue.offer(new WeakReference<TableResultIterator>(scanningItr));
                                continue block10;
                            }
                        }
                    }
                    if (renewed > 0) {
                        LOGGER.info("Renewed leases for " + renewed + " scanner/s in " + (EnvironmentEdgeManager.currentTimeMillis() - start) + " ms ");
                    }
                    this.connectionsQueue.offer(connRef);
                }
            }
            catch (InternalRenewLeaseTaskException e) {
                LOGGER.error("Exception thrown when renewing lease. Draining the queue of scanners ", (Throwable)e);
                this.connectionsQueue.clear();
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.error("Thread interrupted when renewing lease.", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("Exception thrown when renewing lease ", (Throwable)e);
            }
            catch (Throwable e) {
                LOGGER.error("Exception thrown when renewing lease. Draining the queue of scanners ", e);
                this.connectionsQueue.clear();
                throw new RuntimeException(e);
            }
        }

        private static class InternalRenewLeaseTaskException
        extends Exception {
            public InternalRenewLeaseTaskException(String msg) {
                super(msg);
            }
        }
    }

    private static class RenewLeaseThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger threadNumber = new AtomicInteger(1);
        private static final String NAME_PREFIX = "PHOENIX-SCANNER-RENEW-LEASE-thread-";

        private RenewLeaseThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, NAME_PREFIX + threadNumber.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }

    private static interface RetriableOperation {
        public boolean checkForCompletion() throws TimeoutException, IOException;

        public String getOperationName();
    }

    private static interface Mutator {
        public void mutate(PMetaData var1) throws SQLException;
    }

    private static interface FeatureSupported {
        public boolean isSupported(ConnectionQueryServices var1);
    }
}

