/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.replication;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.replication.WALCellFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.phoenix.util.SchemaUtil;

public class SystemCatalogWALEntryFilter
implements WALEntryFilter,
WALCellFilter {
    private boolean skipCellFilter;

    public WAL.Entry filter(WAL.Entry entry) {
        this.skipCellFilter = !SchemaUtil.isMetaTable(entry.getKey().getTablename().getName());
        return entry;
    }

    public Cell filterCell(WAL.Entry entry, Cell cell) {
        if (this.skipCellFilter) {
            return cell;
        }
        return this.isTenantRowCell(cell) ? cell : null;
    }

    private boolean isTenantRowCell(Cell cell) {
        return cell.getRowArray()[cell.getRowOffset()] != 0;
    }
}

