/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PBinaryArray
extends PArrayDataType<byte[][]> {
    public static final PBinaryArray INSTANCE = new PBinaryArray();

    private PBinaryArray() {
        super("BINARY ARRAY", 3000 + PBinary.INSTANCE.getSqlType(), PhoenixArray.class, null, 28);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return this.compareTo(lhs, rhs);
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public byte[] toBytes(Object object) {
        return this.toBytes(object, SortOrder.ASC);
    }

    @Override
    public byte[] toBytes(Object object, SortOrder sortOrder) {
        return this.toBytes(object, PBinary.INSTANCE, sortOrder);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        return this.toObject(bytes, offset, length, PBinary.INSTANCE, sortOrder, maxLength, scale, PBinary.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.isCoercibleTo(targetType, this);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        Object[] charArr;
        if (value == null) {
            return true;
        }
        PhoenixArray pArr = (PhoenixArray)value;
        for (Object i : charArr = (Object[])pArr.array) {
            if (super.isCoercibleTo((PDataType)PBinary.INSTANCE, i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return this.getSampleValue(PBinary.INSTANCE, arrayLength, maxLength);
    }
}

