/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.trace;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.htrace.Span;

public class TracingUtils {
    public static final String METRIC_SOURCE_KEY = "phoenix.";
    public static final String METRICS_CONTEXT = "tracing";
    public static final String METRICS_MARKER_CONTEXT = "marker";

    public static void addAnnotation(Span span, String message, int value) {
        span.addKVAnnotation(message.getBytes(), Bytes.toBytes((String)Integer.toString(value)));
    }

    public static Pair<String, String> readAnnotation(byte[] key, byte[] value) {
        return new Pair((Object)new String(key), (Object)Bytes.toString((byte[])value));
    }

    public static final String getTraceMetricName(long traceId) {
        return TracingUtils.getTraceMetricName(Long.toString(traceId));
    }

    public static final String getTraceMetricName(String traceId) {
        return METRIC_SOURCE_KEY + traceId;
    }
}

