/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.transaction;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.DelegateHTable;
import org.apache.phoenix.execute.PhoenixTxIndexMutationGenerator;
import org.apache.phoenix.index.IndexMetaDataCacheClient;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.transaction.PhoenixTransactionClient;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.TephraTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SQLCloseables;
import org.apache.tephra.Transaction;
import org.apache.tephra.TransactionAware;
import org.apache.tephra.TransactionCodec;
import org.apache.tephra.TransactionConflictException;
import org.apache.tephra.TransactionContext;
import org.apache.tephra.TransactionFailureException;
import org.apache.tephra.TransactionSystemClient;
import org.apache.tephra.TxConstants;
import org.apache.tephra.hbase.TransactionAwareHTable;
import org.apache.tephra.visibility.FenceWait;
import org.apache.tephra.visibility.VisibilityFence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TephraTransactionContext
implements PhoenixTransactionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(TephraTransactionContext.class);
    private static final TransactionCodec CODEC = new TransactionCodec();
    private final List<TransactionAware> txAwares;
    private final TransactionContext txContext;
    private Transaction tx;
    private TransactionSystemClient txServiceClient;

    public TephraTransactionContext() {
        this.txServiceClient = null;
        this.txAwares = Lists.newArrayList();
        this.txContext = null;
    }

    public TephraTransactionContext(byte[] txnBytes) throws IOException {
        this();
        this.tx = CODEC.decode(txnBytes);
    }

    public TephraTransactionContext(PhoenixConnection connection) throws SQLException {
        PhoenixTransactionClient client = connection.getQueryServices().initTransactionClient(this.getProvider());
        assert (client instanceof TephraTransactionProvider.TephraTransactionClient);
        this.txServiceClient = ((TephraTransactionProvider.TephraTransactionClient)client).getTransactionClient();
        this.txAwares = Collections.emptyList();
        this.txContext = new TransactionContext(this.txServiceClient, new TransactionAware[0]);
    }

    private TephraTransactionContext(PhoenixTransactionContext ctx, boolean subTask) {
        assert (ctx instanceof TephraTransactionContext);
        TephraTransactionContext tephraTransactionContext = (TephraTransactionContext)ctx;
        this.txServiceClient = tephraTransactionContext.txServiceClient;
        if (subTask) {
            this.tx = tephraTransactionContext.getTransaction();
            this.txAwares = Lists.newArrayList();
            this.txContext = null;
        } else {
            this.txAwares = Collections.emptyList();
            this.txContext = tephraTransactionContext.getContext();
        }
    }

    @Override
    public TransactionFactory.Provider getProvider() {
        return TransactionFactory.Provider.TEPHRA;
    }

    @Override
    public void begin() throws SQLException {
        if (this.txContext == null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.NULL_TRANSACTION_CONTEXT).build().buildException();
        }
        try {
            this.txContext.start();
        }
        catch (TransactionFailureException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_FAILED).setMessage(e.getMessage()).setRootCause(e).build().buildException();
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.txContext == null || !this.isTransactionRunning()) {
            return;
        }
        try {
            this.txContext.finish();
        }
        catch (TransactionFailureException e) {
            if (e instanceof TransactionConflictException) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_CONFLICT_EXCEPTION).setMessage(e.getMessage()).setRootCause(e).build().buildException();
            }
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_FAILED).setMessage(e.getMessage()).setRootCause(e).build().buildException();
        }
    }

    @Override
    public void abort() throws SQLException {
        if (this.txContext == null || !this.isTransactionRunning()) {
            return;
        }
        try {
            this.txContext.abort();
        }
        catch (TransactionFailureException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TRANSACTION_FAILED).setMessage(e.getMessage()).setRootCause(e).build().buildException();
        }
    }

    @Override
    public void checkpoint(boolean hasUncommittedData) throws SQLException {
        if (hasUncommittedData) {
            try {
                if (this.txContext == null) {
                    this.tx = this.txServiceClient.checkpoint(this.tx);
                } else {
                    assert (this.txContext != null);
                    this.txContext.checkpoint();
                    this.tx = this.txContext.getCurrentTransaction();
                }
            }
            catch (TransactionFailureException e) {
                throw new SQLException(e);
            }
        }
        if (this.txContext == null) {
            this.tx.setVisibility(Transaction.VisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT);
        } else {
            assert (this.txContext != null);
            this.txContext.getCurrentTransaction().setVisibility(Transaction.VisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT);
        }
    }

    @Override
    public void commitDDLFence(PTable dataTable) throws SQLException {
        byte[] key = dataTable.getName().getBytes();
        try {
            FenceWait fenceWait = VisibilityFence.prepareWait((byte[])key, (TransactionSystemClient)this.txServiceClient);
            fenceWait.await(10000L, TimeUnit.MILLISECONDS);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Added write fence at ~" + this.getCurrentTransaction().getReadPointer());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
        }
        catch (TimeoutException | TransactionFailureException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TX_UNABLE_TO_GET_WRITE_FENCE).setSchemaName(dataTable.getSchemaName().getString()).setTableName(dataTable.getTableName().getString()).build().buildException();
        }
        finally {
            this.begin();
        }
    }

    @Override
    public void markDMLFence(PTable table) {
        if (table.getType() == PTableType.INDEX) {
            return;
        }
        byte[] logicalKey = table.getName().getBytes();
        TransactionAware logicalTxAware = VisibilityFence.create((byte[])logicalKey);
        if (this.txContext == null) {
            this.txAwares.add(logicalTxAware);
        } else {
            this.txContext.addTransactionAware(logicalTxAware);
        }
        byte[] physicalKey = table.getPhysicalName().getBytes();
        if (Bytes.compareTo((byte[])physicalKey, (byte[])logicalKey) != 0) {
            TransactionAware physicalTxAware = VisibilityFence.create((byte[])physicalKey);
            if (this.txContext == null) {
                this.txAwares.add(physicalTxAware);
            } else {
                this.txContext.addTransactionAware(physicalTxAware);
            }
        }
    }

    @Override
    public void join(PhoenixTransactionContext ctx) {
        if (ctx == PhoenixTransactionContext.NULL_CONTEXT) {
            return;
        }
        assert (ctx instanceof TephraTransactionContext);
        TephraTransactionContext tephraContext = (TephraTransactionContext)ctx;
        if (this.txContext != null) {
            for (TransactionAware txAware : tephraContext.getAwares()) {
                this.txContext.addTransactionAware(txAware);
            }
        } else {
            this.txAwares.addAll(tephraContext.getAwares());
        }
    }

    private Transaction getCurrentTransaction() {
        return this.tx != null ? this.tx : (this.txContext != null ? this.txContext.getCurrentTransaction() : null);
    }

    @Override
    public boolean isTransactionRunning() {
        return this.getCurrentTransaction() != null;
    }

    @Override
    public void reset() {
        this.tx = null;
        this.txAwares.clear();
    }

    @Override
    public long getTransactionId() {
        Transaction tx = this.getCurrentTransaction();
        return tx == null ? Long.MAX_VALUE : tx.getTransactionId();
    }

    @Override
    public long getReadPointer() {
        Transaction tx = this.getCurrentTransaction();
        if (tx == null) {
            return -1L;
        }
        return tx.getReadPointer();
    }

    @Override
    public long getWritePointer() {
        Transaction tx = this.getCurrentTransaction();
        return tx == null ? Long.MAX_VALUE : tx.getWritePointer();
    }

    @Override
    public void setVisibilityLevel(PhoenixTransactionContext.PhoenixVisibilityLevel visibilityLevel) {
        Transaction.VisibilityLevel tephraVisibilityLevel = null;
        switch (visibilityLevel) {
            case SNAPSHOT: {
                tephraVisibilityLevel = Transaction.VisibilityLevel.SNAPSHOT;
                break;
            }
            case SNAPSHOT_EXCLUDE_CURRENT: {
                tephraVisibilityLevel = Transaction.VisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT;
                break;
            }
            case SNAPSHOT_ALL: {
                tephraVisibilityLevel = Transaction.VisibilityLevel.SNAPSHOT_ALL;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Transaction tx = this.getCurrentTransaction();
        assert (tx != null);
        tx.setVisibility(tephraVisibilityLevel);
    }

    @Override
    public PhoenixTransactionContext.PhoenixVisibilityLevel getVisibilityLevel() {
        PhoenixTransactionContext.PhoenixVisibilityLevel phoenixVisibilityLevel;
        Transaction.VisibilityLevel visibilityLevel = null;
        Transaction tx = this.getCurrentTransaction();
        assert (tx != null);
        visibilityLevel = tx.getVisibilityLevel();
        switch (visibilityLevel) {
            case SNAPSHOT: {
                phoenixVisibilityLevel = PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT;
                break;
            }
            case SNAPSHOT_EXCLUDE_CURRENT: {
                phoenixVisibilityLevel = PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT_EXCLUDE_CURRENT;
                break;
            }
            case SNAPSHOT_ALL: {
                phoenixVisibilityLevel = PhoenixTransactionContext.PhoenixVisibilityLevel.SNAPSHOT_ALL;
                break;
            }
            default: {
                phoenixVisibilityLevel = null;
            }
        }
        return phoenixVisibilityLevel;
    }

    @Override
    public byte[] encodeTransaction() throws SQLException {
        Transaction tx = this.getCurrentTransaction();
        assert (tx != null);
        try {
            byte[] encodedTxBytes = CODEC.encode(tx);
            encodedTxBytes = Arrays.copyOf(encodedTxBytes, encodedTxBytes.length + 1);
            encodedTxBytes[encodedTxBytes.length - 1] = this.getProvider().getCode();
            return encodedTxBytes;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    Transaction getTransaction() {
        return this.getCurrentTransaction();
    }

    TransactionContext getContext() {
        return this.txContext;
    }

    List<TransactionAware> getAwares() {
        return this.txAwares;
    }

    void addTransactionAware(TransactionAware txAware) {
        if (this.txContext != null) {
            this.txContext.addTransactionAware(txAware);
        } else if (this.tx != null) {
            this.txAwares.add(txAware);
            assert (this.tx != null);
            txAware.startTx(this.tx);
        }
    }

    @Override
    public PhoenixTransactionContext newTransactionContext(PhoenixTransactionContext context, boolean subTask) {
        return new TephraTransactionContext(context, subTask);
    }

    @Override
    public Table getTransactionalTable(Table htable, boolean isConflictFree) {
        TransactionAwareHTable transactionAwareHTable = new TransactionAwareHTable(htable, isConflictFree ? TxConstants.ConflictDetection.NONE : TxConstants.ConflictDetection.ROW);
        this.addTransactionAware((TransactionAware)transactionAwareHTable);
        return transactionAwareHTable;
    }

    @Override
    public Table getTransactionalTableWriter(PhoenixConnection connection, PTable table, Table htable, boolean isIndex) throws SQLException {
        TransactionAwareHTable transactionAwareHTable;
        if (isIndex) {
            transactionAwareHTable = new TransactionAwareHTable(htable, TxConstants.ConflictDetection.NONE);
            transactionAwareHTable.startTx(this.getTransaction());
        } else {
            htable = new RollbackHookHTableWrapper(htable, table, connection);
            transactionAwareHTable = new TransactionAwareHTable(htable, table.isImmutableRows() ? TxConstants.ConflictDetection.NONE : TxConstants.ConflictDetection.ROW);
            this.addTransactionAware((TransactionAware)transactionAwareHTable);
        }
        return transactionAwareHTable;
    }

    private static class RollbackHookHTableWrapper
    extends DelegateHTable {
        private final PTable table;
        private final PhoenixConnection connection;

        private RollbackHookHTableWrapper(Table delegate, PTable table, PhoenixConnection connection) {
            super(delegate);
            this.table = table;
            this.connection = connection;
        }

        @Override
        public void delete(List<Delete> deletes) throws IOException {
            ServerCacheClient.ServerCache cache = null;
            try {
                List<PTable> indexes;
                if (deletes.isEmpty()) {
                    return;
                }
                ImmutableBytesWritable indexMetaDataPtr = new ImmutableBytesWritable();
                if (this.table.getIndexMaintainers(indexMetaDataPtr, this.connection)) {
                    cache = IndexMetaDataCacheClient.setMetaDataOnMutations(this.connection, this.table, deletes, indexMetaDataPtr);
                }
                if (!(indexes = IndexUtil.getClientMaintainedIndexes(this.table)).isEmpty()) {
                    PhoenixTxIndexMutationGenerator generator = PhoenixTxIndexMutationGenerator.newGenerator(this.connection, this.table, indexes, deletes.get(0).getAttributesMap());
                    Collection<Pair<Mutation, byte[]>> indexUpdates = generator.getIndexUpdates(this.delegate, deletes.iterator());
                    for (PTable index : indexes) {
                        byte[] physicalName = index.getPhysicalName().getBytes();
                        try {
                            HTableInterface hindex = this.connection.getQueryServices().getTable(physicalName);
                            Throwable throwable = null;
                            try {
                                ArrayList indexDeletes = Lists.newArrayListWithExpectedSize((int)deletes.size());
                                for (Pair<Mutation, byte[]> mutationPair : indexUpdates) {
                                    if (Bytes.equals((byte[])((byte[])mutationPair.getSecond()), (byte[])physicalName)) {
                                        indexDeletes.add(mutationPair.getFirst());
                                    }
                                    hindex.batch((List)indexDeletes);
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (hindex == null) continue;
                                if (throwable != null) {
                                    try {
                                        hindex.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                hindex.close();
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new IOException(e);
                        }
                    }
                }
                this.delegate.delete(deletes);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
            finally {
                if (cache != null) {
                    SQLCloseables.closeAllQuietly(Collections.singletonList(cache));
                }
            }
        }
    }
}

