/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.math.BigDecimal;
import org.apache.phoenix.schema.types.PDataType;

public class NumberUtil {
    public static final String DEFAULT_NUMBER_FORMAT = "#,##0.###";

    public static BigDecimal normalize(BigDecimal bigDecimal) {
        return bigDecimal.round(PDataType.DEFAULT_MATH_CONTEXT).stripTrailingZeros();
    }

    public static BigDecimal setDecimalWidthAndScale(BigDecimal decimal, Integer precisionOrNull, Integer scaleOrNull) {
        int scale;
        int precision = precisionOrNull == null ? 38 : precisionOrNull;
        int n = scale = scaleOrNull == null ? 0 : scaleOrNull;
        if (precision - scale < decimal.precision() - decimal.scale()) {
            return null;
        }
        if (scaleOrNull != null) {
            decimal = decimal.setScale(scale, 1);
        }
        return decimal;
    }

    public static Long add(Long num1, Long num2) {
        if (num1 == null) {
            if (num2 == null) {
                return null;
            }
            return num2;
        }
        if (num2 == null) {
            return num1;
        }
        return num1 + num2;
    }

    public static Long getMin(Long num1, Long num2) {
        if (num1 == null) {
            if (num2 == null) {
                return null;
            }
            return num2;
        }
        if (num2 == null) {
            return num1;
        }
        return Math.min(num1, num2);
    }
}

