/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.StatementNormalizer;
import org.apache.phoenix.compile.SubqueryRewriter;
import org.apache.phoenix.compile.SubselectRewriter;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.FamilyWildcardParseNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.StatelessTraverseAllParseNodeVisitor;
import org.apache.phoenix.parse.TableWildcardParseNode;
import org.apache.phoenix.parse.WildcardParseNode;
import org.apache.phoenix.util.SchemaUtil;

public class ParseNodeUtil {
    public static <T> void applyParseNodeVisitor(SelectStatement selectStatement, ParseNodeVisitor<T> parseNodeVisitor) throws SQLException {
        ParseNodeUtil.applyParseNodeVisitor(selectStatement, parseNodeVisitor, true);
    }

    public static <T> void applyParseNodeVisitor(SelectStatement selectStatement, ParseNodeVisitor<T> parseNodeVisitor, boolean applyWhere) throws SQLException {
        for (AliasedNode selectAliasedNode : selectStatement.getSelect()) {
            selectAliasedNode.getNode().accept(parseNodeVisitor);
        }
        if (selectStatement.getGroupBy() != null) {
            for (ParseNode groupByParseNode : selectStatement.getGroupBy()) {
                groupByParseNode.accept(parseNodeVisitor);
            }
        }
        if (selectStatement.getHaving() != null) {
            selectStatement.getHaving().accept(parseNodeVisitor);
        }
        if (selectStatement.getOrderBy() != null) {
            for (OrderByNode orderByNode : selectStatement.getOrderBy()) {
                orderByNode.getNode().accept(parseNodeVisitor);
            }
        }
        if (applyWhere && selectStatement.getWhere() != null) {
            selectStatement.getWhere().accept(parseNodeVisitor);
        }
    }

    public static Set<String> collectReferencedColumnNamesForSingleTable(SelectStatement selectStatement) throws SQLException {
        SingleTableCollectColumnNameParseNodeVisitor collectColumnNameParseNodeVisitor = new SingleTableCollectColumnNameParseNodeVisitor();
        ParseNodeUtil.applyParseNodeVisitor(selectStatement, collectColumnNameParseNodeVisitor);
        boolean isWildcard = collectColumnNameParseNodeVisitor.isWildcard();
        if (isWildcard) {
            return null;
        }
        return collectColumnNameParseNodeVisitor.getReferenceColumnNames();
    }

    public static RewriteResult rewrite(SelectStatement selectStatement, PhoenixConnection phoenixConnection) throws SQLException {
        SelectStatement selectStatementToUse = SubselectRewriter.flatten(selectStatement, phoenixConnection);
        ColumnResolver columnResolver = FromCompiler.getResolverForQuery(selectStatementToUse, phoenixConnection);
        SelectStatement transformedSubquery = SubqueryRewriter.transform(selectStatementToUse = StatementNormalizer.normalize(selectStatementToUse, columnResolver), columnResolver, phoenixConnection);
        if (transformedSubquery != selectStatementToUse) {
            columnResolver = FromCompiler.getResolverForQuery(transformedSubquery, phoenixConnection);
            transformedSubquery = StatementNormalizer.normalize(transformedSubquery, columnResolver);
        }
        return new RewriteResult(transformedSubquery, columnResolver);
    }

    public static class RewriteResult {
        private SelectStatement rewrittenSelectStatement;
        private ColumnResolver columnResolver;

        public RewriteResult(SelectStatement rewrittenSelectStatement, ColumnResolver columnResolver) {
            this.rewrittenSelectStatement = rewrittenSelectStatement;
            this.columnResolver = columnResolver;
        }

        public SelectStatement getRewrittenSelectStatement() {
            return this.rewrittenSelectStatement;
        }

        public ColumnResolver getColumnResolver() {
            return this.columnResolver;
        }
    }

    private static class SingleTableCollectColumnNameParseNodeVisitor
    extends StatelessTraverseAllParseNodeVisitor {
        private final Set<String> referenceColumnNames = new HashSet<String>();
        private boolean wildcard = false;

        public Set<String> getReferenceColumnNames() {
            return this.referenceColumnNames;
        }

        public boolean isWildcard() {
            return this.wildcard;
        }

        @Override
        public Void visit(ColumnParseNode columnParseNode) throws SQLException {
            String normalizedColumnName = SchemaUtil.getNormalizedColumnName(columnParseNode);
            this.referenceColumnNames.add(normalizedColumnName);
            return null;
        }

        @Override
        public Void visit(WildcardParseNode node) throws SQLException {
            this.wildcard = true;
            return null;
        }

        @Override
        public Void visit(TableWildcardParseNode node) throws SQLException {
            this.wildcard = true;
            return null;
        }

        @Override
        public Void visit(FamilyWildcardParseNode node) throws SQLException {
            this.wildcard = true;
            return null;
        }
    }
}

