/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.LocalIndexSplitter;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.MetaDataEndpointImpl;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.coprocessor.TableInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.SequenceAllocation;
import org.apache.phoenix.schema.SequenceAlreadyExistsException;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.TableViewFinderResult;
import org.apache.phoenix.util.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeUtil.class);
    private static final byte[] SEQ_PREFIX_BYTES = ByteUtil.concat(QueryConstants.SEPARATOR_BYTE_ARRAY, new byte[][]{Bytes.toBytes((String)"_SEQ_")});
    public static final byte[] UPGRADE_TO_4_7_COLUMN_NAME = Bytes.toBytes((String)"UPGRADE_TO_4_7");
    private static final String DO_NOT_UPGRADE = "DoNotUpgrade";
    public static String UPSERT_BASE_COLUMN_COUNT_IN_HEADER_ROW = "UPSERT INTO SYSTEM.CATALOG (TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY, BASE_COLUMN_COUNT) VALUES (?, ?, ?, ?, ?, ?) ";
    public static final String UPSERT_UPDATE_CACHE_FREQUENCY = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,UPDATE_CACHE_FREQUENCY) VALUES (?, ?, ?, ?)";
    public static String SELECT_BASE_COLUMN_COUNT_FROM_HEADER_ROW = "SELECT BASE_COLUMN_COUNT FROM \"SYSTEM\".CATALOG WHERE COLUMN_NAME IS NULL AND COLUMN_FAMILY IS NULL AND TENANT_ID %s AND TABLE_SCHEM %s AND TABLE_NAME = ? ";
    private static final String UPDATE_LINK = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_FAMILY,LINK_TYPE,TABLE_SEQ_NUM,TABLE_TYPE) SELECT TENANT_ID,TABLE_SCHEM,TABLE_NAME,'%s' AS COLUMN_FAMILY ,LINK_TYPE,TABLE_SEQ_NUM,TABLE_TYPE FROM SYSTEM.\"CATALOG\" WHERE  (TABLE_SCHEM=? OR (TABLE_SCHEM IS NULL AND ? IS NULL)) AND TABLE_NAME=? AND COLUMN_FAMILY=? AND LINK_TYPE = " + PTable.LinkType.PHYSICAL_TABLE.getSerializedValue();
    private static final String DELETE_LINK = "DELETE FROM SYSTEM.CATALOG WHERE (TABLE_SCHEM=? OR (TABLE_SCHEM IS NULL AND ? IS NULL)) AND TABLE_NAME=? AND COLUMN_FAMILY=? AND LINK_TYPE = " + PTable.LinkType.PHYSICAL_TABLE.getSerializedValue();

    private UpgradeUtil() {
    }

    private static byte[] getSequenceSnapshotName() {
        return Bytes.toBytes((String)("_BAK_" + PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME));
    }

    private static void createSequenceSnapshot(HBaseAdmin admin, PhoenixConnection conn) throws SQLException {
        byte[] tableName = UpgradeUtil.getSequenceSnapshotName();
        HColumnDescriptor columnDesc = new HColumnDescriptor(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES);
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        desc.addFamily(columnDesc);
        try {
            admin.createTable(desc);
            UpgradeUtil.copyTable(conn, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES, tableName);
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    private static void restoreSequenceSnapshot(HBaseAdmin admin, PhoenixConnection conn) throws SQLException {
        byte[] tableName = UpgradeUtil.getSequenceSnapshotName();
        UpgradeUtil.copyTable(conn, tableName, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES);
    }

    private static void deleteSequenceSnapshot(HBaseAdmin admin) throws SQLException {
        byte[] tableName = UpgradeUtil.getSequenceSnapshotName();
        try {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copyTable(PhoenixConnection conn, byte[] sourceName, byte[] targetName) throws SQLException {
        batchSizeBytes = 102400;
        sizeBytes = 0;
        mutations = Lists.newArrayListWithExpectedSize((int)10000);
        scan = new Scan();
        scan.setRaw(true);
        scan.setMaxVersions();
        scanner = null;
        source = null;
        target = null;
        try {
            source = conn.getQueryServices().getTable(sourceName);
            target = conn.getQueryServices().getTable(targetName);
            scanner = source.getScanner(scan);
lbl16:
            // 3 sources

            while (true) {
                result = scanner.next();
                if (result == null) {
                    if (!mutations.isEmpty()) {
                        UpgradeUtil.LOGGER.info("Committing last bactch of temp rows");
                        target.batch((List)mutations);
                    }
                    UpgradeUtil.LOGGER.info("Successfully completed copy");
                    return;
                }
                var11_16 = result.raw();
                var12_17 = var11_16.length;
                break;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw ServerUtil.parseServerException(e);
        }
        finally {
            try {
                if (scanner != null) {
                    scanner.close();
                }
            }
            finally {
                try {
                    if (source != null) {
                        source.close();
                    }
                }
                catch (IOException e) {
                    UpgradeUtil.LOGGER.warn("Exception during close of source table", (Throwable)e);
                }
                finally {
                    try {
                        if (target != null) {
                            target.close();
                        }
                    }
                    catch (IOException e) {
                        UpgradeUtil.LOGGER.warn("Exception during close of target table", (Throwable)e);
                    }
                }
            }
        }
        for (var13_18 = 0; var13_18 < var12_17; ++var13_18) {
            keyValue = var11_16[var13_18];
            sizeBytes += keyValue.getLength();
            if (KeyValue.Type.codeToType((byte)keyValue.getType()) == KeyValue.Type.Put) {
                put = new Put(keyValue.getRow());
                put.add((Cell)keyValue);
                mutations.add(put);
                continue;
            }
            if (KeyValue.Type.codeToType((byte)keyValue.getType()) != KeyValue.Type.Delete) continue;
            delete = new Delete(keyValue.getRow());
            delete.addDeleteMarker((Cell)keyValue);
            mutations.add(delete);
        }
        if (sizeBytes < batchSizeBytes) ** GOTO lbl16
        UpgradeUtil.LOGGER.info("Committing bactch of temp rows");
        target.batch((List)mutations);
        mutations.clear();
        sizeBytes = 0;
        ** while (true)
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void preSplitSequenceTable(PhoenixConnection conn, int nSaltBuckets) throws SQLException {
        HBaseAdmin admin = conn.getQueryServices().getAdmin();
        boolean snapshotCreated = false;
        boolean success = false;
        try {
            if (nSaltBuckets <= 0) {
                return;
            }
            LOGGER.warn("Pre-splitting SYSTEM.SEQUENCE table " + nSaltBuckets + "-ways. This may take some time - please do not close window.");
            HTableDescriptor desc = admin.getTableDescriptor(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES);
            UpgradeUtil.createSequenceSnapshot(admin, conn);
            snapshotCreated = true;
            admin.disableTable(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME);
            admin.deleteTable(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME);
            byte[][] splitPoints = SaltingUtil.getSalteByteSplitPoints(nSaltBuckets);
            admin.createTable(desc, splitPoints);
            UpgradeUtil.restoreSequenceSnapshot(admin, conn);
            success = true;
            LOGGER.warn("Completed pre-splitting SYSTEM.SEQUENCE table");
        }
        catch (IOException e) {
            throw new SQLException("Unable to pre-split SYSTEM.SEQUENCE table", e);
        }
        finally {
            try {
                if (snapshotCreated && success) {
                    try {
                        UpgradeUtil.deleteSequenceSnapshot(admin);
                    }
                    catch (SQLException e) {
                        LOGGER.warn("Exception while deleting SYSTEM.SEQUENCE snapshot during pre-split", (Throwable)e);
                    }
                }
            }
            finally {
                try {
                    admin.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Exception while closing admin during pre-split", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhoenixConnection upgradeLocalIndexes(PhoenixConnection metaConnection) throws SQLException, IOException, org.apache.hadoop.hbase.TableNotFoundException {
        PhoenixConnection toReturn;
        block36: {
            Properties props = PropertiesUtil.deepCopy(metaConnection.getClientInfo());
            Long originalScn = null;
            String str = props.getProperty("CurrentSCN");
            if (str != null) {
                originalScn = Long.valueOf(str);
            }
            props.setProperty("CurrentSCN", Long.toString(Long.MAX_VALUE));
            PhoenixConnection globalConnection = null;
            toReturn = null;
            globalConnection = new PhoenixConnection(metaConnection, metaConnection.getQueryServices(), props);
            SQLException sqlEx = null;
            try (HBaseAdmin admin = globalConnection.getQueryServices().getAdmin();){
                ResultSet rs = globalConnection.createStatement().executeQuery("SELECT TABLE_SCHEM, TABLE_NAME, DATA_TABLE_NAME, TENANT_ID, MULTI_TENANT, SALT_BUCKETS FROM SYSTEM.CATALOG        WHERE COLUMN_NAME IS NULL           AND COLUMN_FAMILY IS NULL           AND INDEX_TYPE=" + PTable.IndexType.LOCAL.getSerializedValue());
                boolean droppedLocalIndexes = false;
                while (rs.next()) {
                    int i;
                    if (!droppedLocalIndexes) {
                        HTableDescriptor[] localIndexTables = admin.listTables("_LOCAL_IDX_.*");
                        String localIndexSplitter = LocalIndexSplitter.class.getName();
                        for (HTableDescriptor table : localIndexTables) {
                            HTableDescriptor dataTableDesc = admin.getTableDescriptor(TableName.valueOf((String)MetaDataUtil.getLocalIndexUserTableName(table.getNameAsString())));
                            HColumnDescriptor[] columnFamilies = dataTableDesc.getColumnFamilies();
                            boolean modifyTable = false;
                            for (HColumnDescriptor cf : columnFamilies) {
                                String localIndexCf = "L#" + cf.getNameAsString();
                                if (dataTableDesc.getFamily(Bytes.toBytes((String)localIndexCf)) != null) continue;
                                HColumnDescriptor colDef = new HColumnDescriptor(localIndexCf);
                                for (Map.Entry keyValue : cf.getValues().entrySet()) {
                                    colDef.setValue(((ImmutableBytesWritable)keyValue.getKey()).copyBytes(), ((ImmutableBytesWritable)keyValue.getValue()).copyBytes());
                                }
                                dataTableDesc.addFamily(colDef);
                                modifyTable = true;
                            }
                            List coprocessors = dataTableDesc.getCoprocessors();
                            for (String coprocessor : coprocessors) {
                                if (!coprocessor.equals(localIndexSplitter)) continue;
                                dataTableDesc.removeCoprocessor(localIndexSplitter);
                                modifyTable = true;
                            }
                            if (!modifyTable) continue;
                            admin.modifyTable(dataTableDesc.getName(), dataTableDesc);
                        }
                        admin.disableTables("_LOCAL_IDX_.*");
                        admin.deleteTables("_LOCAL_IDX_.*");
                        droppedLocalIndexes = true;
                    }
                    String schemaName = rs.getString(1);
                    String indexTableName = rs.getString(2);
                    String dataTableName = rs.getString(3);
                    String tenantId = rs.getString(4);
                    boolean multiTenantTable = rs.getBoolean(5);
                    int numColumnsToSkip = 1 + (multiTenantTable ? 1 : 0);
                    String getColumns = "SELECT COLUMN_NAME, COLUMN_FAMILY FROM SYSTEM.CATALOG  WHERE TABLE_SCHEM " + (schemaName == null ? "IS NULL " : "='" + schemaName + "'") + " AND TENANT_ID " + (tenantId == null ? "IS NULL " : "='" + tenantId + "'") + " and TABLE_NAME='" + indexTableName + "' AND COLUMN_NAME IS NOT NULL AND KEY_SEQ > " + numColumnsToSkip + " ORDER BY KEY_SEQ";
                    ResultSet getColumnsRs = globalConnection.createStatement().executeQuery(getColumns);
                    ArrayList<String> indexedColumns = new ArrayList<String>(1);
                    ArrayList<String> coveredColumns = new ArrayList<String>(1);
                    while (getColumnsRs.next()) {
                        String column = getColumnsRs.getString(1);
                        String columnName = IndexUtil.getDataColumnName(column);
                        String columnFamily = IndexUtil.getDataColumnFamilyName(column);
                        if (getColumnsRs.getString(2) == null) {
                            if (columnFamily != null && !columnFamily.isEmpty()) {
                                if (SchemaUtil.normalizeIdentifier(columnFamily).equals("0")) {
                                    indexedColumns.add(columnName);
                                    continue;
                                }
                                indexedColumns.add(SchemaUtil.getCaseSensitiveColumnDisplayName(columnFamily, columnName));
                                continue;
                            }
                            indexedColumns.add(columnName);
                            continue;
                        }
                        coveredColumns.add(SchemaUtil.normalizeIdentifier(columnFamily).equals("0") ? columnName : SchemaUtil.getCaseSensitiveColumnDisplayName(columnFamily, columnName));
                    }
                    StringBuilder createIndex = new StringBuilder("CREATE LOCAL INDEX ");
                    createIndex.append(indexTableName);
                    createIndex.append(" ON ");
                    createIndex.append(SchemaUtil.getTableName(schemaName, dataTableName));
                    createIndex.append("(");
                    for (i = 0; i < indexedColumns.size(); ++i) {
                        createIndex.append((String)indexedColumns.get(i));
                        if (i >= indexedColumns.size() - 1) continue;
                        createIndex.append(",");
                    }
                    createIndex.append(")");
                    if (!coveredColumns.isEmpty()) {
                        createIndex.append(" INCLUDE(");
                        for (i = 0; i < coveredColumns.size(); ++i) {
                            createIndex.append((String)coveredColumns.get(i));
                            if (i >= coveredColumns.size() - 1) continue;
                            createIndex.append(",");
                        }
                        createIndex.append(")");
                    }
                    createIndex.append(" ASYNC");
                    LOGGER.info("Index creation query is : " + createIndex.toString());
                    LOGGER.info("Dropping the index " + indexTableName + " to clean up the index details from SYSTEM.CATALOG.");
                    PhoenixConnection localConnection = null;
                    if (tenantId != null) {
                        props.setProperty("TenantId", tenantId);
                        localConnection = new PhoenixConnection(globalConnection, globalConnection.getQueryServices(), props);
                    }
                    try {
                        (localConnection == null ? globalConnection : localConnection).createStatement().execute("DROP INDEX IF EXISTS " + indexTableName + " ON " + SchemaUtil.getTableName(schemaName, dataTableName));
                        LOGGER.info("Recreating the index " + indexTableName);
                        (localConnection == null ? globalConnection : localConnection).createStatement().execute(createIndex.toString());
                        LOGGER.info("Created the index " + indexTableName);
                        props.remove("TenantId");
                    }
                    catch (Throwable throwable) {
                        props.remove("TenantId");
                        if (localConnection != null && (sqlEx = UpgradeUtil.closeConnection(localConnection, sqlEx)) != null) {
                            throw sqlEx;
                        }
                        throw throwable;
                    }
                    if (localConnection == null || (sqlEx = UpgradeUtil.closeConnection(localConnection, sqlEx)) == null) continue;
                    throw sqlEx;
                }
                globalConnection.createStatement().execute("DELETE FROM SYSTEM.CATALOG WHERE SUBSTR(TABLE_NAME,0,11)='_LOCAL_IDX_'");
                if (originalScn != null) {
                    props.setProperty("CurrentSCN", Long.toString(originalScn));
                }
                toReturn = new PhoenixConnection(globalConnection, globalConnection.getQueryServices(), props);
            }
            catch (SQLException e) {
                sqlEx = e;
                return sqlEx;
            }
            finally {
                sqlEx = UpgradeUtil.closeConnection(metaConnection, sqlEx);
                sqlEx = UpgradeUtil.closeConnection(globalConnection, sqlEx);
                if (sqlEx == null) break block36;
                throw sqlEx;
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhoenixConnection disableViewIndexes(PhoenixConnection connParam) throws SQLException, IOException, InterruptedException, TimeoutException {
        PhoenixConnection toReturn;
        block76: {
            Properties props = PropertiesUtil.deepCopy(connParam.getClientInfo());
            Long originalScn = null;
            String str = props.getProperty("CurrentSCN");
            if (str != null) {
                originalScn = Long.valueOf(str);
            }
            props.setProperty("CurrentSCN", Long.toString(Long.MAX_VALUE));
            HashSet<String> physicalTables = new HashSet<String>();
            SQLException sqlEx = null;
            PhoenixConnection globalConnection = null;
            toReturn = null;
            try {
                globalConnection = new PhoenixConnection(connParam, connParam.getQueryServices(), props);
                String tenantId = null;
                try (HBaseAdmin admin = globalConnection.getQueryServices().getAdmin();){
                    String fetchViewIndexes = "SELECT TENANT_ID, TABLE_SCHEM, TABLE_NAME, DATA_TABLE_NAME FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE " + "VIEW_INDEX_ID" + " IS NOT NULL";
                    String disableIndexDDL = "ALTER INDEX %s ON %s DISABLE";
                    try (ResultSet rs = globalConnection.createStatement().executeQuery(fetchViewIndexes);){
                        while (rs.next()) {
                            TableName tableName;
                            String indexPhysicalTableName;
                            tenantId = rs.getString(1);
                            String indexSchema = rs.getString(2);
                            String indexName = rs.getString(3);
                            String viewName = rs.getString(4);
                            String fullIndexName = SchemaUtil.getTableName(indexSchema, indexName);
                            String fullViewName = SchemaUtil.getTableName(indexSchema, viewName);
                            PTable viewPTable = null;
                            if (tenantId != null && !tenantId.isEmpty()) {
                                int existingViewIdxIdPosition;
                                Properties newProps = PropertiesUtil.deepCopy(globalConnection.getClientInfo());
                                newProps.setProperty("TenantId", tenantId);
                                PTable indexPTable = null;
                                try (PhoenixConnection tenantConnection = new PhoenixConnection(globalConnection, globalConnection.getQueryServices(), newProps);){
                                    viewPTable = PhoenixRuntime.getTable(tenantConnection, fullViewName);
                                    tenantConnection.createStatement().execute(String.format(disableIndexDDL, indexName, fullViewName));
                                    indexPTable = PhoenixRuntime.getTable(tenantConnection, fullIndexName);
                                }
                                int offset = indexPTable.getBucketNum() != null ? 1 : 0;
                                int existingTenantIdPosition = ++offset;
                                int newTenantIdPosition = existingViewIdxIdPosition = ++offset;
                                int newViewIdxPosition = existingTenantIdPosition;
                                String tenantIdColumn = indexPTable.getColumns().get(existingTenantIdPosition - 1).getName().getString();
                                int index = 0;
                                String updatePosition = "UPSERT INTO " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " ( " + "TENANT_ID" + "," + "TABLE_SCHEM" + "," + "TABLE_NAME" + "," + "COLUMN_NAME" + "," + "COLUMN_FAMILY" + "," + "ORDINAL_POSITION" + ") SELECT " + "TENANT_ID" + "," + "TABLE_SCHEM" + "," + "TABLE_NAME" + "," + "COLUMN_NAME" + "," + "COLUMN_FAMILY" + ",? FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE " + "TENANT_ID" + " = ?  AND " + "TABLE_NAME" + " = ?  AND " + (indexSchema == null ? "TABLE_SCHEM IS NULL" : "TABLE_SCHEM = ? ") + " AND " + "COLUMN_NAME" + " = ? ";
                                try (PreparedStatement s = globalConnection.prepareStatement(updatePosition);){
                                    index = 0;
                                    s.setInt(++index, newViewIdxPosition);
                                    s.setString(++index, tenantId);
                                    s.setString(++index, indexName);
                                    if (indexSchema != null) {
                                        s.setString(++index, indexSchema);
                                    }
                                    s.setString(++index, MetaDataUtil.getViewIndexIdColumnName());
                                    s.executeUpdate();
                                }
                                s = globalConnection.prepareStatement(updatePosition);
                                var32_43 = null;
                                try {
                                    index = 0;
                                    s.setInt(++index, newTenantIdPosition);
                                    s.setString(++index, tenantId);
                                    s.setString(++index, indexName);
                                    if (indexSchema != null) {
                                        s.setString(++index, indexSchema);
                                    }
                                    s.setString(++index, tenantIdColumn);
                                    s.executeUpdate();
                                }
                                catch (Throwable throwable) {
                                    var32_43 = throwable;
                                    throw throwable;
                                }
                                finally {
                                    if (s != null) {
                                        if (var32_43 != null) {
                                            try {
                                                s.close();
                                            }
                                            catch (Throwable throwable) {
                                                var32_43.addSuppressed(throwable);
                                            }
                                        } else {
                                            s.close();
                                        }
                                    }
                                }
                                globalConnection.commit();
                            } else {
                                viewPTable = PhoenixRuntime.getTable(globalConnection, fullViewName);
                                globalConnection.createStatement().execute(String.format(disableIndexDDL, indexName, fullViewName));
                            }
                            if (!physicalTables.add(indexPhysicalTableName = MetaDataUtil.getViewIndexPhysicalName(viewPTable.getPhysicalName().getString())) || !admin.tableExists(tableName = TableName.valueOf((String)indexPhysicalTableName))) continue;
                            admin.disableTable(tableName);
                            admin.truncateTable(tableName, false);
                        }
                    }
                }
                if (originalScn != null) {
                    props.setProperty("CurrentSCN", Long.toString(originalScn));
                }
                toReturn = new PhoenixConnection(globalConnection, globalConnection.getQueryServices(), props);
            }
            catch (SQLException e) {
                sqlEx = e;
                return sqlEx;
            }
            finally {
                sqlEx = UpgradeUtil.closeConnection(connParam, sqlEx);
                sqlEx = UpgradeUtil.closeConnection(globalConnection, sqlEx);
                if (sqlEx == null) break block76;
                throw sqlEx;
            }
        }
        return toReturn;
    }

    public static SQLException closeConnection(PhoenixConnection conn, SQLException sqlEx) {
        SQLException toReturn = sqlEx;
        try {
            conn.close();
        }
        catch (SQLException e) {
            if (toReturn != null) {
                toReturn.setNextException(e);
            }
            toReturn = e;
        }
        return toReturn;
    }

    /*
     * Exception decompiling
     */
    public static boolean upgradeSequenceTable(PhoenixConnection conn, int nSaltBuckets, PTable oldTable) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static KeyValue addSaltByte(KeyValue keyValue, int nSaltBuckets) {
        byte[] newBuf;
        boolean isViewSeq;
        byte[] buf = keyValue.getBuffer();
        int length = keyValue.getRowLength();
        int offset = keyValue.getRowOffset();
        boolean bl = isViewSeq = length > SEQ_PREFIX_BYTES.length && Bytes.compareTo((byte[])SEQ_PREFIX_BYTES, (int)0, (int)SEQ_PREFIX_BYTES.length, (byte[])buf, (int)offset, (int)SEQ_PREFIX_BYTES.length) == 0;
        if (!isViewSeq && nSaltBuckets == 0) {
            return null;
        }
        if (isViewSeq) {
            if (buf[length - 1] == 0) {
                --length;
            }
            byte[][] rowKeyMetaData = new byte[3][];
            SchemaUtil.getVarChars(buf, offset, length, 0, rowKeyMetaData);
            byte[] schemaName = rowKeyMetaData[1];
            byte[] unprefixedSchemaName = new byte[schemaName.length - MetaDataUtil.VIEW_INDEX_SEQUENCE_PREFIX_BYTES.length];
            System.arraycopy(schemaName, MetaDataUtil.VIEW_INDEX_SEQUENCE_PREFIX_BYTES.length, unprefixedSchemaName, 0, unprefixedSchemaName.length);
            byte[] tableName = rowKeyMetaData[2];
            PName physicalName = PNameFactory.newName(unprefixedSchemaName);
            newBuf = MetaDataUtil.getViewIndexSequenceKey(tableName == null ? null : Bytes.toString((byte[])tableName), physicalName, nSaltBuckets, false).getKey();
        } else {
            newBuf = new byte[length + 1];
            System.arraycopy(buf, offset, newBuf, 1, length);
            newBuf[0] = SaltingUtil.getSaltingByte(newBuf, 1, length, nSaltBuckets);
        }
        return new KeyValue(newBuf, 0, newBuf.length, buf, keyValue.getFamilyOffset(), (int)keyValue.getFamilyLength(), buf, keyValue.getQualifierOffset(), keyValue.getQualifierLength(), keyValue.getTimestamp(), KeyValue.Type.codeToType((byte)keyValue.getType()), buf, keyValue.getValueOffset(), keyValue.getValueLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upgradeTo4_5_0(PhoenixConnection oldMetaConnection) throws SQLException {
        try (PhoenixConnection metaConnection = null;){
            metaConnection = new PhoenixConnection(oldMetaConnection, Long.MAX_VALUE);
            LOGGER.info("Upgrading metadata to support adding columns to tables with views");
            String getBaseTableAndViews = "SELECT COLUMN_FAMILY AS BASE_PHYSICAL_TABLE, TENANT_ID, TABLE_SCHEM AS VIEW_SCHEMA, TABLE_NAME AS VIEW_NAME FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE " + "COLUMN_FAMILY" + " IS NOT NULL  AND " + "COLUMN_NAME" + " IS NULL  AND " + "LINK_TYPE" + " = ? ";
            HashMap<String, ArrayList<ViewKey>> parentTableViewsMap = new HashMap<String, ArrayList<ViewKey>>();
            PreparedStatement stmt = metaConnection.prepareStatement(getBaseTableAndViews);
            Object object = null;
            try {
                stmt.setByte(1, PTable.LinkType.PHYSICAL_TABLE.getSerializedValue());
                try (ResultSet resultSet = stmt.executeQuery();){
                    while (resultSet.next()) {
                        String parentTable = resultSet.getString("BASE_PHYSICAL_TABLE");
                        String tenantId = resultSet.getString("TENANT_ID");
                        String viewSchema = resultSet.getString("VIEW_SCHEMA");
                        String viewName = resultSet.getString("VIEW_NAME");
                        ArrayList<ViewKey> viewKeysList = (ArrayList<ViewKey>)parentTableViewsMap.get(parentTable);
                        if (viewKeysList == null) {
                            viewKeysList = new ArrayList<ViewKey>();
                            parentTableViewsMap.put(parentTable, viewKeysList);
                        }
                        viewKeysList.add(new ViewKey(tenantId, viewSchema, viewName));
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (object != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            boolean clearCache = false;
            for (Map.Entry entry : parentTableViewsMap.entrySet()) {
                String physicalTable = (String)entry.getKey();
                String baseTableSchemaName = SchemaUtil.getSchemaNameFromFullName(physicalTable).equals("") ? null : SchemaUtil.getSchemaNameFromFullName(physicalTable);
                String baseTableName = SchemaUtil.getTableNameFromFullName(physicalTable);
                ArrayList<ColumnDetails> basePhysicalTableColumns = new ArrayList<ColumnDetails>();
                String fetchColumnInfoForBasePhysicalTable = "SELECT COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,COLUMN_SIZE,DECIMAL_DIGITS,ORDINAL_POSITION,SORT_ORDER,ARRAY_SIZE FROM SYSTEM.CATALOG WHERE TABLE_SCHEM %s AND TABLE_NAME = ? AND COLUMN_NAME IS NOT NULL AND LINK_TYPE IS NULL ORDER BY ORDINAL_POSITION";
                PreparedStatement stmt2 = null;
                if (baseTableSchemaName == null) {
                    fetchColumnInfoForBasePhysicalTable = String.format(fetchColumnInfoForBasePhysicalTable, "IS NULL ");
                    stmt2 = metaConnection.prepareStatement(fetchColumnInfoForBasePhysicalTable);
                    stmt2.setString(1, baseTableName);
                } else {
                    fetchColumnInfoForBasePhysicalTable = String.format(fetchColumnInfoForBasePhysicalTable, " = ? ");
                    stmt2 = metaConnection.prepareStatement(fetchColumnInfoForBasePhysicalTable);
                    stmt2.setString(1, baseTableSchemaName);
                    stmt2.setString(2, baseTableName);
                }
                try (ResultSet rs = stmt2.executeQuery();){
                    while (rs.next()) {
                        basePhysicalTableColumns.add(new ColumnDetails(rs.getString("COLUMN_FAMILY"), rs.getString("COLUMN_NAME"), rs.getInt("ORDINAL_POSITION"), rs.getInt("DATA_TYPE"), rs.getInt("COLUMN_SIZE"), rs.getInt("DECIMAL_DIGITS"), rs.getInt("SORT_ORDER"), rs.getInt("ARRAY_SIZE")));
                    }
                }
                List viewKeys = (List)entry.getValue();
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,COLUMN_SIZE,DECIMAL_DIGITS,ORDINAL_POSITION,SORT_ORDER,ARRAY_SIZE FROM SYSTEM.CATALOG WHERE COLUMN_NAME IS NOT NULL AND ORDINAL_POSITION <= ? AND (TENANT_ID, TABLE_SCHEM, TABLE_NAME) IN (");
                int numViews = viewKeys.size();
                for (int i = 0; i < numViews; ++i) {
                    sb.append(" (?, ?, ?) ");
                    if (i >= numViews - 1) continue;
                    sb.append(", ");
                }
                sb.append(" ) ");
                sb.append(" GROUP BY TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,COLUMN_SIZE,DECIMAL_DIGITS,ORDINAL_POSITION,SORT_ORDER,ARRAY_SIZE ORDER BY TENANT_ID,TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION");
                String fetchViewColumnsSql = sb.toString();
                stmt2 = metaConnection.prepareStatement(fetchViewColumnsSql);
                int numColsInBaseTable = basePhysicalTableColumns.size();
                stmt2.setInt(1, numColsInBaseTable);
                int paramIndex = 1;
                stmt2.setInt(paramIndex++, numColsInBaseTable);
                for (ViewKey view : viewKeys) {
                    stmt2.setString(paramIndex++, view.tenantId);
                    stmt2.setString(paramIndex++, view.schema);
                    stmt2.setString(paramIndex++, view.name);
                }
                String currentTenantId = null;
                String currentViewSchema = null;
                String currentViewName = null;
                try (ResultSet rs = stmt2.executeQuery();){
                    int numBaseTableColsMatched = 0;
                    boolean ignore = false;
                    boolean baseColumnCountUpserted = false;
                    while (rs.next()) {
                        int arraySize;
                        int sortOrder;
                        int decimalDigits;
                        int columnSize;
                        int dataType;
                        int ordinalPos;
                        String viewTenantId = rs.getString("TENANT_ID");
                        String viewSchema = rs.getString("TABLE_SCHEM");
                        String viewName = rs.getString("TABLE_NAME");
                        if (!(com.google.common.base.Objects.equal((Object)viewTenantId, currentTenantId) && com.google.common.base.Objects.equal((Object)viewSchema, currentViewSchema) && com.google.common.base.Objects.equal((Object)viewName, currentViewName))) {
                            if (currentViewName != null && !baseColumnCountUpserted && numBaseTableColsMatched < numColsInBaseTable) {
                                UpgradeUtil.upsertBaseColumnCountInHeaderRow(metaConnection, currentTenantId, currentViewSchema, currentViewName, -100);
                                clearCache = true;
                            }
                            numBaseTableColsMatched = 0;
                            currentTenantId = viewTenantId;
                            currentViewSchema = viewSchema;
                            currentViewName = viewName;
                            ignore = false;
                            baseColumnCountUpserted = false;
                        }
                        if (ignore) continue;
                        ColumnDetails baseTableColumn = (ColumnDetails)basePhysicalTableColumns.get(numBaseTableColsMatched);
                        String columName = rs.getString("COLUMN_NAME");
                        String columnFamily = rs.getString("COLUMN_FAMILY");
                        ColumnDetails viewColumn = new ColumnDetails(columnFamily, columName, ordinalPos = rs.getInt("ORDINAL_POSITION"), dataType = rs.getInt("DATA_TYPE"), columnSize = rs.getInt("COLUMN_SIZE"), decimalDigits = rs.getInt("DECIMAL_DIGITS"), sortOrder = rs.getInt("SORT_ORDER"), arraySize = rs.getInt("ARRAY_SIZE"));
                        if (baseTableColumn.equals(viewColumn)) {
                            if (++numBaseTableColsMatched != numColsInBaseTable) continue;
                            UpgradeUtil.upsertBaseColumnCountInHeaderRow(metaConnection, viewTenantId, viewSchema, viewName, numColsInBaseTable);
                            baseColumnCountUpserted = true;
                            clearCache = true;
                            continue;
                        }
                        UpgradeUtil.upsertBaseColumnCountInHeaderRow(metaConnection, viewTenantId, viewSchema, viewName, -100);
                        baseColumnCountUpserted = true;
                        clearCache = true;
                        ignore = true;
                    }
                }
                UpgradeUtil.upsertBaseColumnCountInHeaderRow(metaConnection, null, baseTableSchemaName, baseTableName, -1);
                metaConnection.commit();
            }
            if (clearCache) {
                metaConnection.getQueryServices().clearCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addParentToChildLinks(PhoenixConnection oldMetaConnection) throws SQLException {
        try (PhoenixConnection metaConnection = null;){
            metaConnection = new PhoenixConnection(oldMetaConnection, Long.MAX_VALUE);
            LOGGER.info("Upgrading metadata to add parent to child links for views");
            metaConnection.commit();
            String createChildLink = "UPSERT INTO SYSTEM.CATALOG(TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,LINK_TYPE)SELECT PARENT_TENANT_ID,       CASE INSTR(COLUMN_FAMILY,'.')              WHEN 0 THEN NULL              ELSE REGEXP_SUBSTR(COLUMN_FAMILY,'[^\\.]+')       END AS PARENT_SCHEMA,       CASE INSTR(COLUMN_FAMILY,'.')              WHEN 0 THEN COLUMN_FAMILY              ELSE SUBSTR(COLUMN_FAMILY,INSTR(COLUMN_FAMILY,'.')+1)       END AS PARENT_TABLE,       TENANT_ID,       CASE WHEN TABLE_SCHEM IS NULL THEN TABLE_NAME            ELSE TABLE_SCHEM||'.'||TABLE_NAME       END AS VIEW_NAME,       4 AS LINK_TYPE FROM SYSTEM.CATALOG(PARENT_TENANT_ID VARCHAR)WHERE LINK_TYPE = 2 AND TABLE_TYPE IS NULL AND (TENANT_ID, TABLE_SCHEM, TABLE_NAME) NOT IN (          SELECT TENANT_ID,               TABLE_SCHEM,               TABLE_NAME        FROM   SYSTEM.CATALOG        WHERE  LINK_TYPE = 3 )";
            metaConnection.createStatement().execute(createChildLink);
            metaConnection.commit();
            String createGrandChildLink = "UPSERT INTO SYSTEM.CATALOG(TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,LINK_TYPE)SELECT PARENT_TENANT_ID,       CASE INSTR(COLUMN_FAMILY,'.')              WHEN 0 THEN NULL              ELSE REGEXP_SUBSTR(COLUMN_FAMILY,'[^\\.]+')       END AS PARENT_SCHEMA,       CASE INSTR(COLUMN_FAMILY,'.')              WHEN 0 THEN COLUMN_FAMILY              ELSE SUBSTR(COLUMN_FAMILY,INSTR(COLUMN_FAMILY,'.')+1)       END AS PARENT_TABLE,       TENANT_ID,       CASE WHEN TABLE_SCHEM IS NULL THEN TABLE_NAME            ELSE TABLE_SCHEM||'.'||TABLE_NAME       END AS VIEW_NAME,       4 AS LINK_TYPE FROM SYSTEM.CATALOG(PARENT_TENANT_ID VARCHAR)WHERE LINK_TYPE = 3 ";
            metaConnection.createStatement().execute(createGrandChildLink);
            metaConnection.commit();
            metaConnection.getQueryServices().clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveChildLinks(PhoenixConnection oldMetaConnection) throws SQLException {
        try (PhoenixConnection metaConnection = null;){
            metaConnection = new PhoenixConnection(oldMetaConnection, Long.MAX_VALUE);
            LOGGER.info("Upgrading metadata to add parent to child links for views");
            metaConnection.commit();
            String createChildLink = "UPSERT INTO SYSTEM.CHILD_LINK(TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY, LINK_TYPE) SELECT TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY, LINK_TYPE FROM SYSTEM.CATALOG WHERE LINK_TYPE = 4";
            metaConnection.createStatement().execute(createChildLink);
            metaConnection.commit();
            String deleteChildLink = "DELETE FROM SYSTEM.CATALOG WHERE LINK_TYPE = 4 ";
            metaConnection.createStatement().execute(deleteChildLink);
            metaConnection.commit();
            metaConnection.getQueryServices().clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addViewIndexToParentLinks(PhoenixConnection oldMetaConnection) throws SQLException {
        PhoenixConnection metaConn = null;
        boolean isMetaConnUsingQueryConn = true;
        try (PhoenixConnection queryConn = new PhoenixConnection(oldMetaConnection, Long.MAX_VALUE);
             PhoenixConnection upsertConn = new PhoenixConnection(oldMetaConnection, Long.MAX_VALUE);){
            LOGGER.info("Upgrading metadata to add parent links for indexes on views");
            String indexQuery = "SELECT TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_FAMILY FROM SYSTEM.CATALOG WHERE LINK_TYPE = " + PTable.LinkType.INDEX_TABLE.getSerializedValue();
            String createViewIndexLink = "UPSERT INTO SYSTEM.CATALOG (TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_FAMILY, LINK_TYPE) VALUES (?,?,?,?,?) ";
            ResultSet rs = queryConn.createStatement().executeQuery(indexQuery);
            String prevTenantId = null;
            metaConn = queryConn;
            Properties props = new Properties(queryConn.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(Long.MAX_VALUE));
            while (rs.next()) {
                String tenantId = rs.getString("TENANT_ID");
                if (!Objects.equals(prevTenantId, tenantId)) {
                    prevTenantId = tenantId;
                    props.setProperty("TenantId", tenantId);
                    if (!isMetaConnUsingQueryConn) {
                        metaConn.close();
                    }
                    metaConn = new PhoenixConnection(oldMetaConnection, props);
                    isMetaConnUsingQueryConn = false;
                }
                String schemaName = rs.getString("TABLE_SCHEM");
                String parentTableName = rs.getString("TABLE_NAME");
                String fullParentTableName = SchemaUtil.getTableName(schemaName, parentTableName);
                String indexName = rs.getString("COLUMN_FAMILY");
                PTable table = PhoenixRuntime.getTable(metaConn, fullParentTableName);
                if (table == null) {
                    throw new TableNotFoundException(fullParentTableName);
                }
                if (!table.getType().equals((Object)PTableType.VIEW)) continue;
                PreparedStatement prepareStatement = upsertConn.prepareStatement(createViewIndexLink);
                prepareStatement.setString(1, tenantId);
                prepareStatement.setString(2, schemaName);
                prepareStatement.setString(3, indexName);
                prepareStatement.setString(4, parentTableName);
                prepareStatement.setByte(5, PTable.LinkType.VIEW_INDEX_PARENT_TABLE.getSerializedValue());
                prepareStatement.execute();
                upsertConn.commit();
            }
            queryConn.getQueryServices().clearCache();
        }
        finally {
            if (!isMetaConnUsingQueryConn) {
                metaConn.close();
            }
        }
    }

    private static HTableDescriptor syncColFamProperties(HTableDescriptor tableDesc, HColumnDescriptor defaultColFam, Map<String, Object> syncedProps) {
        HTableDescriptor newTableDesc = new HTableDescriptor(tableDesc);
        for (HColumnDescriptor currentColFam : tableDesc.getColumnFamilies()) {
            if (currentColFam.equals((Object)defaultColFam)) continue;
            HColumnDescriptor newColFamDesc = new HColumnDescriptor(currentColFam);
            for (String prop : MetaDataUtil.SYNCED_DATA_TABLE_AND_INDEX_COL_FAM_PROPERTIES) {
                String existingPropVal = Bytes.toString((byte[])currentColFam.getValue(Bytes.toBytes((String)prop)));
                String expectedPropVal = syncedProps.get(prop).toString();
                if (existingPropVal != null && existingPropVal.toLowerCase().equals(expectedPropVal.toLowerCase())) continue;
                newColFamDesc.setValue(prop, expectedPropVal);
            }
            if (newColFamDesc.equals((Object)currentColFam)) continue;
            newTableDesc.modifyFamily(newColFamDesc);
        }
        return newTableDesc;
    }

    private static void addTableDescIfPropsChanged(HTableDescriptor origTableDesc, HColumnDescriptor defaultColFam, Map<String, Object> syncedProps, Set<HTableDescriptor> tableDescsToSync) throws SQLException {
        HTableDescriptor newTableDesc = UpgradeUtil.syncColFamProperties(origTableDesc, defaultColFam, syncedProps);
        if (!origTableDesc.equals((Object)newTableDesc)) {
            tableDescsToSync.add(newTableDesc);
        }
    }

    private static void syncGlobalIndexesForTable(ConnectionQueryServices cqs, PTable baseTable, HColumnDescriptor defaultColFam, Map<String, Object> syncedProps, Set<HTableDescriptor> tableDescsToSync) throws SQLException {
        for (PTable indexTable : baseTable.getIndexes()) {
            if (indexTable.getIndexType() != PTable.IndexType.GLOBAL) continue;
            UpgradeUtil.addTableDescIfPropsChanged(cqs.getTableDescriptor(indexTable.getPhysicalName().getBytes()), defaultColFam, syncedProps, tableDescsToSync);
        }
    }

    private static void syncViewIndexTable(ConnectionQueryServices cqs, PTable baseTable, HColumnDescriptor defaultColFam, Map<String, Object> syncedProps, Set<HTableDescriptor> tableDescsToSync) throws SQLException {
        String viewIndexName = MetaDataUtil.getViewIndexPhysicalName(baseTable.getPhysicalName().getString());
        if (!Strings.isNullOrEmpty((String)viewIndexName)) {
            try {
                UpgradeUtil.addTableDescIfPropsChanged(cqs.getTableDescriptor(Bytes.toBytes((String)viewIndexName)), defaultColFam, syncedProps, tableDescsToSync);
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
        }
    }

    private static void syncUpdateCacheFreqForIndexesOfTable(PTable baseTable, PreparedStatement stmt, String tenantId) throws SQLException {
        for (PTable index : baseTable.getIndexes()) {
            if (index.getUpdateCacheFrequency() == baseTable.getUpdateCacheFrequency()) continue;
            stmt.setString(1, tenantId);
            stmt.setString(2, index.getSchemaName().getString());
            stmt.setString(3, index.getTableName().getString());
            stmt.setLong(4, baseTable.getUpdateCacheFrequency());
            stmt.addBatch();
        }
    }

    public static void syncUpdateCacheFreqAllIndexes(PhoenixConnection conn, PTable table) throws SQLException, IOException {
        try (PhoenixConnection newConn = new PhoenixConnection(conn, Long.MAX_VALUE);){
            newConn.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
            byte[] tenantId = newConn.getTenantId() != null ? newConn.getTenantId().getBytes() : null;
            PreparedStatement stmt = newConn.prepareStatement(UPSERT_UPDATE_CACHE_FREQUENCY);
            UpgradeUtil.syncUpdateCacheFreqForIndexesOfTable(table, stmt, Bytes.toString((byte[])tenantId));
            TableViewFinderResult childViewsResult = new TableViewFinderResult();
            for (int i = 0; i < 2; ++i) {
                try (HTableInterface sysCatOrSysChildLinkTable = newConn.getQueryServices().getTable(SchemaUtil.getPhysicalName(i == 0 ? PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES : PhoenixDatabaseMetaData.SYSTEM_CATALOG_TABLE_BYTES, newConn.getQueryServices().getProps()).getName());){
                    ViewUtil.findAllRelatives((Table)sysCatOrSysChildLinkTable, tenantId, table.getSchemaName().getBytes(), table.getTableName().getBytes(), PTable.LinkType.CHILD_TABLE, childViewsResult);
                    for (TableInfo tableInfo : childViewsResult.getLinks()) {
                        UpgradeUtil.getViewAndSyncCacheFreqForIndexes(newConn, stmt, tableInfo);
                    }
                    break;
                }
                catch (TableNotFoundException ex) {
                    if (i != 1) continue;
                    throw ex;
                }
            }
            stmt.executeBatch();
            newConn.commit();
        }
    }

    private static void getViewAndSyncCacheFreqForIndexes(PhoenixConnection newConn, PreparedStatement stmt, TableInfo tableInfo) throws SQLException {
        PTable view;
        String viewName = SchemaUtil.getTableName(tableInfo.getSchemaName(), tableInfo.getTableName());
        String viewTenantId = Bytes.toString((byte[])tableInfo.getTenantId());
        if (StringUtils.isNotEmpty((String)viewTenantId)) {
            Properties props = new Properties(newConn.getClientInfo());
            props.setProperty("TenantId", viewTenantId);
            try (PhoenixConnection tenantConn = new PhoenixConnection(newConn, props);){
                view = UpgradeUtil.resolveView(viewName, tenantConn);
            }
        } else {
            view = UpgradeUtil.resolveView(viewName, newConn);
        }
        if (view != null) {
            UpgradeUtil.syncUpdateCacheFreqForIndexesOfTable(view, stmt, viewTenantId);
        }
    }

    private static PTable resolveView(String viewName, PhoenixConnection conn) throws SQLException {
        PTable view;
        try {
            view = PhoenixRuntime.getTable(conn, viewName);
        }
        catch (TableNotFoundException e) {
            LOGGER.error("Error getting PTable for view: {}", (Object)viewName, (Object)e);
            return null;
        }
        return view;
    }

    public static void syncTableAndIndexProperties(PhoenixConnection conn) throws SQLException, IOException {
        try (HBaseAdmin admin = conn.getQueryServices().getAdmin();){
            HashSet<HTableDescriptor> tableDescriptorsToSynchronize = new HashSet<HTableDescriptor>();
            for (HTableDescriptor origTableDesc : admin.listTables()) {
                PTable table;
                if (MetaDataUtil.isViewIndex(origTableDesc.getTableName().getNameWithNamespaceInclAsString())) continue;
                String fullTableName = SchemaUtil.getPhysicalTableName(origTableDesc.getTableName().getName(), SchemaUtil.isNamespaceMappingEnabled(null, conn.getQueryServices().getProps())).getNameAsString();
                try {
                    table = PhoenixRuntime.getTable(conn, null, fullTableName);
                }
                catch (TableNotFoundException e) {
                    LOGGER.warn("Error getting PTable for HBase table: {}", (Object)fullTableName);
                    continue;
                }
                if (table.getType() == PTableType.INDEX) continue;
                UpgradeUtil.syncUpdateCacheFreqAllIndexes(conn, table);
                HColumnDescriptor defaultColFam = origTableDesc.getFamily(SchemaUtil.getEmptyColumnFamily(table));
                Map<String, Object> syncedProps = MetaDataUtil.getSyncedProps(defaultColFam);
                UpgradeUtil.addTableDescIfPropsChanged(origTableDesc, defaultColFam, syncedProps, tableDescriptorsToSynchronize);
                UpgradeUtil.syncGlobalIndexesForTable(conn.getQueryServices(), table, defaultColFam, syncedProps, tableDescriptorsToSynchronize);
                UpgradeUtil.syncViewIndexTable(conn.getQueryServices(), table, defaultColFam, syncedProps, tableDescriptorsToSynchronize);
            }
            for (HTableDescriptor t : tableDescriptorsToSynchronize) {
                admin.modifyTable(t.getTableName(), t);
            }
        }
    }

    private static void upsertBaseColumnCountInHeaderRow(PhoenixConnection metaConnection, String tenantId, String schemaName, String viewOrTableName, int baseColumnCount) throws SQLException {
        try (PreparedStatement stmt = metaConnection.prepareStatement(UPSERT_BASE_COLUMN_COUNT_IN_HEADER_ROW);){
            stmt.setString(1, tenantId);
            stmt.setString(2, schemaName);
            stmt.setString(3, viewOrTableName);
            stmt.setString(4, null);
            stmt.setString(5, null);
            stmt.setInt(6, baseColumnCount);
            stmt.executeUpdate();
        }
    }

    private static String getTableRVC(List<String> tableNames) {
        StringBuilder query = new StringBuilder("(");
        for (int i = 0; i < tableNames.size(); i += 3) {
            String tenantId = tableNames.get(i);
            String schemaName = tableNames.get(i + 1);
            String tableName = tableNames.get(i + 2);
            query.append('(');
            query.append(tenantId == null ? "null" : "'" + tenantId + "'");
            query.append(',');
            query.append(schemaName == null ? "null" : "'" + schemaName + "'");
            query.append(',');
            query.append("'" + tableName + "'");
            query.append("),");
        }
        query.setCharAt(query.length() - 1, ')');
        return query.toString();
    }

    private static List<String> addPhysicalTables(PhoenixConnection conn, ResultSet rs, PTableType otherType, Set<String> physicalTables) throws SQLException {
        ArrayList tableNames = Lists.newArrayListWithExpectedSize((int)1024);
        while (rs.next()) {
            tableNames.add(rs.getString(1));
            tableNames.add(rs.getString(2));
            tableNames.add(rs.getString(3));
        }
        if (tableNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList otherTables = Lists.newArrayListWithExpectedSize((int)tableNames.size());
        String query = "SELECT TENANT_ID,TABLE_SCHEM,TABLE_NAME,TABLE_TYPE\nFROM SYSTEM.CATALOG (ROW_KEY_ORDER_OPTIMIZABLE BOOLEAN)\nWHERE COLUMN_NAME IS NULL\nAND COLUMN_FAMILY IS NULL\nAND ROW_KEY_ORDER_OPTIMIZABLE IS NULL\nAND TABLE_TYPE IN ('" + PTableType.TABLE.getSerializedValue() + "','" + otherType.getSerializedValue() + "')\nAND (TENANT_ID, TABLE_SCHEM, TABLE_NAME) IN " + UpgradeUtil.getTableRVC(tableNames);
        rs = conn.createStatement().executeQuery(query);
        while (rs.next()) {
            if (PTableType.TABLE.getSerializedValue().equals(rs.getString(4))) {
                physicalTables.add(SchemaUtil.getTableName(rs.getString(2), rs.getString(3)));
                continue;
            }
            otherTables.add(rs.getString(1));
            otherTables.add(rs.getString(2));
            otherTables.add(rs.getString(3));
        }
        return otherTables;
    }

    private static String getAffectedDataTypes() {
        StringBuilder buf = new StringBuilder("(" + PVarchar.INSTANCE.getSqlType() + "," + PChar.INSTANCE.getSqlType() + "," + PBinary.INSTANCE.getSqlType() + "," + PFloat.INSTANCE.getSqlType() + "," + PDouble.INSTANCE.getSqlType() + "," + PDecimal.INSTANCE.getSqlType() + ",");
        for (PDataType type : PDataType.values()) {
            if (!type.isArrayType()) continue;
            buf.append(type.getSqlType());
            buf.append(',');
        }
        buf.setCharAt(buf.length() - 1, ')');
        return buf.toString();
    }

    public static List<String> getPhysicalTablesWithDescVarbinaryRowKey(PhoenixConnection conn) throws SQLException {
        String query = "SELECT TENANT_ID,TABLE_SCHEM,TABLE_NAME\nFROM SYSTEM.CATALOG cat1\nWHERE COLUMN_NAME IS NOT NULL\nAND COLUMN_FAMILY IS NULL\nAND SORT_ORDER = " + SortOrder.DESC.getSystemValue() + "\nAND DATA_TYPE = " + PVarbinary.INSTANCE.getSqlType() + "\nGROUP BY TENANT_ID,TABLE_SCHEM,TABLE_NAME";
        return UpgradeUtil.getPhysicalTablesWithDescRowKey(query, conn);
    }

    public static List<String> getPhysicalTablesWithDescRowKey(PhoenixConnection conn) throws SQLException {
        String query = "SELECT TENANT_ID,TABLE_SCHEM,TABLE_NAME\nFROM SYSTEM.CATALOG cat1\nWHERE COLUMN_NAME IS NOT NULL\nAND COLUMN_FAMILY IS NULL\nAND ( ( SORT_ORDER = " + SortOrder.DESC.getSystemValue() + "\n        AND DATA_TYPE IN " + UpgradeUtil.getAffectedDataTypes() + ")\n    OR ( SORT_ORDER = " + SortOrder.ASC.getSystemValue() + "\n         AND DATA_TYPE = " + PBinary.INSTANCE.getSqlType() + "\n         AND COLUMN_SIZE > 1 ) )\nGROUP BY TENANT_ID,TABLE_SCHEM,TABLE_NAME";
        return UpgradeUtil.getPhysicalTablesWithDescRowKey(query, conn);
    }

    private static List<String> getPhysicalTablesWithDescRowKey(String query, PhoenixConnection conn) throws SQLException {
        HashSet physicalTables;
        ResultSet rs = conn.createStatement().executeQuery(query);
        List<String> remainingTableNames = UpgradeUtil.addPhysicalTables(conn, rs, PTableType.INDEX, physicalTables = Sets.newHashSetWithExpectedSize((int)1024));
        if (!remainingTableNames.isEmpty()) {
            String indexLinkQuery = "SELECT TENANT_ID,TABLE_SCHEM,TABLE_NAME\nFROM SYSTEM.CATALOG\nWHERE COLUMN_NAME IS NULL\nAND (TENANT_ID, TABLE_SCHEM, COLUMN_FAMILY) IN " + UpgradeUtil.getTableRVC(remainingTableNames) + "\nAND LINK_TYPE = " + PTable.LinkType.INDEX_TABLE.getSerializedValue();
            rs = conn.createStatement().executeQuery(indexLinkQuery);
            remainingTableNames = UpgradeUtil.addPhysicalTables(conn, rs, PTableType.VIEW, physicalTables);
            if (!remainingTableNames.isEmpty()) {
                String physicalLinkQuery = "SELECT null,  CASE WHEN INSTR(COLUMN_FAMILY,'.') = 0 THEN NULL ELSE SUBSTR(COLUMN_FAMILY,1,INSTR(COLUMN_FAMILY,'.')) END,\n CASE WHEN INSTR(COLUMN_FAMILY,'.') = 0 THEN COLUMN_FAMILY ELSE SUBSTR(COLUMN_FAMILY,INSTR(COLUMN_FAMILY,'.')+1) END\nFROM SYSTEM.CATALOG\nWHERE COLUMN_NAME IS NULL\nAND COLUMN_FAMILY IS NOT NULL\nAND (TENANT_ID, TABLE_SCHEM, TABLE_NAME) IN " + UpgradeUtil.getTableRVC(remainingTableNames) + "\nAND LINK_TYPE = " + PTable.LinkType.PHYSICAL_TABLE.getSerializedValue();
                rs = conn.createStatement().executeQuery(physicalLinkQuery);
                UpgradeUtil.addPhysicalTables(conn, rs, PTableType.TABLE, physicalTables);
            }
        }
        ArrayList<String> sortedPhysicalTables = new ArrayList<String>(physicalTables);
        Collections.sort(sortedPhysicalTables);
        return sortedPhysicalTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void upgradeDescVarLengthRowKeys(PhoenixConnection upgradeConn, PhoenixConnection globalConn, String schemaName, String tableName, boolean isTable, boolean bypassUpgrade) throws SQLException {
        String physicalName = SchemaUtil.getTableName(schemaName, tableName);
        long currentTime = EnvironmentEdgeManager.currentTimeMillis();
        String snapshotName = physicalName + "_" + currentTime;
        HBaseAdmin admin = null;
        if (isTable && !bypassUpgrade) {
            admin = globalConn.getQueryServices().getAdmin();
        }
        boolean restoreSnapshot = false;
        boolean success = false;
        try {
            String theTableName;
            String theSchemaName;
            String theTenantId;
            int i;
            ResultSet rs;
            if (isTable && !bypassUpgrade) {
                String msg = "Taking snapshot of physical table " + physicalName + " prior to upgrade...";
                System.out.println(msg);
                LOGGER.info(msg);
                admin.disableTable(physicalName);
                admin.snapshot(snapshotName, physicalName);
                admin.enableTable(physicalName);
                restoreSnapshot = true;
            }
            String escapedTableName = SchemaUtil.getEscapedTableName(schemaName, tableName);
            String tenantInfo = "";
            PName tenantId = PName.EMPTY_NAME;
            if (upgradeConn.getTenantId() != null) {
                tenantId = upgradeConn.getTenantId();
                tenantInfo = " for tenant " + tenantId.getString();
            }
            String msg = "Starting upgrade of " + escapedTableName + tenantInfo + "...";
            System.out.println(msg);
            LOGGER.info(msg);
            if (!bypassUpgrade) {
                rs = upgradeConn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ count(*) FROM " + escapedTableName);
                rs.next();
            }
            ArrayList tableNames = Lists.newArrayListWithExpectedSize((int)1024);
            tableNames.add(tenantId == PName.EMPTY_NAME ? null : tenantId.getString());
            tableNames.add(schemaName);
            tableNames.add(tableName);
            if (isTable) {
                String query = "SELECT TENANT_ID,TABLE_SCHEM,TABLE_NAME\nFROM SYSTEM.CATALOG\nWHERE COLUMN_NAME IS NULL\nAND COLUMN_FAMILY = '" + physicalName + "'AND LINK_TYPE = " + PTable.LinkType.PHYSICAL_TABLE.getSerializedValue();
                rs = globalConn.createStatement().executeQuery(query);
                while (rs.next()) {
                    tableNames.add(rs.getString(1));
                    tableNames.add(rs.getString(2));
                    tableNames.add(rs.getString(3));
                }
            }
            for (i = 0; i < tableNames.size(); i += 3) {
                theTenantId = (String)tableNames.get(i);
                theSchemaName = (String)tableNames.get(i + 1);
                theTableName = (String)tableNames.get(i + 2);
                globalConn.createStatement().execute("UPSERT INTO " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " (" + "TENANT_ID" + "," + "TABLE_SCHEM" + "," + "TABLE_NAME" + "," + "ROW_KEY_ORDER_OPTIMIZABLE" + " BOOLEAN) VALUES ('" + (theTenantId == null ? "" : theTenantId) + "','" + (theSchemaName == null ? "" : theSchemaName) + "','" + theTableName + "',TRUE)");
            }
            globalConn.commit();
            for (i = 0; i < tableNames.size(); i += 3) {
                theTenantId = (String)tableNames.get(i);
                theSchemaName = (String)tableNames.get(i + 1);
                theTableName = (String)tableNames.get(i + 2);
                globalConn.getQueryServices().clearTableFromCache(theTenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)theTenantId), theSchemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes((String)schemaName), Bytes.toBytes((String)theTableName), Long.MAX_VALUE);
            }
            success = true;
            msg = "Completed upgrade of " + escapedTableName + tenantInfo;
            System.out.println(msg);
            LOGGER.info(msg);
        }
        catch (Exception e) {
            LOGGER.error("Exception during upgrade of " + physicalName + ":", (Throwable)e);
        }
        finally {
            boolean restored = false;
            try {
                if (!success && restoreSnapshot) {
                    admin.disableTable(physicalName);
                    admin.restoreSnapshot(snapshotName, false);
                    admin.enableTable(physicalName);
                    String msg = "Restored snapshot of " + physicalName + " due to failure of upgrade";
                    System.out.println(msg);
                    LOGGER.info(msg);
                }
                restored = true;
            }
            catch (Exception e) {
                LOGGER.warn("Unable to restoring snapshot " + snapshotName + " after failed upgrade", (Throwable)e);
            }
            finally {
                try {
                    if (restoreSnapshot && restored) {
                        admin.deleteSnapshot(snapshotName);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to delete snapshot " + snapshotName + " after upgrade:", (Throwable)e);
                }
                finally {
                    try {
                        if (admin != null) {
                            admin.close();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.warn("Unable to close admin after upgrade:", (Throwable)e);
                    }
                }
            }
        }
    }

    private static boolean isInvalidTableToUpgrade(PTable table) throws SQLException {
        return table.getType() != PTableType.TABLE || table.getTenantId() != null || !table.getPhysicalName().equals(table.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upgradeDescVarLengthRowKeys(PhoenixConnection conn, List<String> tablesToUpgrade, boolean bypassUpgrade) throws SQLException {
        if (tablesToUpgrade.isEmpty()) {
            return;
        }
        ArrayList tablesNeedingUpgrading = Lists.newArrayListWithExpectedSize((int)tablesToUpgrade.size());
        ArrayList invalidTables = Lists.newArrayListWithExpectedSize((int)tablesToUpgrade.size());
        for (String fullTableName : tablesToUpgrade) {
            PTable table = PhoenixRuntime.getTable(conn, fullTableName);
            if (UpgradeUtil.isInvalidTableToUpgrade(table)) {
                invalidTables.add(fullTableName);
                continue;
            }
            tablesNeedingUpgrading.add(table);
        }
        if (!invalidTables.isEmpty()) {
            StringBuilder buf = new StringBuilder("Only physical tables should be upgraded as their views and indexes will be updated with them: ");
            for (String fullTableName : invalidTables) {
                buf.append(fullTableName);
                buf.append(' ');
            }
            throw new SQLException(buf.toString());
        }
        try (PhoenixConnection upgradeConn = new PhoenixConnection(conn, true, true);){
            upgradeConn.setAutoCommit(true);
            for (PTable table : tablesNeedingUpgrading) {
                boolean wasUpgraded = false;
                if (!table.rowKeyOrderOptimizable()) {
                    wasUpgraded = true;
                    UpgradeUtil.upgradeDescVarLengthRowKeys(upgradeConn, conn, table.getSchemaName().getString(), table.getTableName().getString(), true, bypassUpgrade);
                }
                for (PTable index : table.getIndexes()) {
                    if (index.rowKeyOrderOptimizable() || index.getIndexType() == PTable.IndexType.LOCAL) continue;
                    wasUpgraded = true;
                    UpgradeUtil.upgradeDescVarLengthRowKeys(upgradeConn, conn, index.getSchemaName().getString(), index.getTableName().getString(), false, bypassUpgrade);
                }
                String sharedViewIndexName = Bytes.toString((byte[])MetaDataUtil.getViewIndexPhysicalName(table.getName().getBytes()));
                wasUpgraded |= UpgradeUtil.upgradeSharedIndex(upgradeConn, conn, sharedViewIndexName, bypassUpgrade);
                String sharedLocalIndexName = Bytes.toString((byte[])MetaDataUtil.getLocalIndexPhysicalName(table.getName().getBytes()));
                if (wasUpgraded |= UpgradeUtil.upgradeSharedIndex(upgradeConn, conn, sharedLocalIndexName, bypassUpgrade)) continue;
                System.out.println("Upgrade not required for this table or its indexes: " + table.getName().getString());
            }
        }
    }

    private static boolean upgradeSharedIndex(PhoenixConnection upgradeConn, PhoenixConnection globalConn, String physicalName, boolean bypassUpgrade) throws SQLException {
        String query = "SELECT TENANT_ID,TABLE_SCHEM,TABLE_NAME\nFROM SYSTEM.CATALOG cat1\nWHERE COLUMN_NAME IS NULL\nAND COLUMN_FAMILY = '" + physicalName + "'\nAND LINK_TYPE = " + PTable.LinkType.PHYSICAL_TABLE.getSerializedValue() + "\nORDER BY TENANT_ID";
        ResultSet rs = globalConn.createStatement().executeQuery(query);
        String lastTenantId = null;
        Connection conn = globalConn;
        String url = globalConn.getURL();
        boolean wasUpgraded = false;
        while (rs.next()) {
            PTable table;
            String tableTenantId;
            String fullTableName = SchemaUtil.getTableName(rs.getString("TABLE_SCHEM"), rs.getString("TABLE_NAME"));
            String tenantId = rs.getString(1);
            if (tenantId != null && !tenantId.equals(lastTenantId)) {
                if (lastTenantId != null) {
                    conn.close();
                }
                Properties props = new Properties(globalConn.getClientInfo());
                props.setProperty("TenantId", tenantId);
                conn = DriverManager.getConnection(url, props);
                lastTenantId = tenantId;
            }
            if (!com.google.common.base.Objects.equal(lastTenantId, (Object)(tableTenantId = (table = PhoenixRuntime.getTable(conn, fullTableName)).getTenantId() == null ? null : table.getTenantId().getString())) || table.rowKeyOrderOptimizable()) continue;
            UpgradeUtil.upgradeDescVarLengthRowKeys(upgradeConn, globalConn, table.getSchemaName().getString(), table.getTableName().getString(), false, bypassUpgrade);
            wasUpgraded = true;
        }
        rs.close();
        if (lastTenantId != null) {
            conn.close();
        }
        return wasUpgraded;
    }

    public static void addRowKeyOrderOptimizableCell(List<Mutation> tableMetadata, byte[] tableHeaderRowKey, long clientTimeStamp) {
        Put put = new Put(tableHeaderRowKey, clientTimeStamp);
        put.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, MetaDataEndpointImpl.ROW_KEY_ORDER_OPTIMIZABLE_BYTES, PBoolean.INSTANCE.toBytes(true));
        tableMetadata.add((Mutation)put);
    }

    public static boolean truncateStats(Table metaTable, Table statsTable) throws IOException, InterruptedException {
        long timestamp;
        byte[] statsTableKey = SchemaUtil.getTableKey(null, "SYSTEM", "STATS");
        List columnCells = metaTable.get(new Get(statsTableKey)).getColumnCells(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES);
        if (!columnCells.isEmpty() && (timestamp = ((Cell)columnCells.get(0)).getTimestamp()) < 15L) {
            KeyValue upgradeKV = KeyValueUtil.newKeyValue(statsTableKey, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, UPGRADE_TO_4_7_COLUMN_NAME, timestamp, PBoolean.INSTANCE.toBytes(true));
            Put upgradePut = new Put(statsTableKey);
            upgradePut.add((Cell)upgradeKV);
            if (metaTable.checkAndPut(statsTableKey, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, UPGRADE_TO_4_7_COLUMN_NAME, null, upgradePut)) {
                Result r;
                ArrayList mutations = Lists.newArrayListWithExpectedSize((int)1000);
                Scan scan = new Scan();
                scan.setRaw(true);
                scan.setMaxVersions();
                ResultScanner statsScanner = statsTable.getScanner(scan);
                mutations.clear();
                int count = 0;
                while ((r = statsScanner.next()) != null) {
                    Delete delete = null;
                    for (KeyValue keyValue : r.raw()) {
                        if (KeyValue.Type.codeToType((byte)keyValue.getType()) != KeyValue.Type.Put) continue;
                        if (delete == null) {
                            delete = new Delete(keyValue.getRow());
                        }
                        KeyValue deleteKeyValue = new KeyValue(keyValue.getRowArray(), keyValue.getRowOffset(), (int)keyValue.getRowLength(), keyValue.getFamilyArray(), keyValue.getFamilyOffset(), (int)keyValue.getFamilyLength(), keyValue.getQualifierArray(), keyValue.getQualifierOffset(), keyValue.getQualifierLength(), keyValue.getTimestamp(), KeyValue.Type.Delete, ByteUtil.EMPTY_BYTE_ARRAY, 0, 0);
                        delete.addDeleteMarker((Cell)deleteKeyValue);
                    }
                    if (delete == null) continue;
                    mutations.add(delete);
                    if (count > 10) {
                        statsTable.batch((List)mutations);
                        mutations.clear();
                        count = 0;
                    }
                    ++count;
                }
                if (!mutations.isEmpty()) {
                    statsTable.batch((List)mutations);
                }
                return true;
            }
        }
        return false;
    }

    private static void mapTableToNamespace(HBaseAdmin admin, Table metatable, String srcTableName, String destTableName, ReadOnlyProps props, Long ts, String phoenixTableName, PTableType pTableType, PName tenantId) throws SnapshotCreationException, IllegalArgumentException, IOException, InterruptedException, SQLException {
        srcTableName = SchemaUtil.normalizeIdentifier(srcTableName);
        if (!SchemaUtil.isNamespaceMappingEnabled(pTableType, props)) {
            throw new IllegalArgumentException(SchemaUtil.isSystemTable(srcTableName.getBytes()) ? "For system table phoenix.schema.mapSystemTablesToNamespace also needs to be enabled along with phoenix.schema.isNamespaceMappingEnabled" : "phoenix.schema.isNamespaceMappingEnabled is not enabled");
        }
        UpgradeUtil.mapTableToNamespace(admin, srcTableName, destTableName, pTableType);
        byte[] tableKey = SchemaUtil.getTableKey(tenantId != null ? tenantId.getString() : null, SchemaUtil.getSchemaNameFromFullName(phoenixTableName), SchemaUtil.getTableNameFromFullName(phoenixTableName));
        List columnCells = metatable.get(new Get(tableKey)).getColumnCells(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES);
        if (ts == null) {
            if (!columnCells.isEmpty()) {
                ts = ((Cell)columnCells.get(0)).getTimestamp();
            } else if (PTableType.SYSTEM != pTableType) {
                throw new IllegalArgumentException("Timestamp passed is null and cannot derive timestamp for " + tableKey + " from meta table!!");
            }
        }
        if (ts != null) {
            LOGGER.info(String.format("Updating meta information of phoenix table '%s' to map to namespace..", phoenixTableName));
            Put put = new Put(tableKey, ts.longValue());
            put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.IS_NAMESPACE_MAPPED_BYTES, PBoolean.INSTANCE.toBytes(Boolean.TRUE));
            metatable.put(put);
        }
    }

    public static void mapTableToNamespace(HBaseAdmin admin, String srcTableName, String destTableName, PTableType pTableType) throws IOException {
        boolean srcTableExists = admin.tableExists(srcTableName);
        if (srcTableExists && (PTableType.TABLE.equals((Object)pTableType) || PTableType.INDEX.equals((Object)pTableType) || PTableType.SYSTEM.equals((Object)pTableType))) {
            boolean destTableExists = admin.tableExists(destTableName);
            if (!destTableExists) {
                String snapshotName = "_UPGRADING_TABLE_" + srcTableName;
                LOGGER.info("Disabling table " + srcTableName + " ..");
                admin.disableTable(srcTableName);
                LOGGER.info(String.format("Taking snapshot %s of table %s..", snapshotName, srcTableName));
                admin.snapshot(snapshotName, srcTableName);
                LOGGER.info(String.format("Restoring snapshot %s in destination table %s..", snapshotName, destTableName));
                admin.cloneSnapshot(Bytes.toBytes((String)snapshotName), Bytes.toBytes((String)destTableName));
                LOGGER.info(String.format("deleting old table %s..", srcTableName));
                admin.deleteTable(srcTableName);
                LOGGER.info(String.format("deleting snapshot %s..", snapshotName));
                admin.deleteSnapshot(snapshotName);
            } else {
                LOGGER.info(String.format("Destination Table %s already exists. No migration needed.", destTableName));
            }
        }
    }

    public static void mapTableToNamespace(HBaseAdmin admin, Table metatable, String tableName, ReadOnlyProps props, Long ts, PTableType pTableType, PName tenantId) throws IllegalArgumentException, IOException, InterruptedException, SQLException {
        String destTablename = SchemaUtil.normalizeIdentifier(SchemaUtil.getPhysicalTableName(tableName, props).getNameAsString());
        UpgradeUtil.mapTableToNamespace(admin, metatable, tableName, destTablename, props, ts, tableName, pTableType, tenantId);
    }

    public static void upgradeTable(PhoenixConnection conn, String srcTable) throws SQLException, IllegalArgumentException, IOException, InterruptedException {
        ReadOnlyProps readOnlyProps = conn.getQueryServices().getProps();
        if (conn.getSchema() != null) {
            throw new IllegalArgumentException("Schema should not be set for connection!!");
        }
        if (!SchemaUtil.isNamespaceMappingEnabled(PTableType.TABLE, readOnlyProps)) {
            throw new IllegalArgumentException("phoenix.schema.isNamespaceMappingEnabled is not enabled!!");
        }
        try (HBaseAdmin admin = conn.getQueryServices().getAdmin();
             HTableInterface metatable = conn.getQueryServices().getTable(SchemaUtil.getPhysicalName(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, readOnlyProps).getName());){
            String fullTableName = SchemaUtil.normalizeIdentifier(srcTable);
            String schemaName = SchemaUtil.getSchemaNameFromFullName(fullTableName);
            String tableName = SchemaUtil.getTableNameFromFullName(fullTableName);
            PTable table = PhoenixRuntime.getTable(conn, fullTableName);
            if (schemaName.equals("") && !PTableType.VIEW.equals((Object)table.getType())) {
                throw new IllegalArgumentException("Table doesn't have schema name");
            }
            if (table.isNamespaceMapped()) {
                throw new IllegalArgumentException("Table is already upgraded");
            }
            if (!schemaName.equals("")) {
                LOGGER.info(String.format("Creating schema %s..", schemaName));
                conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
            }
            String oldPhysicalName = table.getPhysicalName().getString();
            String newPhysicalTablename = SchemaUtil.normalizeIdentifier(SchemaUtil.getPhysicalTableName(oldPhysicalName, readOnlyProps).getNameAsString());
            LOGGER.info(String.format("Upgrading %s %s..", new Object[]{table.getType(), fullTableName}));
            LOGGER.info(String.format("oldPhysicalName %s newPhysicalTablename %s..", oldPhysicalName, newPhysicalTablename));
            LOGGER.info(String.format("teanantId %s..", conn.getTenantId()));
            TableViewFinderResult childViewsResult = new TableViewFinderResult();
            for (int i = 0; i < 2; ++i) {
                try {
                    HTableInterface sysCatOrSysChildLinkTable = conn.getQueryServices().getTable(SchemaUtil.getPhysicalName(i == 0 ? PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME_BYTES : PhoenixDatabaseMetaData.SYSTEM_CATALOG_TABLE_BYTES, readOnlyProps).getName());
                    Object object = null;
                    try {
                        byte[] tenantId = conn.getTenantId() != null ? conn.getTenantId().getBytes() : null;
                        ViewUtil.findAllRelatives((Table)sysCatOrSysChildLinkTable, tenantId, schemaName.getBytes(), tableName.getBytes(), PTable.LinkType.CHILD_TABLE, childViewsResult);
                        break;
                    }
                    catch (Throwable tenantId) {
                        object = tenantId;
                        throw tenantId;
                    }
                    finally {
                        if (sysCatOrSysChildLinkTable != null) {
                            if (object != null) {
                                try {
                                    sysCatOrSysChildLinkTable.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                sysCatOrSysChildLinkTable.close();
                            }
                        }
                    }
                }
                catch (TableNotFoundException ex) {
                    if (i != 1) continue;
                    throw ex;
                }
            }
            UpgradeUtil.mapTableToNamespace(admin, (Table)metatable, fullTableName, newPhysicalTablename, readOnlyProps, PhoenixRuntime.getCurrentScn(readOnlyProps), fullTableName, table.getType(), conn.getTenantId());
            conn.removeTable(conn.getTenantId(), fullTableName, table.getParentName() != null ? table.getParentName().getString() : null, table.getTimeStamp());
            byte[] tenantIdBytes = conn.getTenantId() == null ? ByteUtil.EMPTY_BYTE_ARRAY : conn.getTenantId().getBytes();
            conn.getQueryServices().clearTableFromCache(tenantIdBytes, table.getSchemaName().getBytes(), table.getTableName().getBytes(), PhoenixRuntime.getCurrentScn(readOnlyProps));
            MetaDataProtocol.MetaDataMutationResult result = new MetaDataClient(conn).updateCache(conn.getTenantId(), schemaName, tableName, true);
            if (result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                throw new TableNotFoundException(schemaName, fullTableName);
            }
            table = result.getTable();
            if (table.isNamespaceMapped()) {
                for (PTable index : table.getIndexes()) {
                    String srcTableName = index.getPhysicalName().getString();
                    String destTableName = null;
                    String phoenixTableName = index.getName().getString();
                    boolean updateLink = true;
                    if (srcTableName.contains(":")) {
                        LOGGER.info(String.format("skipping as it seems index '%s' is already upgraded..", index.getName()));
                        continue;
                    }
                    if (MetaDataUtil.isLocalIndex(srcTableName)) {
                        LOGGER.info(String.format("local index '%s' found with physical hbase table name ''..", index.getName(), srcTableName));
                        destTableName = Bytes.toString((byte[])MetaDataUtil.getLocalIndexPhysicalName(newPhysicalTablename.getBytes()));
                        conn.createStatement().execute(String.format("ALTER TABLE %s set PARENT_TABLE='%s'", phoenixTableName, table.getPhysicalName()));
                    } else if (MetaDataUtil.isViewIndex(srcTableName)) {
                        LOGGER.info(String.format("View index '%s' found with physical hbase table name ''..", index.getName(), srcTableName));
                        destTableName = Bytes.toString((byte[])MetaDataUtil.getViewIndexPhysicalName(newPhysicalTablename.getBytes()));
                    } else {
                        LOGGER.info(String.format("Global index '%s' found with physical hbase table name ''..", index.getName(), srcTableName));
                        destTableName = SchemaUtil.getPhysicalTableName(index.getPhysicalName().getString(), readOnlyProps).getNameAsString();
                    }
                    LOGGER.info(String.format("Upgrading index %s..", index.getName()));
                    if (table.getType() != PTableType.VIEW || MetaDataUtil.isViewIndex(srcTableName) || PTable.IndexType.LOCAL == index.getIndexType()) {
                        UpgradeUtil.mapTableToNamespace(admin, (Table)metatable, srcTableName, destTableName, readOnlyProps, PhoenixRuntime.getCurrentScn(readOnlyProps), phoenixTableName, index.getType(), conn.getTenantId());
                    }
                    if (updateLink) {
                        LOGGER.info(String.format("Updating link information for index '%s' ..", index.getName()));
                        UpgradeUtil.updateLink(conn, srcTableName, destTableName, index.getSchemaName(), index.getTableName());
                        conn.commit();
                    }
                    conn.getQueryServices().clearTableFromCache(tenantIdBytes, index.getSchemaName().getBytes(), index.getTableName().getBytes(), PhoenixRuntime.getCurrentScn(readOnlyProps));
                }
            } else {
                throw new RuntimeException("Error: problem occured during upgrade. Table is not upgraded successfully");
            }
            UpgradeUtil.updateIndexesSequenceIfPresent(conn, table);
            conn.commit();
            if (table.getType() == PTableType.VIEW) {
                LOGGER.info(String.format("Updating link information for view '%s' ..", table.getTableName()));
                UpgradeUtil.updateLink(conn, oldPhysicalName, newPhysicalTablename, table.getSchemaName(), table.getTableName());
                conn.commit();
                if (table.getParentName().equals(table.getPhysicalName())) {
                    LOGGER.info(String.format("Creating PARENT link for view '%s' ..", table.getTableName()));
                    PreparedStatement linkStatement = conn.prepareStatement(MetaDataClient.CREATE_VIEW_LINK);
                    linkStatement.setString(1, Bytes.toStringBinary((byte[])tenantIdBytes));
                    linkStatement.setString(2, table.getSchemaName().getString());
                    linkStatement.setString(3, table.getTableName().getString());
                    linkStatement.setString(4, table.getParentName().getString());
                    linkStatement.setByte(5, PTable.LinkType.PARENT_TABLE.getSerializedValue());
                    linkStatement.setString(6, null);
                    linkStatement.execute();
                    conn.commit();
                }
                conn.getQueryServices().clearTableFromCache(tenantIdBytes, table.getSchemaName().getBytes(), table.getTableName().getBytes(), PhoenixRuntime.getCurrentScn(readOnlyProps));
            }
            if (table.getType() == PTableType.TABLE) {
                UpgradeUtil.mapChildViewsToNamespace(conn.getURL(), conn.getClientInfo(), childViewsResult.getLinks());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isUpdateViewIndexIdColumnDataTypeFromShortToLongNeeded(PhoenixConnection metaConnection, byte[] rowKey, byte[] syscatBytes) {
        try (HTableInterface sysTable = metaConnection.getQueryServices().getTable(syscatBytes);){
            Scan s = new Scan();
            s.setRowPrefixFilter(rowKey);
            s.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TYPE_BYTES);
            ResultScanner scanner = sysTable.getScanner(s);
            Result result = scanner.next();
            Cell cell = result.getColumnLatestCell(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TYPE_BYTES);
            boolean bl = Bytes.compareTo((byte[])CellUtil.cloneValue((Cell)cell), (byte[])PInteger.INSTANCE.toBytes(5)) == 0;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error(String.format("Checking VIEW_INDEX_ID data type for upgrade failed: %s. ", e.getMessage()));
            return false;
        }
    }

    public static void updateViewIndexIdColumnDataTypeFromShortToLong(PhoenixConnection metaConnection, byte[] rowKey, byte[] syscatBytes) {
        try (HTableInterface sysTable = metaConnection.getQueryServices().getTable(syscatBytes);){
            KeyValue viewIndexIdKV = new KeyValue(rowKey, PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TYPE_BYTES, 33L, PInteger.INSTANCE.toBytes(-5));
            Put viewIndexIdPut = new Put(rowKey);
            viewIndexIdPut.add((Cell)viewIndexIdKV);
            sysTable.put(viewIndexIdPut);
            LOGGER.info("Updated VIEW_INDEX_ID data type from SMALLINT TO BIGINT.");
        }
        catch (Exception e) {
            LOGGER.error(String.format("Upgrade/change VIEW_INDEX_ID data type failed: %s. ", e.getMessage()));
        }
    }

    private static void updateIndexesSequenceIfPresent(PhoenixConnection connection, PTable dataTable) throws SQLException {
        PName tenantId = connection.getTenantId();
        PName physicalName = dataTable.getPhysicalName();
        PName oldPhysicalName = PNameFactory.newName(physicalName.toString().replace(":", "."));
        String oldSchemaName = MetaDataUtil.getViewIndexSequenceSchemaName(oldPhysicalName, false);
        String newSchemaName = MetaDataUtil.getViewIndexSequenceSchemaName(physicalName, true);
        String newSequenceName = MetaDataUtil.getViewIndexSequenceName(physicalName, tenantId, true);
        String upsert = "UPSERT INTO SYSTEM.\"SEQUENCE\" SELECT NULL,'" + newSchemaName + "','" + newSequenceName + "'," + "START_WITH" + "," + "CURRENT_VALUE" + "," + "INCREMENT_BY" + "," + "CACHE_SIZE" + "," + "MIN_VALUE" + "," + "MAX_VALUE" + "," + "CYCLE_FLAG" + "," + "LIMIT_REACHED_FLAG" + " FROM " + "SYSTEM.\"SEQUENCE\"" + " WHERE " + "TENANT_ID" + " IS NULL AND " + "SEQUENCE_SCHEMA" + " = '" + oldSchemaName + "'";
        connection.createStatement().executeUpdate(upsert);
    }

    private static void updateLink(PhoenixConnection conn, String srcTableName, String destTableName, PName schemaName, PName tableName) throws SQLException {
        boolean hasTenantId;
        String updateLinkSql = String.format(UPDATE_LINK, destTableName);
        boolean bl = hasTenantId = conn.getTenantId() != null && conn.getTenantId().getBytes().length != 0;
        if (hasTenantId) {
            updateLinkSql = updateLinkSql + " AND TENANT_ID  = ? ";
        }
        PreparedStatement updateLinkStatment = conn.prepareStatement(updateLinkSql);
        updateLinkStatment.setString(1, schemaName.getString());
        updateLinkStatment.setString(2, schemaName.getString());
        updateLinkStatment.setString(3, tableName.getString());
        updateLinkStatment.setString(4, srcTableName);
        if (hasTenantId) {
            updateLinkStatment.setString(5, conn.getTenantId().getString());
        }
        updateLinkStatment.execute();
        String deleteLinkSql = DELETE_LINK;
        if (hasTenantId) {
            deleteLinkSql = deleteLinkSql + " AND TENANT_ID  = ? ";
        }
        PreparedStatement deleteLinkStatment = conn.prepareStatement(deleteLinkSql);
        deleteLinkStatment.setString(1, schemaName.getString());
        deleteLinkStatment.setString(2, schemaName.getString());
        deleteLinkStatment.setString(3, tableName.getString());
        deleteLinkStatment.setString(4, srcTableName);
        if (hasTenantId) {
            deleteLinkStatment.setString(5, conn.getTenantId().getString());
        }
        deleteLinkStatment.execute();
    }

    private static void mapChildViewsToNamespace(String connUrl, Properties props, List<TableInfo> viewInfoList) throws SQLException, IllegalArgumentException, IOException, InterruptedException {
        String prevTenantId = null;
        PhoenixConnection conn = null;
        for (TableInfo viewInfo : viewInfoList) {
            String tenantId = viewInfo.getTenantId() != null ? Bytes.toString((byte[])viewInfo.getTenantId()) : null;
            String viewName = SchemaUtil.getTableName(viewInfo.getSchemaName(), viewInfo.getTableName());
            if (!Objects.equals(prevTenantId, tenantId)) {
                if (tenantId != null) {
                    props.setProperty("TenantId", tenantId);
                } else {
                    props.remove("TenantId");
                }
                if (conn != null) {
                    conn.close();
                }
                conn = DriverManager.getConnection(connUrl, props).unwrap(PhoenixConnection.class);
            }
            LOGGER.info(String.format("Upgrading view %s for tenantId %s..", viewName, tenantId));
            if (conn != null) {
                try {
                    UpgradeUtil.upgradeTable(conn, viewName);
                }
                catch (TableNotFoundException e) {
                    LOGGER.error("Error getting PTable for view: " + viewInfo, (Throwable)e);
                }
            }
            prevTenantId = tenantId;
        }
    }

    public static void mergeViewIndexIdSequences(PhoenixConnection olderMetaConnection) throws SQLException {
        HashMap sequenceTableMap = new HashMap();
        try (PhoenixConnection metaConnection = new PhoenixConnection(olderMetaConnection, Long.MAX_VALUE);){
            DatabaseMetaData metaData = metaConnection.getMetaData();
            ConnectionQueryServices cqs = metaConnection.getQueryServices();
            try (ResultSet sequenceRS = metaData.getTables(null, null, "%_ID_%", new String[]{"SEQUENCE"});){
                while (sequenceRS.next()) {
                    String tenantId = sequenceRS.getString("TABLE_CAT");
                    String schemaName = sequenceRS.getString("TABLE_SCHEM");
                    String sequenceName = sequenceRS.getString("TABLE_NAME");
                    int numBuckets = sequenceRS.getInt("SALT_BUCKETS");
                    SequenceKey key = new SequenceKey(tenantId, schemaName, sequenceName, numBuckets);
                    String baseTableName = schemaName != null && schemaName.contains("_SEQ_") ? schemaName.replace("_SEQ_", "") : SchemaUtil.getTableName(schemaName, sequenceName.replace("_ID_", ""));
                    if (!sequenceTableMap.containsKey(baseTableName)) {
                        sequenceTableMap.put(baseTableName, new ArrayList());
                    }
                    ((List)sequenceTableMap.get(baseTableName)).add(key);
                }
            }
            for (String baseTableName : sequenceTableMap.keySet()) {
                HashMap<SequenceKey, Long> currentSequenceValues = new HashMap<SequenceKey, Long>();
                long maxViewIndexId = Long.MIN_VALUE;
                PName name = PNameFactory.newName(baseTableName);
                boolean hasNamespaceMapping = SchemaUtil.isNamespaceMappingEnabled(null, cqs.getConfiguration()) || cqs.getProps().getBoolean("phoenix.schema.isNamespaceMappingEnabled", false);
                List existingSequenceKeys = (List)sequenceTableMap.get(baseTableName);
                for (SequenceKey sequenceKey : existingSequenceKeys) {
                    long[] currentValueArray = new long[1];
                    SQLException[] sqlExceptions = new SQLException[1];
                    cqs.incrementSequences(Lists.newArrayList((Object[])new SequenceAllocation[]{new SequenceAllocation(sequenceKey, 1L)}), EnvironmentEdgeManager.currentTimeMillis(), currentValueArray, new SQLException[1]);
                    if (sqlExceptions[0] != null) {
                        LOGGER.error("Unable to convert view index sequence because of error. It will need to be converted manually,  or there's a risk that two view indexes of the same base table will have colliding view index ids.", (Throwable)sqlExceptions[0]);
                        continue;
                    }
                    if (currentValueArray[0] > maxViewIndexId) {
                        maxViewIndexId = currentValueArray[0];
                    }
                    currentSequenceValues.put(sequenceKey, currentValueArray[0]);
                }
                maxViewIndexId += 100L;
                try {
                    SequenceKey newSequenceKey = new SequenceKey(null, MetaDataUtil.getViewIndexSequenceSchemaName(name, hasNamespaceMapping), MetaDataUtil.getViewIndexSequenceName(name, null, hasNamespaceMapping), cqs.getSequenceSaltBuckets());
                    if (currentSequenceValues.containsKey(newSequenceKey)) {
                        long incrementValue = maxViewIndexId - (Long)currentSequenceValues.get(newSequenceKey);
                        SQLException[] incrementExceptions = new SQLException[1];
                        ArrayList incrementAllocations = Lists.newArrayList((Object[])new SequenceAllocation[]{new SequenceAllocation(newSequenceKey, incrementValue)});
                        cqs.incrementSequences(incrementAllocations, EnvironmentEdgeManager.currentTimeMillis(), new long[1], incrementExceptions);
                        if (incrementExceptions[0] == null) continue;
                        throw incrementExceptions[0];
                    }
                    cqs.createSequence(null, newSequenceKey.getSchemaName(), newSequenceKey.getSequenceName(), maxViewIndexId, 1L, 1L, Long.MIN_VALUE, Long.MAX_VALUE, false, EnvironmentEdgeManager.currentTimeMillis());
                }
                catch (SequenceAlreadyExistsException sae) {
                    LOGGER.info("Tried to create view index sequence " + SchemaUtil.getTableName(sae.getSchemaName(), sae.getSequenceName()) + " during upgrade but it already existed. This is probably fine.");
                }
            }
        }
    }

    public static String getSysTableSnapshotName(long currentSystemTableTimestamp, String tableName) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String date = formatter.format((Object)new Date(EnvironmentEdgeManager.currentTimeMillis()));
        String upgradingFrom = MetaDataProtocol.getVersion(currentSystemTableTimestamp);
        return String.format("SNAPSHOT_%s_%s_TO_%s_%s", tableName, upgradingFrom, "4.16.0", date);
    }

    public static boolean isNoUpgradeSet(Properties props) {
        return Boolean.compare(true, Boolean.valueOf(props.getProperty(DO_NOT_UPGRADE))) == 0;
    }

    public static void doNotUpgradeOnFirstConnection(Properties props) {
        props.setProperty(DO_NOT_UPGRADE, String.valueOf(true));
    }

    public static void bootstrapLastDDLTimestamp(Connection metaConnection) throws SQLException {
        String pkCols = "TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY";
        String upsertSql = "UPSERT INTO " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " (" + pkCols + ", " + "LAST_DDL_TIMESTAMP" + ") SELECT " + pkCols + ", PHOENIX_ROW_TIMESTAMP() FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE " + "TABLE_TYPE" + "  in ('" + PTableType.TABLE.getSerializedValue() + "', '" + PTableType.VIEW.getSerializedValue() + "')";
        LOGGER.info("Setting DDL timestamps for tables and views to row timestamps");
        try (PreparedStatement stmt = metaConnection.prepareStatement(upsertSql);){
            stmt.execute();
            metaConnection.commit();
        }
        LOGGER.info("Setting DDL timestamps for tables and views is complete");
    }

    private static class ViewKey {
        @Nullable
        private final String tenantId;
        @Nullable
        private final String schema;
        @Nonnull
        private final String name;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
            result = 31 * result + this.name.hashCode();
            result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ViewKey other = (ViewKey)obj;
            if (this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId)) {
                return false;
            }
            if (!this.name.equals(other.name)) {
                return false;
            }
            return !(this.schema == null ? other.schema != null : !this.schema.equals(other.schema));
        }

        private ViewKey(String tenantId, String schema, String viewName) {
            this.tenantId = tenantId;
            this.schema = schema;
            this.name = viewName;
        }
    }

    private static class ColumnDetails {
        @Nullable
        private final String columnFamily;
        @Nonnull
        private final String columnName;
        private final int ordinalValue;
        private final int dataType;
        private final int maxLength;
        private final int scale;
        private final int sortOrder;
        private final int arraySize;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.columnName.hashCode();
            result = 31 * result + (this.columnFamily == null ? 0 : this.columnFamily.hashCode());
            result = 31 * result + this.arraySize;
            result = 31 * result + this.dataType;
            result = 31 * result + this.maxLength;
            result = 31 * result + this.ordinalValue;
            result = 31 * result + this.scale;
            result = 31 * result + this.sortOrder;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ColumnDetails other = (ColumnDetails)obj;
            if (!this.columnName.equals(other.columnName)) {
                return false;
            }
            if (this.columnFamily == null ? other.columnFamily != null : !this.columnFamily.equals(other.columnFamily)) {
                return false;
            }
            if (this.arraySize != other.arraySize) {
                return false;
            }
            if (this.dataType != other.dataType) {
                return false;
            }
            if (this.maxLength != other.maxLength) {
                return false;
            }
            if (this.ordinalValue != other.ordinalValue) {
                return false;
            }
            if (this.scale != other.scale) {
                return false;
            }
            return this.sortOrder == other.sortOrder;
        }

        ColumnDetails(String columnFamily, String columnName, int ordinalValue, int dataType, int maxLength, int scale, int sortOrder, int arraySize) {
            Preconditions.checkNotNull((Object)columnName);
            Preconditions.checkNotNull((Object)ordinalValue);
            Preconditions.checkNotNull((Object)dataType);
            this.columnFamily = columnFamily;
            this.columnName = columnName;
            this.ordinalValue = ordinalValue;
            this.dataType = dataType;
            this.maxLength = maxLength;
            this.scale = scale;
            this.sortOrder = sortOrder;
            this.arraySize = arraySize;
        }
    }
}

